/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.etc;

import z80emu.Z80CPU;
import z80emu.Z80MaxSpeedListener;
import z80emu.Z80TStatesListener;

public class GDC82720
implements Z80MaxSpeedListener,
Z80TStatesListener {
    public static final int DISPL_ADDR_MASK = 262143;
    public static final int DISPL_IMAGE_MASK = 262144;
    public static final int DISPL_CURSOR_MASK = 524288;
    public static final int DISPL_NEW_CROW_MASK = 0x100000;
    public static final int DISPL_BLINK_MASK = 0x200000;
    private static final int STATUS_DATA_AVAILABLE = 1;
    private static final int STATUS_FIFO_EMPTY = 4;
    private static final int STATUS_VSYNC_ACTIVE = 32;
    private static final int STATUS_HBLANK_ACTIVE = 64;
    private GDCListener gdcListener = null;
    private VRAM vram = null;
    private volatile byte[] pram = new byte[16];
    private volatile int pramLen = 0;
    private Mode mode = Mode.INVALID;
    private int[] args = new int[16];
    private int argIdx = 0;
    private int cmd = 0;
    private int nBytesToRead = 0;
    private int displayLines = 0;
    private int lineCounter = 0;
    private int lineTStateCounter = 0;
    private volatile int tStatesPerLine = 0;
    private volatile int tStatesPerHBlank = 0;
    private int mask = 0;
    private int statusReg = 4;
    private int linesPerCharRow = 0;
    private int wordsPerCharRow = 0;
    private int memWordsPerChRow = 0;
    private boolean drawingSL = false;
    private boolean drawingR = false;
    private boolean drawingA = false;
    private boolean drawingGC = false;
    private boolean drawingL = false;
    private boolean drawingGD = false;
    private int drawingDir = 0;
    private int drawingD = 0;
    private int drawingDC = 0;
    private int drawingD1 = 0;
    private int drawingD2 = 0;
    private int drawingDM = 0;
    private int blinkCounter = 0;
    private int blinkRate = 0;
    private int charBlinkNum = 0;
    private int cursorAddr = 0;
    private int cursorDotAddr = 0;
    private int cursorTopLine = 0;
    private int cursorBottomLine = 0;
    private boolean cursorBlinkState = false;
    private boolean cursorBlinking = false;
    private boolean cursorEnabled = false;
    private boolean screenEnabled = false;

    public boolean canExtractScreenText() {
        return this.getCharRowCount() > 0;
    }

    public int getCharColCount() {
        return this.wordsPerCharRow;
    }

    public int getCharRowCount() {
        int n;
        int n2 = 0;
        if (this.screenEnabled && (n = this.linesPerCharRow) >= 8) {
            if (this.mode == Mode.CHARACTER) {
                int n3;
                for (int i = 0; i < 4 && (n3 = i * 4) + 3 < this.pramLen; ++i) {
                    int n4 = this.pram[n3 + 2] >> 4 & 0xF | this.pram[n3 + 3] << 4 & 0x3F0;
                    n2 += n4 / n;
                    if (n4 % n == 0) {
                        continue;
                    }
                    break;
                }
            } else if (this.mode == Mode.MIXED) {
                int n5;
                for (int i = 0; i < 2 && (n5 = i * 4) + 3 < this.pramLen; ++i) {
                    if ((this.pram[n5 + 3] & 0x40) != 0) continue;
                    int n6 = this.pram[n5 + 2] >> 4 & 0xF | this.pram[n5 + 3] << 4 & 0x3F0;
                    n2 += n6 / n;
                    if (n6 % n == 0) {
                        continue;
                    }
                    break;
                }
            }
            if (n2 * n > this.displayLines) {
                n2 = this.displayLines / n;
            }
        }
        return n2;
    }

    public int getCharRowHeight() {
        return this.linesPerCharRow;
    }

    public int getCharTopLine() {
        int n = 0;
        if (this.mode == Mode.MIXED && this.pramLen >= 4 && (this.pram[3] & 0x40) != 0) {
            n = this.pram[2] >> 4 & 0xF | this.pram[3] << 4 & 0x3F0;
        }
        return n;
    }

    public int getDisplayLines() {
        return this.displayLines;
    }

    public int getDisplayValue(int n, int n2) {
        int n3;
        block9: {
            block10: {
                n3 = -1;
                if (!this.screenEnabled || n2 < 0 || n2 >= this.displayLines) break block9;
                if (this.mode != Mode.CHARACTER) break block10;
                if (this.linesPerCharRow <= 0) break block9;
                int n4 = Math.min(this.pramLen, 16);
                int n5 = 0;
                for (int i = 0; i < n4; i += 4) {
                    int n6 = this.pram[i + 2] >> 4 & 0xF | this.pram[i + 3] << 4 & 0x3F0;
                    if (n6 > 0 && n2 < n5 + n6) {
                        int n7 = n2 - n5;
                        int n8 = this.pram[i + 1] << 8 & 0xF00 | this.pram[i] & 0xFF;
                        n3 = n8 + n7 / this.linesPerCharRow * this.memWordsPerChRow + n;
                        int n9 = n7 % this.linesPerCharRow;
                        if (this.cursorEnabled && n3 == this.cursorAddr && n9 >= this.cursorTopLine && n9 <= this.cursorBottomLine && (!this.cursorBlinking || this.cursorBlinkState)) {
                            n3 |= 0x80000;
                        }
                        if (n9 != 0) break block9;
                        n3 |= 0x100000;
                        break block9;
                    }
                    n5 += n6;
                }
                break block9;
            }
            if (this.mode == Mode.GRAPHICS || this.mode == Mode.MIXED) {
                int n10 = Math.min(this.pramLen, 8);
                int n11 = 0;
                for (int i = 0; i < n10; i += 4) {
                    int n12 = this.pram[i + 2] >> 4 & 0xF | this.pram[i + 3] << 4 & 0x3F0;
                    if (n12 > 0 && n2 < n11 + n12) {
                        int n13 = n2 - n11;
                        int n14 = this.pram[i + 2] << 16 & 0x30000 | this.pram[i + 1] << 8 & 0xFF00 | this.pram[i] & 0xFF;
                        if (this.mode == Mode.MIXED && (this.pram[i + 3] & 0x40) == 0) {
                            if (this.linesPerCharRow <= 0) break;
                            n3 = n14 + n13 / this.linesPerCharRow * this.memWordsPerChRow + n;
                            int n15 = n13 % this.linesPerCharRow;
                            if (this.cursorEnabled && n3 == this.cursorAddr && n15 >= this.cursorTopLine && n15 <= this.cursorBottomLine && (!this.cursorBlinking || this.cursorBlinkState)) {
                                n3 |= 0x80000;
                            }
                            if (n15 == 0) {
                                n3 |= 0x100000;
                            }
                            if (this.charBlinkNum >= 3) break;
                            n3 |= 0x200000;
                            break;
                        }
                        n3 = n14 + n13 * this.memWordsPerChRow + n;
                        break;
                    }
                    n11 += n12;
                }
            }
        }
        return n3;
    }

    public Mode getMode() {
        return this.mode;
    }

    public int getScreenChar(int n, int n2) {
        int n3 = -1;
        int n4 = this.linesPerCharRow;
        if (n >= 0 && n2 >= 0 && n < this.wordsPerCharRow && n4 > 0 && n2 * n4 < this.displayLines) {
            int n5 = -1;
            if (this.mode == Mode.CHARACTER) {
                int n6;
                for (int i = 0; i < 4 && (n6 = i * 4) + 3 < this.pramLen; ++i) {
                    int n7 = this.pram[n6 + 2] >> 4 & 0xF | this.pram[n6 + 3] << 4 & 0x3F0;
                    int n8 = n7 / n4;
                    if (n2 < n8) {
                        n5 = this.pram[n6 + 1] << 8 & 0x1F00 | this.pram[n6] & 0xFF;
                    } else if (n7 % n4 == 0) {
                        n2 -= n8;
                        continue;
                    }
                    break;
                }
            } else if (this.mode == Mode.MIXED) {
                int n9;
                for (int i = 0; i < 2 && (n9 = i * 4) + 3 < this.pramLen; ++i) {
                    if ((this.pram[n9 + 3] & 0x40) != 0) continue;
                    int n10 = this.pram[n9 + 2] >> 4 & 0xF | this.pram[n9 + 3] << 4 & 0x3F0;
                    int n11 = n10 / n4;
                    if (n2 < n11) {
                        n5 = this.pram[n9 + 2] << 16 & 0x30000 | this.pram[n9 + 1] << 8 & 0xFF00 | this.pram[n9] & 0xFF;
                    } else if (n10 % n4 == 0) {
                        n2 -= n11;
                        continue;
                    }
                    break;
                }
            }
            if (n5 >= 0) {
                n3 = this.vram.getVRAMWord(n5 + n2 * this.memWordsPerChRow + n) & 0xFF;
            }
        }
        return n3;
    }

    public int readData() {
        int n = 0;
        if (this.nBytesToRead > 0 && (this.statusReg & 1) != 0) {
            if ((this.cmd & 0xE4) == 160) {
                switch (this.cmd & 0x18) {
                    case 0: {
                        if ((this.nBytesToRead & 1) == 0) {
                            n = this.vram.getVRAMWord(this.cursorAddr) & 0xFF;
                            --this.nBytesToRead;
                            break;
                        }
                        n = this.vram.getVRAMWord(this.cursorAddr) >> 8 & 0xFF;
                        --this.nBytesToRead;
                        this.cursorAddr = this.cursorAddr + 1 & 0x3FFFF;
                        break;
                    }
                    case 16: {
                        n = this.vram.getVRAMWord(this.cursorAddr) & 0xFF;
                        --this.nBytesToRead;
                        this.cursorAddr = this.cursorAddr + 1 & 0x3FFFF;
                        break;
                    }
                    case 24: {
                        n = this.vram.getVRAMWord(this.cursorAddr) >> 8 & 0xFF;
                        --this.nBytesToRead;
                        this.cursorAddr = this.cursorAddr + 1 & 0x3FFFF;
                    }
                }
                if (this.nBytesToRead <= 0) {
                    this.drawingDC = 0;
                }
            } else if (this.cmd == 224) {
                switch (this.nBytesToRead) {
                    case 5: {
                        n = this.cursorAddr & 0xFF;
                        --this.nBytesToRead;
                        break;
                    }
                    case 4: {
                        n = this.cursorAddr >> 8 & 0xFF;
                        --this.nBytesToRead;
                        break;
                    }
                    case 3: {
                        n = this.cursorAddr >> 16 & 3;
                        --this.nBytesToRead;
                        break;
                    }
                    case 2: {
                        n = this.cursorDotAddr & 0xFF;
                        --this.nBytesToRead;
                        break;
                    }
                    case 1: {
                        n = this.cursorDotAddr >> 8 & 0xFF;
                        --this.nBytesToRead;
                        break;
                    }
                    default: {
                        this.nBytesToRead = 0;
                    }
                }
            }
        }
        if (this.nBytesToRead <= 0) {
            this.statusReg &= 0xFFFFFFFE;
            this.statusReg |= 4;
        }
        return n;
    }

    public int readStatus() {
        int n = this.statusReg;
        if (this.lineCounter < 50) {
            n |= 0x20;
        }
        if (this.lineTStateCounter < this.tStatesPerHBlank) {
            n |= 0x40;
        }
        return n | 4;
    }

    public void setGDCListener(GDCListener gDCListener) {
        this.gdcListener = gDCListener;
    }

    public void setVRAM(VRAM vRAM) {
        this.vram = vRAM;
    }

    public void writeArg(int n) {
        this.statusReg &= 0xFFFFFFFB;
        if (this.argIdx < this.args.length) {
            this.args[this.argIdx++] = n;
        }
        this.execCmd();
    }

    public void writeCmd(int n) {
        this.statusReg &= 0xFFFFFFFB;
        this.argIdx = 0;
        this.cmd = n & 0xFF;
        this.execCmd();
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        this.tStatesPerLine = z80CPU.getMaxSpeedKHz() * 20 / 312;
        this.tStatesPerHBlank = this.tStatesPerLine / 2;
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        int n2;
        if (this.screenEnabled && n > 0 && (n2 = this.tStatesPerLine) > 0) {
            this.lineTStateCounter += n;
            if (this.lineTStateCounter >= n2) {
                this.lineTStateCounter -= n2;
                if (this.lineCounter < 311) {
                    ++this.lineCounter;
                } else {
                    this.lineCounter = 0;
                    if (this.blinkCounter > 0) {
                        --this.blinkCounter;
                    } else {
                        GDCListener gDCListener;
                        this.blinkCounter = this.blinkRate > 0 ? this.blinkRate : 32;
                        boolean bl = this.cursorBlinkState = !this.cursorBlinkState;
                        if (this.cursorBlinkState) {
                            this.charBlinkNum = this.charBlinkNum < 3 ? ++this.charBlinkNum : 0;
                        }
                        if ((gDCListener = this.gdcListener) != null) {
                            gDCListener.screenDirty(this);
                        }
                    }
                }
            }
        }
    }

    private void execCmd() {
        int n;
        boolean bl = false;
        this.statusReg &= 0xFFFFFFFE;
        this.statusReg |= 4;
        if (this.cmd == 0 || (this.cmd & 0xFE) == 14) {
            n = this.screenEnabled;
            boolean bl2 = this.screenEnabled = (this.cmd & 1) != 0;
            if (this.screenEnabled != n) {
                bl = true;
            }
            this.screenEnabled = this.screenEnabled;
            this.lineCounter = 0;
            this.lineTStateCounter = 0;
            switch (this.argIdx) {
                case 1: {
                    Mode mode = this.mode;
                    switch (this.args[0] & 0x22) {
                        case 0: {
                            this.mode = Mode.MIXED;
                            break;
                        }
                        case 2: {
                            this.mode = Mode.GRAPHICS;
                            break;
                        }
                        case 32: {
                            this.mode = Mode.CHARACTER;
                            break;
                        }
                        default: {
                            this.mode = Mode.INVALID;
                        }
                    }
                    if (this.mode == mode) break;
                    bl = true;
                    break;
                }
                case 2: {
                    int n2 = this.wordsPerCharRow;
                    this.wordsPerCharRow = this.args[1] + 2;
                    if (this.wordsPerCharRow == n2) break;
                    bl = true;
                    break;
                }
                case 7: {
                    int n3 = this.displayLines;
                    this.displayLines = this.args[6];
                    if (this.displayLines == n3) break;
                    bl = true;
                    break;
                }
                case 8: {
                    this.argIdx = 0;
                }
            }
            this.statusReg |= 4;
        } else if ((this.cmd & 0xFE) == 12) {
            n = this.screenEnabled;
            boolean bl3 = this.screenEnabled = (this.cmd & 1) != 0;
            if (this.screenEnabled != n) {
                bl = true;
            }
        } else if ((this.cmd & 0xE4) == 32) {
            if (this.argIdx > 0) {
                n = -1;
                int n4 = this.cmd & 0x18;
                if (n4 == 0 && this.argIdx == 2) {
                    n = this.args[1] << 8 | this.args[0];
                } else if (n4 == 16 && this.argIdx == 1) {
                    n = this.args[0];
                } else if (n4 == 24 && this.argIdx == 1) {
                    n = this.args[1] << 8;
                }
                if (n >= 0) {
                    VRAM vRAM = this.vram;
                    int n5 = this.cmd & 7;
                    int n6 = this.drawingDC + 1 & 0x3FFF;
                    n6 = this.drawingDC + 1;
                    for (int i = 0; i < n6; ++i) {
                        if (vRAM != null) {
                            if (this.drawingSL || this.drawingGC || this.drawingGD) {
                                System.out.println("GDC82720: WDAT: Grafikmode nicht implementiert");
                            } else {
                                int n7 = this.vram.getVRAMWord(this.cursorAddr);
                                int n8 = n7 & ~this.mask;
                                switch (n5) {
                                    case 0: {
                                        this.vram.setVRAMWord(this.cursorAddr, n & this.mask | n8);
                                        break;
                                    }
                                    case 1: {
                                        this.vram.setVRAMWord(this.cursorAddr, ~n7 & this.mask | n8);
                                        break;
                                    }
                                    case 2: {
                                        this.vram.setVRAMWord(this.cursorAddr, n8);
                                        break;
                                    }
                                    case 3: {
                                        this.vram.setVRAMWord(this.cursorAddr, this.mask | n8);
                                    }
                                }
                            }
                        }
                        switch (this.drawingDir) {
                            case 0: 
                            case 1: 
                            case 7: {
                                this.cursorAddr += this.memWordsPerChRow;
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                this.cursorAddr -= this.memWordsPerChRow;
                            }
                        }
                        switch (this.drawingDir) {
                            case 1: 
                            case 2: 
                            case 3: {
                                if (n4 == 0) {
                                    if ((this.mask & 0x8000) != 0) {
                                        this.mask = (this.mask << 1 | 1) & 0xFFFF;
                                        ++this.cursorAddr;
                                        break;
                                    }
                                    this.mask <<= 1;
                                    break;
                                }
                                if (n4 == 16) {
                                    if ((this.mask & 0x80) != 0) {
                                        this.mask = this.mask & 0xFF00 | (this.mask << 1 | 1) & 0xFF;
                                        ++this.cursorAddr;
                                        break;
                                    }
                                    this.mask = this.mask & 0xFF00 | (this.mask << 1 | 0xFF);
                                    break;
                                }
                                if (n4 != 24) break;
                                if ((this.mask & 0x8000) != 0) {
                                    this.mask = (this.mask << 1 | 0x100) & 0xFF00 | this.mask & 0xFF;
                                    ++this.cursorAddr;
                                    break;
                                }
                                this.mask = this.mask << 1 | 0xFF00 | this.mask & 0xFF;
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 7: {
                                if (n4 == 0) {
                                    if ((this.mask & 1) != 0) {
                                        this.mask = (this.mask >> 1 | 0x8000) & 0xFFFF;
                                        --this.cursorAddr;
                                        break;
                                    }
                                    this.mask >>= 1;
                                    break;
                                }
                                if (n4 == 16) {
                                    if ((this.mask & 1) != 0) {
                                        this.mask = this.mask & 0xFF00 | (this.mask >> 1 | 0x80) & 0xFF;
                                        --this.cursorAddr;
                                        break;
                                    }
                                    this.mask = this.mask & 0xFF00 | (this.mask >> 1 | 0xFF);
                                    break;
                                }
                                if (n4 != 24) break;
                                if ((this.mask & 0x100) != 0) {
                                    this.mask = (this.mask >> 1 | 0x8000) & 0xFF00 | this.mask & 0xFF;
                                    --this.cursorAddr;
                                    break;
                                }
                                this.mask = this.mask >> 1 | 0xFF00 | this.mask & 0xFF;
                            }
                        }
                        this.cursorAddr &= 0x3FFFF;
                    }
                    this.argIdx = 0;
                    this.drawingDC = 0;
                    this.statusReg |= 4;
                }
            } else if (this.argIdx > 2) {
                this.argIdx = 0;
                this.statusReg |= 4;
            }
        } else if (this.cmd == 70) {
            if (this.argIdx == 1) {
                if (this.args[0] != 0) {
                    System.out.println("GDC82720: Zoomfaktor groesser 1 nicht implementiert");
                }
                this.argIdx = 0;
                this.statusReg |= 4;
            }
        } else if (this.cmd == 71) {
            if (this.argIdx == 1) {
                n = this.memWordsPerChRow;
                this.memWordsPerChRow = this.args[0];
                if (this.memWordsPerChRow != n) {
                    bl = true;
                }
                this.argIdx = 0;
                this.statusReg |= 4;
            }
        } else if (this.cmd == 73) {
            if (this.argIdx == 2) {
                this.cursorAddr = this.args[1] << 8 & 0xFF00 | this.args[0] & 0xFF;
                this.statusReg |= 4;
            } else if (this.argIdx == 3) {
                this.cursorAddr = this.cursorAddr & 0xFFFF | this.args[2] << 16 & 0x30000;
                this.cursorDotAddr = this.args[2] >> 4 & 0xF;
                this.mask = this.cursorDotAddr > 0 ? 1 << this.cursorDotAddr : 1;
                this.argIdx = 0;
                this.statusReg |= 4;
            }
        } else if (this.cmd == 74) {
            if (this.argIdx == 1) {
                this.mask = this.args[0];
            } else if (this.argIdx == 2) {
                this.mask = this.args[1] << 8 & 0xFF00 | this.args[0];
                this.argIdx = 0;
                this.statusReg |= 4;
            }
        } else if (this.cmd == 75) {
            if (this.argIdx == 3) {
                n = this.linesPerCharRow;
                int n9 = this.cursorTopLine;
                int n10 = this.cursorBottomLine;
                this.linesPerCharRow = (this.args[0] & 0x1F) + 1;
                this.cursorTopLine = this.args[1] & 0x1F;
                this.cursorBottomLine = this.args[2] >> 3 & 0x1F;
                if (this.linesPerCharRow != n || n9 != this.cursorTopLine || n10 != this.cursorBottomLine) {
                    bl = true;
                }
                this.cursorEnabled = (this.args[0] & 0x80) != 0;
                this.cursorBlinking = (this.args[1] & 0x20) == 0;
                this.blinkRate = this.args[1] >> 6 & 3 | this.args[2] << 2 & 0x1C;
                this.argIdx = 0;
                this.statusReg |= 4;
            }
        } else if (this.cmd == 76) {
            switch (this.argIdx) {
                case 1: {
                    n = this.args[0];
                    this.drawingSL = (n & 0x80) != 0;
                    this.drawingR = (n & 0x40) != 0;
                    this.drawingA = (n & 0x20) != 0;
                    this.drawingGC = (n & 0x10) != 0;
                    this.drawingL = (n & 8) != 0;
                    this.drawingDir = n & 7;
                    break;
                }
                case 2: {
                    this.drawingDC = this.args[1];
                    break;
                }
                case 3: {
                    n = this.args[2];
                    this.drawingDC = n << 8 & 0x3F00 | this.args[1];
                    this.drawingGD = (n & 0x40) != 0;
                    break;
                }
                case 4: {
                    this.drawingD = this.args[3];
                    break;
                }
                case 5: {
                    this.drawingD = this.args[4] << 8 & 0x3F00 | this.args[3];
                    break;
                }
                case 6: {
                    this.drawingD2 = this.args[5];
                    break;
                }
                case 7: {
                    this.drawingD2 = this.args[6] << 8 & 0x3F00 | this.args[5];
                    break;
                }
                case 8: {
                    this.drawingD1 = this.args[7];
                    break;
                }
                case 9: {
                    this.drawingD1 = this.args[8] << 8 & 0x3F00 | this.args[7];
                    break;
                }
                case 10: {
                    this.drawingDM = this.args[9];
                }
                case 11: {
                    this.drawingDM = this.args[10] << 8 & 0x3F00 | this.args[9];
                    this.argIdx = 0;
                    this.statusReg |= 4;
                }
            }
        } else if (this.cmd == 107) {
            if (!this.screenEnabled) {
                bl = true;
            }
            this.screenEnabled = true;
            this.argIdx = 0;
            this.statusReg |= 4;
        } else if ((this.cmd & 0xF0) == 112) {
            if (this.argIdx > 0) {
                n = this.argIdx - 1;
                int n11 = (this.cmd & 0xF) + n;
                if (n11 < this.pram.length) {
                    byte by = (byte)this.args[n];
                    if (by != this.pram[n11]) {
                        bl = true;
                    }
                    this.pram[n11] = by;
                }
                this.pramLen = n11 + 1;
            }
            this.statusReg |= 4;
        } else if ((this.cmd & 0xE4) == 160) {
            if ((this.cmd & 0x18) != 8 && this.drawingDC > 0) {
                this.nBytesToRead = (this.cmd & 0x18) == 0 ? this.drawingDC * 2 : this.drawingDC;
                this.statusReg |= 1;
                this.statusReg &= 0xFFFFFFFB;
            }
            this.argIdx = 0;
        } else if (this.cmd == 224) {
            this.nBytesToRead = 5;
            this.argIdx = 0;
            this.statusReg |= 1;
            this.statusReg &= 0xFFFFFFFB;
        } else {
            this.argIdx = 0;
            this.statusReg |= 4;
        }
        GDCListener gDCListener = this.gdcListener;
        if (gDCListener != null) {
            if (bl) {
                gDCListener.screenConfigChanged(this);
            }
            gDCListener.screenDirty(this);
        }
    }

    public static enum Mode {
        CHARACTER,
        GRAPHICS,
        MIXED,
        INVALID;

    }

    public static interface VRAM {
        public int getVRAMWord(int var1);

        public void setVRAMWord(int var1, int var2);
    }

    public static interface GDCListener {
        public void screenConfigChanged(GDC82720 var1);

        public void screenDirty(GDC82720 var1);
    }
}

