/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.etc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.util.EventObject;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import jkcemu.Main;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuThread;
import jkcemu.base.HelpFrm;
import jkcemu.etc.ChessboardFld;
import jkcemu.image.ImgSelection;

public class ChessboardFrm
extends BaseFrm {
    private static final String HELP_PAGE = "/help/chessboard.htm";
    private static ChessboardFrm instance = null;
    private JMenuItem mnuClose;
    private JMenuItem mnuCopy;
    private JMenuItem mnuSwap;
    private JMenuItem mnuHelpContent;
    private ChessboardFld chessboardFld;

    public static void close() {
        if (instance != null) {
            instance.doClose();
        }
    }

    public static void open(EmuThread emuThread) {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new ChessboardFrm(emuThread);
        }
        instance.toFront();
        instance.setVisible(true);
    }

    public static void repaintChessboard() {
        if (instance != null) {
            ChessboardFrm.instance.chessboardFld.repaint();
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.mnuClose) {
                bl = true;
                this.doClose();
            } else if (object == this.mnuCopy) {
                bl = true;
                this.doCopy();
            } else if (object == this.mnuSwap) {
                bl = true;
                this.chessboardFld.swap();
            } else if (object == this.mnuHelpContent) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            }
        }
        return bl;
    }

    private ChessboardFrm(EmuThread emuThread) {
        this.setTitle("JKCEMU Schachbrett");
        Main.updIcon(this);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        this.mnuClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuClose);
        JMenu jMenu2 = new JMenu("Bearbeiten");
        jMenu2.setMnemonic(66);
        this.mnuCopy = this.createJMenuItem("Schachbrett kopieren");
        jMenu2.add(this.mnuCopy);
        JMenu jMenu3 = new JMenu("Ansicht");
        jMenu3.setMnemonic(65);
        this.mnuSwap = this.createJMenuItem("Seite wechseln");
        jMenu3.add(this.mnuSwap);
        JMenu jMenu4 = new JMenu("?");
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu4.add(this.mnuHelpContent);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        this.setJMenuBar(jMenuBar);
        this.setLayout(new BorderLayout());
        this.chessboardFld = new ChessboardFld(emuThread);
        this.add((Component)this.chessboardFld, "Center");
        this.setLocationByPlatform(true);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.pack();
        }
        this.setResizable(false);
    }

    private void doCopy() {
        try {
            Clipboard clipboard;
            Toolkit toolkit = this.getToolkit();
            if (toolkit != null && (clipboard = toolkit.getSystemClipboard()) != null) {
                ImgSelection imgSelection = new ImgSelection(this.chessboardFld.createImage());
                clipboard.setContents(imgSelection, imgSelection);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

