/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.etc;

import java.io.IOException;
import java.io.InterruptedIOException;

public class ByteQueue {
    private byte[] buf;
    private Object modifyLock;
    private Object readLock;
    private Object writeLock;
    private boolean empty;
    private int front;
    private int rear;

    public ByteQueue(int n) {
        this.buf = new byte[n > 0 ? n : 1];
        this.modifyLock = new Object();
        this.readLock = new Object();
        this.writeLock = new Object();
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(byte by) {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.modifyLock;
            synchronized (object2) {
                if (!this.empty && this.front == this.rear) {
                    byte[] byArray = new byte[this.buf.length + 1024];
                    this.rear = this.buf.length - this.front;
                    System.arraycopy(this.buf, this.front, byArray, 0, this.rear);
                    if (this.front > 0) {
                        System.arraycopy(this.buf, 0, byArray, this.rear, this.front);
                        this.rear += this.front;
                    }
                    this.buf = byArray;
                    this.front = 0;
                }
                this.buf[this.rear++] = by;
                if (this.rear >= this.buf.length) {
                    this.rear = 0;
                }
                this.empty = false;
            }
            try {
                this.readLock.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.writeLock;
        synchronized (object) {
            Object object2 = this.modifyLock;
            synchronized (object2) {
                this.empty = true;
                this.front = 0;
                this.rear = 0;
            }
            try {
                this.writeLock.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean bl = false;
        Object object = this.modifyLock;
        synchronized (object) {
            bl = this.empty;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int poll() {
        int n = -1;
        Object object = this.writeLock;
        synchronized (object) {
            Object object2 = this.modifyLock;
            synchronized (object2) {
                if (!this.empty) {
                    n = this.buf[this.front++] & 0xFF;
                    if (this.front >= this.buf.length) {
                        this.front = 0;
                    }
                    if (this.front == this.rear) {
                        this.empty = true;
                    }
                }
            }
            try {
                this.writeLock.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte read() throws IOException {
        int n = 0;
        Object object = this.readLock;
        synchronized (object) {
            n = this.poll();
            while (n < 0) {
                try {
                    this.readLock.wait();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                n = this.poll();
            }
        }
        return (byte)(n & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte by) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (!this.empty && this.front == this.rear) {
                try {
                    this.writeLock.wait();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
        }
        this.add(by);
    }
}

