/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.zxspectrum;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.EmuUtil;
import jkcemu.base.ROMFileSettingsFld;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;

public class ZXSpectrumSettingsFld
extends AbstractSettingsFld {
    private JRadioButton btn48K;
    private JRadioButton btn128K;
    private ROMFileSettingsFld fldAltROM;

    public ZXSpectrumSettingsFld(SettingsFrm settingsFrm, String string) {
        super(settingsFrm, string);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btn48K = new JRadioButton("ZX Spectrum 48K", true);
        buttonGroup.add(this.btn48K);
        this.add((Component)this.btn48K, gridBagConstraints);
        this.btn128K = new JRadioButton("ZX Spectrum+ 128K", false);
        buttonGroup.add(this.btn128K);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btn128K, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        ++gridBagConstraints.gridy;
        this.add((Component)new JSeparator(), gridBagConstraints);
        this.fldAltROM = new ROMFileSettingsFld(settingsFrm, string + "rom.", "Alternativer Betriebssystem-ROM:");
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)this.fldAltROM, gridBagConstraints);
        this.btn48K.addActionListener(this);
        this.btn128K.addActionListener(this);
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        EmuUtil.setProperty(properties, this.propPrefix + "model", this.btn128K.isSelected() ? "128k" : "48k");
        this.fldAltROM.applyInput(properties, bl);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null && object instanceof AbstractButton) {
            bl = true;
            this.fireDataChanged();
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.fldAltROM.lookAndFeelChanged();
    }

    @Override
    public void updFields(Properties properties) {
        if (EmuUtil.getProperty(properties, this.propPrefix + "model").equals("128k")) {
            this.btn128K.setSelected(true);
        } else {
            this.btn48K.setSelected(true);
        }
        this.fldAltROM.updFields(properties);
    }
}

