/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.zxspectrum;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.ZXSpectrum;

public class ZXSpectrum48KeyboardFld
extends AbstractKeyboardFld<ZXSpectrum> {
    private static final int FONT_LARGE_H = 12;
    private static final int FONT_LETTER_H = 18;
    private static final int FONT_H = 9;
    private static final int KEY_W = 45;
    private static final int KEY_H = 30;
    private static final int COL_W = 65;
    private static final int COL1_X1 = 15;
    private static final int COL2_X1 = 45;
    private static final int COL3_X1 = 65;
    private static final int COL4_X1 = 15;
    private static final int COL4_X2 = 100;
    private static final int ROW_H = 60;
    private static final int ROW1_Y = 10;
    private static final int ROW2_Y = 80;
    private static final int ROW3_Y = 140;
    private static final int ROW4_Y = 200;
    private AbstractKeyboardFld.KeyData keyCapsShift;
    private AbstractKeyboardFld.KeyData keySymbolShift;
    private AbstractKeyboardFld.KeyData keyEnter;
    private AbstractKeyboardFld.KeyData keySpace;
    private Image imgBG = this.getImage("bg.png");
    private Image imgG1 = this.getImage("g1.png");
    private Image imgG2 = this.getImage("g2.png");
    private Image imgG3 = this.getImage("g3.png");
    private Image imgG4 = this.getImage("g4.png");
    private Image imgG5 = this.getImage("g5.png");
    private Image imgG6 = this.getImage("g6.png");
    private Image imgG7 = this.getImage("g7.png");
    private Image imgG8 = this.getImage("g8.png");
    private Image imgLeft = this.getImage("left.png");
    private Image imgRight = this.getImage("right.png");
    private Image imgUp = this.getImage("up.png");
    private Image imgDown = this.getImage("down.png");
    private Image imgKey = this.getImage("key45.png");
    private Image imgKeyPressed = this.getImage("key45_pressed.png");
    private Image imgKeyCs = this.getImage("key65.png");
    private Image imgKeyCsPressed = this.getImage("key65_pressed.png");
    private Image imgKeySp = this.getImage("key75.png");
    private Image imgKeySpPressed = this.getImage("key75_pressed.png");
    private Color colorRed = new Color(192, 0, 0);
    private Color colorGreen = new Color(0, 192, 0);
    private Color colorBlue = new Color(0, 0, 255);
    private Color colorMagenta = new Color(192, 0, 192);
    private Color colorCyan = new Color(0, 192, 192);
    private Color colorYellow = new Color(192, 192, 0);
    private Color colorKeyNormal = new Color(150, 150, 150);
    private Color colorKeyPressed = new Color(100, 100, 100);
    private Font fontLarge = new Font("SansSerif", 1, 12);
    private Font fontLetter = new Font("SansSerif", 1, 18);
    private Font fontStd = new Font("SansSerif", 0, 9);
    private int[] kbMatrix = new int[8];
    private int curIdx = 0;
    private int curX = 15;
    private int curY = 32;

    public ZXSpectrum48KeyboardFld(ZXSpectrum zXSpectrum) {
        super(zXSpectrum, 40, false);
        this.addKey("1", this.imgG1, "!", this.colorRed, 3, 1);
        this.addKey("2", this.imgG2, "@", this.colorRed, 3, 2);
        this.addKey("3", this.imgG3, "#", this.colorRed, 3, 4);
        this.addKey("4", this.imgG4, "$", this.colorRed, 3, 8);
        this.addKey("5", this.imgG5, "%", this.colorRed, 3, 16);
        this.addKey("6", this.imgG6, "&", this.colorRed, 4, 16);
        this.addKey("7", this.imgG7, "'", this.colorRed, 4, 8);
        this.addKey("8", this.imgG8, "(", this.colorRed, 4, 4);
        this.addKey("9", null, ")", this.colorRed, 4, 2);
        this.addKey("0", null, "_", this.colorRed, 4, 1);
        this.curX = 45;
        this.curY = 91;
        this.addKey("Q", "<=", "PLOT", 2, 1);
        this.addKey("W", "<>", "DRAW", 2, 2);
        this.addKey("E", "<=", "REM", 2, 4);
        this.addKey("R", "<", "RUN", 2, 8);
        this.addKey("T", ">", "RAND", 2, 16);
        this.addKey("Y", "AND", "RETURN", 5, 16);
        this.addKey("U", "OR", "IF", 5, 8);
        this.addKey("I", "AT", "INPUT", 5, 4);
        this.addKey("O", ";", "POKE", 5, 2);
        this.addKey("P", "\"", "PRINT", 5, 1);
        this.curX = 65;
        this.curY = 151;
        this.addKey("A", "STOP", "NEW", 1, 1);
        this.addKey("S", "NOT", "SAVE", 1, 2);
        this.addKey("D", "STEP", "DIM", 1, 4);
        this.addKey("F", "TO", "FOR", 1, 8);
        this.addKey("G", "THEN", "GOTO", 1, 16);
        this.addKey("H", "\u2191", "GOSUB", 6, 16);
        this.addKey("J", "-", "LOAD", 6, 8);
        this.addKey("K", "+", "LIST", 6, 4);
        this.addKey("L", "=", "LET", 6, 2);
        this.keyEnter = this.addKey(6, 1, false);
        this.curY = 211;
        this.keyCapsShift = new AbstractKeyboardFld.KeyData(15, this.curY, 65, 30, null, null, null, null, null, 0, 1, true, null);
        this.keys[this.curIdx++] = this.keyCapsShift;
        this.curX = 100;
        this.addKey("Z", ":", "COPY", 0, 2);
        this.addKey("X", "\u00a3", "CLEAR", 0, 4);
        this.addKey("C", "?", "CONT", 0, 8);
        this.addKey("V", "/", "CLS", 0, 16);
        this.addKey("B", "*", "BORDER", 7, 16);
        this.addKey("N", ",", "NEXT", 7, 8);
        this.addKey("M", ".", "PAUSE", 7, 4);
        this.keySymbolShift = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 45, 30, null, null, null, null, null, 7, 2, true, null);
        this.keys[this.curIdx++] = this.keySymbolShift;
        this.curX += 65;
        this.keySpace = new AbstractKeyboardFld.KeyData(this.curX, this.curY, this.keyEnter.x + this.keyEnter.w - this.curX, 30, null, null, null, null, null, 7, 1, false, null);
        this.keys[this.curIdx++] = this.keySpace;
        this.curX += 65;
        this.setPreferredSize(new Dimension(this.keySpace.x + this.keySpace.w + 15, this.keySpace.y + this.keySpace.h + 9 + 10));
        this.setShiftKeys(this.keyCapsShift, this.keySymbolShift);
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        return emuSys instanceof ZXSpectrum ? !((ZXSpectrum)emuSys).isMode128K() : false;
    }

    @Override
    public String getKeyboardName() {
        return "ZX Spectrum 48K Tastatur";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Arrays.fill(this.kbMatrix, 0);
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                int n = keyData.col;
                this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
            }
        }
        ((ZXSpectrum)this.emuSys).updKeyboardMatrix(this.kbMatrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this) {
            super.mousePressed(mouseEvent);
            List list = this.selectedKeys;
            synchronized (list) {
                if ((ZXSpectrum48KeyboardFld.hits(this.keyCapsShift, mouseEvent) || ZXSpectrum48KeyboardFld.hits(this.keySymbolShift, mouseEvent)) && this.isKeySelected(this.keyCapsShift) && !this.keyCapsShift.locked && this.isKeySelected(this.keySymbolShift) && !this.keySymbolShift.locked) {
                    this.selectedKeys.remove(this.keyCapsShift);
                    this.selectedKeys.remove(this.keySymbolShift);
                }
            }
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.imgBG != null) {
            graphics.drawImage(this.imgBG, 0, 0, this);
        }
        for (int i = 0; i < this.keys.length; ++i) {
            AbstractKeyboardFld.KeyData keyData = this.keys[i];
            Image image = null;
            boolean bl = this.isKeySelected(keyData);
            if (keyData == this.keyCapsShift) {
                image = bl ? this.imgKeyCsPressed : this.imgKeyCs;
            } else if (keyData == this.keySpace) {
                image = bl ? this.imgKeySpPressed : this.imgKeySp;
            } else {
                Image image2 = image = bl ? this.imgKeyPressed : this.imgKey;
            }
            if (image != null) {
                graphics.drawImage(image, keyData.x, keyData.y, this);
            } else {
                graphics.setColor(bl ? this.colorKeyPressed : this.colorKeyNormal);
                graphics.fillRect(keyData.x, keyData.y, keyData.w, keyData.h);
            }
            if (keyData == this.keyEnter) {
                graphics.setFont(this.fontStd);
                graphics.setColor(Color.white);
                ZXSpectrum48KeyboardFld.drawStringCenter(graphics, "ENTER", keyData.x + 5, keyData.y + 10 + 9, keyData.w - 10);
                continue;
            }
            if (keyData == this.keyCapsShift) {
                graphics.setFont(this.fontLarge);
                graphics.setColor(Color.white);
                ZXSpectrum48KeyboardFld.drawStringCenter(graphics, "CAPS", keyData.x + 5, keyData.y + keyData.h / 2 - 2, keyData.w - 10);
                ZXSpectrum48KeyboardFld.drawStringCenter(graphics, "SHIFT", keyData.x + 5, keyData.y + keyData.h / 2 + 12 - 1, keyData.w - 10);
                continue;
            }
            if (keyData == this.keySymbolShift) {
                graphics.setFont(this.fontStd);
                graphics.setColor(this.colorRed);
                ZXSpectrum48KeyboardFld.drawStringCenter(graphics, "SYMBOL", keyData.x + 5, keyData.y + keyData.h / 2 - 2, keyData.w - 10);
                ZXSpectrum48KeyboardFld.drawStringCenter(graphics, "SHIFT", keyData.x + 5, keyData.y + keyData.h / 2 + 12 - 1, keyData.w - 10);
                continue;
            }
            if (keyData == this.keySpace) {
                graphics.setColor(Color.white);
                graphics.setFont(this.fontStd);
                ZXSpectrum48KeyboardFld.drawStringCenter(graphics, "BREAK", keyData.x + 5, keyData.y + keyData.h / 2 - 3, keyData.w - 10);
                graphics.setFont(this.fontLarge);
                ZXSpectrum48KeyboardFld.drawStringCenter(graphics, "SPACE", keyData.x + 5, keyData.y + keyData.h / 2 + 12 - 1, keyData.w - 10);
                continue;
            }
            if (keyData.image != null) {
                graphics.drawImage(keyData.image, keyData.x + keyData.w - 15, keyData.y + 3, this);
            }
            graphics.setFont(this.fontLetter);
            if (keyData.text1 != null) {
                graphics.setColor(Color.white);
                if (i < 10) {
                    graphics.drawString(keyData.text1, keyData.x + 5, keyData.y + 20);
                } else {
                    graphics.drawString(keyData.text1, keyData.x + 3, keyData.y + 18 - 1);
                }
            }
            graphics.setFont(this.fontStd);
            if (keyData.text2 != null) {
                graphics.setColor(this.colorRed);
                ZXSpectrum48KeyboardFld.drawStringRight(graphics, keyData.text2, keyData.x + 20, keyData.y + 3 + 9, keyData.w - 23);
            }
            if (keyData.text3 == null) continue;
            if (i < 10) {
                graphics.setColor(this.colorRed);
                graphics.drawString(keyData.text3, keyData.x + keyData.w - 14, keyData.y + 30 - 5);
                continue;
            }
            graphics.setColor(Color.WHITE);
            ZXSpectrum48KeyboardFld.drawStringRight(graphics, keyData.text3, keyData.x + 20, keyData.y + 30 - 3, keyData.w - 23);
        }
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!(emuSys instanceof ZXSpectrum)) {
            throw new IllegalArgumentException("EmuSys != ZXSpectrum");
        }
        this.emuSys = (ZXSpectrum)emuSys;
    }

    @Override
    protected Image getImage(String string) {
        return super.getImage("/images/keyboard/zxspectrum/48k/" + string);
    }

    private AbstractKeyboardFld.KeyData addKey(int n, int n2, boolean bl) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 45, 30, null, null, null, null, null, n, n2, bl, null);
        this.keys[this.curIdx++] = keyData;
        this.curX += 65;
        return keyData;
    }

    private void addKey(String string, String string2, String string3, int n, int n2) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 45, 30, string, string2, string3, this.colorGreen, null, n, n2, false, null);
        this.keys[this.curIdx++] = keyData;
        this.curX += 65;
    }

    private void addKey(String string, Image image, String string2, Color color, int n, int n2) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 45, 30, string, null, string2, color, image, n, n2, false, null);
        this.keys[this.curIdx++] = keyData;
        this.curX += 65;
    }
}

