/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.zxspectrum;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.ZXSpectrum;

public class ZXSpectrum128KeyboardFld
extends AbstractKeyboardFld<ZXSpectrum> {
    private static final String KEY_TEXT_CAPS_SHIFT = "\nCAPS SHIFT";
    private static final String KEY_TEXT_SYMBOL_SHIFT = "SYMBOL\nSHIFT";
    private static final int KEY_H = 60;
    private static final int KEY_W = 60;
    private static final int KEY_EDIT_W = 75;
    private static final int KEY_LARGE_W = 90;
    private static final int KEY_CAPS_SHIFT_W = 135;
    private static final int KEY_SPACE_W = 270;
    private static final int KEY_ENTER_W = 105;
    private static final int KEY_ENTER_H = 120;
    private static final int FONT_HUGE_H = 18;
    private static final int FONT_LARGE_H = 14;
    private static final int FONT_STD_H = 10;
    private static final int KEY_X1 = 30;
    private static final int KEY_Y1 = 60;
    private static final int CAPS_SHIFT_COL = 0;
    private static final int CAPS_SHIFT_VALUE = 1;
    private static final int SYM_SHIFT_COL = 7;
    private static final int SYM_SHIFT_VALUE = 2;
    private Color colorBg = new Color(-12566464);
    private Color colorSelected = new Color(-1070583760);
    private Color colorShadow = new Color(-16777216);
    private Color colorLight = new Color(-8355712);
    private Color colorLogo = Color.RED;
    private Font fontHuge;
    private Font fontLarge;
    private Font fontStd;
    private Polygon polygonEnter;
    private Image imgG1 = this.getImage("g1.png");
    private Image imgG2 = this.getImage("g2.png");
    private Image imgG3 = this.getImage("g3.png");
    private Image imgG4 = this.getImage("g4.png");
    private Image imgG5 = this.getImage("g5.png");
    private Image imgG6 = this.getImage("g6.png");
    private Image imgG7 = this.getImage("g7.png");
    private Image imgG8 = this.getImage("g8.png");
    private Image imgKeyEnter;
    private Image imgLeft = this.getImage("left.png");
    private Image imgRight = this.getImage("right.png");
    private Image imgUp = this.getImage("up.png");
    private Image imgDown = this.getImage("down.png");
    private Image imgKeyCapsShift;
    private Image imgKeyEdit;
    private Image imgKeyLarge;
    private Image imgKeySpace;
    private Image imgKeyStd;
    private Image imgLogo128k;
    private Set<AbstractKeyboardFld.KeyData> capsShiftLinks;
    private Set<AbstractKeyboardFld.KeyData> symShiftLinks;
    private AbstractKeyboardFld.KeyData keyCapsShift1;
    private AbstractKeyboardFld.KeyData keyCapsShift2;
    private AbstractKeyboardFld.KeyData keySymShift1;
    private AbstractKeyboardFld.KeyData keySymShift2;
    private AbstractKeyboardFld.KeyData keyEnter;
    private int[] kbMatrix;
    private int curIdx = 0;
    private int curX = 30;
    private int curY = 60;

    public ZXSpectrum128KeyboardFld(ZXSpectrum zXSpectrum) {
        super(zXSpectrum, 58, false);
        this.imgKeyEnter = this.getImage("key_enter.png");
        this.imgKeyEdit = this.getImage("key75.png");
        this.imgKeyLarge = this.getImage("key90.png");
        this.imgKeyCapsShift = this.getImage("key135.png");
        this.imgKeySpace = this.getImage("key270.png");
        this.imgKeyStd = this.getImage("key60.png");
        this.imgLogo128k = this.getImage("logo128k.png");
        this.capsShiftLinks = new HashSet<AbstractKeyboardFld.KeyData>();
        this.symShiftLinks = new HashSet<AbstractKeyboardFld.KeyData>();
        this.fontHuge = new Font("SansSerif", 1, 18);
        this.fontLarge = new Font("SansSerif", 0, 14);
        this.fontStd = new Font("SansSerif", 0, 10);
        this.kbMatrix = new int[8];
        this.capsShiftLinks.add(this.addKey(null, "TRUE\nVIDEO", null, 3, 4));
        this.capsShiftLinks.add(this.addKey(null, "INV\nVIDEO", null, 3, 8));
        this.addKey("1", this.imgG1, "!", "BLUE\nDEF FN", 3, 1);
        this.addKey("2", this.imgG2, "@", "RED\nFN", 3, 2);
        this.addKey("3", this.imgG3, "#", "MGNTA\nLINE", 3, 4);
        this.addKey("4", this.imgG4, "$", "GREEN\nOPEN #", 3, 8);
        this.addKey("5", this.imgG5, "%", "CYAN\nCLOSE #", 3, 16);
        this.addKey("6", this.imgG6, "&", "YELLOW\nMOVE", 4, 16);
        this.addKey("7", this.imgG7, "'", "WHITE\nERASE", 4, 8);
        this.addKey("8", this.imgG8, "(", "\nPOINT", 4, 4);
        this.addKey("9", ")", "\nCAT", 4, 2);
        this.addKey("0", "_", "BLACK\nFORMAT", 4, 1);
        this.capsShiftLinks.add(this.addKey(90, null, "\nBREAK", null, 7, 1));
        this.curX = 30;
        this.curY += 60;
        this.capsShiftLinks.add(this.addKey(90, null, "\nDELETE", null, 4, 1));
        this.capsShiftLinks.add(this.addKey(null, "\nGRAPH", null, 4, 2));
        this.addKey("Q", "PLOT\n<=", "SIN\nASIN", 2, 1);
        this.addKey("W", "DRAW\n<>", "COS\nACS", 2, 2);
        this.addKey("E", "REM\n>=", "TAN\nATN", 2, 4);
        this.addKey("R", "RUN\n<", "INT\nVERIFY", 2, 8);
        this.addKey("T", "RAND\n>", "RND\nMERGE", 2, 16);
        this.addKey("Y", "RETURN\nAND", "STR$\n[", 5, 16);
        this.addKey("U", "IF\nOR", "CHR$\n]", 5, 8);
        this.addKey("I", "INPUT\nAT", "CODE\nIN", 5, 4);
        this.addKey("O", "POKE", "PEEK\nOUT", 5, 2);
        this.addKey("P", "PRINT", "TAB\n(c)", 5, 1);
        this.curX = 30;
        this.curY += 60;
        AbstractKeyboardFld.KeyData keyData = this.addKey(90, null, "EXTENDED\nMODE", null, 0, 0);
        this.capsShiftLinks.add(keyData);
        this.symShiftLinks.add(keyData);
        this.capsShiftLinks.add(this.addKey(75, null, "\nEDIT", null, 3, 1));
        this.addKey("A", "NEW\nSTOP", "READ\n~", 1, 1);
        this.addKey("S", "SAVE\nNOT", "RESTR\n|", 1, 2);
        this.addKey("D", "DIM\nSTEP", "DATA\n\\", 1, 4);
        this.addKey("F", "FOR\nTO", "SGN\n{", 1, 8);
        this.addKey("G", "GOTO\nTHEN", "ABS\n}", 1, 16);
        this.addKey("H", "GOSUB\n\u2191", "SQR\nCIRCLE", 6, 16);
        this.addKey("J", "LOAD\n-", "VAL\nVAL$", 6, 8);
        this.addKey("K", "LIST\n+", "LEN\nSCRN$", 6, 4);
        this.addKey("L", "LET\n=", "USR\nATTR", 6, 2);
        this.keyEnter = new AbstractKeyboardFld.KeyData(this.curX, this.curY - 60, 105, 120, null, "ENTER", null, null, null, 6, 1, false, null);
        this.keys[this.curIdx++] = this.keyEnter;
        this.curX = 30;
        this.curY += 60;
        this.keyCapsShift1 = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 135, 60, null, KEY_TEXT_CAPS_SHIFT, null, null, null, 0, 1, true, null);
        this.keys[this.curIdx++] = this.keyCapsShift1;
        this.curX += 135;
        this.capsShiftLinks.add(this.addKey(null, "CAPS\nLOCK", null, 3, 2));
        this.addKey("Z", "COPY\n:", "LN\nBEEP", 0, 2);
        this.addKey("X", "CLEAR\n\u00a3", "EXP\nINK", 0, 4);
        this.addKey("C", "CONT\n?", "LPRINT\nPAPER", 0, 8);
        this.addKey("V", "CLS\n/", "LLIST\nFLASH", 0, 16);
        this.addKey("B", "BORDER\n*", "BIN\nBRIGHT", 7, 16);
        this.addKey("N", "NEXT", "INKEY$\nOVER", 7, 8);
        this.addKey("M", "PAUSE", "PI\nINVERS", 7, 4);
        this.symShiftLinks.add(this.addKey(".", null, null, 7, 4));
        this.keyCapsShift2 = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 135, 60, null, KEY_TEXT_CAPS_SHIFT, null, null, null, 0, 1, true, null);
        this.keys[this.curIdx++] = this.keyCapsShift2;
        this.curX = 30;
        this.curY += 60;
        this.keySymShift1 = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 60, null, KEY_TEXT_SYMBOL_SHIFT, null, null, null, 7, 2, true, null);
        this.keys[this.curIdx++] = this.keySymShift1;
        this.curX += 60;
        this.symShiftLinks.add(this.addKey(";", null, null, 5, 2));
        this.symShiftLinks.add(this.addKey("\"", null, null, 5, 1));
        this.capsShiftLinks.add(this.addKey(null, this.imgLeft, null, null, 3, 16));
        this.capsShiftLinks.add(this.addKey(null, this.imgRight, null, null, 4, 4));
        this.addKey(270, null, null, null, 7, 1);
        this.capsShiftLinks.add(this.addKey(null, this.imgUp, null, null, 4, 8));
        this.capsShiftLinks.add(this.addKey(null, this.imgDown, null, null, 4, 16));
        this.symShiftLinks.add(this.addKey(",", null, null, 7, 8));
        this.keySymShift2 = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 60, null, KEY_TEXT_SYMBOL_SHIFT, null, null, null, 7, 2, true, null);
        this.keys[this.curIdx++] = this.keySymShift2;
        this.polygonEnter = new Polygon(new int[]{this.keyEnter.x + this.keyEnter.w - 60, this.keyEnter.x + this.keyEnter.w - 1, this.keyEnter.x + this.keyEnter.w - 1, this.keyEnter.x, this.keyEnter.x, this.keyEnter.x + this.keyEnter.w - 60, this.keyEnter.x + this.keyEnter.w - 60}, new int[]{this.keyEnter.y, this.keyEnter.y, this.keyEnter.y + this.keyEnter.h - 1, this.keyEnter.y + this.keyEnter.h - 1, this.keyEnter.y + 60, this.keyEnter.y + 60, this.keyEnter.y}, 7);
        int n = Math.max(30, this.imgLogo128k.getWidth(this) + 20);
        this.setPreferredSize(new Dimension(this.keySymShift2.x + this.keySymShift2.w + n, this.keySymShift2.y + this.keySymShift2.h + 30));
        this.setShiftKeys(this.keyCapsShift1, this.keyCapsShift2, this.keySymShift1, this.keySymShift2);
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        return emuSys instanceof ZXSpectrum ? ((ZXSpectrum)emuSys).isMode128K() : false;
    }

    @Override
    public String getKeyboardName() {
        return "ZX Spectrum+ 128K Tastatur";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Arrays.fill(this.kbMatrix, 0);
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                if (this.capsShiftLinks.contains(keyData)) {
                    this.kbMatrix[0] = this.kbMatrix[0] | 1;
                }
                if (this.symShiftLinks.contains(keyData)) {
                    this.kbMatrix[7] = this.kbMatrix[7] | 2;
                }
                if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                int n = keyData.col;
                this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
            }
        }
        ((ZXSpectrum)this.emuSys).updKeyboardMatrix(this.kbMatrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this) {
            super.mousePressed(mouseEvent);
            List list = this.selectedKeys;
            synchronized (list) {
                if ((ZXSpectrum128KeyboardFld.hits(this.keyCapsShift1, mouseEvent) || ZXSpectrum128KeyboardFld.hits(this.keyCapsShift2, mouseEvent) || ZXSpectrum128KeyboardFld.hits(this.keySymShift1, mouseEvent) || ZXSpectrum128KeyboardFld.hits(this.keySymShift2, mouseEvent)) && (this.isKeySelected(this.keyCapsShift1) && !this.keyCapsShift1.locked || this.isKeySelected(this.keyCapsShift2) && !this.keyCapsShift2.locked) && (this.isKeySelected(this.keySymShift1) && !this.keySymShift1.locked || this.isKeySelected(this.keySymShift2) && !this.keySymShift2.locked)) {
                    this.selectedKeys.remove(this.keyCapsShift1);
                    this.selectedKeys.remove(this.keyCapsShift2);
                    this.selectedKeys.remove(this.keySymShift1);
                    this.selectedKeys.remove(this.keySymShift2);
                }
            }
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        int n2 = this.getWidth();
        graphics.setColor(this.colorBg);
        graphics.fillRect(0, 0, n2, this.getHeight());
        graphics.setColor(this.colorLogo);
        this.setFont(new Font("SansSerif", 0, 16));
        graphics.drawString("ZX Spectrum+", 31, 20);
        int n3 = 60;
        for (n = 0; n < 5; ++n) {
            graphics.setColor(this.colorShadow);
            graphics.drawLine(0, n3, 30, n3);
            graphics.setColor(this.colorLight);
            graphics.drawLine(0, n3 + 1, 30, n3 + 1);
            n3 += 60;
        }
        for (n = 0; n < this.keys.length; ++n) {
            AbstractKeyboardFld.KeyData keyData = this.keys[n];
            Image image = null;
            boolean bl = this.isKeySelected(keyData);
            if (keyData == this.keyEnter) {
                if (bl) {
                    graphics.setColor(this.colorSelected);
                    graphics.fillPolygon(this.polygonEnter);
                } else {
                    graphics.setColor(Color.BLACK);
                    graphics.drawPolygon(this.polygonEnter);
                }
                if (this.imgKeyEnter != null) {
                    graphics.drawImage(this.imgKeyEnter, keyData.x, keyData.y, this);
                }
                graphics.setColor(Color.WHITE);
                graphics.setFont(this.fontStd);
                ZXSpectrum128KeyboardFld.drawStringCenter(graphics, keyData.text2, keyData.x, keyData.y + keyData.h / 4 * 3 + 10 - 4, keyData.w);
                continue;
            }
            if (bl) {
                graphics.setColor(this.colorSelected);
                graphics.fillRect(keyData.x, keyData.y, keyData.w - 1, keyData.h - 1);
            } else {
                graphics.setColor(Color.BLACK);
                graphics.drawRect(keyData.x, keyData.y, keyData.w - 1, keyData.h - 1);
            }
            switch (keyData.w) {
                case 60: {
                    image = this.imgKeyStd;
                    break;
                }
                case 75: {
                    image = this.imgKeyEdit;
                    break;
                }
                case 90: {
                    image = this.imgKeyLarge;
                    break;
                }
                case 135: {
                    image = this.imgKeyCapsShift;
                    break;
                }
                case 270: {
                    image = this.imgKeySpace;
                }
            }
            if (image != null) {
                graphics.drawImage(image, keyData.x, keyData.y, this);
            }
            if (keyData.image != null) {
                graphics.drawImage(keyData.image, keyData.x, keyData.y, this);
            }
            graphics.setColor(Color.WHITE);
            if (keyData.text1 != null) {
                graphics.setFont(this.fontHuge);
                if (keyData.text2 == null && keyData.text3 == null) {
                    ZXSpectrum128KeyboardFld.drawStringCenter(graphics, keyData.text1, keyData.x, keyData.y + keyData.h / 2 + 18 - 8, keyData.w);
                } else {
                    ZXSpectrum128KeyboardFld.drawStringCenter(graphics, keyData.text1, keyData.x, keyData.y + keyData.h - 7, keyData.w);
                }
            }
            if (keyData.text2 != null) {
                int n4 = keyData.y + 30 - 2;
                if (keyData.text2.length() == 1) {
                    graphics.setFont(this.fontLarge);
                    graphics.drawString(keyData.text2, keyData.x + 30 + 5, n4 + 5);
                } else {
                    String string = null;
                    String string2 = null;
                    int n5 = keyData.text2.indexOf(10);
                    if (n5 >= 0) {
                        string = keyData.text2.substring(0, n5);
                        string2 = keyData.text2.substring(n5 + 1);
                    } else {
                        string = keyData.text2;
                    }
                    graphics.setFont(this.fontStd);
                    if (string != null) {
                        ZXSpectrum128KeyboardFld.drawStringCenter(graphics, string, keyData.x, n4, keyData.w);
                    }
                    if (string2 != null && !string2.isEmpty()) {
                        graphics.setFont(this.fontStd);
                        n4 += 8;
                        char c = string2.charAt(0);
                        if (c == '~' || Character.isLetter(c)) {
                            ZXSpectrum128KeyboardFld.drawStringCenter(graphics, string2, keyData.x, n4, keyData.w);
                        } else {
                            int n6 = keyData.x + keyData.w - 22;
                            if (c == '|' || c == '\\' || c == '[' || c == ']' || c == '{' || c == '}') {
                                n6 = keyData.x + 15;
                            }
                            graphics.drawString(string2, n6, n4);
                        }
                    }
                }
            }
            if (keyData.text3 == null) continue;
            graphics.setFont(this.fontStd);
            this.drawMultiLineString(graphics, keyData.x, keyData.y + 10 - 1, keyData.w, keyData.text3, 8);
        }
        n = this.keySymShift2.x + this.keySymShift2.w;
        n3 = 60;
        for (int i = 0; i < 5; ++i) {
            graphics.setColor(this.colorShadow);
            graphics.drawLine(n, n3, n2, n3);
            graphics.setColor(this.colorLight);
            graphics.drawLine(n, n3 + 1, n2, n3 + 1);
            n3 += 60;
        }
        graphics.setColor(this.colorShadow);
        graphics.drawLine(0, n3, n2, n3);
        graphics.setColor(this.colorLight);
        graphics.drawLine(0, n3 + 1, n2, n3 + 1);
        if (this.imgLogo128k != null) {
            graphics.drawImage(this.imgLogo128k, n + 10, n3 - 5 - this.imgLogo128k.getHeight(this), this);
        }
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!(emuSys instanceof ZXSpectrum)) {
            throw new IllegalArgumentException("EmuSys != ZXSpectrum");
        }
        this.emuSys = (ZXSpectrum)emuSys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeySelection(int[] nArray) {
        boolean bl = false;
        List list = this.selectedKeys;
        synchronized (list) {
            bl = !this.selectedKeys.isEmpty();
            this.selectedKeys.clear();
            if (nArray != null) {
                int n;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                if (0 < nArray.length && (nArray[0] & 1) != 0) {
                    bl3 = true;
                }
                if (7 < nArray.length && (nArray[7] & 2) != 0) {
                    bl4 = true;
                }
                for (n = 0; n < nArray.length; ++n) {
                    if (nArray[n] == 0) continue;
                    for (AbstractKeyboardFld.KeyData keyData : this.keys) {
                        if (keyData.col != n || (keyData.value & nArray[n]) == 0 || keyData == this.keySymShift1 || keyData == this.keySymShift2 || keyData == this.keyCapsShift1 || keyData == this.keyCapsShift2 || bl3 != this.capsShiftLinks.contains(keyData) || bl4 != this.symShiftLinks.contains(keyData)) continue;
                        bl2 = true;
                        bl = true;
                        keyData.locked = false;
                        this.selectedKeys.add(keyData);
                    }
                }
                if (!bl2) {
                    for (n = 0; n < nArray.length; ++n) {
                        if (nArray[n] == 0) continue;
                        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
                            if (keyData.col != n || (keyData.value & nArray[n]) == 0 || keyData == this.keySymShift1 || keyData == this.keySymShift2 || keyData == this.keyCapsShift1 || keyData == this.keyCapsShift2 || this.capsShiftLinks.contains(keyData) || this.symShiftLinks.contains(keyData)) continue;
                            if (bl3) {
                                bl5 = true;
                            }
                            if (bl4) {
                                bl6 = true;
                            }
                            bl = true;
                            keyData.locked = false;
                            this.selectedKeys.add(keyData);
                        }
                    }
                }
                if (bl5) {
                    this.keyCapsShift1.locked = false;
                    this.keyCapsShift2.locked = false;
                    this.selectedKeys.add(this.keyCapsShift1);
                    this.selectedKeys.add(this.keyCapsShift2);
                    bl = true;
                }
                if (bl6) {
                    this.keySymShift1.locked = false;
                    this.keySymShift2.locked = false;
                    this.selectedKeys.add(this.keySymShift1);
                    this.selectedKeys.add(this.keySymShift2);
                    bl = true;
                }
            }
        }
        if (bl) {
            this.repaint();
        }
    }

    @Override
    protected Image getImage(String string) {
        return super.getImage("/images/keyboard/zxspectrum/128k/" + string);
    }

    private AbstractKeyboardFld.KeyData addKey(String string, String string2, String string3, int n, int n2) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 60, string, string2, string3, null, null, n, n2, false, null);
        this.keys[this.curIdx++] = keyData;
        this.curX += 60;
        return keyData;
    }

    private AbstractKeyboardFld.KeyData addKey(int n, String string, String string2, String string3, int n2, int n3) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, n, 60, string, string2, string3, null, null, n2, n3, false, null);
        this.keys[this.curIdx++] = keyData;
        this.curX += n;
        return keyData;
    }

    private AbstractKeyboardFld.KeyData addKey(String string, Image image, String string2, String string3, int n, int n2) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 60, string, string2, string3, null, image, n, n2, false, null);
        this.keys[this.curIdx++] = keyData;
        this.curX += 60;
        return keyData;
    }

    private void drawMultiLineString(Graphics graphics, int n, int n2, int n3, String string, int n4) {
        if (string != null) {
            int n5 = string.length();
            int n6 = 0;
            while (n6 < n5) {
                int n7 = string.indexOf(10, n6);
                if (n7 < n6) {
                    ZXSpectrum128KeyboardFld.drawStringCenter(graphics, string.substring(n6), n, n2, n3);
                    break;
                }
                ZXSpectrum128KeyboardFld.drawStringCenter(graphics, string.substring(n6, n7), n, n2, n3);
                n6 = n7 + 1;
                n2 += n4;
            }
        }
    }
}

