/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.z1013;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Arrays;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.Z1013;
import jkcemu.emusys.z1013.KeyboardMatrix;
import jkcemu.emusys.z1013.KeyboardMatrix8x8;
import jkcemu.emusys.z1013.Z1013Keyboard;

public class Z1013KeyboardFld8x8
extends AbstractKeyboardFld<Z1013> {
    private static final int MARGIN = 20;
    private static final int TEXT_FONT_SIZE = 11;
    private static final int LETTER_FONT_SIZE = 14;
    private static final int DIGIT_FONT_SIZE = 12;
    private static final int KEY_SIZE = 40;
    private static final int MEDIUM_KEY_SIZE = 50;
    private static final int LARGE_KEY_SIZE = 60;
    private static final int SPACE_KEY_SIZE = 320;
    private static final int DOUBLE_KEY_HEIGHT = 80;
    private Image imgLeft = this.getImage("/images/keyboard/left.png");
    private Image imgRight = this.getImage("/images/keyboard/right.png");
    private Image imgUp = this.getImage("/images/keyboard/up.png");
    private Image imgDown = this.getImage("/images/keyboard/down.png");
    private Font fontText = new Font("SansSerif", 0, 11);
    private Font fontLetter = new Font("SansSerif", 0, 14);
    private Font fontDigit = new Font("SansSerif", 0, 12);
    private int[] kbMatrix = new int[8];
    private int curIdx = 0;
    private int curX = 20;
    private int curY = 20;

    public Z1013KeyboardFld8x8(Z1013 z1013) {
        super(z1013, 59, true);
        this.addKey("\\", "|", 5, 64);
        this.addKey("1", "!", 0, 1);
        this.addKey("2", "\"", 0, 16);
        this.addKey("3", "#", 1, 1);
        this.addKey("4", "$", 1, 16);
        this.addKey("5", "%", 2, 1);
        this.addKey("6", "&", 2, 16);
        this.addKey("7", "'", 3, 1);
        this.addKey("8", "(", 3, 16);
        this.addKey("9", ")", 4, 1);
        this.addKey("0", "", 4, 16);
        this.addKey("-", "=", 5, 1);
        this.addKey("^", "~", 5, 8);
        this.addKey("Graph\nE/A", null, 6, 1, "F1");
        this.curX = 20;
        this.curY += 40;
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 40, "CTRL", null, null, null, null, 6, 32, true, null);
        this.keys[this.curIdx++] = keyData;
        this.curX += 60;
        this.addKey("Q", 0, 2);
        this.addKey("W", 0, 32);
        this.addKey("E", 1, 2);
        this.addKey("R", 1, 32);
        this.addKey("T", 2, 2);
        this.addKey("Z", 2, 32);
        this.addKey("U", 3, 2);
        this.addKey("I", 3, 32);
        this.addKey("O", 4, 2);
        this.addKey("P", 4, 32);
        this.addKey("@", "`", 5, 2);
        this.addKey("[", "{", 5, 16);
        this.curX = 30;
        this.curY += 40;
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 40, "Shift\nLock", null, null, null, null, 7, 128, false, null);
        this.curX += 60;
        this.addKey("A", 0, 4);
        this.addKey("S", 0, 64);
        this.addKey("D", 1, 4);
        this.addKey("F", 1, 64);
        this.addKey("G", 2, 4);
        this.addKey("H", 2, 64);
        this.addKey("J", 3, 4);
        this.addKey("K", 3, 64);
        this.addKey("L", 4, 4);
        this.addKey("+", ";", 4, 64);
        this.addKey("*", ":", 5, 4);
        this.addKey("]", "}", 5, 32);
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 80, "ENT", null, null, null, null, 6, 2, false, "Enter");
        int n = this.curX + 40 + 20;
        this.curX = 20;
        this.curY += 40;
        AbstractKeyboardFld.KeyData keyData2 = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 50, 40, "Shift", null, null, null, null, 7, 64, true, null);
        this.keys[this.curIdx++] = keyData2;
        this.curX += 50;
        this.addKey("_", 5, 128);
        this.addKey("Y", 0, 8);
        this.addKey("X", 0, 128);
        this.addKey("C", 1, 8);
        this.addKey("V", 1, 128);
        this.addKey("B", 2, 8);
        this.addKey("N", 2, 128);
        this.addKey("M", 3, 8);
        this.addKey(",", "<", 3, 128);
        this.addKey(".", ">", 4, 8);
        this.addKey("/", "?", 4, 128);
        AbstractKeyboardFld.KeyData keyData3 = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 40, "Shift", null, null, null, null, 7, 64, true, null);
        this.keys[this.curIdx++] = keyData3;
        this.curX = 80;
        this.curY += 40;
        this.addKey(this.imgUp, 6, 64);
        this.addKey(this.imgLeft, 6, 4);
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 320, 40, null, null, null, null, null, 6, 16, false, null);
        this.curX += 320;
        this.addKey(this.imgRight, 6, 8);
        this.addKey(this.imgDown, 6, 128);
        int n2 = this.curY + 40 + 20;
        this.setPreferredSize(new Dimension(n, n2));
        this.setShiftKeys(keyData2, keyData3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeySelection(int[] nArray) {
        boolean bl = false;
        List list = this.selectedKeys;
        synchronized (list) {
            bl = !this.selectedKeys.isEmpty();
            this.selectedKeys.clear();
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) continue;
                    for (AbstractKeyboardFld.KeyData keyData : this.keys) {
                        if (keyData.col != i || (keyData.value & nArray[i]) == 0) continue;
                        bl = true;
                        keyData.locked = false;
                        this.selectedKeys.add(keyData);
                    }
                }
            }
        }
        if (bl) {
            this.repaint();
        }
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        KeyboardMatrix keyboardMatrix;
        Z1013Keyboard z1013Keyboard;
        boolean bl = false;
        if (emuSys instanceof Z1013 && (z1013Keyboard = ((Z1013)emuSys).getZ1013Keyboard()) != null && (keyboardMatrix = z1013Keyboard.getKeyboardMatrix()) != null && keyboardMatrix instanceof KeyboardMatrix8x8) {
            bl = true;
        }
        return bl;
    }

    @Override
    public String getKeyboardName() {
        return "Z1013 Alphatastatur";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Z1013Keyboard z1013Keyboard = ((Z1013)this.emuSys).getZ1013Keyboard();
        KeyboardMatrix keyboardMatrix = z1013Keyboard.getKeyboardMatrix();
        if (keyboardMatrix instanceof KeyboardMatrix8x8) {
            Arrays.fill(this.kbMatrix, 0);
            List list = this.selectedKeys;
            synchronized (list) {
                for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                    if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                    int n = keyData.col;
                    this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
                }
            }
            ((KeyboardMatrix8x8)keyboardMatrix).updKeyboardMatrix(this.kbMatrix);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setPaintMode();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
            boolean bl = this.isKeySelected(keyData);
            if (bl) {
                graphics.setColor(Color.gray);
                graphics.fillRect(keyData.x + 1, keyData.y + 1, keyData.w - 1, keyData.h - 1);
            }
            graphics.setColor(Color.lightGray);
            graphics.draw3DRect(keyData.x + 1, keyData.y + 1, keyData.w - 1, keyData.h - 1, !bl);
            if (keyData.image != null) {
                graphics.drawImage(keyData.image, keyData.x + (keyData.w - keyData.image.getWidth(this)) / 2 + 1, keyData.y + (keyData.h - keyData.image.getHeight(this)) / 2 + 1, this);
                continue;
            }
            graphics.setColor(Color.black);
            if (keyData.text1 == null) continue;
            if (keyData.text2 != null) {
                graphics.setFont(this.fontDigit);
                graphics.drawString(keyData.text1, keyData.x + 8, keyData.y + 40 - 8);
                graphics.drawString(keyData.text2, keyData.x + 20, keyData.y + 5 + 12);
                continue;
            }
            if (keyData.text1.length() == 1) {
                graphics.setFont(this.fontLetter);
                this.drawMultiLineString(graphics, keyData.x, keyData.y, keyData.w, keyData.h, keyData.text1, 14);
                continue;
            }
            graphics.setFont(this.fontText);
            this.drawMultiLineString(graphics, keyData.x, keyData.y, keyData.w, keyData.h, keyData.text1, 11);
        }
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!this.accepts(emuSys)) {
            throw new IllegalArgumentException("EmuSys != Z1013/8x8");
        }
        this.emuSys = (Z1013)emuSys;
    }

    private void addKey(Image image, int n, int n2) {
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, null, null, null, null, image, n, n2, false, null);
        this.curX += 40;
    }

    private void addKey(String string, String string2, int n, int n2, String string3) {
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, string, string2, null, null, null, n, n2, false, string3);
        this.curX += 40;
    }

    private void addKey(String string, String string2, int n, int n2) {
        this.addKey(string, string2, n, n2, null);
    }

    private void addKey(String string, int n, int n2) {
        this.addKey(string, null, n, n2, null);
    }
}

