/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.z1013;

import java.util.Arrays;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.emusys.z1013.KeyboardMatrix;

public class KeyboardMatrix8x4
extends KeyboardMatrix {
    private int[] keyboardMatrix = new int[8];

    public KeyboardMatrix8x4() {
        this.reset();
    }

    public boolean isAnyControlKeyPressed() {
        boolean bl = false;
        for (int i = 0; i < 4; ++i) {
            if ((this.keyboardMatrix[i] & 8) == 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public synchronized void updKeyboardMatrix(int[] nArray) {
        int n;
        int n2 = Math.min(nArray.length, this.keyboardMatrix.length);
        for (n = 0; n < n2; ++n) {
            this.keyboardMatrix[n] = nArray[n];
        }
        while (n < this.keyboardMatrix.length) {
            this.keyboardMatrix[n] = 0;
            ++n;
        }
        this.updShiftKeysPressed();
    }

    @Override
    public String getKeyboardType() {
        return "8x4";
    }

    @Override
    public int getRowValues(int n, boolean bl) {
        int n2 = 0;
        if (n >= 0) {
            if (this.onlyShiftKeysReadable()) {
                if (n < 4) {
                    n2 = this.keyboardMatrix[n] & 8;
                }
            } else if (n < this.keyboardMatrix.length) {
                n2 = this.keyboardMatrix[n];
            }
        }
        return n2;
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.keyboardMatrix, 0);
    }

    @Override
    public synchronized boolean setKeyCode(int n) {
        boolean bl = true;
        this.reset();
        switch (n) {
            case 37: {
                this.keyboardMatrix[4] = 8;
                break;
            }
            case 39: {
                this.keyboardMatrix[6] = 8;
                break;
            }
            case 10: {
                this.keyboardMatrix[7] = 8;
                break;
            }
            case 32: {
                this.keyboardMatrix[5] = 8;
                break;
            }
            case 8: {
                this.setKeyCharCode(8, false);
                break;
            }
            case 9: {
                this.setKeyCharCode(9, false);
                break;
            }
            case 40: {
                this.setKeyCharCode(10, false);
                break;
            }
            case 38: {
                this.setKeyCharCode(11, false);
                break;
            }
            case 127: {
                this.setKeyCharCode(127, false);
                break;
            }
            case 112: {
                this.keyboardMatrix[0] = 8;
                break;
            }
            case 113: {
                this.keyboardMatrix[1] = 8;
                break;
            }
            case 114: {
                this.keyboardMatrix[2] = 8;
                break;
            }
            case 115: {
                this.keyboardMatrix[3] = 8;
                break;
            }
            default: {
                bl = false;
            }
        }
        this.updShiftKeysPressed();
        return bl;
    }

    @Override
    public void updKeyboardFld(AbstractKeyboardFld abstractKeyboardFld) {
        if (abstractKeyboardFld != null) {
            abstractKeyboardFld.updKeySelection(this.keyboardMatrix);
        }
    }

    @Override
    protected synchronized boolean updKeyboardMatrix(int n, boolean bl) {
        boolean bl2 = false;
        if (n > 0) {
            int n2 = n & 7;
            switch (n & 0xF8) {
                case 64: {
                    int n3 = n2;
                    this.keyboardMatrix[n3] = this.keyboardMatrix[n3] | 1;
                    bl2 = true;
                    break;
                }
                case 72: {
                    int n4 = n2;
                    this.keyboardMatrix[n4] = this.keyboardMatrix[n4] | 2;
                    if (bl) {
                        this.keyboardMatrix[0] = this.keyboardMatrix[0] | 8;
                    }
                    bl2 = true;
                    break;
                }
                case 80: {
                    int n5 = n2;
                    this.keyboardMatrix[n5] = this.keyboardMatrix[n5] | 4;
                    if (bl) {
                        this.keyboardMatrix[0] = this.keyboardMatrix[0] | 8;
                    }
                    bl2 = true;
                    break;
                }
                case 88: {
                    int n6 = n2;
                    this.keyboardMatrix[n6] = this.keyboardMatrix[n6] | 1;
                    this.keyboardMatrix[0] = this.keyboardMatrix[0] | 8;
                    bl2 = true;
                    break;
                }
                case 48: {
                    int n7 = n2;
                    this.keyboardMatrix[n7] = this.keyboardMatrix[n7] | 2;
                    if (!bl) {
                        this.keyboardMatrix[0] = this.keyboardMatrix[0] | 8;
                    }
                    bl2 = true;
                    break;
                }
                case 56: {
                    int n8 = n2;
                    this.keyboardMatrix[n8] = this.keyboardMatrix[n8] | 4;
                    if (!bl) {
                        this.keyboardMatrix[0] = this.keyboardMatrix[0] | 8;
                    }
                    bl2 = true;
                    break;
                }
                case 120: {
                    int n9 = n2;
                    this.keyboardMatrix[n9] = this.keyboardMatrix[n9] | 1;
                    this.keyboardMatrix[1] = this.keyboardMatrix[1] | 8;
                    bl2 = true;
                    break;
                }
                case 32: {
                    int n10 = n2;
                    this.keyboardMatrix[n10] = this.keyboardMatrix[n10] | 2;
                    this.keyboardMatrix[1] = this.keyboardMatrix[1] | 8;
                    bl2 = true;
                    break;
                }
                case 40: {
                    int n11 = n2;
                    this.keyboardMatrix[n11] = this.keyboardMatrix[n11] | 4;
                    this.keyboardMatrix[1] = this.keyboardMatrix[1] | 8;
                    bl2 = true;
                    break;
                }
                case 96: {
                    int n12 = n2;
                    this.keyboardMatrix[n12] = this.keyboardMatrix[n12] | 1;
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 8;
                    bl2 = true;
                    break;
                }
                case 104: {
                    int n13 = n2;
                    this.keyboardMatrix[n13] = this.keyboardMatrix[n13] | 2;
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 8;
                    bl2 = true;
                    break;
                }
                case 112: {
                    int n14 = n2;
                    this.keyboardMatrix[n14] = this.keyboardMatrix[n14] | 4;
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 8;
                    bl2 = true;
                    break;
                }
                case 16: {
                    int n15 = n2;
                    this.keyboardMatrix[n15] = this.keyboardMatrix[n15] | 1;
                    this.keyboardMatrix[3] = this.keyboardMatrix[3] | 8;
                    bl2 = true;
                    break;
                }
                case 0: {
                    int n16 = n2;
                    this.keyboardMatrix[n16] = this.keyboardMatrix[n16] | 2;
                    this.keyboardMatrix[3] = this.keyboardMatrix[3] | 8;
                    bl2 = true;
                    break;
                }
                case 8: {
                    int n17 = n2;
                    this.keyboardMatrix[n17] = this.keyboardMatrix[n17] | 4;
                    this.keyboardMatrix[3] = this.keyboardMatrix[3] | 8;
                    bl2 = true;
                }
            }
            switch (n) {
                case 241: {
                    this.keyboardMatrix[0] = this.keyboardMatrix[0] | 8;
                    break;
                }
                case 242: {
                    this.keyboardMatrix[1] = this.keyboardMatrix[1] | 8;
                    break;
                }
                case 243: {
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 8;
                    break;
                }
                case 244: {
                    this.keyboardMatrix[3] = this.keyboardMatrix[3] | 8;
                }
            }
        }
        if (bl2) {
            this.updShiftKeysPressed();
        }
        return bl2;
    }

    private void updShiftKeysPressed() {
        this.setShiftKeysPressed(this.isAnyControlKeyPressed());
    }
}

