/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.z1013;

import java.util.Arrays;
import jkcemu.emusys.z1013.KeyboardMatrix;

public abstract class KeyboardMatrix12x8
extends KeyboardMatrix {
    protected int[] matrixNormal = null;
    protected int[] matrixShift = null;
    protected int ctrlCol = -1;
    protected int ctrlValue = 0;
    protected int shiftCol = -1;
    protected int shiftValue = 0;
    protected int[] keyboardMatrix = new int[12];
    protected boolean ctrlPressed;
    protected boolean shiftPressed;

    protected KeyboardMatrix12x8() {
        this.reset();
    }

    protected void updShiftKeysPressed() {
        this.setShiftKeysPressed(this.ctrlPressed || this.shiftPressed);
    }

    @Override
    public int getRowValues(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        if (n >= 0) {
            if ((n == 15 || n == this.ctrlCol) && this.ctrlPressed && this.ctrlCol >= 0 && this.ctrlCol < this.keyboardMatrix.length) {
                n3 |= this.ctrlValue;
            }
            if ((n == 15 || n == this.shiftCol) && this.shiftPressed && this.shiftCol >= 0 && this.shiftCol < this.keyboardMatrix.length) {
                n3 |= this.shiftValue;
            }
            if (!this.onlyShiftKeysReadable()) {
                if (n == 15) {
                    for (int i = 0; i < this.keyboardMatrix.length; ++i) {
                        n3 |= this.keyboardMatrix[i];
                    }
                } else if (n < this.keyboardMatrix.length) {
                    n3 |= this.keyboardMatrix[n];
                }
            }
            if ((n3 & 0x55) != 0) {
                n2 |= 1;
            }
            if ((n3 & 0x66) != 0) {
                n2 |= 2;
            }
            if ((n3 & 0x78) != 0) {
                n2 |= 4;
            }
            if ((n3 & 0x80) != 0) {
                n2 |= 8;
            }
        }
        return n2;
    }

    @Override
    public void reset() {
        super.reset();
        this.ctrlPressed = false;
        this.shiftPressed = false;
        Arrays.fill(this.keyboardMatrix, 0);
    }

    @Override
    protected synchronized boolean updKeyboardMatrix(int n, boolean bl) {
        boolean bl2 = this.updKeyboardMatrixInternal(n);
        if (!bl2 && n < 32 && this.updKeyboardMatrixInternal(n + 65 - 1)) {
            this.ctrlPressed = true;
            bl2 = true;
        }
        if (bl2) {
            this.updShiftKeysPressed();
        }
        return bl2;
    }

    private boolean updKeyboardMatrixInternal(int n) {
        boolean bl = false;
        if (n > 0) {
            int n2 = this.indexOf(this.matrixNormal, n);
            if (n2 >= 0) {
                bl = true;
                int n3 = 1 << n2 / 12;
                int n4 = n2 % 12;
                this.keyboardMatrix[n4] = this.keyboardMatrix[n4] | n3;
            } else {
                n2 = this.indexOf(this.matrixShift, n);
                if (n2 >= 0) {
                    bl = true;
                    int n5 = 1 << n2 / 12;
                    int n6 = n2 % 12;
                    this.keyboardMatrix[n6] = this.keyboardMatrix[n6] | n5;
                    this.shiftPressed = true;
                }
            }
        }
        return bl;
    }

    private int indexOf(int[] nArray, int n) {
        int n2 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }
}

