/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.z1013;

import jkcemu.base.CharRaster;
import jkcemu.base.EmuUtil;
import jkcemu.base.ScreenFrm;
import jkcemu.etc.GDC82720;

public class GraphicCCJ
implements GDC82720.GDCListener,
GDC82720.VRAM {
    private static final int CHAR_WIDTH = 8;
    private static final int DEFAULT_SCREEN_HEIGHT = 256;
    private static final int DEFAULT_SCREEN_WIDTH = 640;
    private static byte[] gccjFont = null;
    private ScreenFrm screenFrm;
    private GDC82720 gdc;
    private byte[] fontBytes;
    private byte[] vram;

    public GraphicCCJ(ScreenFrm screenFrm, String string) {
        this.screenFrm = screenFrm;
        this.gdc = new GDC82720();
        this.vram = new byte[2048];
        this.gdc.setVRAM(this);
        this.loadFont(string);
    }

    public boolean canExtractScreenText() {
        return this.gdc.canExtractScreenText();
    }

    public CharRaster getCharRaster() {
        return this.gdc.canExtractScreenText() ? new CharRaster(this.gdc.getCharColCount(), this.gdc.getCharRowCount(), this.gdc.getCharRowHeight(), this.gdc.getCharRowHeight(), 8, this.getYMargin() + this.gdc.getCharTopLine()) : null;
    }

    public boolean getPixel(int n, int n2) {
        boolean bl = false;
        if (this.fontBytes != null) {
            int n3 = this.gdc.getCharRowHeight();
            int n4 = this.gdc.getDisplayValue(n / 8, n2 -= this.getYMargin());
            if (n3 > 0 && n4 >= 0) {
                int n5 = this.vram[n4 & 0x7FF] & 0xFF;
                int n6 = n5 | n2 % n3 << 8 & 0xF00;
                if ((n4 & 0x80000) != 0) {
                    if (this.fontBytes.length > 4096) {
                        n6 |= 0x1000;
                    } else {
                        bl = true;
                        n6 = -1;
                    }
                }
                if (n6 >= 0 && n6 < this.fontBytes.length) {
                    byte by = this.fontBytes[n6];
                    int n7 = 128;
                    int n8 = n % 8;
                    if (n8 > 0) {
                        n7 >>= n8;
                    }
                    bl = (by & n7) != 0;
                }
            }
        }
        return bl;
    }

    public int getScreenChar(int n, int n2) {
        return this.gdc.getScreenChar(n, n2) & 0x7F;
    }

    public int getScreenHeight() {
        int n = this.gdc.getDisplayLines();
        return n > 256 ? n : 256;
    }

    public int getScreenWidth() {
        int n = this.gdc.getCharColCount() * 8;
        return n > 640 ? n : 640;
    }

    public void loadFont(String string) {
        byte[] byArray = null;
        if (string != null && !string.isEmpty()) {
            byArray = EmuUtil.readFile(this.screenFrm, string, true, 8192, "Zeichensatzdatei");
        }
        if (byArray == null) {
            if (gccjFont == null) {
                gccjFont = EmuUtil.readResource(this.screenFrm, "/rom/z1013/gccjfont.bin");
            }
            byArray = gccjFont;
        }
        this.fontBytes = byArray;
    }

    public int readData() {
        return this.gdc.readData();
    }

    public int readStatus() {
        return this.gdc.readStatus();
    }

    public boolean shouldAskConvertScreenChar() {
        return this.fontBytes != gccjFont;
    }

    public void writeArg(int n) {
        this.gdc.writeArg(n);
    }

    public void writeCmd(int n) {
        this.gdc.writeCmd(n);
    }

    @Override
    public void screenConfigChanged(GDC82720 gDC82720) {
        this.screenFrm.clearScreenSelection();
        this.screenFrm.fireUpdScreenTextActionsEnabled();
    }

    @Override
    public void screenDirty(GDC82720 gDC82720) {
        this.screenFrm.setScreenDirty(true);
    }

    @Override
    public int getVRAMWord(int n) {
        return this.vram[n & 0x7FF] & 0xFF | 0xFF00;
    }

    @Override
    public void setVRAMWord(int n, int n2) {
        this.vram[n & 0x7FF] = (byte)n2;
        this.screenFrm.setScreenDirty(true);
    }

    private int getYMargin() {
        int n = this.gdc.getDisplayLines();
        return 256 > n ? (256 - n) / 2 : 0;
    }
}

