/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.poly880;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.EmuUtil;
import jkcemu.base.ROMFileSettingsFld;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;

public class Poly880SettingsFld
extends AbstractSettingsFld {
    private JTabbedPane tabbedPane;
    private JPanel tabExt;
    private JPanel tabEtc;
    private JCheckBox btnRAM8000;
    private JCheckBox btnInversedROM;
    private ROMFileSettingsFld fldAltROM0;
    private ROMFileSettingsFld fldAltROM1;
    private ROMFileSettingsFld fldROM2;
    private ROMFileSettingsFld fldROM3;

    public Poly880SettingsFld(SettingsFrm settingsFrm, String string) {
        super(settingsFrm, string);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, "Center");
        this.tabExt = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Erweiterungen", this.tabExt);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnRAM8000 = new JCheckBox("32 KByte RAM-Erweiterung");
        this.btnRAM8000.addActionListener(this);
        this.tabExt.add((Component)this.btnRAM8000, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        ++gridBagConstraints.gridy;
        this.tabExt.add((Component)new JSeparator(), gridBagConstraints);
        this.fldROM2 = new ROMFileSettingsFld(settingsFrm, string + "rom_2000.", "ROM-Erweiterung 2000h-23FFh:");
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.tabExt.add((Component)this.fldROM2, gridBagConstraints);
        this.fldROM3 = new ROMFileSettingsFld(settingsFrm, string + "rom_3000.", "ROM-Erweiterung 3000h-33FFh:");
        ++gridBagConstraints.gridy;
        this.tabExt.add((Component)this.fldROM3, gridBagConstraints);
        this.tabEtc = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Sonstiges", this.tabEtc);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.fldAltROM0 = new ROMFileSettingsFld(settingsFrm, string + "rom_0000.", "Alternativer ROM-Inhalt 0000h-03FFh:");
        ++gridBagConstraints2.gridy;
        this.tabEtc.add((Component)this.fldAltROM0, gridBagConstraints2);
        this.fldAltROM1 = new ROMFileSettingsFld(settingsFrm, string + "rom_1000.", "Alternativer ROM-Inhalt 1000h-13FFh:");
        ++gridBagConstraints2.gridy;
        this.tabEtc.add((Component)this.fldAltROM1, gridBagConstraints2);
        this.btnInversedROM = new JCheckBox("ROM-Bytes sind negiert (entsprechend dem Original)");
        this.btnInversedROM.addActionListener(this);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        ++gridBagConstraints2.gridy;
        this.tabEtc.add((Component)this.btnInversedROM, gridBagConstraints2);
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        EmuUtil.setProperty(properties, this.propPrefix + "ram_8000.enabled", this.btnRAM8000.isSelected());
        this.fldAltROM0.applyInput(properties, bl);
        this.fldAltROM1.applyInput(properties, bl);
        this.fldROM2.applyInput(properties, bl);
        this.fldROM3.applyInput(properties, bl);
        EmuUtil.setProperty(properties, this.propPrefix + "rom." + "negated", this.btnInversedROM.isSelected());
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null && object instanceof AbstractButton) {
            this.fireDataChanged();
            bl = true;
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.fldAltROM0.lookAndFeelChanged();
        this.fldAltROM1.lookAndFeelChanged();
        this.fldROM2.lookAndFeelChanged();
        this.fldROM3.lookAndFeelChanged();
    }

    @Override
    public void updFields(Properties properties) {
        this.btnRAM8000.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "ram_8000.enabled", false));
        this.fldAltROM0.updFields(properties);
        this.fldAltROM1.updFields(properties);
        this.fldROM2.updFields(properties);
        this.fldROM3.updFields(properties);
        this.btnInversedROM.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "rom." + "negated", false));
    }
}

