/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.llc1;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Properties;
import jkcemu.base.AbstractScreenDevice;
import jkcemu.base.AbstractScreenFrm;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuThread;
import jkcemu.emusys.LLC1;
import jkcemu.text.TextUtil;

public class LLC1AlphaScreenDevice
extends AbstractScreenDevice
implements KeyListener {
    private LLC1 llc1;

    public LLC1AlphaScreenDevice(LLC1 lLC1, Properties properties) {
        super(properties);
        this.llc1 = lLC1;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = 0;
        switch (keyEvent.getKeyCode()) {
            case 40: {
                n = 4;
                break;
            }
            case 38: {
                n = 36;
                break;
            }
            case 8: 
            case 37: {
                n = 8;
                break;
            }
            case 39: {
                n = 9;
                break;
            }
            case 10: {
                n = 13;
                break;
            }
            case 32: {
                n = 64;
            }
        }
        if (n > 0) {
            this.llc1.putAlphaKeyChar(n);
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.llc1.putAlphaKeyChar(0);
        keyEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        c = c > '\u0000' && c < '\u007f' ? TextUtil.toReverseCase(c) : (char)'\u0000';
        if (c > '\u0000') {
            this.llc1.putAlphaKeyChar(c);
            keyEvent.consume();
        }
    }

    @Override
    public void cancelPastingText() {
        this.llc1.cancelPastingAlphaText();
        AbstractScreenFrm abstractScreenFrm = this.getScreenFrm();
        if (abstractScreenFrm != null) {
            abstractScreenFrm.firePastingTextFinished();
        }
    }

    @Override
    public boolean canExtractScreenText() {
        return true;
    }

    @Override
    public int getColorIndex(int n, int n2) {
        byte[] byArray;
        int n3 = 0;
        int n4 = n2 % 14;
        if (n4 >= 0 && n4 < 8 && (byArray = this.llc1.getAlphaScreenFontBytes()) != null) {
            int n5;
            int n6 = n / 8;
            int n7 = n2 / 14;
            int n8 = this.llc1.getMemByte(7168 + n7 * 64 + n6, false);
            int n9 = 0;
            if (n4 == 7 && (n8 & 0x80) != 0) {
                n9 = 255;
            } else {
                n5 = n4 * 128 + (n8 & 0x7F);
                if (n5 >= 0 && n5 < byArray.length) {
                    n9 = byArray[n5] & 0xFF;
                }
            }
            if (n9 != 0) {
                n5 = 128;
                int n10 = n % 8;
                if (n10 > 0) {
                    n5 >>= n10;
                }
                if ((n9 & n5) != 0) {
                    n3 = 1;
                }
            }
        }
        return n3;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        return new CharRaster(64, 16, 14, 8, 8, 0);
    }

    @Override
    public EmuThread getEmuThread() {
        return this.llc1.getEmuThread();
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        int n3 = -1;
        int n4 = this.llc1.getMemByte(7168 + n2 * 64 + n, false);
        switch (n4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 64: 
            case 95: 
            case 96: {
                n3 = 32;
                break;
            }
            case 14: {
                n3 = 183;
                break;
            }
            case 16: {
                n3 = 47;
                break;
            }
            case 17: {
                n3 = 59;
                break;
            }
            case 18: {
                n3 = 34;
                break;
            }
            case 19: {
                n3 = 61;
                break;
            }
            case 20: {
                n3 = 37;
                break;
            }
            case 21: {
                n3 = 38;
                break;
            }
            case 22: {
                n3 = 40;
                break;
            }
            case 23: {
                n3 = 41;
                break;
            }
            case 24: {
                n3 = 95;
                break;
            }
            case 25: {
                n3 = 64;
                break;
            }
            case 26: {
                n3 = 58;
                break;
            }
            case 27: {
                n3 = 35;
                break;
            }
            case 28: {
                n3 = 42;
                break;
            }
            case 29: {
                n3 = 39;
                break;
            }
            case 30: {
                n3 = 33;
                break;
            }
            case 31: {
                n3 = 63;
                break;
            }
            case 58: {
                n3 = 172;
                break;
            }
            case 59: {
                n3 = 36;
                break;
            }
            case 60: {
                n3 = 43;
                break;
            }
            case 61: {
                n3 = 45;
                break;
            }
            case 62: {
                n3 = 46;
                break;
            }
            case 63: {
                n3 = 44;
                break;
            }
            case 91: {
                n3 = 93;
                break;
            }
            case 92: {
                n3 = 91;
                break;
            }
            case 94: {
                n3 = 96;
                break;
            }
            case 123: {
                n3 = 62;
                break;
            }
            case 124: {
                n3 = 60;
                break;
            }
            case 125: {
                n3 = 124;
                break;
            }
            case 126: {
                n3 = 94;
                break;
            }
            default: {
                if (!(n4 >= 48 && n4 <= 57 || n4 >= 65 && n4 <= 90) && (n4 < 97 || n4 > 122)) break;
                n3 = n4;
            }
        }
        return n3;
    }

    @Override
    public int getScreenHeight() {
        return 224;
    }

    @Override
    public int getScreenWidth() {
        return 512;
    }

    @Override
    public String getTitle() {
        return "JKCEMU: LLC1 Alphanumerischer Bildschirm";
    }

    @Override
    public void startPastingText(String string) {
        this.llc1.startPastingAlphaText(string);
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return true;
    }
}

