/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.lc80;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.AutoInputSettingsFld;
import jkcemu.base.AutoLoadSettingsFld;
import jkcemu.base.EmuUtil;
import jkcemu.base.ROMFileSettingsFld;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;

public class LC80SettingsFld
extends AbstractSettingsFld {
    private JTabbedPane tabbedPane;
    private JPanel tabModel;
    private JPanel tabRom;
    private AutoLoadSettingsFld tabAutoLoad;
    private AutoInputSettingsFld tabAutoInput;
    private JRadioButton btnLC80_U505;
    private JRadioButton btnLC80_2716;
    private JRadioButton btnLC80_2;
    private JRadioButton btnLC80e;
    private JRadioButton btnLC80ex;
    private ROMFileSettingsFld fldAltOS;
    private ROMFileSettingsFld fldAltA000;
    private ROMFileSettingsFld fldAltC000;

    public LC80SettingsFld(SettingsFrm settingsFrm, String string) {
        super(settingsFrm, string);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, "Center");
        this.tabModel = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Modell", this.tabModel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnLC80_U505 = new JRadioButton("LC-80, 2 KByte ROM (2xU505), 1 KByte RAM", false);
        this.btnLC80_U505.addActionListener(this);
        buttonGroup.add(this.btnLC80_U505);
        this.tabModel.add((Component)this.btnLC80_U505, gridBagConstraints);
        this.btnLC80_2716 = new JRadioButton("LC-80, 2 KByte ROM (2716), 4 KByte RAM", true);
        this.btnLC80_2716.addActionListener(this);
        buttonGroup.add(this.btnLC80_2716);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.btnLC80_2716, gridBagConstraints);
        this.btnLC80_2 = new JRadioButton("LC-80.2, 4 KByte ROM mit Buschendorf-Monitor, 4 KByte RAM", false);
        this.btnLC80_2.addActionListener(this);
        buttonGroup.add(this.btnLC80_2);
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.btnLC80_2, gridBagConstraints);
        this.btnLC80e = new JRadioButton("LC-80e, 12 KByte ROM mit Schachprogramm SC-80, 4 KByte RAM", false);
        this.btnLC80e.addActionListener(this);
        buttonGroup.add(this.btnLC80e);
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.btnLC80e, gridBagConstraints);
        this.btnLC80ex = new JRadioButton("LC-80ex, 20 KByte ROM, 32 KByte RAM, TV-Terminal 1.2", false);
        this.btnLC80ex.addActionListener(this);
        buttonGroup.add(this.btnLC80ex);
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.btnLC80ex, gridBagConstraints);
        this.tabRom = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("ROM", this.tabRom);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.fldAltOS = new ROMFileSettingsFld(settingsFrm, string + "os.", "Alternatives Monitorprogramm (0000h-1FFFh):");
        ++gridBagConstraints2.gridy;
        this.tabRom.add((Component)this.fldAltOS, gridBagConstraints2);
        this.fldAltA000 = new ROMFileSettingsFld(settingsFrm, string + "rom_a000.", "Alternativer ROM-Inhalt A000h-BFFFh (nur LC80ex):");
        ++gridBagConstraints2.gridy;
        this.tabRom.add((Component)this.fldAltA000, gridBagConstraints2);
        this.fldAltC000 = new ROMFileSettingsFld(settingsFrm, string + "rom_c000.", "Alternativer ROM-Inhalt C000h-FFFFh (nur LC80e/LC80ex):");
        ++gridBagConstraints2.gridy;
        this.tabRom.add((Component)this.fldAltC000, gridBagConstraints2);
        this.tabAutoLoad = new AutoLoadSettingsFld(settingsFrm, string, 15000, true);
        this.tabbedPane.addTab("AutoLoad", this.tabAutoLoad);
        this.tabAutoInput = new AutoInputSettingsFld(settingsFrm, string, true, 4, 15000);
        this.tabbedPane.addTab("AutoInput", this.tabAutoInput);
        this.updFldAltC000Enabled();
    }

    public String getModelSysName() {
        String string = "LC80_2716";
        if (this.btnLC80_U505.isSelected()) {
            string = "LC80_U505";
        } else if (this.btnLC80_2.isSelected()) {
            string = "LC80_2";
        } else if (this.btnLC80e.isSelected()) {
            string = "LC80_E";
        } else if (this.btnLC80ex.isSelected()) {
            string = "LC80_EX";
        }
        return string;
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        JPanel jPanel = null;
        try {
            jPanel = this.tabRom;
            this.fldAltOS.applyInput(properties, bl);
            this.fldAltA000.applyInput(properties, bl);
            this.fldAltC000.applyInput(properties, bl);
            jPanel = this.tabAutoLoad;
            this.tabAutoLoad.applyInput(properties, bl);
            jPanel = this.tabAutoInput;
            this.tabAutoInput.applyInput(properties, bl);
        }
        catch (UserInputException userInputException) {
            if (jPanel != null) {
                this.tabbedPane.setSelectedComponent(jPanel);
            }
            throw userInputException;
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.btnLC80_U505 || object == this.btnLC80_2716 || object == this.btnLC80_2 || object == this.btnLC80e || object == this.btnLC80ex) {
            bl = true;
            this.updFldAltA000Enabled();
            this.updFldAltC000Enabled();
            this.fireDataChanged();
        }
        if (!bl) {
            bl = this.tabAutoLoad.doAction(eventObject);
        }
        if (!bl) {
            bl = this.tabAutoInput.doAction(eventObject);
        }
        if (!bl && object instanceof AbstractButton) {
            this.fireDataChanged();
            bl = true;
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.fldAltOS.lookAndFeelChanged();
        this.fldAltA000.lookAndFeelChanged();
        this.fldAltC000.lookAndFeelChanged();
        this.tabAutoLoad.lookAndFeelChanged();
        this.tabAutoInput.lookAndFeelChanged();
    }

    @Override
    public void updFields(Properties properties) {
        switch (EmuUtil.getProperty(properties, "jkcemu.system")) {
            case "LC80_U505": {
                this.btnLC80_U505.setSelected(true);
                break;
            }
            case "LC80_2": {
                this.btnLC80_2.setSelected(true);
                break;
            }
            case "LC80_E": {
                this.btnLC80e.setSelected(true);
                break;
            }
            case "LC80_EX": {
                this.btnLC80ex.setSelected(true);
                break;
            }
            default: {
                this.btnLC80_2716.setSelected(true);
            }
        }
        this.updFldAltC000Enabled();
        this.fldAltOS.updFields(properties);
        this.fldAltA000.updFields(properties);
        this.fldAltC000.updFields(properties);
        this.tabAutoLoad.updFields(properties);
        this.tabAutoInput.updFields(properties);
    }

    private void updFldAltA000Enabled() {
        this.fldAltA000.setEnabled(this.btnLC80ex.isSelected());
    }

    private void updFldAltC000Enabled() {
        this.fldAltC000.setEnabled(this.btnLC80e.isSelected() || this.btnLC80ex.isSelected());
    }
}

