/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.lc80;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.LC80;

public class LC80KeyboardFld
extends AbstractKeyboardFld<LC80> {
    private static final int KEY_W = 35;
    private static final int KEY_COL_W = 48;
    private static final int KEY_X0 = 36;
    private static final int KEY_X1 = 84;
    private static final int KEY_X2 = 132;
    private static final int KEY_X3 = 180;
    private static final int KEY_X4 = 228;
    private static final int KEY_H = 23;
    private static final int KEY_ROW_H = 44;
    private static final int KEY_Y0 = 294;
    private static final int KEY_Y1 = 338;
    private static final int KEY_Y2 = 382;
    private static final int KEY_Y3 = 426;
    private static final int KEY_Y4 = 470;
    private Image imgBgLC80 = this.getImage("/images/keyboard/lc80/bg_lc80.png");
    private Image imgBgSC80 = this.getImage("/images/keyboard/lc80/bg_sc80.png");
    private AbstractKeyboardFld.KeyData nmiKey;
    private AbstractKeyboardFld.KeyData resetKey;
    private Color colorKeySelected;
    private Color colorKeyBorder;
    private Color colorKeyLight;
    private int[] kbMatrix = new int[6];
    private int curIdx;

    public LC80KeyboardFld(LC80 lC80) {
        super(lC80, 25, true);
        this.colorKeySelected = new Color(100, 100, 100);
        this.colorKeyBorder = new Color(80, 80, 80);
        this.colorKeyLight = Color.white;
        Color color = new Color(20, 20, 20);
        Color color2 = new Color(200, 0, 0);
        Color color3 = this.colorKeyLight;
        this.curIdx = 0;
        this.resetKey = this.addKey(36, 294, color2, -1, -1, "Esc");
        this.nmiKey = this.addKey(36, 338, color2, -1, -1, "N");
        this.addKey(36, 382, color, 0, 64, "S oder F4#F4");
        this.addKey(36, 426, color, 0, 32, "L oder F3#R oder F3");
        this.addKey(36, 470, color, 0, 128, "X oder Enter");
        this.addKey(84, 294, color, 5, 128, "F1");
        this.addKey(84, 338, color3, 4, 128, "C#L");
        this.addKey(84, 382, color3, 3, 128, "8#H oder 8");
        this.addKey(84, 426, color3, 2, 128, "4#D oder 4");
        this.addKey(84, 470, color3, 1, 128, "0");
        this.addKey(132, 294, color, 5, 64, "F2");
        this.addKey(132, 338, color3, 4, 64, "D#T");
        this.addKey(132, 382, color3, 3, 64, "9");
        this.addKey(132, 426, color3, 2, 64, "5#E oder 5");
        this.addKey(132, 470, color3, 1, 64, "1#A oder 1");
        this.addKey(180, 294, color, 2, 32, "+#O oder +");
        this.addKey(180, 338, color3, 3, 32, "E#M");
        this.addKey(180, 382, color3, 4, 32, "A#U");
        this.addKey(180, 426, color3, 5, 32, "6#F oder 6");
        this.addKey(180, 470, color3, 1, 32, "2#B oder 2");
        this.addKey(228, 294, color, 5, 16, "-#W oder -");
        this.addKey(228, 338, color3, 4, 16, "F#K");
        this.addKey(228, 382, color3, 3, 16, "B#S");
        this.addKey(228, 426, color3, 2, 16, "7#G oder 7");
        this.addKey(228, 470, color3, 1, 16, "3#C oder 3");
        this.setPreferredSize(new Dimension(300, 574));
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        return emuSys instanceof LC80;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n;
        String string = super.getToolTipText(mouseEvent);
        if (string != null && (n = string.indexOf(35)) >= 0) {
            string = ((LC80)this.emuSys).isChessMode() ? (n + 1 < string.length() ? string.substring(n + 1) : null) : (n > 0 ? string.substring(0, n) : null);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Arrays.fill(this.kbMatrix, 0);
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                int n = keyData.col;
                this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
            }
        }
        ((LC80)this.emuSys).updKeyboardMatrix(this.kbMatrix);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this) {
            if (LC80KeyboardFld.hits(this.resetKey, mouseEvent)) {
                this.fireWarmResetAfterDelay();
            } else if (LC80KeyboardFld.hits(this.nmiKey, mouseEvent)) {
                this.fireNMIAfterDelay();
            }
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (((LC80)this.emuSys).isChessMode()) {
            if (this.imgBgSC80 != null) {
                graphics.drawImage(this.imgBgSC80, 0, 0, this);
            }
        } else if (this.imgBgLC80 != null) {
            graphics.drawImage(this.imgBgLC80, 0, 0, this);
        }
        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
            Color color = this.isKeySelected(keyData) ? this.colorKeySelected : keyData.color;
            graphics.setColor(color);
            graphics.fillRect(keyData.x, keyData.y, keyData.w, keyData.h);
            if (color != this.colorKeyLight) continue;
            graphics.setColor(this.colorKeyBorder);
            graphics.drawRect(keyData.x, keyData.y, keyData.w, keyData.h);
        }
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!(emuSys instanceof LC80)) {
            throw new IllegalArgumentException("EmuSys != LC80");
        }
        this.emuSys = (LC80)emuSys;
    }

    private AbstractKeyboardFld.KeyData addKey(int n, int n2, Color color, int n3, int n4, String string) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(n, n2, 35, 23, null, null, null, color, null, n3, n4, false, string);
        this.keys[this.curIdx++] = keyData;
        return keyData;
    }
}

