/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.awt.Component;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileTimesViewFactory;
import jkcemu.emusys.kc85.AbstractKC85Module;
import jkcemu.etc.VDIP;
import jkcemu.net.KCNet;
import z80emu.Z80CPU;
import z80emu.Z80InterruptSource;
import z80emu.Z80MaxSpeedListener;
import z80emu.Z80TStatesListener;

public class M052
extends AbstractKC85Module
implements Z80InterruptSource,
Z80MaxSpeedListener,
Z80TStatesListener {
    private static byte[] m052 = null;
    private Component owner;
    private String fileName;
    private String title;
    private KCNet kcNet;
    private VDIP vdip;
    private boolean ioEnabled;
    private int begAddr;
    private int romOffs;
    private byte[] rom;

    public M052(int n, Component component, FileTimesViewFactory fileTimesViewFactory, String string) {
        super(n);
        this.owner = component;
        this.fileName = string;
        this.title = String.format("M052 im Schacht %02X", n);
        this.kcNet = new KCNet("Netzwerk-PIO");
        this.vdip = new VDIP(fileTimesViewFactory, "USB-PIO");
        this.ioEnabled = false;
        this.romOffs = 0;
        this.begAddr = 0;
        this.rom = null;
        this.reload(component);
        if (this.rom == null) {
            if (m052 == null) {
                m052 = EmuUtil.readResource(component, "/rom/kc85/m052.bin");
            }
            this.rom = m052;
        }
    }

    public VDIP getVDIP() {
        return this.vdip;
    }

    @Override
    public void appendInterruptStatusHTMLTo(StringBuilder stringBuilder) {
        stringBuilder.append("<h2>Netzwerk-PIO (E/A-Adressen 28-2B)</h2>\n");
        this.kcNet.appendInterruptStatusHTMLTo(stringBuilder);
        stringBuilder.append("<h2>USB-PIO (E/A-Adressen 2C-2F)</h2>\n");
        this.vdip.appendInterruptStatusHTMLTo(stringBuilder);
    }

    @Override
    public synchronized int interruptAccept() {
        int n = 0;
        if (this.kcNet.isInterruptRequested()) {
            n = this.kcNet.interruptAccept();
        } else if (this.vdip.isInterruptRequested()) {
            n = this.vdip.interruptAccept();
        }
        return n;
    }

    @Override
    public synchronized void interruptFinish() {
        if (this.kcNet.isInterruptAccepted()) {
            this.kcNet.interruptFinish();
        } else if (this.vdip.isInterruptAccepted()) {
            this.vdip.interruptFinish();
        }
    }

    @Override
    public boolean isInterruptAccepted() {
        return this.kcNet.isInterruptAccepted() || this.vdip.isInterruptAccepted();
    }

    @Override
    public boolean isInterruptRequested() {
        boolean bl = this.kcNet.isInterruptRequested();
        if (!bl && !this.kcNet.isInterruptAccepted()) {
            bl = this.vdip.isInterruptRequested();
        }
        return bl;
    }

    @Override
    public void reset(boolean bl) {
        this.kcNet.reset(bl);
        this.vdip.reset(bl);
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        this.kcNet.z80MaxSpeedChanged(z80CPU);
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        this.kcNet.z80TStatesProcessed(z80CPU, n);
    }

    @Override
    public void die() {
        this.kcNet.die();
        this.vdip.die();
    }

    @Override
    public int getBegAddr() {
        return this.begAddr;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getModuleName() {
        return "M052";
    }

    @Override
    public int getSegmentNum() {
        return this.romOffs >> 13 & 3;
    }

    @Override
    public int getTypeByte() {
        return 253;
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = -1;
        if (this.ioEnabled) {
            switch (n & 0xFF) {
                case 40: 
                case 41: 
                case 42: 
                case 43: {
                    n3 = this.kcNet.read(n);
                    break;
                }
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    n3 = this.vdip.read(n);
                }
            }
        }
        return n3;
    }

    @Override
    public int readMemByte(int n) {
        int n2;
        int n3 = -1;
        if (this.enabled && n >= this.begAddr && n < this.begAddr + 8192 && this.rom != null && (n2 = n - this.begAddr + this.romOffs) < this.rom.length) {
            n3 = this.rom[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public void reload(Component component) {
        if (this.fileName != null && !this.fileName.isEmpty()) {
            this.rom = EmuUtil.readFile(component, this.fileName, true, 32768, "M052 ROM-Datei");
        }
    }

    @Override
    public void setStatus(int n) {
        super.setStatus(n);
        this.ioEnabled = (n & 4) != 0;
        this.begAddr = n << 8 & 0xC000;
        this.romOffs = n << 10 & 0x6000;
    }

    public String toString() {
        return this.title;
    }

    @Override
    public boolean writeIOByte(int n, int n2, int n3) {
        boolean bl = false;
        if (this.ioEnabled) {
            switch (n & 0xFF) {
                case 8: 
                case 40: 
                case 41: 
                case 42: 
                case 43: {
                    this.kcNet.write(n, n2);
                    bl = true;
                    break;
                }
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    this.vdip.write(n, n2);
                    bl = true;
                }
            }
        }
        return bl;
    }
}

