/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.kc85.AbstractKC85Module;

public class M006
extends AbstractKC85Module {
    private static byte[] rom = null;
    private int begAddr = 0;

    public M006(int n, EmuThread emuThread) {
        super(n);
        if (rom == null) {
            rom = EmuUtil.readResource(emuThread.getScreenFrm(), "/rom/kc85/m006.bin");
        }
    }

    @Override
    public int getBegAddr() {
        return this.begAddr;
    }

    @Override
    public String getModuleName() {
        return "M006";
    }

    @Override
    public int getTypeByte() {
        return 251;
    }

    @Override
    public int readMemByte(int n) {
        int n2;
        int n3 = -1;
        if (this.enabled && n >= this.begAddr && n < this.begAddr + 16384 && rom != null && (n2 = n - this.begAddr) < rom.length) {
            n3 = rom[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public void setStatus(int n) {
        super.setStatus(n);
        this.begAddr = n << 8 & 0xC000;
    }
}

