/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.EventObject;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileNameFld;

public class KC85UserPROMSettingsDlg
extends BaseDlg
implements DropTargetListener {
    private static String[][] moduleTable = new String[][]{{"M025", "F7: 8K User PROM/EPROM", "FB: 8K ROM"}, {"M028", "F8: 16K User PROM/EPROM", "FC: 16K ROM"}, {"M040", "01: Autostart", "F7: 8K User PROM/EPROM", "F8: 16K User PROM/EPROM"}, {"M045", "70"}, {"M046", "71"}, {"M047", "72"}, {"M048", "73"}};
    private Frame owner;
    private String approvedFileName;
    private String approvedTypeByteText;
    private String moduleName;
    private String[] moduleTableRow;
    private JRadioButton[] typeByteBtns;
    private FileNameFld fileNameFld;
    private JButton btnSelect;
    private JButton btnOK;
    private JButton btnCancel;

    public KC85UserPROMSettingsDlg(Frame frame, String string, String string2, String string3) {
        super((Window)frame, string);
        this.owner = frame;
        this.approvedFileName = null;
        this.approvedTypeByteText = null;
        this.moduleName = string;
        this.moduleTableRow = null;
        for (String[] i : moduleTable) {
            if (i.length <= 1 || !i[0].equals(string)) continue;
            this.moduleTableRow = i;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.typeByteBtns = null;
        if (this.moduleTableRow != null && this.moduleTableRow.length > 2) {
            this.add((Component)new JLabel("Strukturbyte:"), gridBagConstraints);
            ButtonGroup jPanel = new ButtonGroup();
            int n = 0;
            gridBagConstraints.insets.bottom = 0;
            this.typeByteBtns = new JRadioButton[this.moduleTableRow.length - 1];
            for (int i = 0; i < this.typeByteBtns.length; ++i) {
                String string4 = this.moduleTableRow[i + 1];
                JRadioButton jRadioButton = new JRadioButton(string4);
                jPanel.add(jRadioButton);
                if (string2 != null && string4.startsWith(string2)) {
                    jRadioButton.setSelected(true);
                    n = 1;
                }
                gridBagConstraints.insets.left = 50;
                if (i > 0) {
                    gridBagConstraints.insets.top = 0;
                }
                if (i == this.typeByteBtns.length - 1) {
                    gridBagConstraints.insets.bottom = 5;
                }
                ++gridBagConstraints.gridy;
                this.add((Component)jRadioButton, gridBagConstraints);
                this.typeByteBtns[i] = jRadioButton;
            }
            if (n == 0) {
                this.typeByteBtns[0].setSelected(true);
            }
        }
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("ROM-Datei:"), gridBagConstraints);
        this.fileNameFld = new FileNameFld();
        if (string3 != null) {
            this.fileNameFld.setFileName(string3);
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.add((Component)this.fileNameFld, gridBagConstraints);
        this.btnSelect = this.createImageButton("/images/file/open.png", "ROM-Datei ausw\u00e4hlen");
        this.btnSelect.addKeyListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.btnSelect, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        this.btnOK = new JButton("OK");
        this.btnOK.setEnabled(this.fileNameFld.getFile() != null);
        this.btnOK.addActionListener(this);
        this.btnOK.addKeyListener(this);
        jPanel.add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
        jPanel.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        new DropTarget(this.fileNameFld, this).setActive(true);
    }

    public String getApprovedFileName() {
        return this.approvedFileName;
    }

    public String getApprovedTypeByteText() {
        return this.approvedTypeByteText;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        File file;
        boolean bl = false;
        DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
        if (dropTargetContext != null && dropTargetContext.getComponent() == this.fileNameFld && (file = EmuUtil.fileDrop(this, dropTargetDropEvent)) != null) {
            this.fileNameFld.setFile(file);
            this.btnOK.setEnabled(true);
            bl = true;
        }
        if (bl) {
            dropTargetDropEvent.dropComplete(true);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.btnSelect) {
                bl = true;
                this.doFileSelect();
            } else if (object == this.btnOK) {
                bl = true;
                this.doApprove();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }

    private void doApprove() {
        File file = this.fileNameFld.getFile();
        if (file != null) {
            if (this.typeByteBtns != null) {
                for (JRadioButton jRadioButton : this.typeByteBtns) {
                    int n;
                    if (!jRadioButton.isSelected()) continue;
                    String string = jRadioButton.getText();
                    if (string != null && (n = string.indexOf(58)) >= 0) {
                        string = string.substring(0, n);
                    }
                    this.approvedTypeByteText = string;
                    break;
                }
            } else if (this.moduleTableRow != null && this.moduleTableRow.length > 1) {
                this.approvedTypeByteText = this.moduleTableRow[1];
            }
            this.approvedFileName = file.getPath();
            this.doClose();
        } else {
            KC85UserPROMSettingsDlg.showErrorDlg((Component)this, "Sie m\u00fcssen eine ROM-Datei ausw\u00e4hlen");
        }
    }

    private void doFileSelect() {
        File file = this.fileNameFld.getFile();
        if (file == null) {
            file = Main.getLastDirFile("rom");
        }
        if ((file = EmuUtil.showFileOpenDlg(this.owner, "ROM-Datei ausw\u00e4hlen", file, EmuUtil.getROMFileFilter())) != null) {
            this.fileNameFld.setFile(file);
            this.btnOK.setEnabled(true);
            Main.setLastFile(file, "rom");
        }
    }
}

