/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.util.Arrays;
import jkcemu.emusys.kc85.AbstractKC85Module;

public class KC85SegmentedRAMModule
extends AbstractKC85Module {
    private String moduleName;
    private int typeByte;
    private int begAddr;
    private int segMask;
    private boolean readWrite;
    private byte[] ram;

    public KC85SegmentedRAMModule(int n, int n2, String string, int n3) {
        super(n);
        this.typeByte = n2;
        this.moduleName = string;
        this.begAddr = 0;
        this.segMask = 0;
        this.readWrite = false;
        this.ram = new byte[n3];
    }

    @Override
    public void clearRAM() {
        Arrays.fill(this.ram, (byte)0);
    }

    @Override
    public int getBegAddr() {
        return this.begAddr;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public Boolean getReadWrite() {
        return this.readWrite;
    }

    @Override
    public int getSegmentNum() {
        return this.segMask >> 14 & 0x1F;
    }

    @Override
    public int getTypeByte() {
        return this.typeByte;
    }

    @Override
    public int readMemByte(int n) {
        int n2;
        int n3 = -1;
        if (this.enabled && n >= this.begAddr && n < this.begAddr + 16384 && (n2 = n - this.begAddr | this.segMask) >= 0 && n2 < this.ram.length) {
            n3 = this.ram[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public void setStatus(int n) {
        super.setStatus(n);
        this.begAddr = (n & 0x80) != 0 ? 32768 : 16384;
        this.segMask = n << 12 & this.ram.length - 1 & 0x7C000;
        this.readWrite = (n & 2) != 0;
    }

    @Override
    public int writeMemByte(int n, int n2) {
        int n3;
        int n4 = 0;
        if (this.enabled && n >= this.begAddr && n < this.begAddr + 16384 && (n3 = n - this.begAddr | this.segMask) >= 0 && n3 < this.ram.length) {
            if (this.readWrite) {
                this.ram[n3] = (byte)n2;
                n4 = 2;
            } else {
                n4 = 1;
            }
        }
        return n4;
    }
}

