/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Properties;
import jkcemu.base.AbstractScreenDevice;
import jkcemu.base.EmuThread;
import jkcemu.emusys.KC85;

public class KC85LEDFld
extends AbstractScreenDevice {
    private static final String TEXT_SYSTEM = "SYSTEM";
    private KC85 kc85;
    private int kcTypeNum;
    private int pioAValue;
    private Color greenOn;
    private Color greenOff;
    private Color yellowOn;
    private Color yellowOff;
    private Font fontTitle;
    private Font fontMem;

    public KC85LEDFld(KC85 kC85, Properties properties) {
        super(properties);
        this.kc85 = kC85;
        this.kcTypeNum = kC85.getKCTypeNum();
        this.pioAValue = 0;
        this.greenOn = Color.GREEN;
        this.greenOff = new Color(60, 120, 60);
        this.yellowOn = Color.YELLOW;
        this.yellowOff = new Color(120, 120, 0);
        this.fontTitle = new Font("SansSerif", 0, 12);
        this.fontMem = new Font("SansSerif", 0, 10);
    }

    public void setPioAValue(int n) {
        if ((n &= this.kcTypeNum >= 4 ? 32 : 39) != this.pioAValue) {
            this.pioAValue = n;
            this.setScreenDirty(true);
        }
    }

    @Override
    public EmuThread getEmuThread() {
        return this.kc85.getEmuThread();
    }

    @Override
    public int getScreenHeight() {
        return 75;
    }

    @Override
    public int getScreenWidth() {
        return this.kcTypeNum >= 4 ? 135 : 215;
    }

    @Override
    public String getTitle() {
        return String.format("%s: %s LED%s", "JKCEMU", this.kc85.getTitle(), this.kcTypeNum >= 4 ? "" : "s");
    }

    @Override
    public boolean paintScreen(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.getScreenWidth();
        int n5 = this.getScreenHeight();
        graphics.translate(n, n2);
        if (n3 > 1 && graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).scale(n3, n3);
        }
        graphics.setColor(new Color(225, 225, 225));
        graphics.fillRect(0, 0, n4, n5);
        graphics.setColor(Color.BLACK);
        graphics.setFont(this.fontTitle);
        if (this.kcTypeNum >= 4) {
            int n6 = 50;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (fontMetrics != null) {
                n6 = fontMetrics.stringWidth(TEXT_SYSTEM);
            }
            graphics.drawString(TEXT_SYSTEM, 65, 58);
            graphics.drawLine(20, 20, 60, 60);
            graphics.drawLine(60, 60, 65 + n6, 60);
            KC85LEDFld.paintLED(graphics, 20, 20, (this.pioAValue & 0x20) != 0 ? this.yellowOn : this.yellowOff);
        } else {
            graphics.fillRect(0, 20, n4, 5);
            graphics.fillRect(50, 0, 5, n5);
            graphics.fillRect(105, 25, 5, n5);
            graphics.fillRect(160, 25, 5, n5);
            this.drawCenter(graphics, 0, 15, 50, "TAPE");
            this.drawCenter(graphics, 55, 15, 160, "MEMORYSELECTION");
            graphics.setFont(this.fontMem);
            this.drawCenter(graphics, 55, 72, 50, "ROM");
            this.drawCenter(graphics, 110, 72, 50, "RAM");
            this.drawCenter(graphics, 165, 72, 50, "IRM");
            KC85LEDFld.paintLED(graphics, 25, 50, (this.pioAValue & 0x20) != 0 ? this.yellowOn : this.yellowOff);
            KC85LEDFld.paintLED(graphics, 80, 50, (this.pioAValue & 1) != 0 ? this.greenOn : this.greenOff);
            KC85LEDFld.paintLED(graphics, 135, 50, (this.pioAValue & 2) != 0 ? this.greenOn : this.greenOff);
            KC85LEDFld.paintLED(graphics, 190, 50, (this.pioAValue & 4) != 0 ? this.greenOn : this.greenOff);
        }
        return true;
    }

    private void drawCenter(Graphics graphics, int n, int n2, int n3, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (fontMetrics != null) {
            graphics.drawString(string, n + (n3 - fontMetrics.stringWidth(string)) / 2, n2);
        }
    }

    private static void paintLED(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(Color.BLACK);
        graphics.fillOval(n - 8, n2 - 8, 16, 16);
        graphics.setColor(color);
        graphics.fillOval(n - 5, n2 - 5, 10, 10);
    }
}

