/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import jkcemu.emusys.kc85.AbstractKC85Module;
import z80emu.Z80InterruptSource;
import z80emu.Z80PIO;

public abstract class KC85JoystickModule
extends AbstractKC85Module
implements Z80InterruptSource {
    protected Z80PIO pio;
    private boolean lastBI;
    private String title;

    protected KC85JoystickModule(int n) {
        super(n);
        this.setStatus(1);
        this.lastBI = false;
        this.pio = new Z80PIO("PIO (Joystick)");
        this.pio.putInValuePortA(255, false);
        this.title = String.format("%s im Schacht %02X", this.getModuleName(), n);
    }

    public void setBIState(boolean bl) {
        if (bl != this.lastBI) {
            this.lastBI = bl;
            if (bl) {
                this.pio.strobePortA();
                this.pio.strobePortB();
            }
        }
    }

    public void setJoystickAction(int n, int n2) {
        if (n == 0) {
            int n3 = 255;
            if ((n2 & 4) != 0) {
                n3 ^= 1;
            }
            if ((n2 & 8) != 0) {
                n3 ^= 2;
            }
            if ((n2 & 1) != 0) {
                n3 ^= 4;
            }
            if ((n2 & 2) != 0) {
                n3 ^= 8;
            }
            if ((n2 & 0x20) != 0) {
                n3 ^= 0x10;
            }
            if ((n2 & 0x10) != 0) {
                n3 ^= 0x20;
            }
            this.pio.putInValuePortA(n3, false);
        }
    }

    @Override
    public void appendInterruptStatusHTMLTo(StringBuilder stringBuilder) {
        stringBuilder.append("<h2>PIO (E/A-Adressen 90-93)</h2>\n");
        this.pio.appendInterruptStatusHTMLTo(stringBuilder);
    }

    @Override
    public synchronized int interruptAccept() {
        return this.pio.interruptAccept();
    }

    @Override
    public synchronized void interruptFinish() {
        if (this.pio.isInterruptAccepted()) {
            this.pio.interruptFinish();
        }
    }

    @Override
    public boolean isInterruptAccepted() {
        return this.pio.isInterruptAccepted();
    }

    @Override
    public boolean isInterruptRequested() {
        return this.pio.isInterruptRequested();
    }

    @Override
    public void reset(boolean bl) {
        this.pio.reset(bl);
    }

    @Override
    public int getTypeByte() {
        return 255;
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = -1;
        if ((n &= 0xFF) >= 144 && n < 152) {
            switch (n & 0xFF) {
                case 144: {
                    n3 = this.pio.readDataA();
                    break;
                }
                case 145: {
                    n3 = this.pio.readDataB();
                    break;
                }
                case 146: {
                    n3 = this.pio.readControlA();
                    break;
                }
                case 147: {
                    n3 = this.pio.readControlB();
                    break;
                }
                default: {
                    n3 = 255;
                }
            }
        }
        return n3;
    }

    @Override
    public void setStatus(int n) {
        super.setStatus(1);
    }

    public String toString() {
        return this.title;
    }

    @Override
    public boolean writeIOByte(int n, int n2, int n3) {
        boolean bl = false;
        if ((n &= 0xFF) >= 144 && n < 152) {
            switch (n & 0xFF) {
                case 144: {
                    this.pio.writeDataA(n2);
                    break;
                }
                case 145: {
                    this.pio.writeDataB(n2);
                    break;
                }
                case 146: {
                    this.pio.writeControlA(n2);
                    break;
                }
                case 147: {
                    this.pio.writeControlB(n2);
                }
            }
            bl = true;
        }
        return bl;
    }
}

