/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.huebler;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Properties;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80PCListener;
import z80emu.Z80PIO;

public abstract class AbstractHueblerMC
extends EmuSys
implements Z80PCListener {
    protected boolean pcListenerAdded = false;
    protected int keyChar;
    protected Z80CTC ctc;
    protected Z80PIO pio;
    private int pasteStateNum;

    public AbstractHueblerMC(EmuThread emuThread, Properties properties, String string) {
        super(emuThread, properties, string);
    }

    protected synchronized void checkAddPCListener(Properties properties, String string) {
        boolean bl = EmuUtil.getBooleanProperty(properties, string, true);
        if (bl != this.pcListenerAdded) {
            Z80CPU z80CPU = this.emuThread.getZ80CPU();
            if (bl) {
                z80CPU.addPCListener(this, 61455);
            } else {
                z80CPU.removePCListener(this);
            }
            this.pcListenerAdded = bl;
        }
    }

    protected void createIOSystem() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        this.ctc = new Z80CTC("CTC (E/A-Adressen 14h-17h)");
        this.pio = new Z80PIO("PIO (E/A-Adressen 0Ch-0Fh)");
        z80CPU.setInterruptSources(this.ctc, this.pio);
        z80CPU.addTStatesListener(this.ctc);
    }

    @Override
    public void z80PCChanged(Z80CPU z80CPU, int n) {
        if (n == 61455) {
            this.emuThread.getPrintMngr().putByte(z80CPU.getRegC());
            z80CPU.setRegPC(z80CPU.doPop());
        }
    }

    @Override
    public void die() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        if (this.ctc != null) {
            z80CPU.removeTStatesListener(this.ctc);
        }
        z80CPU.setInterruptSources(null);
        if (this.pcListenerAdded) {
            z80CPU.removePCListener(this);
        }
    }

    @Override
    public long getDelayMillisAfterPasteChar() {
        return 50L;
    }

    @Override
    public long getDelayMillisAfterPasteEnter() {
        return 300L;
    }

    @Override
    public long getHoldMillisPasteChar() {
        return 50L;
    }

    @Override
    public boolean getSwapKeyCharCase() {
        return true;
    }

    @Override
    public void keyReleased() {
        this.keyChar = 0;
    }

    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        if (c > '\u0000' && c < '\u007f') {
            this.keyChar = c;
            bl = true;
        }
        return bl;
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 0;
        if ((n &= 0xFF) >= 8 && n <= 11) {
            if (this.pasteStateNum > 0) {
                if (this.pasteStateNum == 4) {
                    this.keyChar = 0;
                }
                --this.pasteStateNum;
            } else {
                CharacterIterator characterIterator = this.pasteIter;
                if (characterIterator != null) {
                    int n4 = characterIterator.current();
                    characterIterator.next();
                    if (n4 == 65535) {
                        this.cancelPastingText();
                    } else {
                        if ((n4 = TextUtil.toISO646DE((char)n4)) == 10) {
                            n4 = 13;
                        }
                        if (n4 == 13 || n4 >= 0 && n4 < 127) {
                            this.keyChar = n4;
                            this.pasteStateNum = 8;
                        } else {
                            this.cancelPastingText();
                            this.fireShowCharNotPasted(characterIterator);
                        }
                    }
                }
            }
        }
        switch (n) {
            case 8: 
            case 10: {
                n3 = this.keyChar;
                break;
            }
            case 9: 
            case 11: {
                if (this.keyChar == 0) break;
                n3 = 255;
                break;
            }
            case 12: {
                n3 = this.pio.readDataA();
                break;
            }
            case 13: {
                n3 = this.pio.readControlA();
                break;
            }
            case 14: {
                n3 = this.pio.readDataB();
                break;
            }
            case 15: {
                n3 = this.pio.readControlB();
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n3 = this.ctc.read(n & 3, n2);
            }
        }
        return n3;
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        this.keyChar = 0;
        this.pasteStateNum = 0;
    }

    @Override
    public synchronized void startPastingText(String string) {
        boolean bl = false;
        if (string != null && !string.isEmpty()) {
            this.cancelPastingText();
            this.pasteIter = new StringCharacterIterator(string);
            bl = true;
        }
        if (!bl) {
            this.screenFrm.firePastingTextFinished();
        }
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return true;
    }

    @Override
    public boolean supportsPrinter() {
        return this.pcListenerAdded;
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        switch (n & 0xFF) {
            case 12: {
                this.pio.writeDataA(n2);
                break;
            }
            case 13: {
                this.pio.writeControlA(n2);
                break;
            }
            case 14: {
                this.pio.writeDataB(n2);
                break;
            }
            case 15: {
                this.pio.writeControlB(n2);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.ctc.write(n & 3, n2, n3);
            }
        }
    }
}

