/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.etc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.AutoInputSettingsFld;
import jkcemu.base.AutoLoadSettingsFld;
import jkcemu.base.EmuUtil;
import jkcemu.base.ROMFileSettingsFld;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;

public class PCMSettingsFld
extends AbstractSettingsFld {
    private JTabbedPane tabbedPane;
    private JPanel tabModel;
    private AutoLoadSettingsFld tabAutoLoad;
    private AutoInputSettingsFld tabAutoInput;
    private JCheckBox btnAutoLoadBDOS;
    private JRadioButton btnRF64x16;
    private JRadioButton btnFDC64x16;
    private JRadioButton btnFDC80x24;
    private ROMFileSettingsFld fldAltROM;
    private ROMFileSettingsFld fldAltFont;

    public PCMSettingsFld(SettingsFrm settingsFrm, String string) {
        super(settingsFrm, string);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, "Center");
        this.tabModel = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Modell", this.tabModel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnRF64x16 = new JRadioButton("RAM-Floppy-System, 64x16 Zeichen", true);
        buttonGroup.add(this.btnRF64x16);
        this.btnRF64x16.addActionListener(this);
        this.tabModel.add((Component)this.btnRF64x16, gridBagConstraints);
        this.btnAutoLoadBDOS = new JCheckBox("Bei RESET automatisch BDOS laden", true);
        this.btnAutoLoadBDOS.addActionListener(this);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 50;
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.btnAutoLoadBDOS, gridBagConstraints);
        this.btnFDC64x16 = new JRadioButton("Floppy-Disk-System, 64x16 Zeichen", false);
        buttonGroup.add(this.btnFDC64x16);
        this.btnFDC64x16.addActionListener(this);
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.btnFDC64x16, gridBagConstraints);
        this.btnFDC80x24 = new JRadioButton("Floppy-Disk-System, 80x24 Zeichen", false);
        buttonGroup.add(this.btnFDC80x24);
        this.btnFDC80x24.addActionListener(this);
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.btnFDC80x24, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)new JSeparator(), gridBagConstraints);
        this.fldAltROM = new ROMFileSettingsFld(settingsFrm, string + "rom.", "Alternativer ROM-Inhalt (Grundbetriebssystem):");
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.fldAltROM, gridBagConstraints);
        this.fldAltFont = new ROMFileSettingsFld(settingsFrm, string + "font.", "Alternativer Zeichensatz:");
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.fldAltFont, gridBagConstraints);
        this.tabAutoLoad = new AutoLoadSettingsFld(settingsFrm, string, 500, true);
        this.tabbedPane.addTab("AutoLoad", this.tabAutoLoad);
        this.tabAutoInput = new AutoInputSettingsFld(settingsFrm, string, true, 500);
        this.tabbedPane.addTab("AutoInput", this.tabAutoInput);
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        boolean bl2 = this.btnFDC64x16.isSelected();
        boolean bl3 = this.btnFDC80x24.isSelected();
        EmuUtil.setProperty(properties, this.propPrefix + "fdc.enabled", bl2 || bl3);
        EmuUtil.setProperty(properties, this.propPrefix + "graphic", bl3 ? "80x24" : "64x32");
        EmuUtil.setProperty(properties, this.propPrefix + "auto_load_bdos", this.btnAutoLoadBDOS.isSelected());
        this.fldAltROM.applyInput(properties, bl);
        this.fldAltFont.applyInput(properties, bl);
        this.tabAutoLoad.applyInput(properties, bl);
        this.tabAutoInput.applyInput(properties, bl);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            bl = this.tabAutoLoad.doAction(eventObject);
            if (!bl) {
                bl = this.tabAutoInput.doAction(eventObject);
            }
            if (!bl) {
                if (object instanceof JRadioButton) {
                    this.updAutoLoadBDOSFieldEnabled();
                    this.fireDataChanged();
                    bl = true;
                } else if (object instanceof AbstractButton) {
                    this.fireDataChanged();
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.tabAutoLoad.lookAndFeelChanged();
        this.tabAutoInput.lookAndFeelChanged();
    }

    @Override
    public void updFields(Properties properties) {
        if (EmuUtil.getBooleanProperty(properties, this.propPrefix + "fdc.enabled", false)) {
            if (EmuUtil.getProperty(properties, this.propPrefix + "graphic").equals("80x24")) {
                this.btnFDC80x24.setSelected(true);
            } else {
                this.btnFDC64x16.setSelected(true);
            }
        } else {
            this.btnRF64x16.setSelected(true);
        }
        this.btnAutoLoadBDOS.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "auto_load_bdos", true));
        this.fldAltROM.updFields(properties);
        this.fldAltFont.updFields(properties);
        this.updAutoLoadBDOSFieldEnabled();
        this.tabAutoLoad.updFields(properties);
        this.tabAutoInput.updFields(properties);
    }

    private void updAutoLoadBDOSFieldEnabled() {
        this.btnAutoLoadBDOS.setEnabled(this.btnRF64x16.isSelected());
    }
}

