/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.etc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.AutoInputSettingsFld;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileNameFld;
import jkcemu.base.ROMFileSettingsFld;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserCancelException;
import jkcemu.base.UserInputException;
import jkcemu.disk.GIDESettingsFld;

public class NANOSSettingsFld
extends AbstractSettingsFld {
    private JTabbedPane tabbedPane;
    private JPanel tabGraphic;
    private JRadioButton btnGraphic64x32;
    private JRadioButton btnGraphic80x24;
    private JRadioButton btnGraphic80x25;
    private JRadioButton btnGraphicPoppe;
    private JPanel tabKeyboard;
    private JRadioButton btnKbPio00Ahs;
    private JRadioButton btnKbPio00Abit7;
    private JRadioButton btnKbSio84A;
    private JCheckBox btnKbSwapCase;
    private JPanel tabRom;
    private JRadioButton btnRomNanos;
    private JRadioButton btnRomEpos;
    private JRadioButton btnRomFile;
    private FileNameFld fldRomFile;
    private JButton btnRomFileSelect;
    private JButton btnRomFileRemove;
    private GIDESettingsFld tabGIDE;
    private JPanel tabExt;
    private JCheckBox btnKCNet;
    private JCheckBox btnVDIP;
    private ROMFileSettingsFld fldAltFont8x6;
    private ROMFileSettingsFld fldAltFont8x8;
    private AutoInputSettingsFld tabAutoInput;

    public NANOSSettingsFld(SettingsFrm settingsFrm, String string) {
        super(settingsFrm, string);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, "Center");
        this.tabGraphic = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Grafik", this.tabGraphic);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.tabGraphic.add((Component)new JLabel("Grafikkarte:"), gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnGraphic64x32 = new JRadioButton("Bildschirmsteuerung Video 2 mit 64x32 Zeichen");
        buttonGroup.add(this.btnGraphic64x32);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 50;
        ++gridBagConstraints.gridy;
        this.tabGraphic.add((Component)this.btnGraphic64x32, gridBagConstraints);
        this.btnGraphic80x24 = new JRadioButton("Bildschirmsteuerung Video 3 mit 80x24 Zeichen");
        buttonGroup.add(this.btnGraphic80x24);
        ++gridBagConstraints.gridy;
        this.tabGraphic.add((Component)this.btnGraphic80x24, gridBagConstraints);
        this.btnGraphic80x25 = new JRadioButton("Bildschirmsteuerung Video 3 mit 80x25 Zeichen");
        buttonGroup.add(this.btnGraphic80x25);
        ++gridBagConstraints.gridy;
        this.tabGraphic.add((Component)this.btnGraphic80x25, gridBagConstraints);
        this.btnGraphicPoppe = new JRadioButton("Farbgrafikkarte mit 64x32 und 80x24 Zeichen umschaltbar");
        buttonGroup.add(this.btnGraphicPoppe);
        ++gridBagConstraints.gridy;
        this.tabGraphic.add((Component)this.btnGraphicPoppe, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridy;
        this.tabGraphic.add((Component)new JSeparator(), gridBagConstraints);
        this.fldAltFont8x8 = new ROMFileSettingsFld(settingsFrm, string + "font.8x8.", "Alternativer Zeichensatz (8x8):");
        gridBagConstraints.insets.top = 10;
        ++gridBagConstraints.gridy;
        this.tabGraphic.add((Component)this.fldAltFont8x8, gridBagConstraints);
        this.fldAltFont8x6 = new ROMFileSettingsFld(settingsFrm, string + "font.8x6.", "Alternativer 8x6-Zeichensatz f\u00fcr 64x32-Modus der Farbgrafikkarte:");
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.tabGraphic.add((Component)this.fldAltFont8x6, gridBagConstraints);
        this.tabKeyboard = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Tastatur", this.tabKeyboard);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.tabKeyboard.add((Component)new JLabel("Tastatur ist angeschlossen an:"), gridBagConstraints2);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.btnKbPio00Ahs = new JRadioButton("ZRE-PIO Port A mit Ready/Strobe-Handshake (NANOS 2.2)", true);
        buttonGroup2.add(this.btnKbPio00Ahs);
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.insets.left = 50;
        ++gridBagConstraints2.gridy;
        this.tabKeyboard.add((Component)this.btnKbPio00Ahs, gridBagConstraints2);
        this.btnKbPio00Abit7 = new JRadioButton("ZRE-PIO Port A mit Strobe an Bit 7 (EPOS 2.1)");
        buttonGroup2.add(this.btnKbPio00Abit7);
        ++gridBagConstraints2.gridy;
        this.tabKeyboard.add((Component)this.btnKbPio00Abit7, gridBagConstraints2);
        this.btnKbSio84A = new JRadioButton("IO-Karte SIO Port A");
        buttonGroup2.add(this.btnKbSio84A);
        ++gridBagConstraints2.gridy;
        this.tabKeyboard.add((Component)this.btnKbSio84A, gridBagConstraints2);
        this.btnKbSwapCase = new JCheckBox("Gro\u00df-/Kleinschreibung umkehren");
        gridBagConstraints2.insets.top = 10;
        gridBagConstraints2.insets.left = 5;
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        this.tabKeyboard.add((Component)this.btnKbSwapCase, gridBagConstraints2);
        this.tabRom = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("ROM", this.tabRom);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.btnRomNanos = new JRadioButton("Boot-ROM f\u00fcr NANOS 2.2", true);
        buttonGroup3.add(this.btnRomNanos);
        this.tabRom.add((Component)this.btnRomNanos, gridBagConstraints3);
        this.btnRomEpos = new JRadioButton("Boot-ROM f\u00fcr EPOS 2.1");
        buttonGroup3.add(this.btnRomEpos);
        gridBagConstraints3.insets.top = 0;
        ++gridBagConstraints3.gridy;
        this.tabRom.add((Component)this.btnRomEpos, gridBagConstraints3);
        this.btnRomFile = new JRadioButton("ROM-Datei:");
        buttonGroup3.add(this.btnRomFile);
        ++gridBagConstraints3.gridy;
        this.tabRom.add((Component)this.btnRomFile, gridBagConstraints3);
        this.fldRomFile = new FileNameFld();
        gridBagConstraints3.insets.bottom = 5;
        gridBagConstraints3.insets.left = 50;
        gridBagConstraints3.gridwidth = 1;
        ++gridBagConstraints3.gridy;
        this.tabRom.add((Component)this.fldRomFile, gridBagConstraints3);
        this.btnRomFileSelect = this.createImageButton("/images/file/open.png", "ROM-Datei ausw\u00e4hlen");
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.insets.left = 0;
        ++gridBagConstraints3.gridx;
        this.tabRom.add((Component)this.btnRomFileSelect, gridBagConstraints3);
        this.btnRomFileRemove = this.createImageButton("/images/file/delete.png", "ROM-Datei entfernen");
        ++gridBagConstraints3.gridx;
        this.tabRom.add((Component)this.btnRomFileRemove, gridBagConstraints3);
        this.tabGIDE = new GIDESettingsFld(settingsFrm, string);
        this.tabbedPane.addTab("GIDE", this.tabGIDE);
        this.tabExt = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Erweiterungen", this.tabExt);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.btnKCNet = new JCheckBox("KCNet-kompatible Netzwerkkarte");
        ++gridBagConstraints4.gridy;
        this.tabExt.add((Component)this.btnKCNet, gridBagConstraints4);
        this.btnVDIP = new JCheckBox("USB-Anschluss (Vinculum VDIP Modul)");
        gridBagConstraints4.insets.top = 0;
        gridBagConstraints4.insets.bottom = 5;
        ++gridBagConstraints4.gridy;
        this.tabExt.add((Component)this.btnVDIP, gridBagConstraints4);
        this.tabAutoInput = new AutoInputSettingsFld(settingsFrm, string, false, 2000);
        this.tabbedPane.addTab("AutoInput", this.tabAutoInput);
        this.btnGraphic64x32.addActionListener(this);
        this.btnGraphic80x24.addActionListener(this);
        this.btnGraphic80x25.addActionListener(this);
        this.btnGraphicPoppe.addActionListener(this);
        this.btnKbPio00Ahs.addActionListener(this);
        this.btnKbPio00Abit7.addActionListener(this);
        this.btnKbSio84A.addActionListener(this);
        this.btnKbSwapCase.addActionListener(this);
        this.btnRomNanos.addActionListener(this);
        this.btnRomEpos.addActionListener(this);
        this.btnRomFile.addActionListener(this);
        this.btnKCNet.addActionListener(this);
        this.btnVDIP.addActionListener(this);
        this.updGraphicDependFields();
        this.updRomDependFields();
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserCancelException, UserInputException {
        JPanel jPanel = null;
        String string = null;
        try {
            jPanel = this.tabGraphic;
            string = "80x25";
            if (this.btnGraphic64x32.isSelected()) {
                string = "64x32";
            } else if (this.btnGraphic80x24.isSelected()) {
                string = "80x24";
            } else if (this.btnGraphicPoppe.isSelected()) {
                string = "poppe";
            }
            EmuUtil.setProperty(properties, this.propPrefix + "graphic", string);
            this.fldAltFont8x8.applyInput(properties, bl);
            this.fldAltFont8x6.applyInput(properties, bl);
            jPanel = this.tabKeyboard;
            string = "pio00a_hs";
            if (this.btnKbPio00Abit7.isSelected()) {
                string = "pio00a_bit7";
            } else if (this.btnKbSio84A.isSelected()) {
                string = "sio84a";
            }
            EmuUtil.setProperty(properties, this.propPrefix + "keyboard", string);
            EmuUtil.setProperty(properties, this.propPrefix + "swap_case", this.btnKbSwapCase.isSelected());
            jPanel = this.tabRom;
            string = "nanos";
            if (this.btnRomEpos.isSelected()) {
                string = "epos";
            } else if (this.btnRomFile.isSelected()) {
                File file = this.fldRomFile.getFile();
                if (file == null && bl) {
                    this.tabbedPane.setSelectedComponent(this.tabRom);
                    throw new UserInputException("ROM: Bitte w\u00e4hlen Sie eine ROM-Datei aus\noder stellen Sie einen anderen Boot-ROM ein.");
                }
                if (file != null) {
                    string = "file:" + file.getPath();
                }
            }
            EmuUtil.setProperty(properties, this.propPrefix + "rom", string);
            jPanel = this.tabGIDE;
            this.tabGIDE.applyInput(properties, bl);
            jPanel = this.tabExt;
            EmuUtil.setProperty(properties, this.propPrefix + "kcnet.enabled", this.btnKCNet.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "vdip.enabled", this.btnVDIP.isSelected());
            jPanel = this.tabAutoInput;
            this.tabAutoInput.applyInput(properties, bl);
        }
        catch (UserInputException userInputException) {
            if (jPanel != null) {
                this.tabbedPane.setSelectedComponent(jPanel);
            }
            throw userInputException;
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        this.settingsFrm.setWaitCursor(true);
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            bl = this.tabGIDE.doAction(eventObject);
            if (!bl) {
                bl = this.tabAutoInput.doAction(eventObject);
            }
            if (!bl) {
                if (object == this.btnGraphic64x32 || object == this.btnGraphic80x24 || object == this.btnGraphic80x25 || object == this.btnGraphicPoppe) {
                    this.updGraphicDependFields();
                    this.fireDataChanged();
                    bl = true;
                } else if (object == this.btnRomNanos || object == this.btnRomEpos || object == this.btnRomFile) {
                    this.updRomDependFields();
                    this.fireDataChanged();
                    bl = true;
                } else if (object == this.btnRomFileSelect) {
                    File file = this.selectFile("ROM-Datei ausw\u00e4hlen", "rom", this.fldRomFile.getFile(), EmuUtil.getROMFileFilter());
                    if (file != null && this.fldRomFile.setFile(file)) {
                        this.btnRomFileRemove.setEnabled(true);
                        this.fireDataChanged();
                    }
                    bl = true;
                } else if (object == this.btnRomFileRemove) {
                    if (this.fldRomFile.setFile(null)) {
                        this.btnRomFileRemove.setEnabled(false);
                        this.fireDataChanged();
                    }
                    bl = true;
                } else if (object instanceof AbstractButton) {
                    this.fireDataChanged();
                    bl = true;
                }
            }
        }
        this.settingsFrm.setWaitCursor(false);
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.fldAltFont8x8.lookAndFeelChanged();
        this.fldAltFont8x6.lookAndFeelChanged();
        this.tabGIDE.lookAndFeelChanged();
        this.tabAutoInput.lookAndFeelChanged();
    }

    @Override
    public void updFields(Properties properties) {
        switch (EmuUtil.getProperty(properties, this.propPrefix + "graphic")) {
            case "64x32": {
                this.btnGraphic64x32.setSelected(true);
                break;
            }
            case "80x24": {
                this.btnGraphic80x24.setSelected(true);
                break;
            }
            case "poppe": {
                this.btnGraphicPoppe.setSelected(true);
                break;
            }
            default: {
                this.btnGraphic80x25.setSelected(true);
            }
        }
        this.fldAltFont8x8.updFields(properties);
        this.fldAltFont8x6.updFields(properties);
        switch (EmuUtil.getProperty(properties, this.propPrefix + "keyboard")) {
            case "pio00a_bit7": {
                this.btnKbPio00Abit7.setSelected(true);
                break;
            }
            case "sio84a": {
                this.btnKbSio84A.setSelected(true);
                break;
            }
            default: {
                this.btnKbPio00Ahs.setSelected(true);
            }
        }
        this.btnKbSwapCase.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "swap_case", false));
        String string = EmuUtil.getProperty(properties, this.propPrefix + "rom");
        String string2 = string.toLowerCase();
        if (string2.length() > "file:".length() && string2.startsWith("file:")) {
            this.btnRomFile.setSelected(true);
            this.fldRomFile.setFileName(string.substring(5));
        } else if (string2.equalsIgnoreCase("epos")) {
            this.btnRomEpos.setSelected(true);
        } else {
            this.btnRomNanos.setSelected(true);
        }
        this.btnKCNet.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "kcnet.enabled", false));
        this.btnVDIP.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "vdip.enabled", false));
        this.tabGIDE.updFields(properties);
        this.tabAutoInput.updFields(properties);
        this.updGraphicDependFields();
        this.updRomDependFields();
    }

    private void updGraphicDependFields() {
        this.fldAltFont8x6.setEnabled(this.btnGraphicPoppe.isSelected());
    }

    private void updRomDependFields() {
        boolean bl = this.btnRomFile.isSelected();
        this.fldRomFile.setEnabled(bl);
        this.btnRomFileSelect.setEnabled(bl);
        this.btnRomFileRemove.setEnabled(bl && this.fldRomFile.getFile() != null);
    }
}

