/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.etc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.C80;

public class C80KeyboardFld
extends AbstractKeyboardFld<C80> {
    private static final int MARGIN = 10;
    private static final int FONT_SIZE = 16;
    private static final int KEY_COL_W = 60;
    private static final int KEY_ROW_H = 40;
    private static final int KEY_W = 50;
    private static final int KEY_H = 30;
    private Font fontBtn = new Font("SansSerif", 0, 16);
    private AbstractKeyboardFld.KeyData resetKey;
    private AbstractKeyboardFld.KeyData nmiKey;
    private int[] kbMatrix = new int[8];
    private int curIdx = 0;
    private int curX = 10;
    private int curY = 10;

    public C80KeyboardFld(C80 c80) {
        super(c80, 24, true);
        this.addKey("D", 2, 1);
        this.addKey("E", 2, 2);
        this.addKey("F", 2, 4);
        this.resetKey = this.addKey("RES", -1, -1, "Esc");
        this.curX = 10;
        this.curY += 40;
        this.addKey("A", 3, 1);
        this.addKey("B", 3, 2);
        this.addKey("C", 3, 4);
        this.nmiKey = this.addKey("BRK", -1, -1, "N");
        this.curX = 10;
        this.curY += 40;
        this.addKey("7", 4, 1);
        this.addKey("8", 4, 2);
        this.addKey("9", 4, 4);
        this.addKey("GO", 1, 1, "G");
        this.curX = 10;
        this.curY += 40;
        this.addKey("4", 5, 1);
        this.addKey("5", 5, 2);
        this.addKey("6", 5, 4);
        this.addKey("REG", 0, 1, "R");
        this.curX = 10;
        this.curY += 40;
        this.addKey("1", 6, 1);
        this.addKey("2", 6, 2);
        this.addKey("3", 6, 4);
        this.addKey("-", 1, 2, "-");
        this.curX = 10;
        this.curY += 40;
        this.addKey("FCN", 7, 1, "F1");
        this.addKey("0", 7, 2);
        this.addKey("MEM", 7, 4, "M");
        this.addKey("+", 0, 2, "+ oder Enter");
        int n = this.curY + 40 + 10;
        this.setPreferredSize(new Dimension(250, 250));
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        return emuSys instanceof C80;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Arrays.fill(this.kbMatrix, 0);
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                int n = keyData.col;
                this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
            }
        }
        ((C80)this.emuSys).updKeyboardMatrix(this.kbMatrix);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this) {
            if (C80KeyboardFld.hits(this.resetKey, mouseEvent)) {
                this.fireWarmResetAfterDelay();
            } else if (C80KeyboardFld.hits(this.nmiKey, mouseEvent)) {
                this.fireNMIAfterDelay();
            }
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setPaintMode();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setFont(this.fontBtn);
        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
            FontMetrics fontMetrics;
            boolean bl = this.isKeySelected(keyData);
            if (bl) {
                graphics.setColor(Color.gray);
                graphics.fillRect(keyData.x + 1, keyData.y + 1, keyData.w - 1, keyData.h - 1);
            }
            graphics.setColor(Color.lightGray);
            graphics.draw3DRect(keyData.x + 1, keyData.y + 1, keyData.w - 1, keyData.h - 1, !bl);
            if (keyData.text1 == null || (fontMetrics = graphics.getFontMetrics()) == null) continue;
            graphics.setColor(Color.black);
            graphics.drawString(keyData.text1, keyData.x + (keyData.w - fontMetrics.stringWidth(keyData.text1)) / 2 + 1, keyData.y + 16 + (keyData.h - 16) / 2 - 1);
        }
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!(emuSys instanceof C80)) {
            throw new IllegalArgumentException("EmuSys != C80");
        }
        this.emuSys = (C80)emuSys;
    }

    private AbstractKeyboardFld.KeyData addKey(String string, int n, int n2, String string2) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 50, 30, string, null, null, null, null, n, n2, false, string2);
        this.keys[this.curIdx++] = keyData;
        this.curX += 60;
        return keyData;
    }

    private AbstractKeyboardFld.KeyData addKey(String string, int n, int n2) {
        return this.addKey(string, n, n2, null);
    }
}

