/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.bcs3;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Arrays;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.BCS3;

public class BCS3KeyboardFld
extends AbstractKeyboardFld<BCS3> {
    private static final int MARGIN = 20;
    private static final int FONT_SIZE = 12;
    private static final int KEY_SIZE = 40;
    private Image imgLeft = this.getImage("/images/keyboard/left.png");
    private Font fontText = new Font("SansSerif", 0, 12);
    private int[] kbMatrix = new int[10];
    private int curIdx = 0;
    private int curX = 20;
    private int curY = 20;

    public BCS3KeyboardFld(BCS3 bCS3) {
        super(bCS3, 40, true);
        this.addKey("1", "!", 1, 8);
        this.addKey("2", "\"", 2, 8);
        this.addKey("3", "#", 3, 8);
        this.addKey("4", "$", 4, 8);
        this.addKey("5", "%", 5, 8);
        this.addKey("6", "&", 6, 8);
        this.addKey("7", "'", 7, 8);
        this.addKey("8", "(", 8, 8);
        this.addKey("9", ")", 9, 8);
        this.addKey("0", 0, 8);
        this.curX = 28;
        this.curY += 40;
        this.addKey("Q", "@", 6, 2);
        this.addKey("W", 2, 1);
        this.addKey("E", "*", 4, 4);
        this.addKey("R", 7, 2);
        this.addKey("T", 9, 2);
        this.addKey("Z", 5, 1);
        this.addKey("U", 0, 1);
        this.addKey("I", 8, 4);
        this.addKey("O", ">", 4, 2);
        this.addKey("P", "?", 5, 2);
        this.curX = 36;
        this.curY += 40;
        this.addKey("A", 0, 4);
        this.addKey("S", 8, 2);
        this.addKey("D", 3, 4);
        this.addKey("F", "+", 5, 4);
        this.addKey("G", ",", 6, 4);
        this.addKey("H", "-", 7, 4);
        this.addKey("J", "/", 9, 4);
        this.addKey("K", ":", 0, 2);
        this.addKey("L", ";", 1, 2);
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, null, null, null, null, this.imgLeft, 7, 1, false, null);
        int n = this.curX + 40 + 20;
        this.curX = 20;
        this.curY += 40;
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, "SHIFT", null, null, null, null, 9, 1, true, null);
        this.keys[this.curIdx++] = keyData;
        this.curX += 40;
        this.addKey("Y", 4, 1);
        this.addKey("X", 3, 1);
        this.addKey("C", 2, 4);
        this.addKey("V", 1, 1);
        this.addKey("B", 1, 4);
        this.addKey("N", "=", 3, 2);
        this.addKey("M", "<", 2, 2);
        this.addKey("SP", 6, 1);
        this.addKey("ENTER", 8, 1);
        int n2 = this.curY + 40 + 20;
        this.setPreferredSize(new Dimension(n, n2));
        this.setShiftKeys(keyData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeySelection(int[] nArray) {
        boolean bl = false;
        List list = this.selectedKeys;
        synchronized (list) {
            bl = !this.selectedKeys.isEmpty();
            this.selectedKeys.clear();
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) continue;
                    for (AbstractKeyboardFld.KeyData keyData : this.keys) {
                        if (keyData.col != i || (keyData.value & nArray[i]) == 0) continue;
                        bl = true;
                        keyData.locked = false;
                        this.selectedKeys.add(keyData);
                    }
                }
            }
        }
        if (bl) {
            this.repaint();
        }
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        return emuSys instanceof BCS3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Arrays.fill(this.kbMatrix, 0);
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                int n = keyData.col;
                this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
            }
        }
        ((BCS3)this.emuSys).updKeyboardMatrix(this.kbMatrix);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setPaintMode();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
            boolean bl = this.isKeySelected(keyData);
            if (bl) {
                graphics.setColor(Color.gray);
                graphics.fillRect(keyData.x + 1, keyData.y + 1, keyData.w - 1, keyData.h - 1);
            }
            graphics.setColor(Color.lightGray);
            graphics.draw3DRect(keyData.x + 1, keyData.y + 1, keyData.w - 1, keyData.h - 1, !bl);
            if (keyData.image != null) {
                graphics.drawImage(keyData.image, keyData.x + (keyData.w - keyData.image.getWidth(this)) / 2 + 1, keyData.y + (keyData.h - keyData.image.getHeight(this)) / 4 * 3 + 1, this);
            }
            graphics.setColor(Color.black);
            if (keyData.text1 != null) {
                this.drawCentered(graphics, keyData.text1, keyData.x, keyData.y, keyData.w);
            }
            if (keyData.text2 == null) continue;
            this.drawCentered(graphics, keyData.text2, keyData.x, keyData.y - 20 + 2, keyData.w);
        }
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!(emuSys instanceof BCS3)) {
            throw new IllegalArgumentException("EmuSys != BCS3");
        }
        this.emuSys = (BCS3)emuSys;
    }

    private void addKey(String string, String string2, int n, int n2) {
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, string, string2, null, null, null, n, n2, false, null);
        this.curX += 40;
    }

    private void addKey(String string, int n, int n2) {
        this.addKey(string, null, n, n2);
    }

    private void drawCentered(Graphics graphics, String string, int n, int n2, int n3) {
        if (string != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (fontMetrics != null) {
                int n4 = fontMetrics.stringWidth(string);
                n += (n3 - n4) / 2;
            } else {
                n += 5;
            }
            graphics.drawString(string, n + 2, n2 + 40 - 5);
        }
    }
}

