/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.ac1_llc2;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.EmuUtil;
import jkcemu.base.ROMFileSettingsFld;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;

public class SCCHModule1SettingsFld
extends AbstractSettingsFld
implements ChangeListener {
    private ROMFileSettingsFld fldPrgX;
    private ROMFileSettingsFld fldRomDisk;
    private ROMFileSettingsFld fldBasicRom;
    private JLabel labelBasicRomAddr;
    private JRadioButton btnBasicRom2000;
    private JRadioButton btnBasicRom4000;
    private JLabel labelRomDiskAddr;
    private JRadioButton btnRomDisk8000;
    private JRadioButton btnRomDiskC000;

    public SCCHModule1SettingsFld(SettingsFrm settingsFrm, String string) {
        super(settingsFrm, string);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.fldPrgX = new ROMFileSettingsFld(settingsFrm, string + "program_x.", "ROM-Datei f\u00fcr Programmpaket X (E000h-FFFFh):");
        this.add((Component)this.fldPrgX, gridBagConstraints);
        this.fldRomDisk = new ROMFileSettingsFld(settingsFrm, string + "romdisk.", "ROM-Datei f\u00fcr ROM-Disk (8000h-FFFFh bzw. C000h-FFFFh):");
        gridBagConstraints.insets.bottom = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.fldRomDisk, gridBagConstraints);
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        this.labelRomDiskAddr = new JLabel("ROM-Disk einblenden ab Adresse:");
        jPanel.add(this.labelRomDiskAddr);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnRomDisk8000 = new JRadioButton("8000h", false);
        buttonGroup.add(this.btnRomDisk8000);
        jPanel.add(this.btnRomDisk8000);
        this.btnRomDiskC000 = new JRadioButton("C000h", true);
        buttonGroup.add(this.btnRomDiskC000);
        jPanel.add(this.btnRomDiskC000);
        this.updRomDiskAddrFieldsEnabled();
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        ++gridBagConstraints.gridy;
        this.add((Component)new JSeparator(), gridBagConstraints);
        this.fldBasicRom = new ROMFileSettingsFld(settingsFrm, string + "basic.", "Alternativer BASIC-ROM (2000h-5FFFh bzw. 4000h-5FFFh):");
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.fldBasicRom, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        this.labelBasicRomAddr = new JLabel("BASIC-ROM einblenden ab Adresse:");
        jPanel2.add(this.labelBasicRomAddr);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.btnBasicRom2000 = new JRadioButton("2000h", false);
        buttonGroup2.add(this.btnBasicRom2000);
        jPanel2.add(this.btnBasicRom2000);
        this.btnBasicRom4000 = new JRadioButton("4000h", true);
        buttonGroup2.add(this.btnBasicRom4000);
        jPanel2.add(this.btnBasicRom4000);
        this.updBasicRomAddrFieldsEnabled();
        this.setEnabled(true);
        this.fldRomDisk.addChangeListener(this);
        this.btnRomDisk8000.addActionListener(this);
        this.btnRomDiskC000.addActionListener(this);
        this.fldBasicRom.addChangeListener(this);
        this.btnBasicRom2000.addActionListener(this);
        this.btnBasicRom4000.addActionListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.fldRomDisk) {
            this.updRomDiskAddrFieldsEnabled();
        } else if (object == this.fldBasicRom) {
            this.updBasicRomAddrFieldsEnabled();
        }
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        this.fldPrgX.applyInput(properties, bl);
        this.fldRomDisk.applyInput(properties, bl);
        this.fldBasicRom.applyInput(properties, bl);
        EmuUtil.setProperty(properties, this.propPrefix + "basic.addr", this.btnBasicRom2000.isSelected() ? "2000" : "4000");
        EmuUtil.setProperty(properties, this.propPrefix + "romdisk.addr", this.btnRomDisk8000.isSelected() ? "8000" : "C000");
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null && object instanceof AbstractButton) {
            bl = true;
            this.fireDataChanged();
        }
        return bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.fldPrgX.setEnabled(bl);
        this.fldRomDisk.setEnabled(bl);
        this.fldBasicRom.setEnabled(bl);
        this.updBasicRomAddrFieldsEnabled();
        this.updRomDiskAddrFieldsEnabled();
    }

    @Override
    public void updFields(Properties properties) {
        this.fldPrgX.updFields(properties);
        this.fldRomDisk.updFields(properties);
        this.fldBasicRom.updFields(properties);
        String string = EmuUtil.getProperty(properties, this.propPrefix + "basic.addr");
        if (string.startsWith("2000")) {
            this.btnBasicRom2000.setSelected(true);
        } else {
            this.btnBasicRom4000.setSelected(true);
        }
        this.updBasicRomAddrFieldsEnabled();
        string = EmuUtil.getProperty(properties, this.propPrefix + "romdisk.addr");
        if (string.startsWith("8000")) {
            this.btnRomDisk8000.setSelected(true);
        } else {
            this.btnRomDiskC000.setSelected(true);
        }
        this.updRomDiskAddrFieldsEnabled();
    }

    private void updBasicRomAddrFieldsEnabled() {
        boolean bl = this.fldBasicRom.isEnabled();
        if (bl && this.fldBasicRom.getFile() == null) {
            bl = false;
        }
        this.labelBasicRomAddr.setEnabled(bl);
        this.btnBasicRom2000.setEnabled(bl);
        this.btnBasicRom4000.setEnabled(bl);
    }

    private void updRomDiskAddrFieldsEnabled() {
        boolean bl = this.fldRomDisk.isEnabled();
        if (bl && this.fldRomDisk.getFile() == null) {
            bl = false;
        }
        this.labelRomDiskAddr.setEnabled(bl);
        this.btnRomDisk8000.setEnabled(bl);
        this.btnRomDiskC000.setEnabled(bl);
    }
}

