/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.ac1_llc2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.AutoInputSettingsFld;
import jkcemu.base.AutoLoadSettingsFld;
import jkcemu.base.EmuUtil;
import jkcemu.base.RAMFloppiesSettingsFld;
import jkcemu.base.RAMFloppy;
import jkcemu.base.ROMFileSettingsFld;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;
import jkcemu.disk.GIDESettingsFld;
import jkcemu.emusys.ac1_llc2.SCCHModule1SettingsFld;

public class LLC2SettingsFld
extends AbstractSettingsFld {
    private JTabbedPane tabbedPane;
    private SCCHModule1SettingsFld tabSCCH;
    private RAMFloppiesSettingsFld tabRF;
    private JCheckBox btnFloppyDisk;
    private JCheckBox btnJoystick;
    private JCheckBox btnKCNet;
    private JCheckBox btnVDIP;
    private JCheckBox btnPasteFast;
    private JCheckBox btnRatio43;
    private ROMFileSettingsFld fldAltOS;
    private ROMFileSettingsFld fldAltFont;
    private GIDESettingsFld tabGIDE;
    private JPanel tabExt;
    private JPanel tabEtc;
    private AutoLoadSettingsFld tabAutoLoad;
    private AutoInputSettingsFld tabAutoInput;

    public LLC2SettingsFld(SettingsFrm settingsFrm, String string) {
        super(settingsFrm, string);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, "Center");
        this.tabSCCH = new SCCHModule1SettingsFld(settingsFrm, string + "scch.");
        this.tabbedPane.addTab("SCCH-Modul 1", this.tabSCCH);
        this.tabRF = new RAMFloppiesSettingsFld(settingsFrm, string, "RAM-Floppy nach MP 3/88 (256 KByte) an E/A-Adressen D0h-D7h", RAMFloppy.RFType.MP_3_1988, "RAM-Floppy nach MP 3/88 (256 KByte) an E/A-Adressen B0h-B7h", RAMFloppy.RFType.MP_3_1988);
        this.tabbedPane.addTab("RAM-Floppies", this.tabRF);
        this.tabGIDE = new GIDESettingsFld(settingsFrm, string);
        this.tabbedPane.addTab("GIDE", this.tabGIDE);
        this.tabExt = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Erweiterungen", this.tabExt);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.btnFloppyDisk = new JCheckBox("Floppy-Disk-Modul", false);
        ++gridBagConstraints.gridy;
        this.tabExt.add((Component)this.btnFloppyDisk, gridBagConstraints);
        this.btnKCNet = new JCheckBox("KCNet-kompatible Netzwerkkarte");
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.tabExt.add((Component)this.btnKCNet, gridBagConstraints);
        this.btnVDIP = new JCheckBox("USB-Anschluss (Vinculum VDIP Modul)");
        ++gridBagConstraints.gridy;
        this.tabExt.add((Component)this.btnVDIP, gridBagConstraints);
        this.btnJoystick = new JCheckBox("Joystick");
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.tabExt.add((Component)this.btnJoystick, gridBagConstraints);
        this.tabEtc = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Sonstiges", this.tabEtc);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        this.btnRatio43 = new JCheckBox("Bildschirmausgabe im Format 4:3", false);
        this.tabEtc.add((Component)this.btnRatio43, gridBagConstraints2);
        this.btnPasteFast = new JCheckBox("Einf\u00fcgen von Text durch Abfangen des Systemaufrufs");
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        this.tabEtc.add((Component)this.btnPasteFast, gridBagConstraints2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets.top = 10;
        gridBagConstraints2.insets.bottom = 10;
        ++gridBagConstraints2.gridy;
        this.tabEtc.add((Component)new JSeparator(), gridBagConstraints2);
        this.fldAltOS = new ROMFileSettingsFld(settingsFrm, string + "os.", "Alternatives Monitorprogramm (0000h-0FFFh):");
        gridBagConstraints2.insets.top = 5;
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        this.tabEtc.add((Component)this.fldAltOS, gridBagConstraints2);
        this.fldAltFont = new ROMFileSettingsFld(settingsFrm, string + "font.", "Alternativer Zeichensatz:");
        ++gridBagConstraints2.gridy;
        this.tabEtc.add((Component)this.fldAltFont, gridBagConstraints2);
        this.tabAutoLoad = new AutoLoadSettingsFld(settingsFrm, string, 500, true);
        this.tabbedPane.addTab("AutoLoad", this.tabAutoLoad);
        this.tabAutoInput = new AutoInputSettingsFld(settingsFrm, string, true, 2, 500);
        this.tabbedPane.addTab("AutoInput", this.tabAutoInput);
        this.btnFloppyDisk.addActionListener(this);
        this.btnKCNet.addActionListener(this);
        this.btnVDIP.addActionListener(this);
        this.btnJoystick.addActionListener(this);
        this.btnPasteFast.addActionListener(this);
        this.btnRatio43.addActionListener(this);
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        JPanel jPanel = null;
        try {
            jPanel = this.tabSCCH;
            this.tabSCCH.applyInput(properties, bl);
            jPanel = this.tabRF;
            this.tabRF.applyInput(properties, bl);
            jPanel = this.tabGIDE;
            this.tabGIDE.applyInput(properties, bl);
            jPanel = this.tabEtc;
            EmuUtil.setProperty(properties, this.propPrefix + "fdc.enabled", this.btnFloppyDisk.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "kcnet.enabled", this.btnKCNet.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "vdip.enabled", this.btnVDIP.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "joystick.enabled", this.btnJoystick.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "paste.fast", this.btnPasteFast.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "screen.ratio", this.btnRatio43.isSelected() ? "4:3" : "unscaled");
            this.fldAltOS.applyInput(properties, bl);
            this.fldAltFont.applyInput(properties, bl);
            jPanel = this.tabAutoLoad;
            this.tabAutoLoad.applyInput(properties, bl);
            jPanel = this.tabAutoInput;
            this.tabAutoInput.applyInput(properties, bl);
        }
        catch (UserInputException userInputException) {
            if (jPanel != null) {
                this.tabbedPane.setSelectedComponent(jPanel);
            }
            throw userInputException;
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        this.settingsFrm.setWaitCursor(true);
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            bl = this.tabGIDE.doAction(eventObject);
            if (!bl) {
                bl = this.tabAutoLoad.doAction(eventObject);
            }
            if (!bl) {
                bl = this.tabAutoInput.doAction(eventObject);
            }
            if (!bl && object instanceof AbstractButton) {
                bl = true;
                this.fireDataChanged();
            }
        }
        this.settingsFrm.setWaitCursor(false);
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.fldAltOS.lookAndFeelChanged();
        this.fldAltFont.lookAndFeelChanged();
        this.tabSCCH.lookAndFeelChanged();
        this.tabRF.lookAndFeelChanged();
        this.tabGIDE.lookAndFeelChanged();
        this.tabAutoLoad.lookAndFeelChanged();
        this.tabAutoInput.lookAndFeelChanged();
    }

    @Override
    public void updFields(Properties properties) {
        this.tabSCCH.updFields(properties);
        this.tabRF.updFields(properties);
        this.tabGIDE.updFields(properties);
        this.tabAutoLoad.updFields(properties);
        this.tabAutoInput.updFields(properties);
        this.btnFloppyDisk.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "fdc.enabled", false));
        this.btnKCNet.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "kcnet.enabled", false));
        this.btnVDIP.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "vdip.enabled", false));
        this.btnJoystick.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "joystick.enabled", false));
        this.btnPasteFast.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "paste.fast", false));
        this.btnRatio43.setSelected(EmuUtil.getProperty(properties, this.propPrefix + "screen.ratio").equals("4:3"));
        this.fldAltOS.updFields(properties);
        this.fldAltFont.updFields(properties);
    }
}

