/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.ac1_llc2;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Properties;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.SourceUtil;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80MemView;
import z80emu.Z80PCListener;
import z80emu.Z80PIO;

public abstract class AbstractSCCHSys
extends EmuSys
implements Z80PCListener {
    public static final String PROP_JOYSTICK_ENABLED = "joystick.enabled";
    public static final String PROP_SCCH_PREFIX = "scch.";
    public static final String PROP_PROGRAM_X_PREFIX = "program_x.";
    public static final String PROP_ROMDISK_PREFIX = "romdisk.";
    public static final String PROP_BASIC_ADDR = "basic.addr";
    public static final String PROP_ROMDISK_ADDR = "romdisk.addr";
    public static final String PROP_SCCH_BASIC_FILE = "scch.basic.file";
    public static final String PROP_SCCH_PROGRAM_X_FILE = "scch.program_x.file";
    public static final String PROP_SCCH_ROMDISK_FILE = "scch.romdisk.file";
    private static int ADDR_INCH = 6146;
    protected static final String[] scchTokens = new String[]{"END", "FOR", "NEXT", "DATA", "INPUT", "DIM", "READ", "LET", "GOTO", "RUN", "IF", "RESTORE", "GOSUB", "RETURN", "REM", "STOP", "OUT", "ON", "NULL", "WAIT", "DEF", "POKE", "DOKE", "AUTO", "LINES", "CLS", "WIDTH", "BYE", "KEY", "CALL", "PRINT", "CONT", "LIST", "CLEAR", "CLOAD", "CSAVE", "NEW", "TAB(", "TO", "FN", "SPC(", "THEN", "NOT", "STEP", "+", "-", "*", "/", "^", "AND", "OR", ">", "=", "<", "SGN", "INT", "ABS", "USR", "FRE", "INP", "POS", "SQR", "RND", "LN", "EXP", "COS", "SIN", "TAN", "ATN", "PEEK", "DEEK", "POINT", "LEN", "STR$", "VAL", "ASC", "CHR$", "LEFT$", "RIGHT$", "MID$", "SET", "RESET", "RENUMBER", "LOCATE", "SOUND", "INKEY", "MODE", "TRON", "TROFF", "PAUSE", "EDIT", "DIR", "BLOAD", "LPRINT", "LLIST", "BACO", "CONV", "TRANS", "ALIST", "AEDIT", "ASAVE", "ALOAD", "INSTR", "JOY", "TICKS", "TIME$", "PI", "UPPER$", "SCREEN", "GCLS", "PSET", "LINE", "DRAWTO", "BOX", "CIRCLE", "TEXT", "PLOAD", "PSAVE", "DLOAD", "DSAVE", "DGET", "DPUT", "CD"};
    protected static final int[] scchCharToUnicode = new int[]{32, 9624, 9629, 9600, 9622, 9612, 9630, 9627, 9623, 9626, 9616, 9628, 9604, 9625, 9631, 9608, -1, -1, 9632, 9586, 9585, 9547, 9618, -1, -1, -1, -1, 9633, 9635, 9670, 9643, 9642, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 167, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 220, 94, 95, 64, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 252, 223, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9675, 9688, 9711, -1, 9700, 9699, 9585, 9586, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9473, 9475, 9531, 9507, 9523, 9515, 9547, 9495, 9487, 9491, 9499, -1, -1, -1, -1, 9587, 9624, 9629, 9623, 9622, 9612, 9616, 9600, 9604, 9626, 9630, 9631, 9625, 9627, 9628, 9698, 9701, -1, -1, -1, -1, 9823, -1, -1, 9618, -1, 9830, 9827, 9829, 9824, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9601, 9602, 9603, 9604, 9605, 9606, 9607, 9608};
    protected Z80PIO pio1;
    protected volatile boolean joystickEnabled;
    protected volatile boolean joystickSelected;
    protected int joystickValue;
    protected int keyboardValue;
    protected boolean rf32KActive;
    protected boolean rf32NegA15;
    protected boolean rfReadEnabled;
    protected boolean rfWriteEnabled;
    protected int rfAddr16to19;
    protected byte[] ramModule3;
    protected byte[] scchBasicRomBytes;
    protected byte[] scchPrgXRomBytes;
    protected byte[] scchRomdiskBytes;
    protected String scchBasicRomFile;
    protected String scchPrgXRomFile;
    protected String scchRomdiskFile;
    protected boolean scchBasicRomEnabled;
    protected int scchBasicRomBegAddr;
    protected boolean scchPrgXRomEnabled;
    protected boolean scchRomdiskEnabled;
    protected int scchRomdiskBegAddr;
    protected int scchRomdiskBankAddr;
    protected volatile boolean pasteFast;
    protected boolean v24BitOut;
    protected int v24BitNum;
    protected int v24ShiftBuf;
    protected int v24TStateCounter;
    protected int v24TStatesPerBit;
    private byte[] gsbasic;

    protected AbstractSCCHSys(EmuThread emuThread, Properties properties, String string) {
        super(emuThread, properties, string);
        this.joystickEnabled = this.emulatesJoystick(properties);
        this.ramModule3 = null;
        this.scchBasicRomBegAddr = this.getScchBasicRomBegAddr(properties);
        this.scchBasicRomBytes = null;
        this.scchBasicRomFile = null;
        this.scchPrgXRomBytes = null;
        this.scchPrgXRomFile = null;
        this.scchRomdiskBytes = null;
        this.scchRomdiskFile = null;
        this.scchRomdiskBegAddr = this.getScchRomdiskBegAddr(properties);
        this.scchRomdiskBankAddr = 0;
        this.pasteFast = false;
        this.gsbasic = null;
    }

    protected synchronized void checkAddPCListener(Properties properties) {
        boolean bl;
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        if (z80CPU != null && (bl = EmuUtil.getBooleanProperty(properties, this.propPrefix + "paste.fast", false)) != this.pasteFast) {
            this.pasteFast = bl;
            if (bl) {
                z80CPU.addPCListener(this, ADDR_INCH);
            } else {
                z80CPU.removePCListener(this);
            }
        }
    }

    protected boolean emulatesFloppyDisk(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "fdc.enabled", false);
    }

    protected boolean emulatesJoystick(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_JOYSTICK_ENABLED, false);
    }

    protected boolean emulatesKCNet(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "kcnet.enabled", false);
    }

    protected boolean emulatesUSB(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "vdip.enabled", false);
    }

    protected int getScchMemByte(int n, boolean bl) {
        int n2;
        int n3 = 255;
        boolean bl2 = false;
        if (!bl && this.rfReadEnabled && this.ramModule3 != null) {
            n2 = this.rfAddr16to19 | n;
            if (n2 >= 0 && n2 < this.ramModule3.length) {
                n3 = this.ramModule3[n2] & 0xFF;
            }
            bl2 = true;
        }
        if (!bl2 && this.rf32KActive && this.ramModule3 != null && n >= 16384 && n < 49152) {
            n2 = this.rfAddr16to19 | n;
            if (this.rf32NegA15) {
                n2 ^= 0x8000;
            }
            if (n2 >= 0 && n2 < this.ramModule3.length) {
                n3 = this.ramModule3[n2] & 0xFF;
            }
            bl2 = true;
        }
        if (!bl2 && this.scchBasicRomEnabled && n >= this.scchBasicRomBegAddr && n < 24576) {
            if (this.scchBasicRomBytes != null && (n2 = n - this.scchBasicRomBegAddr) < this.scchBasicRomBytes.length) {
                n3 = this.scchBasicRomBytes[n2] & 0xFF;
            }
            bl2 = true;
        }
        if (!bl2 && this.scchRomdiskEnabled && n >= this.scchRomdiskBegAddr) {
            if (this.scchRomdiskBytes != null && (n2 = this.scchRomdiskBankAddr | n - this.scchRomdiskBegAddr) < this.scchRomdiskBytes.length) {
                n3 = this.scchRomdiskBytes[n2] & 0xFF;
            }
            bl2 = true;
        }
        if (!bl2 && this.scchPrgXRomEnabled && n >= 57344) {
            if (this.scchPrgXRomBytes != null && (n2 = n - 57344) < this.scchPrgXRomBytes.length) {
                n3 = this.scchPrgXRomBytes[n2] & 0xFF;
            }
            bl2 = true;
        }
        return bl2 ? n3 : -1;
    }

    protected void loadROMs(Properties properties, String string) {
        this.scchBasicRomFile = EmuUtil.getProperty(properties, this.propPrefix + PROP_SCCH_BASIC_FILE);
        this.scchBasicRomBytes = this.readROMFile(this.scchBasicRomFile, this.scchBasicRomBegAddr < 16384 ? 16384 : 8192, "BASIC");
        if (this.scchBasicRomBytes == null) {
            if (this.gsbasic == null) {
                this.gsbasic = this.readResource(string);
            }
            this.scchBasicRomBytes = this.gsbasic;
        }
        this.scchPrgXRomFile = EmuUtil.getProperty(properties, this.propPrefix + PROP_SCCH_PROGRAM_X_FILE);
        this.scchPrgXRomBytes = this.readROMFile(this.scchPrgXRomFile, 8192, "Programmpaket X");
        this.scchRomdiskFile = EmuUtil.getProperty(properties, this.propPrefix + PROP_SCCH_ROMDISK_FILE);
        this.scchRomdiskBytes = this.readROMFile(this.scchRomdiskFile, 262144, "SCCH-Modul 1 ROM-Disk");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setKeyboardValue(int n) {
        this.keyboardValue = n;
        Z80PIO z80PIO = this.pio1;
        synchronized (z80PIO) {
            if (!this.joystickEnabled || !this.joystickSelected) {
                this.pio1.putInValuePortA(this.keyboardValue, 255);
            }
        }
    }

    protected int setScchMemByte(int n, int n2) {
        int n3;
        int n4 = -1;
        if (this.rfWriteEnabled && this.ramModule3 != null) {
            n3 = this.rfAddr16to19 | n;
            if (n3 >= 0 && n3 < this.ramModule3.length) {
                this.ramModule3[n3] = (byte)n2;
                n4 = 1;
            } else {
                n4 = 0;
            }
        }
        if (n4 < 0 && this.rf32KActive && this.ramModule3 != null && n >= 16384 && n < 49152) {
            n3 = this.rfAddr16to19 | n;
            if (this.rf32NegA15) {
                n3 ^= 0x8000;
            }
            if (n3 >= 0 && n3 < this.ramModule3.length) {
                this.ramModule3[n3] = (byte)n2;
                n4 = 1;
            } else {
                n4 = 0;
            }
        }
        return n4;
    }

    @Override
    public synchronized void z80PCChanged(Z80CPU z80CPU, int n) {
        CharacterIterator characterIterator;
        if (this.pasteFast && n == ADDR_INCH && (characterIterator = this.pasteIter) != null) {
            char c = characterIterator.next();
            if (c == '\uffff') {
                this.cancelPastingText();
            } else if (c > '\u0000' && c < '\u007f') {
                z80CPU.setRegA(c == '\n' ? 13 : (int)c);
                z80CPU.setRegPC(z80CPU.doPop());
            } else {
                this.cancelPastingText();
                this.fireShowCharNotPasted(characterIterator);
            }
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl;
        boolean bl2 = bl = this.emulatesJoystick(properties) == this.joystickEnabled;
        if (bl) {
            bl = TextUtil.equals(this.scchBasicRomFile, EmuUtil.getProperty(properties, this.propPrefix + PROP_SCCH_BASIC_FILE));
        }
        if (bl && this.scchBasicRomFile != null) {
            boolean bl3 = bl = this.scchBasicRomBegAddr == this.getScchBasicRomBegAddr(properties);
        }
        if (bl) {
            bl = TextUtil.equals(this.scchPrgXRomFile, EmuUtil.getProperty(properties, this.propPrefix + PROP_SCCH_PROGRAM_X_FILE));
        }
        if (bl) {
            bl = TextUtil.equals(this.scchRomdiskFile, EmuUtil.getProperty(properties, this.propPrefix + PROP_SCCH_ROMDISK_FILE));
        }
        if (bl && this.scchRomdiskFile != null) {
            bl = this.scchRomdiskBegAddr == this.getScchRomdiskBegAddr(properties);
        }
        return bl;
    }

    @Override
    public int getSupportedJoystickCount() {
        return this.joystickEnabled ? 1 : 0;
    }

    @Override
    public void openBasicProgram() {
        String string = SourceUtil.getBasicProgram(this.emuThread, 24823, scchTokens);
        if (string != null) {
            this.screenFrm.openText(string);
        } else {
            this.showNoBasic();
        }
    }

    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n2 = 0;
        switch (n) {
            case 37: {
                n2 = 8;
                break;
            }
            case 39: {
                n2 = 9;
                break;
            }
            case 40: {
                n2 = 10;
                break;
            }
            case 38: {
                n2 = 11;
                break;
            }
            case 10: {
                n2 = 13;
                break;
            }
            case 32: {
                n2 = 32;
                break;
            }
            case 8: {
                n2 = 127;
                break;
            }
            case 127: {
                n2 = 4;
                break;
            }
            case 155: {
                n2 = 5;
                break;
            }
            case 33: {
                n2 = 17;
                break;
            }
            case 34: {
                n2 = 21;
                break;
            }
            case 36: {
                n2 = 1;
                break;
            }
            case 35: {
                n2 = 26;
            }
        }
        if (n2 > 0) {
            this.setKeyboardValue(n2 | 0x80);
            bl3 = true;
        }
        return bl3;
    }

    @Override
    public void keyReleased() {
        this.setKeyboardValue(0);
    }

    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        if (c > '\u0000' && c < '\u007f') {
            this.setKeyboardValue(c | 0x80);
            bl = true;
        }
        return bl;
    }

    @Override
    public int reassembleSysCall(Z80MemView z80MemView, int n, StringBuilder stringBuilder, boolean bl, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = stringBuilder.length();
        int n7 = z80MemView.getMemByte(n, true);
        int n8 = 0;
        String string = null;
        block0 : switch (n7) {
            case 207: {
                if (!bl) {
                    stringBuilder.append(String.format("%04X  %02X", n, n7));
                }
                AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n2);
                stringBuilder.append("RST");
                AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n3);
                stringBuilder.append("08H");
                AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n4);
                stringBuilder.append(";INCH\n");
                n5 = 1;
                break;
            }
            case 215: {
                if (!bl) {
                    stringBuilder.append(String.format("%04X  %02X", n, n7));
                }
                AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n2);
                stringBuilder.append("RST");
                AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n3);
                stringBuilder.append("10H");
                AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n4);
                stringBuilder.append(";OUTCH\n");
                n5 = 1;
                break;
            }
            case 223: {
                if (!bl) {
                    stringBuilder.append(String.format("%04X  %02X", n, n7));
                }
                AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n2);
                stringBuilder.append("RST");
                AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n3);
                stringBuilder.append("18H");
                AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n4);
                stringBuilder.append(";OUTS\n");
                n5 = 1 + AbstractSCCHSys.reassStringBit7(this.emuThread, n + 1, stringBuilder, bl, n2, n3);
                break;
            }
            case 195: {
                n8 = z80MemView.getMemWord(n + 1);
                string = null;
                switch (n8) {
                    case 8: 
                    case 6146: {
                        string = "INCH";
                        break;
                    }
                    case 16: 
                    case 6149: {
                        string = "OUTCH";
                        break;
                    }
                    case 24: 
                    case 6152: {
                        string = "OUTS";
                    }
                }
                if (string == null) break;
                if (!bl) {
                    stringBuilder.append(String.format("%04X  %02X %02X %02X", n, n7, n8 >> 8, n8 & 0xFF));
                }
                AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n2);
                stringBuilder.append("JP");
                AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n3);
                stringBuilder.append(String.format("%04XH", n8));
                AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n4);
                stringBuilder.append(';');
                stringBuilder.append(string);
                stringBuilder.append('\n');
                n5 = 3;
                break;
            }
            case 205: {
                n8 = z80MemView.getMemWord(n + 1);
                switch (n8) {
                    case 8: 
                    case 6146: {
                        if (!bl) {
                            stringBuilder.append(String.format("%04X  %02X %02X %02X", n, n7, n8 >> 8, n8 & 0xFF));
                        }
                        AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n2);
                        stringBuilder.append("CALL");
                        AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n3);
                        stringBuilder.append(String.format("%04XH", n8));
                        AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n4);
                        stringBuilder.append(";INCH\n");
                        n5 = 3;
                        break block0;
                    }
                    case 16: 
                    case 6149: {
                        if (!bl) {
                            stringBuilder.append(String.format("%04X  %02X %02X %02X", n, n7, n8 >> 8, n8 & 0xFF));
                        }
                        AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n2);
                        stringBuilder.append("CALL");
                        AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n3);
                        stringBuilder.append(String.format("%04XH", n8));
                        AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n4);
                        stringBuilder.append(";OUTCH\n");
                        n5 = 3;
                        break block0;
                    }
                    case 24: 
                    case 6152: {
                        if (!bl) {
                            stringBuilder.append(String.format("%04X  %02X %02X %02X", n, n7, n8 >> 8, n8 & 0xFF));
                        }
                        AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n2);
                        stringBuilder.append("CALL");
                        AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n3);
                        stringBuilder.append(String.format("%04XH", n8));
                        AbstractSCCHSys.appendSpacesToCol(stringBuilder, n6, n4);
                        stringBuilder.append(";OUTS\n");
                        n5 = 3 + AbstractSCCHSys.reassStringBit7(this.emuThread, n + 3, stringBuilder, bl, n2, n3);
                    }
                }
            }
        }
        return n5;
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        this.joystickSelected = false;
        this.joystickValue = 0;
        this.keyboardValue = 0;
        this.rf32KActive = false;
        this.rf32NegA15 = false;
        this.rfReadEnabled = false;
        this.rfWriteEnabled = false;
        this.rfAddr16to19 = 0;
        this.scchBasicRomEnabled = false;
        this.scchPrgXRomEnabled = false;
        this.scchRomdiskEnabled = false;
        this.scchRomdiskBankAddr = 0;
        this.v24BitOut = true;
        this.v24BitNum = 0;
        this.v24ShiftBuf = 0;
        this.v24TStateCounter = 0;
    }

    @Override
    public synchronized void startPastingText(String string) {
        boolean bl;
        block10: {
            bl = false;
            if (string != null && !string.isEmpty()) {
                if (this.pasteFast) {
                    this.cancelPastingText();
                    StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
                    char c = stringCharacterIterator.first();
                    if (c != '\uffff') {
                        if (c == '\n') {
                            c = '\r';
                        }
                        try {
                            this.keyReleased();
                            Thread.sleep(100L);
                            if (this.keyTyped(c)) {
                                long l;
                                long l2 = l = c == '\r' ? this.getDelayMillisAfterPasteEnter() : this.getDelayMillisAfterPasteChar();
                                if (l > 0L) {
                                    Thread.sleep(l);
                                }
                                this.pasteIter = stringCharacterIterator;
                                bl = true;
                                break block10;
                            }
                            this.fireShowCharNotPasted(stringCharacterIterator);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    super.startPastingText(string);
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.screenFrm.firePastingTextFinished();
        }
    }

    @Override
    public boolean supportsOpenBasic() {
        return true;
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return true;
    }

    private int getScchBasicRomBegAddr(Properties properties) {
        String string;
        int n = 16384;
        if (properties != null && !EmuUtil.getProperty(properties, this.propPrefix + PROP_SCCH_BASIC_FILE).isEmpty() && (string = EmuUtil.getProperty(properties, this.propPrefix + PROP_SCCH_PREFIX + PROP_BASIC_ADDR)) != null && string.trim().startsWith("2000")) {
            n = 8192;
        }
        return n;
    }

    private int getScchRomdiskBegAddr(Properties properties) {
        String string;
        int n = 49152;
        if (properties != null && (string = EmuUtil.getProperty(properties, this.propPrefix + PROP_SCCH_PREFIX + PROP_ROMDISK_ADDR)) != null && string.trim().startsWith("8000")) {
            n = 32768;
        }
        return n;
    }
}

