/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.CRC32;
import jkcemu.audio.AudioIn;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.zxspectrum.ZXSpectrum128KeyboardFld;
import jkcemu.emusys.zxspectrum.ZXSpectrum48KeyboardFld;
import jkcemu.etc.PSG8910;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80InterruptSource;

public class ZXSpectrum
extends EmuSys
implements PSG8910.Callback,
Z80InterruptSource {
    public static final String SYSNAME = "ZXSpectrum";
    public static final String SYSTEXT = "ZX Spectrum";
    public static final String PROP_PREFIX = "jkcemu.zxspectrum.";
    public static final String VALUE_128K = "128k";
    private static final int SCREEN_WIDTH = 256;
    private static final int SCREEN_HEIGHT = 192;
    private static final int DEFAULT_48K_KHZ = 3500;
    private static final int DEFAULT_128K_KHZ = 3547;
    private static final int MIN_TAPE_IN_1TO0_DELAY = 180;
    private static final int MAX_TAPE_IN_1TO0_DELAY = 2000;
    private static final int[][] kbMatrixNormal = new int[][]{{-1, 122, 120, 99, 118}, {97, 115, 100, 102, 103}, {113, 119, 101, 114, 116}, {49, 50, 51, 52, 53}, {48, 57, 56, 55, 54}, {112, 111, 105, 117, 121}, {13, 108, 107, 106, 104}, {32, -1, 109, 110, 98}};
    private static final int[][] kbMatrixSymbolShift = new int[][]{{-1, 58, 163, 63, 47}, {126, 124, 92, 123, 125}, {-1, -1, -1, 60, 62}, {33, 64, 35, 36, 37}, {95, 41, 40, 39, 38}, {34, 59, -1, 93, 91}, {13, 61, 43, 45, 94}, {32, -1, 46, 44, 42}};
    private static final int[][] kbMatrixControl = new int[][]{{-1, 90, 88, 67, 86}, {65, 83, 68, 70, 71}, {81, 87, 69, 82, 84}, {49, 50, 51, 52, 53}, {48, 57, 56, 55, 54}, {80, 79, 73, 85, 89}, {10, 76, 75, 74, 72}, {32, -1, 77, 78, 66}};
    private static byte[] os48k = null;
    private static byte[] os128k = null;
    private static Map<Long, Character> pixelCRC32ToChar = null;
    private Color[] colors = new Color[16];
    private String osFile = null;
    private volatile float fTStatesPerLine;
    private volatile int tStatesPerLine;
    private boolean mode128k;
    private boolean cfgRegProtected = false;
    private boolean interruptRequested;
    private boolean earPhase;
    private boolean blinkState;
    private int blinkLineCounter;
    private int tapeOutBits;
    private int tapeInLDelayTStateCounter;
    private int joyActionMask;
    private int linesPerScreen;
    private int firstScreenLine;
    private int lastScreenLine;
    private int curScreenLine;
    private int screenTStateCounter;
    private int lineTStateCounter;
    private int borderColorNum;
    private int romOffs = 0;
    private int ramC000Offs = 0;
    private volatile int screenOffs;
    private int psgRegNum = 0;
    private int[] kbMatrix = new int[8];
    private byte[] osBytes = null;
    private byte[] borderColorNums;
    private byte[] screenColorNums;
    private byte[] ram = null;
    private PSG8910 psg = null;
    private AbstractKeyboardFld keyboardFld = null;

    public ZXSpectrum(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        this.mode128k = ZXSpectrum.emulates128K(properties);
        if (this.mode128k) {
            this.screenOffs = 81920;
            this.linesPerScreen = 311;
            this.firstScreenLine = 63;
            this.ram = this.emuThread.getExtendedRAM(131072);
            this.psg = new PSG8910(1773500, 220, this);
        } else {
            this.screenOffs = 16384;
            this.linesPerScreen = 312;
            this.firstScreenLine = 64;
        }
        this.lastScreenLine = this.firstScreenLine + 192;
        this.borderColorNums = new byte[this.linesPerScreen];
        this.screenColorNums = new byte[49152];
        Z80CPU z80CPU = emuThread.getZ80CPU();
        z80CPU.setInterruptSources(this);
        z80CPU.addTStatesListener(this);
        z80CPU.addMaxSpeedListener(this);
        this.applySettings(properties);
        this.z80MaxSpeedChanged(z80CPU);
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
        if (this.psg != null) {
            this.psg.start();
        }
    }

    public static int getDefaultSpeedKHz(Properties properties) {
        return ZXSpectrum.emulates128K(properties) ? 3547 : 3500;
    }

    public boolean isMode128K() {
        return this.mode128k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeyboardMatrix(int[] nArray) {
        int[] nArray2 = this.kbMatrix;
        synchronized (this.kbMatrix) {
            int n;
            int n2 = Math.min(nArray.length, this.kbMatrix.length);
            for (n = 0; n < n2; ++n) {
                this.kbMatrix[n] = nArray[n];
            }
            while (n < this.kbMatrix.length) {
                this.kbMatrix[n] = 0;
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public int psgReadPort(PSG8910 pSG8910, int n) {
        return 255;
    }

    @Override
    public void psgWritePort(PSG8910 pSG8910, int n, int n2) {
    }

    @Override
    public void psgWriteFrame(PSG8910 pSG8910, int n, int n2, int n3) {
        int n4 = (n + n2 + n3) / 6;
        this.emuThread.writeSoundOutFrames(1, n4, n4, n4);
    }

    @Override
    public void appendInterruptStatusHTMLTo(StringBuilder stringBuilder) {
        stringBuilder.append("<table border=\"1\">\n<tr><td>Interrupt angemeldet:</td><td>");
        stringBuilder.append(this.interruptRequested ? "ja" : "nein");
        stringBuilder.append("</td></tr>\n</table>\n");
    }

    @Override
    public int interruptAccept() {
        this.interruptRequested = false;
        return 255;
    }

    @Override
    public void interruptFinish() {
    }

    @Override
    public boolean isInterruptAccepted() {
        return false;
    }

    @Override
    public boolean isInterruptRequested() {
        return this.interruptRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(boolean bl) {
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            Arrays.fill(this.kbMatrix, 0);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Arrays.fill(this.borderColorNums, (byte)0);
            Arrays.fill(this.screenColorNums, (byte)0);
            this.earPhase = true;
            this.cfgRegProtected = false;
            this.interruptRequested = false;
            this.blinkState = false;
            this.blinkLineCounter = 0;
            this.tapeOutBits = 0;
            this.tapeInLDelayTStateCounter = 0;
            this.joyActionMask = 0;
            this.screenTStateCounter = 0;
            this.lineTStateCounter = 0;
            this.curScreenLine = 0;
            this.borderColorNum = 0;
            this.ramC000Offs = 0;
            this.romOffs = 0;
            this.screenOffs = (this.mode128k ? 5 : 1) * 16384;
            this.psgRegNum = 0;
            if (this.psg != null) {
                this.psg.reset();
            }
            return;
        }
    }

    @Override
    public void appendStatusHTMLTo(StringBuilder stringBuilder, Z80CPU z80CPU) {
        stringBuilder.append("<h1>ZX Spectrum Status</h1>\n<table border=\"1\">\n<tr><td>Aktuelle Pixelzeile:</td><td>");
        stringBuilder.append(this.curScreenLine);
        stringBuilder.append("</td></tr>\n</table>\n");
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        this.createColors(properties);
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
        if (bl && ZXSpectrum.emulates128K(properties) != this.mode128k) {
            bl = false;
        }
        if (bl && !TextUtil.equals(this.osFile, EmuUtil.getProperty(properties, this.propPrefix + "rom." + "file"))) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean canExtractScreenText() {
        return true;
    }

    @Override
    public AbstractKeyboardFld createKeyboardFld() {
        this.keyboardFld = this.mode128k ? new ZXSpectrum128KeyboardFld(this) : new ZXSpectrum48KeyboardFld(this);
        return this.keyboardFld;
    }

    @Override
    public void die() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.setInterruptSources(null);
        if (this.psg != null) {
            this.psg.die();
        }
    }

    @Override
    public int getBorderColorIndex() {
        return this.borderColorNum;
    }

    @Override
    public int getBorderColorIndexByLine(int n) {
        if ((n += this.firstScreenLine) < 0 || n >= this.borderColorNums.length) {
            n = Math.abs(n) % this.borderColorNums.length;
        }
        return this.borderColorNums[n];
    }

    @Override
    public Color getColor(int n) {
        Color color = null;
        if (this.colors != null && n >= 0 && n < this.colors.length) {
            color = this.colors[n];
        }
        return color != null ? color : super.getColor(n);
    }

    @Override
    public int getColorCount() {
        return this.colors.length;
    }

    @Override
    public int getColorIndex(int n, int n2) {
        int n3 = 0;
        if (n >= 0) {
            if (n < 256 && n2 >= 0 && n2 < 192) {
                n3 = this.screenColorNums[n2 * 256 + n] & 0xF;
            }
        }
        return n3;
    }

    @Override
    public boolean getConvertKeyCharToISO646DE() {
        return false;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        return new CharRaster(32, 24, 8, 8, 8, 0);
    }

    @Override
    public String getHelpPage() {
        return "/help/zxspectrum.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2 = 255;
        if ((n &= 0xFFFF) < 16384) {
            int n3;
            if (this.osBytes != null && (n3 = n + this.romOffs) < this.osBytes.length) {
                n2 = this.osBytes[n3] & 0xFF;
            }
        } else if (this.ram != null) {
            int n4 = n;
            if (n >= 16384 && n < 32768) {
                n4 += 65536;
            } else if (n >= 49152) {
                n4 = n - 49152 + this.ramC000Offs;
            }
            if (n4 < this.ram.length) {
                n2 = this.ram[n4] & 0xFF;
            }
        } else {
            n2 = this.emuThread.getRAMByte(n);
        }
        return n2;
    }

    @Override
    public int getResetStartAddress(EmuThread.ResetLevel resetLevel) {
        return 0;
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        Map<Long, Character> map;
        int n3 = -1;
        if (n >= 0 && n < 32 && n2 >= 0 && n2 < 24 && (map = this.getPixelCRC32ToCharMap()) != null) {
            CRC32 cRC32 = new CRC32();
            CRC32 cRC322 = new CRC32();
            int n4 = 0x4000 | n2 << 8 & 0x1800 | n2 << 5 & 0xE0 | n & 0x1F;
            for (int i = 0; i < 8; ++i) {
                int n5 = this.getMemByte(n4, false);
                cRC32.update(n5);
                cRC322.update(~n5 & 0xFF);
                n4 += 256;
            }
            Character c = map.get(cRC32.getValue());
            if (c == null) {
                c = map.get(cRC322.getValue());
            }
            if (c != null) {
                n3 = c.charValue();
            }
        }
        return n3;
    }

    @Override
    public int getScreenHeight() {
        return 192;
    }

    @Override
    public int getScreenWidth() {
        return 256;
    }

    @Override
    public int getSupportedJoystickCount() {
        return 1;
    }

    @Override
    public String getTitle() {
        return SYSTEXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            if (bl) {
                if (bl2) {
                    this.kbMatrix[0] = this.kbMatrix[0] | 1;
                    this.kbMatrix[7] = this.kbMatrix[7] | 2;
                    bl3 = true;
                } else if (this.setValueInKBMatrix(kbMatrixControl, n)) {
                    this.kbMatrix[7] = this.kbMatrix[7] | 2;
                    bl3 = true;
                }
            } else {
                switch (n) {
                    case 112: {
                        this.kbMatrix[0] = this.kbMatrix[0] | 1;
                        this.kbMatrix[3] = this.kbMatrix[3] | 1;
                        bl3 = true;
                        break;
                    }
                    case 113: {
                        this.kbMatrix[0] = this.kbMatrix[0] | 1;
                        this.kbMatrix[3] = this.kbMatrix[3] | 2;
                        bl3 = true;
                        break;
                    }
                    case 114: {
                        this.kbMatrix[0] = this.kbMatrix[0] | 1;
                        this.kbMatrix[3] = this.kbMatrix[3] | 4;
                        bl3 = true;
                        break;
                    }
                    case 115: {
                        this.kbMatrix[0] = this.kbMatrix[0] | 1;
                        this.kbMatrix[3] = this.kbMatrix[3] | 8;
                        bl3 = true;
                        break;
                    }
                    case 116: {
                        this.kbMatrix[0] = this.kbMatrix[0] | 1;
                        bl3 = true;
                        break;
                    }
                    case 117: {
                        this.kbMatrix[7] = this.kbMatrix[7] | 2;
                        bl3 = true;
                        break;
                    }
                    case 120: {
                        this.kbMatrix[0] = this.kbMatrix[0] | 1;
                        this.kbMatrix[4] = this.kbMatrix[4] | 2;
                        bl3 = true;
                        break;
                    }
                    case 8: 
                    case 127: {
                        this.kbMatrix[0] = this.kbMatrix[0] | 1;
                        this.kbMatrix[4] = this.kbMatrix[4] | 1;
                        bl3 = true;
                        break;
                    }
                    case 37: {
                        this.kbMatrix[0] = this.kbMatrix[0] | 1;
                        this.kbMatrix[3] = this.kbMatrix[3] | 0x10;
                        bl3 = true;
                        break;
                    }
                    case 40: {
                        this.kbMatrix[0] = this.kbMatrix[0] | 1;
                        this.kbMatrix[4] = this.kbMatrix[4] | 0x10;
                        bl3 = true;
                        break;
                    }
                    case 38: {
                        this.kbMatrix[0] = this.kbMatrix[0] | 1;
                        this.kbMatrix[4] = this.kbMatrix[4] | 8;
                        bl3 = true;
                        break;
                    }
                    case 39: {
                        this.kbMatrix[0] = this.kbMatrix[0] | 1;
                        this.kbMatrix[4] = this.kbMatrix[4] | 4;
                        bl3 = true;
                        break;
                    }
                    case 10: {
                        if (bl2) {
                            this.kbMatrix[0] = this.kbMatrix[0] | 1;
                        }
                        this.kbMatrix[6] = this.kbMatrix[6] | 1;
                        bl3 = true;
                        break;
                    }
                    case 32: {
                        if (bl2) {
                            this.kbMatrix[0] = this.kbMatrix[0] | 1;
                        }
                        this.kbMatrix[7] = this.kbMatrix[7] | 1;
                        bl3 = true;
                    }
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (bl3) {
                this.updKeyboardFld();
            }
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased() {
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            Arrays.fill(this.kbMatrix, 0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.updKeyboardFld();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            bl = this.setValueInKBMatrix(kbMatrixNormal, c);
            if (!bl && c >= 'A' && c <= 'Z' && (bl = this.setValueInKBMatrix(kbMatrixNormal, Character.toLowerCase(c)))) {
                this.kbMatrix[0] = this.kbMatrix[0] | 1;
            }
            if (!bl && (bl = this.setValueInKBMatrix(kbMatrixSymbolShift, c))) {
                this.kbMatrix[7] = this.kbMatrix[7] | 2;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (bl) {
                this.updKeyboardFld();
            }
            return bl;
        }
    }

    @Override
    protected boolean pasteChar(char c) throws InterruptedException {
        if (c == '\u00a3') {
            c = (char)96;
        } else if (c == '\u00a9') {
            c = (char)127;
        }
        return super.pasteChar(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        if ((n & 1) == 0) {
            this.checkInsertWaitStates(n & 0x3FFF | 0x4000, 4);
            int[] nArray = this.kbMatrix;
            synchronized (this.kbMatrix) {
                int n4 = ~n;
                int n5 = 256;
                for (int i = 0; i < this.kbMatrix.length; ++i) {
                    if ((n4 & n5) != 0) {
                        n3 &= ~this.kbMatrix[i];
                    }
                    n5 <<= 1;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                boolean bl = false;
                AudioIn audioIn = this.emuThread.getTapeIn();
                if (audioIn != null && !audioIn.isPause()) {
                    bl = true;
                    if (!audioIn.readPhase()) {
                        n3 &= 0xFFFFFFBF;
                    }
                }
                if (!bl && !this.earPhase && this.tapeInLDelayTStateCounter <= 0) {
                    n3 &= 0xFFFFFFBF;
                }
            }
        } else {
            if ((n & 0xFF) == 31) {
                n3 = 0;
                if ((this.joyActionMask & 2) != 0) {
                    n3 |= 1;
                }
                if ((this.joyActionMask & 1) != 0) {
                    n3 |= 2;
                }
                if ((this.joyActionMask & 8) != 0) {
                    n3 |= 4;
                }
                if ((this.joyActionMask & 4) != 0) {
                    n3 |= 8;
                }
                if ((this.joyActionMask & 0x30) != 0) {
                    n3 |= 0x10;
                }
            }
            if (this.mode128k) {
                if ((n & 0x8002) == 0) {
                    this.writeCfgReg(255);
                } else if ((n & 0xC002) == 49152 && this.psg != null) {
                    n3 = this.psg.getRegister(this.psgRegNum);
                }
            }
            this.checkInsertWaitStates(n, 4);
        }
        return n3;
    }

    @Override
    public int readMemByte(int n, boolean bl) {
        this.checkInsertWaitStates(n, bl ? 0 : 4);
        return this.getMemByte(n, true);
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON && this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
    }

    @Override
    public void setJoystickAction(int n, int n2) {
        if (n == 0) {
            this.joyActionMask = n2;
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        boolean bl = false;
        if ((n &= 0xFFFF) >= 16384) {
            if (this.ram != null) {
                int n3 = n;
                if (n >= 16384 && n < 32768) {
                    n3 += 65536;
                } else if (n >= 49152) {
                    n3 = n3 - 49152 + this.ramC000Offs;
                }
                if (n3 < this.ram.length) {
                    this.ram[n3] = (byte)n2;
                }
            } else {
                this.emuThread.setRAMByte(n, n2);
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public void soundOutFrameRateChanged(int n) {
        if (this.psg != null) {
            this.psg.setFrameRate(n);
        } else {
            super.soundOutFrameRateChanged(n);
        }
    }

    @Override
    public boolean supportsBorderColorByLine() {
        return true;
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsKeyboardFld() {
        return true;
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return true;
    }

    @Override
    public boolean supportsTapeIn() {
        return true;
    }

    @Override
    public boolean supportsTapeOut() {
        return true;
    }

    @Override
    public boolean supportsSoundOut8Bit() {
        return this.psg != null;
    }

    @Override
    public boolean supportsSoundOutMono() {
        return true;
    }

    public String toString() {
        return "ULA (Bildschirmsteuerung)";
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        if ((n & 1) == 0) {
            boolean bl;
            this.checkInsertWaitStates(n & 0x3FFF | 0x4000, 4);
            this.borderColorNum = n2 & 7;
            int n4 = n2 & 0x18;
            boolean bl2 = bl = (n2 & 0x10) != 0;
            if (this.psg == null) {
                this.soundOutPhase = bl;
            }
            if (n4 != this.tapeOutBits) {
                this.tapeOutPhase = !this.tapeOutPhase;
            }
            this.tapeOutBits = n4;
            if (bl != this.earPhase) {
                if (bl) {
                    this.tapeInLDelayTStateCounter = 0;
                } else if (this.tapeInLDelayTStateCounter < 180) {
                    this.tapeInLDelayTStateCounter = 180;
                }
                this.earPhase = bl;
            }
        } else {
            if (this.mode128k) {
                if ((n & 0x8002) == 0) {
                    this.writeCfgReg(n2);
                } else if ((n & 0xC002) == 32768) {
                    if (this.psg != null) {
                        this.psg.setRegister(this.psgRegNum, n2);
                    }
                } else if ((n & 0xC002) == 49152) {
                    this.psgRegNum = n2 & 0xF;
                }
            }
            this.checkInsertWaitStates(n, 4);
        }
    }

    @Override
    public void writeMemByte(int n, int n2) {
        this.checkInsertWaitStates(n, 4);
        this.setMemByte(n, n2);
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        this.tStatesPerLine = this.mode128k ? (int)Math.round((double)z80CPU.getMaxSpeedKHz() / 15.557) : (int)Math.round((double)z80CPU.getMaxSpeedKHz() / 15.625);
        this.fTStatesPerLine = this.tStatesPerLine;
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        this.lineTStateCounter += n;
        if (this.lineTStateCounter >= this.tStatesPerLine) {
            this.lineTStateCounter -= this.tStatesPerLine;
            this.updScreenLine();
            ++this.curScreenLine;
            if (this.curScreenLine >= this.linesPerScreen) {
                this.curScreenLine = 0;
                this.interruptRequested = true;
                ++this.blinkLineCounter;
                if (this.blinkLineCounter >= 16) {
                    this.blinkLineCounter = 0;
                    boolean bl = this.blinkState = !this.blinkState;
                }
            }
        }
        if (this.earPhase) {
            if (this.tapeInLDelayTStateCounter < 2000) {
                this.tapeInLDelayTStateCounter += n / 2;
            }
        } else if (this.tapeInLDelayTStateCounter > 0) {
            this.tapeInLDelayTStateCounter -= n;
        }
    }

    private void checkInsertWaitStates(int n, int n2) {
        if (((n &= 0xFFFF) >= 16384 && n < 32768 || this.mode128k && n >= 49152 && (this.ramC000Offs & 0x4000) != 0) && this.curScreenLine >= this.firstScreenLine && this.curScreenLine <= this.lastScreenLine) {
            int n3;
            int n4 = Math.round((float)(this.lineTStateCounter + n2) / this.fTStatesPerLine * 224.0f);
            if ((n4 -= 63) >= 0 && n4 < 128 && (n3 = 6 - n4 % 8) > 0) {
                this.emuThread.getZ80CPU().addWaitStates(n3);
            }
        }
    }

    private void createColors(Properties properties) {
        float f = ZXSpectrum.getBrightness(properties);
        if (f >= 0.0f && f <= 1.0f) {
            for (int i = 0; i < this.colors.length; ++i) {
                int n = Math.round(f * (float)((i & 8) != 0 ? 255 : 192));
                int n2 = (i & 2) != 0 ? n : 0;
                int n3 = (i & 4) != 0 ? n : 0;
                int n4 = (i & 1) != 0 ? n : 0;
                this.colors[i] = new Color(n2, n3, n4);
            }
        }
    }

    private static boolean emulates128K(Properties properties) {
        return EmuUtil.getProperty(properties, "jkcemu.zxspectrum.model").equals(VALUE_128K);
    }

    private Map<Long, Character> getPixelCRC32ToCharMap() {
        byte[] byArray;
        if (pixelCRC32ToChar == null && (byArray = this.getOS48kBytes()) != null && byArray.length >= 16384) {
            HashMap<Long, Character> hashMap = new HashMap<Long, Character>();
            CRC32 cRC32 = new CRC32();
            int n = 15616;
            for (int i = 32; i <= 127; ++i) {
                cRC32.reset();
                cRC32.update(byArray, n, 8);
                char c = (char)i;
                if (i == 96) {
                    c = '\u00a3';
                } else if (i == 127) {
                    c = '\u00a9';
                }
                hashMap.put(cRC32.getValue(), Character.valueOf(c));
                n += 8;
            }
            pixelCRC32ToChar = hashMap;
        }
        return pixelCRC32ToChar;
    }

    private byte[] getOS48kBytes() {
        if (os48k == null) {
            os48k = this.readResource("/rom/zxspectrum/os48k.bin");
        }
        return os48k;
    }

    private byte[] getOS128kBytes() {
        if (os128k == null) {
            os128k = this.readResource("/rom/zxspectrum/os128k.bin");
        }
        return os128k;
    }

    private void loadROMs(Properties properties) {
        this.osFile = EmuUtil.getProperty(properties, this.propPrefix + "rom." + "file");
        this.osBytes = this.readROMFile(this.osFile, this.mode128k ? 32768 : 16384, "ROM");
        if (this.osBytes == null) {
            this.osBytes = this.mode128k ? this.getOS128kBytes() : this.getOS48kBytes();
        }
    }

    private boolean setValueInKBMatrix(int[][] nArray, int n) {
        boolean bl = false;
        int n2 = Math.min(nArray.length, this.kbMatrix.length);
        for (int i = 0; i < n2; ++i) {
            int n3 = 1;
            int[] nArray2 = nArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray2[j] == n) {
                    int n4 = i;
                    this.kbMatrix[n4] = this.kbMatrix[n4] | n3;
                    bl = true;
                }
                n3 <<= 1;
            }
        }
        return bl;
    }

    private void updKeyboardFld() {
        if (this.keyboardFld != null) {
            this.keyboardFld.updKeySelection(this.kbMatrix);
        }
    }

    private void updScreenLine() {
        int n = this.curScreenLine;
        int n2 = n - this.firstScreenLine;
        if (n2 >= 0 && n2 < 192) {
            int n3 = n2 * 256;
            int n4 = n2 / 8;
            int n5 = this.screenOffs + 6144 + n4 * 32;
            int n6 = this.screenOffs | n2 << 5 & 0x1800 | n2 << 2 & 0xE0 | n2 << 8 & 0x700;
            for (int i = 0; i < 32; ++i) {
                int n7 = 0;
                int n8 = 0;
                if (this.ram != null) {
                    if (n5 < this.ram.length) {
                        n7 = this.ram[n5++] & 0xFF;
                    }
                    if (n6 < this.ram.length) {
                        n8 = this.ram[n6++] & 0xFF;
                    }
                } else {
                    n7 = this.getMemByte(n5++, false);
                    n8 = this.getMemByte(n6++, false);
                }
                boolean bl = (n7 & 0x80) != 0;
                boolean bl2 = (n7 & 0x40) != 0;
                for (int j = 0; j < 8; ++j) {
                    boolean bl3;
                    boolean bl4 = bl3 = bl && this.blinkState;
                    if ((n8 & 0x80) != 0) {
                        bl3 = !bl3;
                    }
                    int n9 = 0;
                    if (bl3) {
                        n9 = n7 & 7;
                        if (bl2) {
                            n9 |= 8;
                        }
                    } else {
                        n9 = n7 >> 3 & 7;
                    }
                    this.screenColorNums[n3++] = (byte)n9;
                    this.screenFrm.setScreenDirty(true);
                    n8 <<= 1;
                }
            }
        }
        if (n >= 0 && n < this.borderColorNums.length) {
            this.borderColorNums[n] = (byte)this.borderColorNum;
        }
    }

    private void writeCfgReg(int n) {
        if (this.mode128k && !this.cfgRegProtected) {
            this.ramC000Offs = 16384 * (n & 7);
            this.screenOffs = ((n & 8) != 0 ? 7 : 5) * 16384;
            this.romOffs = (n & 0x10) != 0 ? 16384 : 0;
            this.cfgRegProtected = (n & 0x20) != 0;
        }
    }
}

