/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.etc.SLC1KeyboardFld;
import z80emu.Z80CPU;
import z80emu.Z80PCListener;

public class SLC1
extends EmuSys
implements Z80PCListener {
    public static final String SYSNAME = "SLC1";
    public static final String PROP_PREFIX = "jkcemu.slc1.";
    private static byte[] rom = null;
    private SLC1KeyboardFld keyboardFld;
    private int[] keyboardMatrix;
    private int[] digitStatus;
    private int[] digitValues;
    private byte[] ram;
    private int displayTStates;
    private int curKeyCol;
    private int curSegValue;
    private long curDisplayTStates;
    private int ledStatus;
    private boolean ledValue;
    private boolean chessMode;

    public SLC1(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        if (rom == null) {
            rom = this.readResource("/rom/slc1/slc1_0000.bin");
        }
        this.keyboardFld = null;
        this.keyboardMatrix = new int[3];
        this.digitStatus = new int[6];
        this.digitValues = new int[6];
        this.ram = new byte[1024];
        this.ledStatus = 0;
        this.ledValue = false;
        this.chessMode = true;
        Z80CPU z80CPU = emuThread.getZ80CPU();
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addPCListener(this, 0, 1557);
        z80CPU.addTStatesListener(this);
        this.z80MaxSpeedChanged(z80CPU);
    }

    public static int getDefaultSpeedKHz() {
        return 2500;
    }

    public boolean isChessMode() {
        return this.chessMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeyboardMatrix(int[] nArray) {
        int[] nArray2 = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            int n;
            int n2 = Math.min(nArray.length, this.keyboardMatrix.length);
            for (n = 0; n < n2; ++n) {
                this.keyboardMatrix[n] = nArray[n];
            }
            while (n < this.keyboardMatrix.length) {
                this.keyboardMatrix[n] = 0;
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void z80PCChanged(Z80CPU z80CPU, int n) {
        switch (n) {
            case 0: {
                this.setChessMode(true);
                break;
            }
            case 1557: {
                this.setChessMode(false);
            }
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        return EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
    }

    @Override
    public AbstractKeyboardFld createKeyboardFld() {
        this.keyboardFld = new SLC1KeyboardFld(this);
        return this.keyboardFld;
    }

    @Override
    public void die() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removePCListener(this);
        z80CPU.removeMaxSpeedListener(this);
        super.die();
    }

    @Override
    public EmuSys.Chessman getChessman(int n, int n2) {
        EmuSys.Chessman chessman = null;
        if (this.chessMode && n >= 0 && n < 8 && n2 >= 0 && n2 < 8) {
            switch (this.getMemByte(20480 + n * 16 + n2, false)) {
                case 1: {
                    chessman = EmuSys.Chessman.WHITE_PAWN;
                    break;
                }
                case 2: {
                    chessman = EmuSys.Chessman.WHITE_KNIGHT;
                    break;
                }
                case 3: {
                    chessman = EmuSys.Chessman.WHITE_BISHOP;
                    break;
                }
                case 4: {
                    chessman = EmuSys.Chessman.WHITE_ROOK;
                    break;
                }
                case 5: {
                    chessman = EmuSys.Chessman.WHITE_QUEEN;
                    break;
                }
                case 6: {
                    chessman = EmuSys.Chessman.WHITE_KING;
                    break;
                }
                case 255: {
                    chessman = EmuSys.Chessman.BLACK_PAWN;
                    break;
                }
                case 254: {
                    chessman = EmuSys.Chessman.BLACK_KNIGHT;
                    break;
                }
                case 253: {
                    chessman = EmuSys.Chessman.BLACK_BISHOP;
                    break;
                }
                case 252: {
                    chessman = EmuSys.Chessman.BLACK_ROOK;
                    break;
                }
                case 251: {
                    chessman = EmuSys.Chessman.BLACK_QUEEN;
                    break;
                }
                case 250: {
                    chessman = EmuSys.Chessman.BLACK_KING;
                }
            }
        }
        return chessman;
    }

    @Override
    public Color getColor(int n) {
        Color color = Color.black;
        switch (n) {
            case 1: {
                color = this.colorGreenDark;
                break;
            }
            case 2: {
                color = this.colorGreenLight;
            }
        }
        return color;
    }

    @Override
    public int getColorCount() {
        return 3;
    }

    @Override
    public String getHelpPage() {
        return "/help/slc1.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2 = 255;
        if ((n & 0x4000) != 0) {
            int n3 = n & 0x3FF;
            if (n3 < this.ram.length) {
                n2 = this.ram[n3] & 0xFF;
            }
        } else if ((n &= 0xFFF) < rom.length) {
            n2 = rom[n] & 0xFF;
        }
        return n2;
    }

    @Override
    public int getScreenHeight() {
        return 110;
    }

    @Override
    public int getScreenWidth() {
        return 70 + this.digitValues.length * 50;
    }

    @Override
    public String getTitle() {
        return SYSNAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            if (this.chessMode) {
                switch (n) {
                    case 27: {
                        this.keyboardMatrix[2] = 16;
                        bl3 = true;
                        break;
                    }
                    case 10: {
                        this.keyboardMatrix[2] = 128;
                        bl3 = true;
                        break;
                    }
                    case 112: {
                        this.keyboardMatrix[2] = 32;
                        bl3 = true;
                        break;
                    }
                    case 113: {
                        this.keyboardMatrix[2] = 64;
                        bl3 = true;
                    }
                }
            } else {
                switch (n) {
                    case 112: {
                        this.keyboardMatrix[2] = 128;
                        bl3 = true;
                        break;
                    }
                    case 113: {
                        this.keyboardMatrix[2] = 64;
                        bl3 = true;
                    }
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (bl3) {
                this.updKeyboardFld();
            }
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased() {
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            Arrays.fill(this.keyboardMatrix, 0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.updKeyboardFld();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            c = Character.toUpperCase(c);
            if (this.chessMode) {
                switch (c) {
                    case 'S': {
                        this.keyboardMatrix[2] = 64;
                        bl = true;
                        break;
                    }
                    case 'Z': {
                        this.keyboardMatrix[2] = 128;
                        bl = true;
                        break;
                    }
                    case '1': 
                    case 'A': {
                        this.keyboardMatrix[0] = 128;
                        bl = true;
                        break;
                    }
                    case '2': 
                    case 'B': {
                        this.keyboardMatrix[0] = 64;
                        bl = true;
                        break;
                    }
                    case '3': 
                    case 'C': {
                        this.keyboardMatrix[0] = 32;
                        bl = true;
                        break;
                    }
                    case '4': 
                    case 'D': {
                        this.keyboardMatrix[0] = 16;
                        bl = true;
                        break;
                    }
                    case '5': 
                    case 'E': {
                        this.keyboardMatrix[1] = 16;
                        bl = true;
                        break;
                    }
                    case '6': 
                    case 'F': {
                        this.keyboardMatrix[1] = 32;
                        bl = true;
                        break;
                    }
                    case '7': 
                    case 'G': {
                        this.keyboardMatrix[1] = 64;
                        bl = true;
                        break;
                    }
                    case '8': 
                    case 'H': {
                        this.keyboardMatrix[1] = 128;
                        bl = true;
                    }
                }
            } else {
                switch (c) {
                    case '0': 
                    case '8': {
                        this.keyboardMatrix[0] = 128;
                        bl = true;
                        break;
                    }
                    case '1': 
                    case '9': {
                        this.keyboardMatrix[0] = 64;
                        bl = true;
                        break;
                    }
                    case '2': 
                    case 'A': {
                        this.keyboardMatrix[0] = 32;
                        bl = true;
                        break;
                    }
                    case '3': 
                    case 'B': {
                        this.keyboardMatrix[0] = 16;
                        bl = true;
                        break;
                    }
                    case '4': 
                    case 'C': {
                        this.keyboardMatrix[1] = 16;
                        bl = true;
                        break;
                    }
                    case '5': 
                    case 'D': {
                        this.keyboardMatrix[1] = 32;
                        bl = true;
                        break;
                    }
                    case '6': 
                    case 'E': {
                        this.keyboardMatrix[1] = 64;
                        bl = true;
                        break;
                    }
                    case '7': 
                    case 'F': {
                        this.keyboardMatrix[1] = 128;
                        bl = true;
                        break;
                    }
                    case 'S': {
                        this.keyboardMatrix[2] = 16;
                        bl = true;
                        break;
                    }
                    case '+': 
                    case '-': {
                        this.keyboardMatrix[2] = 32;
                        bl = true;
                    }
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (bl) {
                this.updKeyboardFld();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paintScreen(Graphics graphics, int n, int n2, int n3) {
        int[] nArray = this.digitStatus;
        synchronized (this.digitStatus) {
            graphics.setFont(new Font("SansSerif", 1, 18 * n3));
            graphics.setColor(this.ledValue || this.ledStatus > 0 ? this.colorGreenLight : this.colorGreenDark);
            graphics.drawString("Busy", n, n2 + 110 * n3);
            for (int i = this.digitValues.length - 1; i >= 0; --i) {
                SLC1.paint7SegDigit(graphics, n, n2, this.digitValues[i], this.colorGreenDark, this.colorGreenLight, n3);
                n += 65 * n3;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            if (this.curKeyCol >= 0 && this.curKeyCol < this.keyboardMatrix.length) {
                n3 = ~this.keyboardMatrix[this.curKeyCol] & 0xFF;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            this.initSRAM(this.ram, properties);
        }
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            Arrays.fill(this.keyboardMatrix, 0);
            this.curKeyCol = 0;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            nArray = this.digitStatus;
            synchronized (this.digitStatus) {
                Arrays.fill(this.digitStatus, 0);
                Arrays.fill(this.digitValues, 0);
                this.ledStatus = 0;
                this.ledValue = false;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.curSegValue = 0;
                this.curDisplayTStates = 0L;
                this.setChessMode(true);
                return;
            }
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        int n3;
        boolean bl = false;
        if ((n & 0x4000) != 0 && (n3 = n & 0x3FF) < this.ram.length) {
            this.ram[n3] = (byte)n2;
            if (this.chessMode && n3 < 120 && n3 % 16 < 8) {
                this.screenFrm.setChessboardDirty(true);
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean supportsChessboard() {
        return true;
    }

    @Override
    public boolean supportsKeyboardFld() {
        return true;
    }

    @Override
    public boolean supportsSoundOutMono() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeIOByte(int n, int n2, int n3) {
        int n4 = n2 & 0xF;
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            this.curKeyCol = n4 - 3;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.soundOutPhase = n4 == 9;
            boolean bl = false;
            int n5 = 1;
            int n6 = n & 7;
            if (n6 > 0) {
                n5 <<= n6;
            }
            this.curSegValue = (n2 & 0x80) != 0 ? (this.curSegValue |= n5) : (this.curSegValue &= ~n5);
            if (n4 == 2) {
                n4 = -1;
            } else if (n4 > 2) {
                --n4;
            }
            int[] nArray2 = this.digitStatus;
            synchronized (this.digitStatus) {
                boolean bl2;
                if (n4 >= 0 && n4 < this.digitValues.length) {
                    this.curSegValue &= 0x7F;
                    if (this.curSegValue != this.digitValues[n4]) {
                        this.digitValues[n4] = this.curSegValue;
                        bl = true;
                    }
                    this.digitStatus[n4] = 3;
                }
                int n7 = 0;
                boolean bl3 = bl2 = (n2 & 0x10) != 0;
                if (bl2) {
                    n7 = 3;
                    if (!this.ledValue && this.ledStatus == 0) {
                        bl = true;
                    }
                } else if (this.ledValue || this.ledStatus > 0) {
                    bl = true;
                }
                this.ledStatus = n7;
                this.ledValue = bl2;
                // ** MonitorExit[var8_10] (shouldn't be in output)
                if (bl) {
                    this.screenFrm.setScreenDirty(true);
                }
                return;
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        this.displayTStates = z80CPU.getMaxSpeedKHz() * 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        if (this.displayTStates <= 0) return;
        this.curDisplayTStates += (long)n;
        if (this.curDisplayTStates <= (long)this.displayTStates) return;
        boolean bl = false;
        int[] nArray = this.digitStatus;
        synchronized (this.digitStatus) {
            for (int i = 0; i < this.digitStatus.length; ++i) {
                if (this.digitStatus[i] > 0) {
                    int n2 = i;
                    this.digitStatus[n2] = this.digitStatus[n2] - 1;
                    continue;
                }
                if (this.digitValues[i] == 0) continue;
                this.digitValues[i] = 0;
                bl = true;
            }
            if (!this.ledValue && this.ledStatus > 0) {
                --this.ledStatus;
                if (this.ledStatus == 0) {
                    bl = true;
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (bl) {
                this.screenFrm.setScreenDirty(true);
            }
            this.curDisplayTStates = 0L;
            return;
        }
    }

    private void setChessMode(boolean bl) {
        if (bl != this.chessMode) {
            this.chessMode = bl;
            if (this.keyboardFld != null) {
                this.keyboardFld.repaint();
            }
        }
    }

    private void updKeyboardFld() {
        if (this.keyboardFld != null) {
            this.keyboardFld.updKeySelection(this.keyboardMatrix);
        }
    }
}

