/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.etc.SC2KeyboardFld;
import z80emu.Z80CPU;
import z80emu.Z80PIO;

public class SC2
extends EmuSys {
    public static final String SYSNAME = "SC2";
    public static final String PROP_PREFIX = "jkcemu.sc2.";
    private static byte[] rom0000 = null;
    private static byte[] rom2000 = null;
    private byte[] ram;
    private int[] digitStatus;
    private int[] digitValues;
    private int[] keyboardMatrix;
    private SC2KeyboardFld keyboardFld;
    private int ledChessStatus;
    private int ledMateStatus;
    private boolean ledChessValue;
    private boolean ledMateValue;
    private long curDisplayTStates;
    private long displayTStates;
    private Z80PIO pio;

    public SC2(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        if (rom0000 == null) {
            rom0000 = this.readResource("/rom/sc2/sc2_0000.bin");
        }
        if (rom2000 == null) {
            rom2000 = this.readResource("/rom/sc2/sc2_2000.bin");
        }
        this.ram = new byte[1024];
        this.keyboardFld = null;
        this.keyboardMatrix = new int[4];
        this.digitStatus = new int[4];
        this.digitValues = new int[4];
        Z80CPU z80CPU = emuThread.getZ80CPU();
        this.pio = new Z80PIO("PIO");
        z80CPU.setInterruptSources(this.pio);
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        this.z80MaxSpeedChanged(z80CPU);
    }

    public static int getDefaultSpeedKHz() {
        return 2458;
    }

    public boolean getLEDChessValue() {
        return this.ledChessValue;
    }

    public boolean getLEDMateValue() {
        return this.ledMateValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeyboardMatrix(int[] nArray) {
        int[] nArray2 = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            int n;
            int n2 = Math.min(this.keyboardMatrix.length, nArray.length);
            for (n = 0; n < n2; ++n) {
                this.keyboardMatrix[n] = nArray[n];
            }
            while (n < this.keyboardMatrix.length) {
                this.keyboardMatrix[n] = 0;
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        return EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
    }

    @Override
    public AbstractKeyboardFld createKeyboardFld() {
        this.keyboardFld = new SC2KeyboardFld(this);
        return this.keyboardFld;
    }

    @Override
    public void die() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.setInterruptSources(null);
    }

    @Override
    public EmuSys.Chessman getChessman(int n, int n2) {
        EmuSys.Chessman chessman = null;
        if (n >= 0 && n < 8 && n2 >= 0 && n2 < 8) {
            switch (this.getMemByte(4096 + n * 16 + n2, false)) {
                case 1: {
                    chessman = EmuSys.Chessman.WHITE_PAWN;
                    break;
                }
                case 2: {
                    chessman = EmuSys.Chessman.WHITE_KNIGHT;
                    break;
                }
                case 3: {
                    chessman = EmuSys.Chessman.WHITE_BISHOP;
                    break;
                }
                case 4: {
                    chessman = EmuSys.Chessman.WHITE_ROOK;
                    break;
                }
                case 5: {
                    chessman = EmuSys.Chessman.WHITE_QUEEN;
                    break;
                }
                case 6: {
                    chessman = EmuSys.Chessman.WHITE_KING;
                    break;
                }
                case 255: {
                    chessman = EmuSys.Chessman.BLACK_PAWN;
                    break;
                }
                case 254: {
                    chessman = EmuSys.Chessman.BLACK_KNIGHT;
                    break;
                }
                case 253: {
                    chessman = EmuSys.Chessman.BLACK_BISHOP;
                    break;
                }
                case 252: {
                    chessman = EmuSys.Chessman.BLACK_ROOK;
                    break;
                }
                case 251: {
                    chessman = EmuSys.Chessman.BLACK_QUEEN;
                    break;
                }
                case 250: {
                    chessman = EmuSys.Chessman.BLACK_KING;
                }
            }
        }
        return chessman;
    }

    @Override
    public Color getColor(int n) {
        Color color = Color.black;
        switch (n) {
            case 1: {
                color = this.colorGreenDark;
                break;
            }
            case 2: {
                color = this.colorGreenLight;
            }
        }
        return color;
    }

    @Override
    public int getColorCount() {
        return 3;
    }

    @Override
    public String getHelpPage() {
        return "/help/sc2.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2;
        int n3 = 255;
        if ((n &= 0x3FFF) < 4096 && rom0000 != null) {
            if (n < rom0000.length) {
                n3 = rom0000[n] & 0xFF;
            }
        } else if (n >= 4096 && n < 8192) {
            int n4 = n - 4096;
            if (n4 < this.ram.length) {
                n3 = this.ram[n4] & 0xFF;
            }
        } else if (n >= 8192 && n < 15360 && rom2000 != null && (n2 = n - 8192) < rom2000.length) {
            n3 = rom2000[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public int getScreenHeight() {
        return 110;
    }

    @Override
    public int getScreenWidth() {
        return 70 + this.digitValues.length * 50;
    }

    @Override
    public String getTitle() {
        return SYSNAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (n == 8) {
            int[] nArray = this.keyboardMatrix;
            // MONITORENTER : this.keyboardMatrix
            this.keyboardMatrix[0] = this.keyboardMatrix[0] | 0x40;
            bl3 = true;
            // MONITOREXIT : nArray
        } else if (n == 10) {
            int[] nArray = this.keyboardMatrix;
            // MONITORENTER : this.keyboardMatrix
            this.keyboardMatrix[0] = this.keyboardMatrix[0] | 0x80;
            bl3 = true;
            // MONITOREXIT : nArray
        } else if (n == 27) {
            this.emuThread.fireReset(EmuThread.ResetLevel.WARM_RESET);
            bl3 = true;
        }
        if (!bl3) return bl3;
        this.updKeyboardFld();
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased() {
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            Arrays.fill(this.keyboardMatrix, 0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.updKeyboardFld();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            switch (Character.toUpperCase(c)) {
                case '1': 
                case 'A': {
                    this.keyboardMatrix[1] = this.keyboardMatrix[1] | 0x10;
                    bl = true;
                    break;
                }
                case '2': 
                case 'B': {
                    this.keyboardMatrix[1] = this.keyboardMatrix[1] | 0x20;
                    bl = true;
                    break;
                }
                case '3': 
                case 'C': {
                    this.keyboardMatrix[1] = this.keyboardMatrix[1] | 0x40;
                    bl = true;
                    break;
                }
                case '4': 
                case 'D': {
                    this.keyboardMatrix[1] = this.keyboardMatrix[1] | 0x80;
                    bl = true;
                    break;
                }
                case '5': 
                case 'E': {
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 0x10;
                    bl = true;
                    break;
                }
                case '6': 
                case 'F': {
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 0x20;
                    bl = true;
                    break;
                }
                case '7': 
                case 'G': {
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 0x40;
                    bl = true;
                    break;
                }
                case '8': 
                case 'H': {
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 0x80;
                    bl = true;
                    break;
                }
                case '+': 
                case 'K': {
                    this.keyboardMatrix[3] = this.keyboardMatrix[3] | 0x10;
                    bl = true;
                    break;
                }
                case 'L': {
                    this.keyboardMatrix[0] = this.keyboardMatrix[0] | 0x40;
                    bl = true;
                    break;
                }
                case 'P': {
                    this.keyboardMatrix[3] = this.keyboardMatrix[3] | 0x80;
                    bl = true;
                    break;
                }
                case 'Q': {
                    this.keyboardMatrix[0] = this.keyboardMatrix[0] | 0x80;
                    bl = true;
                    break;
                }
                case 'S': 
                case 'W': {
                    this.keyboardMatrix[3] = this.keyboardMatrix[3] | 0x20;
                    bl = true;
                    break;
                }
                case 'T': {
                    this.keyboardMatrix[0] = this.keyboardMatrix[0] | 0x20;
                    bl = true;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (bl) {
                this.updKeyboardFld();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paintScreen(Graphics graphics, int n, int n2, int n3) {
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            graphics.setFont(new Font("SansSerif", 1, 18 * n3));
            graphics.setColor(this.ledChessValue ? this.colorGreenLight : this.colorGreenDark);
            graphics.drawString("Schach", n, n2 + 110 * n3);
            int n4 = 0;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n4 = fontMetrics != null ? n + this.getScreenWidth() * n3 - fontMetrics.stringWidth("Matt") : n + this.getScreenWidth() / 2 * n3;
            graphics.setColor(this.ledMateValue ? this.colorGreenLight : this.colorGreenDark);
            graphics.drawString("Matt", n4, n2 + 110 * n3);
            for (int i = 0; i < this.digitValues.length; ++i) {
                SC2.paint7SegDigit(graphics, n, n2, this.digitValues[i], this.colorGreenDark, this.colorGreenLight, n3);
                n += (i == 1 ? 90 : 65) * n3;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        if ((n & 8) == 0) {
            switch (n & 3) {
                case 0: {
                    n3 = this.pio.readDataA();
                    break;
                }
                case 1: {
                    int n4 = this.pio.fetchOutValuePortB(false) & 0xF;
                    int[] nArray = this.keyboardMatrix;
                    synchronized (this.keyboardMatrix) {
                        int n5 = 1;
                        for (int i = 0; i < this.keyboardMatrix.length; ++i) {
                            if ((n4 & n5) != 0) {
                                n4 |= this.keyboardMatrix[i] & 0xF0;
                            }
                            n5 <<= 1;
                        }
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        this.pio.putInValuePortB(n4, 240);
                        n3 = this.pio.readDataB();
                        break;
                    }
                }
                case 2: {
                    n3 = this.pio.readControlA();
                    break;
                }
                case 3: {
                    n3 = this.pio.readControlB();
                }
            }
        }
        return n3;
    }

    @Override
    public int readMemByte(int n, boolean bl) {
        this.updSoundOutPhase(n &= 0x3FFF);
        return this.getMemByte(n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            this.initSRAM(this.ram, properties);
        }
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            Arrays.fill(this.digitStatus, 0);
            Arrays.fill(this.digitValues, 0);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.ledChessValue = false;
            this.ledMateValue = false;
            this.ledChessStatus = 0;
            this.ledMateStatus = 0;
            this.curDisplayTStates = 0L;
            return;
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        int n3;
        boolean bl = false;
        if ((n &= 0x3FFF) >= 4096 && n < 15360 && (n3 = n - 4096) < this.ram.length) {
            this.ram[n3] = (byte)n2;
            if (n3 < 120 && n3 % 16 < 8) {
                this.screenFrm.setChessboardDirty(true);
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean supportsChessboard() {
        return true;
    }

    @Override
    public boolean supportsKeyboardFld() {
        return true;
    }

    @Override
    public boolean supportsSoundOutMono() {
        return true;
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        if ((n & 8) == 0) {
            switch (n & 3) {
                case 0: {
                    this.pio.writeDataA(n2);
                    this.updDisplay();
                    break;
                }
                case 1: {
                    this.pio.writeDataB(n2);
                    this.updDisplay();
                    break;
                }
                case 2: {
                    this.pio.writeControlA(n2);
                    break;
                }
                case 3: {
                    this.pio.writeControlB(n2);
                }
            }
        }
    }

    @Override
    public void writeMemByte(int n, int n2) {
        this.updSoundOutPhase(n &= 0x3FFF);
        this.setMemByte(n, n2);
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        this.displayTStates = z80CPU.getMaxSpeedKHz() * 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        if (this.displayTStates <= 0L) return;
        this.curDisplayTStates += (long)n;
        if (this.curDisplayTStates <= this.displayTStates) return;
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            for (int i = 0; i < this.digitValues.length; ++i) {
                int n2 = this.digitStatus[i];
                if (n2 >= 4) continue;
                if (n2 > 0) {
                    int n3 = i;
                    this.digitStatus[n3] = this.digitStatus[n3] - 1;
                    continue;
                }
                if (this.digitValues[i] == 0) continue;
                this.digitValues[i] = 0;
                bl = true;
            }
            if (this.ledChessStatus < 4) {
                if (this.ledChessStatus > 0) {
                    --this.ledChessStatus;
                } else if (this.ledChessValue) {
                    this.ledChessValue = false;
                    bl2 = true;
                }
            }
            if (this.ledMateStatus < 4) {
                if (this.ledMateStatus > 0) {
                    --this.ledMateStatus;
                } else if (this.ledMateValue) {
                    this.ledMateValue = false;
                    bl2 = true;
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (bl || bl2) {
                this.screenFrm.setScreenDirty(true);
            }
            if (bl2 && this.keyboardFld != null) {
                this.keyboardFld.repaint();
            }
            this.curDisplayTStates = 0L;
            return;
        }
    }

    private int toDigitValue(int n) {
        int n2 = n & 8;
        if ((n & 1) != 0) {
            n2 |= 0x40;
        }
        if ((n & 2) != 0) {
            n2 |= 0x20;
        }
        if ((n & 4) != 0) {
            n2 |= 0x10;
        }
        if ((n & 0x10) != 0) {
            n2 |= 4;
        }
        if ((n & 0x20) != 0) {
            n2 |= 2;
        }
        if ((n & 0x40) != 0) {
            n2 |= 1;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updDisplay() {
        int n = this.pio.fetchOutValuePortA(false);
        int n2 = this.toDigitValue(n & 0x7F);
        int n3 = this.pio.fetchOutValuePortB(false);
        boolean bl = (n & 0x80) != 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            int n4 = 1;
            for (int i = 0; i < this.digitValues.length; ++i) {
                if ((n3 & n4) == 0) {
                    if (n2 != 0) {
                        if (n2 != this.digitValues[i]) {
                            this.digitValues[i] = n2;
                            bl2 = true;
                        }
                        this.digitStatus[i] = 4;
                    } else if (this.digitStatus[i] > 3) {
                        this.digitStatus[i] = 3;
                    }
                }
                n4 <<= 1;
            }
            if (bl && (n3 & 1) == 0) {
                if (bl != this.ledChessValue) {
                    this.ledChessValue = bl;
                    bl3 = true;
                }
                this.ledChessStatus = 4;
            } else if (this.ledChessStatus > 3) {
                this.ledChessStatus = 3;
            }
            if (bl && (n3 & 2) == 0) {
                if (bl != this.ledMateValue) {
                    this.ledMateValue = bl;
                    bl3 = true;
                }
                this.ledMateStatus = 4;
            } else if (this.ledMateStatus > 3) {
                this.ledMateStatus = 3;
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (bl2 || bl3) {
                this.screenFrm.setScreenDirty(true);
            }
            if (bl3 && this.keyboardFld != null) {
                this.keyboardFld.repaint();
            }
            return;
        }
    }

    private void updKeyboardFld() {
        if (this.keyboardFld != null) {
            this.keyboardFld.updKeySelection(this.keyboardMatrix);
        }
    }

    private void updSoundOutPhase(int n) {
        this.soundOutPhase = n >= 15360;
    }
}

