/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.util.Arrays;
import java.util.Properties;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.RAMFloppy;
import jkcemu.disk.FDC8272;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.disk.FloppyDiskFormat;
import jkcemu.disk.FloppyDiskInfo;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80CTCListener;
import z80emu.Z80PIO;
import z80emu.Z80SIO;
import z80emu.Z80SIOChannelListener;

public class PCM
extends EmuSys
implements FDC8272.DriveSelector,
Z80CTCListener,
Z80SIOChannelListener {
    public static final String SYSNAME = "PCM";
    public static final String SYSTEXT = "PC/M";
    public static final String PROP_PREFIX = "jkcemu.pcm.";
    public static final String PROP_AUTO_LOAD_BDOS = "auto_load_bdos";
    public static final String PROP_GRAPHIC = "graphic";
    public static final String VALUE_GRAPHIC_80X24 = "80x24";
    public static final String VALUE_GRAPHIC_64X32 = "64x32";
    public static final boolean DEFAULT_SWAP_KEY_CHAR_CASE = true;
    private static FloppyDiskInfo disk64x16 = new FloppyDiskInfo("/disks/pcm/pcmsys330_64x16.dump.gz", "PC/M Boot-Diskette (64x16 Zeichen)", 2, 2048, true);
    private static FloppyDiskInfo disk80x24 = new FloppyDiskInfo("/disks/pcm/pcmsys330_80x24.dump.gz", "PC/M Boot-Diskette (80x24 Zeichen)", 2, 2048, true);
    private static final FloppyDiskInfo[] availableFloppyDisks = new FloppyDiskInfo[]{disk64x16, disk80x24};
    private static byte[] bdos = null;
    private static byte[] romRF64x16 = null;
    private static byte[] romFDC64x16 = null;
    private static byte[] romFDC80x24 = null;
    private static byte[] pcmFontBytes64x16 = null;
    private static byte[] pcmFontBytes80x24 = null;
    private byte[] fontBytes = null;
    private byte[] romBytes = null;
    private String romFile = null;
    private byte[] ramVideo = new byte[2048];
    private RAMFloppy ramFloppy;
    private Z80CTC ctc;
    private Z80PIO pio;
    private Z80SIO sio;
    private FDC8272 fdc;
    private FloppyDiskDrive curFDDrive;
    private FloppyDiskDrive[] fdDrives;
    private boolean fdcTC = false;
    private boolean tapeInPhase;
    private boolean keyboardUsed;
    private boolean mode80x24;
    private boolean romEnabled;
    private boolean upperBank0Enabled;
    private int ramBank;
    private int romSize = 8192;
    private int nmiCounter;

    public PCM(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        this.mode80x24 = this.emulates80x24(properties);
        this.curFDDrive = null;
        this.fdc = null;
        this.fdDrives = null;
        if (this.emulatesFloppyDisk(properties)) {
            this.fdc = new FDC8272(this, 4);
            this.fdDrives = new FloppyDiskDrive[4];
            Arrays.fill(this.fdDrives, null);
        } else {
            this.fdc = null;
            this.fdDrives = null;
        }
        this.ramFloppy = this.emuThread.getRAMFloppy1();
        if (this.ramFloppy != null) {
            this.ramFloppy.install(SYSTEXT, RAMFloppy.RFType.OTHER, 126976, "PC/M RAM-B\u00e4nke 1 und 2", EmuUtil.getProperty(properties, this.propPrefix + "ramfloppy." + "file"));
        }
        Z80CPU z80CPU = emuThread.getZ80CPU();
        this.ctc = new Z80CTC("CTC (80-83)");
        this.pio = new Z80PIO("PIO (84-87)");
        this.sio = new Z80SIO("SIO (88-8B)");
        z80CPU.setInterruptSources(this.ctc, this.pio, this.sio);
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        this.ctc.addCTCListener(this);
        this.sio.addChannelListener(this, 0);
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
        this.z80MaxSpeedChanged(z80CPU);
    }

    public static FloppyDiskInfo[] getAvailableFloppyDisks() {
        return availableFloppyDisks;
    }

    public static int getDefaultSpeedKHz() {
        return 2500;
    }

    @Override
    public FloppyDiskDrive getFloppyDiskDrive(int n) {
        return this.curFDDrive;
    }

    @Override
    public void z80CTCUpdate(Z80CTC z80CTC, int n) {
        if (z80CTC == this.ctc) {
            switch (n) {
                case 0: {
                    this.sio.clockPulseSenderA();
                    this.sio.clockPulseReceiverA();
                    break;
                }
                case 1: {
                    this.sio.clockPulseSenderB();
                    this.sio.clockPulseReceiverB();
                    break;
                }
                case 2: {
                    this.soundOutPhase = !this.soundOutPhase;
                }
            }
        }
    }

    @Override
    public void z80SIOByteSent(Z80SIO z80SIO, int n, int n2) {
        if (z80SIO == this.sio && n == 0) {
            this.emuThread.getPrintMngr().putByte(n2);
            this.sio.setClearToSendA(false);
            this.sio.setClearToSendA(true);
        }
    }

    @Override
    public void appendStatusHTMLTo(StringBuilder stringBuilder, Z80CPU z80CPU) {
        stringBuilder.append("<h1>PC/M Speicherkonfiguration</h1>\n<table border=\"1\">\n<tr><td>F800h-FFFFh:</td><td>BWS</td></tr>\n<tr><td>C000h-F7FFh:</td><td>RAM Bank ");
        if (this.upperBank0Enabled) {
            stringBuilder.append("0");
        } else {
            stringBuilder.append(this.ramBank);
        }
        int n = this.romEnabled ? this.romSize : 0;
        stringBuilder.append(String.format("</td></tr>\n<tr><td>%04Xh-BFFFh:</td><td>RAM Bank %d</td></tr>\n", n, this.ramBank));
        if (n > 0) {
            stringBuilder.append(String.format("<tr><td>0000h-%04Xh:</td><td>ROM</td></tr>\n", n - 1));
        }
        stringBuilder.append("</table>\n");
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        this.loadFont(properties);
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
        if (bl) {
            bl = TextUtil.equals(this.romFile, EmuUtil.getProperty(properties, this.propPrefix + "rom." + "file"));
        }
        if (bl && this.emulatesFloppyDisk(properties) != (this.fdc != null)) {
            bl = false;
        }
        if (bl && this.emulates80x24(properties) != this.mode80x24) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean canExtractScreenText() {
        return true;
    }

    @Override
    public void die() {
        if (this.ramFloppy != null) {
            this.ramFloppy.deinstall();
        }
        this.sio.removeChannelListener(this, 0);
        this.ctc.removeCTCListener(this);
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.setInterruptSources(null);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.removeTStatesListener(this);
        if (this.fdc != null) {
            this.fdc.die();
        }
    }

    @Override
    public int getAppStartStackInitValue() {
        return 51200;
    }

    @Override
    public int getColorIndex(int n, int n2) {
        int n3 = 0;
        if (this.fontBytes != null) {
            if (this.mode80x24) {
                int n4 = n2 % 10;
                int n5 = n2 / 10;
                int n6 = n / 6;
                int n7 = n5 * 80 + n6;
                if (n7 >= 0 && n7 < this.ramVideo.length) {
                    int n8 = this.ramVideo[n7] & 0xFF;
                    if (n4 == 8 && (n8 & 0x80) != 0) {
                        n3 = 1;
                    } else {
                        int n9 = (n8 & 0x7F) * 16 + n4;
                        if (n9 >= 0 && n9 < this.fontBytes.length) {
                            int n10 = 128;
                            int n11 = n % 6;
                            if (n11 > 0) {
                                n10 >>= n11;
                            }
                            if ((this.fontBytes[n9] & n10) == 0) {
                                n3 = 1;
                            }
                        }
                    }
                }
            } else {
                int n12;
                int n13;
                int n14 = n2 % 16;
                int n15 = n2 / 16;
                int n16 = n / 7;
                int n17 = 1024;
                if (n14 >= 8) {
                    n17 = 0;
                    n14 -= 8;
                }
                if ((n13 = n17 + n15 * 64 + n16) >= 0 && n13 < this.ramVideo.length && (n12 = (this.ramVideo[n13] & 0xFF) * 8 + n14) >= 0 && n12 < this.fontBytes.length) {
                    int n18 = 128;
                    int n19 = n % 7;
                    if (n19 > 0) {
                        n18 >>= n19;
                    }
                    if ((this.fontBytes[n12] & n18) != 0) {
                        n3 = 1;
                    }
                }
            }
        }
        return n3;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        return this.mode80x24 ? new CharRaster(80, 24, 10, 10, 6, 0) : new CharRaster(64, 32, 8, 8, 7, 0);
    }

    @Override
    public FloppyDiskFormat getDefaultFloppyDiskFormat() {
        return FloppyDiskFormat.FMT_624K;
    }

    @Override
    protected long getDelayMillisAfterPasteChar() {
        return 50L;
    }

    @Override
    protected long getDelayMillisAfterPasteEnter() {
        return 150L;
    }

    @Override
    protected long getHoldMillisPasteChar() {
        return 50L;
    }

    @Override
    public String getHelpPage() {
        return "/help/pcm.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2 = 255;
        if ((n &= 0xFFFF) < this.romSize && this.romEnabled) {
            if (this.romBytes != null && n < this.romBytes.length) {
                n2 = this.romBytes[n] & 0xFF;
            }
        } else if (n >= 63488) {
            int n3 = n - 63488;
            if (n3 < this.ramVideo.length) {
                n2 = this.ramVideo[n3] & 0xFF;
            }
        } else if (this.ramBank == 0 || n >= 49152 && this.upperBank0Enabled) {
            n2 = this.emuThread.getRAMByte(n);
        } else if (this.ramBank == 1 && this.ramFloppy != null) {
            n2 = this.ramFloppy.getByte(n);
        } else if (this.ramBank == 2 && this.ramFloppy != null) {
            n2 = this.ramFloppy.getByte(n + 63488);
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        int n3 = -1;
        if (this.mode80x24) {
            int n4 = n2 * 80 + n;
            if (n4 < 0) return n3;
            if (n4 >= this.ramVideo.length) return n3;
            int n5 = this.ramVideo[n4];
            switch (n5) {
                case 1: {
                    return 196;
                }
                case 2: {
                    return 214;
                }
                case 3: {
                    return 220;
                }
                case 4: {
                    return 228;
                }
                case 5: {
                    return 246;
                }
                case 6: {
                    return 252;
                }
                case 7: {
                    return 223;
                }
                default: {
                    if (n5 < 32) return n3;
                    if (n5 >= 127) return n3;
                    return n5;
                }
            }
        }
        int n6 = -1;
        n6 = (n2 & 1) == 0 ? 1024 + (n2 /= 2) * 64 + n : (n2 /= 2) * 64 + n;
        if (n6 < 0) return n3;
        if (n6 >= this.ramVideo.length) return n3;
        int n7 = this.ramVideo[n6];
        switch (n7) {
            case 24: {
                n3 = 196;
                break;
            }
            case 25: {
                n3 = 228;
                break;
            }
            case 26: {
                n3 = 214;
                break;
            }
            case 27: {
                n3 = 246;
                break;
            }
            case 28: {
                n3 = 220;
                break;
            }
            case 29: {
                n3 = 252;
                break;
            }
            case 30: {
                n3 = 223;
                break;
            }
            default: {
                if (n7 < 32 || n7 >= 127) break;
                n3 = n7;
            }
        }
        if (n7 < 32) return n3;
        if (n7 >= 127) return n3;
        return n7;
    }

    @Override
    public int getScreenHeight() {
        return this.mode80x24 ? 240 : 256;
    }

    @Override
    public int getScreenWidth() {
        return this.mode80x24 ? 480 : 448;
    }

    @Override
    public FloppyDiskInfo[] getSuitableFloppyDisks() {
        FloppyDiskInfo[] floppyDiskInfoArray = null;
        if (this.fdc != null) {
            floppyDiskInfoArray = this.mode80x24 ? new FloppyDiskInfo[]{disk80x24} : new FloppyDiskInfo[]{disk64x16};
        }
        return floppyDiskInfoArray;
    }

    @Override
    public int getSupportedFloppyDiskDriveCount() {
        return this.fdDrives != null ? this.fdDrives.length : 0;
    }

    @Override
    public boolean getSwapKeyCharCase() {
        return true;
    }

    @Override
    public String getTitle() {
        return SYSTEXT;
    }

    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n2 = 0;
        switch (n) {
            case 8: 
            case 37: {
                n2 = 8;
                break;
            }
            case 39: {
                n2 = 9;
                break;
            }
            case 40: {
                n2 = 10;
                break;
            }
            case 38: {
                n2 = 11;
                break;
            }
            case 10: {
                n2 = 13;
                break;
            }
            case 32: {
                n2 = 32;
                break;
            }
            case 127: {
                n2 = 127;
            }
        }
        if (n2 > 0) {
            this.pio.putInValuePortA(n2 | 0x80, 255);
            bl3 = true;
        }
        return bl3;
    }

    @Override
    public void keyReleased() {
        this.pio.putInValuePortA(0, 255);
    }

    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        if (c > '\u0000' && c < '\u007f') {
            this.pio.putInValuePortA(c | 0x80, 255);
            bl = true;
        }
        return bl;
    }

    @Override
    protected boolean pasteChar(char c) throws InterruptedException {
        boolean bl = false;
        if (c == '\n') {
            c = (char)13;
        }
        if (c > '\u0000' && c < '\u007f') {
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            } else if (Character.isLowerCase(c)) {
                c = Character.toUpperCase(c);
            }
            this.pio.putInValuePortA(c | 0x80, 255);
            Thread.sleep(100L);
            this.pio.putInValuePortA(0, 255);
            bl = true;
        }
        return bl;
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        switch (n & 0xFF) {
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                n3 = this.ctc.read(n & 3, n2);
                break;
            }
            case 132: {
                if (!this.keyboardUsed) {
                    this.pio.putInValuePortA(0, 255);
                    this.keyboardUsed = true;
                }
                n3 = this.pio.readDataA();
                break;
            }
            case 133: {
                n3 = this.pio.readDataB();
                break;
            }
            case 134: {
                n3 = this.pio.readControlA();
                break;
            }
            case 135: {
                n3 = this.pio.readControlB();
                break;
            }
            case 136: {
                n3 = this.sio.readDataA();
                break;
            }
            case 137: {
                n3 = this.sio.readDataB();
                break;
            }
            case 138: {
                n3 = this.sio.readControlA();
                break;
            }
            case 139: {
                n3 = this.sio.readControlB();
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                this.nmiCounter = 3;
                break;
            }
            case 192: {
                if (this.fdc == null) break;
                n3 = this.fdc.readMainStatusReg();
                break;
            }
            case 193: {
                if (this.fdc == null) break;
                n3 = this.fdc.readData();
            }
        }
        return n3;
    }

    @Override
    public int readMemByte(int n, boolean bl) {
        if (bl && this.nmiCounter > 0) {
            --this.nmiCounter;
            if (this.nmiCounter == 0) {
                this.emuThread.getZ80CPU().fireNMI();
            }
        }
        return this.getMemByte(n, bl);
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        int n;
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            if (this.isReloadExtROMsOnPowerOnEnabled(properties)) {
                this.loadROMs(properties);
            }
            this.fillRandom(this.ramVideo);
        }
        if (EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_AUTO_LOAD_BDOS, true)) {
            if (bdos == null) {
                bdos = this.readResource("/rom/pcm/bdos.bin");
            }
            if (bdos != null) {
                n = 53248;
                for (int i = 0; n < 65536 && i < bdos.length; ++i) {
                    this.emuThread.setRAMByte(n++, bdos[i]);
                }
            }
        }
        if (this.fdc != null) {
            this.fdc.reset(resetLevel == EmuThread.ResetLevel.POWER_ON);
        }
        if (resetLevel == EmuThread.ResetLevel.POWER_ON || resetLevel == EmuThread.ResetLevel.COLD_RESET) {
            this.ctc.reset(true);
            this.pio.reset(true);
            this.sio.reset(true);
        } else {
            this.ctc.reset(false);
            this.pio.reset(false);
            this.sio.reset(false);
        }
        this.sio.setClearToSendA(true);
        this.sio.setClearToSendB(true);
        if (this.fdDrives != null) {
            for (n = 0; n < this.fdDrives.length; ++n) {
                FloppyDiskDrive floppyDiskDrive = this.fdDrives[n];
                if (floppyDiskDrive == null) continue;
                floppyDiskDrive.reset();
            }
        }
        this.tapeInPhase = this.emuThread.readTapeInPhase();
        this.curFDDrive = null;
        this.fdcTC = false;
        this.keyboardUsed = false;
        this.romEnabled = true;
        this.upperBank0Enabled = true;
        this.ramBank = 0;
        this.nmiCounter = 0;
    }

    @Override
    public void setFloppyDiskDrive(int n, FloppyDiskDrive floppyDiskDrive) {
        if (this.fdDrives != null && n >= 0 && n < this.fdDrives.length) {
            this.fdDrives[n] = floppyDiskDrive;
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        boolean bl = false;
        if ((n &= 0xFFFF) >= 63488) {
            int n3 = n - 63488;
            if (n3 < this.ramVideo.length) {
                this.ramVideo[n3] = (byte)n2;
                this.screenFrm.setScreenDirty(true);
                bl = true;
            }
        } else if (n >= this.romSize || !this.romEnabled) {
            if (this.ramBank == 0 || n >= 49152 && this.upperBank0Enabled) {
                this.emuThread.setRAMByte(n, n2);
                bl = true;
            } else if (this.ramBank == 1 && this.ramFloppy != null) {
                this.ramFloppy.setByte(n, n2);
                bl = true;
            } else if (this.ramBank == 2 && this.ramFloppy != null) {
                this.ramFloppy.setByte(n + 63488, n2);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean shouldAskConvertScreenChar() {
        return this.fontBytes != pcmFontBytes64x16 && this.fontBytes != pcmFontBytes80x24;
    }

    @Override
    public boolean supportsPrinter() {
        return true;
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return true;
    }

    @Override
    public boolean supportsRAMFloppy1() {
        return this.ramFloppy != null;
    }

    @Override
    public boolean supportsSoundOutMono() {
        return true;
    }

    @Override
    public boolean supportsTapeIn() {
        return true;
    }

    @Override
    public boolean supportsTapeOut() {
        return true;
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        switch (n & 0xFF) {
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                this.ctc.write(n & 3, n2, n3);
                break;
            }
            case 132: {
                this.pio.writeDataA(n2);
                break;
            }
            case 133: {
                this.pio.writeDataB(n2);
                this.tapeOutPhase = (this.pio.fetchOutValuePortB(false) & 0x40) != 0;
                break;
            }
            case 134: {
                this.pio.writeControlA(n2);
                break;
            }
            case 135: {
                this.pio.writeControlB(n2);
                break;
            }
            case 136: {
                this.sio.writeDataA(n2);
                break;
            }
            case 137: {
                this.sio.writeDataB(n2);
                break;
            }
            case 138: {
                this.sio.writeControlA(n2);
                break;
            }
            case 139: {
                this.sio.writeControlB(n2);
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: {
                this.ramBank = n2 & 3;
                this.upperBank0Enabled = (n2 & 0x40) != 0;
                this.romEnabled = (n2 & 0x80) == 0;
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                this.nmiCounter = 3;
                break;
            }
            case 193: {
                if (this.fdc == null) break;
                this.fdc.write(n2);
                break;
            }
            case 194: 
            case 195: {
                boolean bl;
                if (this.fdc == null) break;
                if (this.fdDrives != null) {
                    FloppyDiskDrive floppyDiskDrive = null;
                    int n4 = (n2 & 0xF) >> 1 | (n2 & 1) << 3;
                    int n5 = 1;
                    for (int i = 0; i < this.fdDrives.length; ++i) {
                        if ((n4 & n5) != 0) {
                            floppyDiskDrive = this.fdDrives[i];
                            break;
                        }
                        n5 <<= 1;
                    }
                    this.curFDDrive = floppyDiskDrive;
                }
                boolean bl2 = bl = (n2 & 0x80) != 0;
                if (bl && bl != this.fdcTC) {
                    this.fdc.fireTC();
                }
                this.fdcTC = bl;
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        if (this.fdc != null) {
            this.fdc.z80MaxSpeedChanged(z80CPU);
        }
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        boolean bl = this.emuThread.readTapeInPhase();
        if (bl != this.tapeInPhase) {
            this.tapeInPhase = bl;
            this.pio.putInValuePortB(this.tapeInPhase ? 128 : 0, 128);
        }
        this.ctc.z80TStatesProcessed(z80CPU, n);
        if (this.fdc != null) {
            this.fdc.z80TStatesProcessed(z80CPU, n);
        }
    }

    private boolean emulates80x24(Properties properties) {
        return EmuUtil.getProperty(properties, this.propPrefix + PROP_GRAPHIC).equals(VALUE_GRAPHIC_80X24);
    }

    private boolean emulatesFloppyDisk(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "fdc.enabled", true);
    }

    private void loadFont(Properties properties) {
        this.fontBytes = this.readFontByProperty(properties, this.propPrefix + "font.file", 2048);
        if (this.fontBytes == null) {
            if (this.mode80x24) {
                if (pcmFontBytes80x24 == null) {
                    pcmFontBytes80x24 = this.readResource("/rom/pcm/pcmfont_80x24.bin");
                }
                this.fontBytes = pcmFontBytes80x24;
            } else {
                if (pcmFontBytes64x16 == null) {
                    pcmFontBytes64x16 = this.readResource("/rom/pcm/pcmfont_64x16.bin");
                }
                this.fontBytes = pcmFontBytes64x16;
            }
        }
    }

    private void loadROMs(Properties properties) {
        this.romFile = EmuUtil.getProperty(properties, this.propPrefix + "rom." + "file");
        this.romBytes = this.readROMFile(this.romFile, 32768, "ROM-Inhalt (Grundbetriebssystem)");
        if (this.romBytes != null) {
            int n = (this.romBytes.length + 8191) / 8192;
            if (n < 1) {
                n = 1;
            } else if (n > 4) {
                n = 4;
            }
            this.romSize = n * 8192;
        } else if (this.fdc != null) {
            if (this.mode80x24) {
                if (romFDC80x24 == null) {
                    romFDC80x24 = this.readResource("/rom/pcm/pcmsys330_80x24.bin");
                }
                this.romBytes = romFDC80x24;
            } else {
                if (romFDC64x16 == null) {
                    romFDC64x16 = this.readResource("/rom/pcm/pcmsys330_64x16.bin");
                }
                this.romBytes = romFDC64x16;
            }
        } else {
            if (romRF64x16 == null) {
                romRF64x16 = this.readResource("/rom/pcm/pcmsys210_64x16.bin");
            }
            this.romBytes = romRF64x16;
        }
        this.loadFont(properties);
    }
}

