/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.disk.FDC8272;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.disk.FloppyDiskFormat;
import jkcemu.disk.FloppyDiskInfo;
import jkcemu.disk.GIDE;
import jkcemu.etc.VDIP;
import jkcemu.net.KCNet;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80CTCListener;
import z80emu.Z80InterruptSource;
import z80emu.Z80PIO;
import z80emu.Z80PIOPortListener;
import z80emu.Z80SIO;
import z80emu.Z80SIOChannelListener;

public class NANOS
extends EmuSys
implements FDC8272.DriveSelector,
Z80CTCListener,
Z80PIOPortListener,
Z80SIOChannelListener {
    public static final String SYSNAME = "NANOS";
    public static final String PROP_PREFIX = "jkcemu.nanos.";
    public static final String PROP_KEYBOARD = "keyboard";
    public static final String PROP_FONT_8X6_PREFIX = "font.8x6.";
    public static final String PROP_FONT_8X8_PREFIX = "font.8x8.";
    public static final String PROP_ROM = "rom";
    public static final String PROP_KEYBOARD_SWAP_CASE = "swap_case";
    public static final String PROP_GRAPHIC = "graphic";
    public static final String VALUE_EPOS = "epos";
    public static final String VALUE_NANOS = "nanos";
    public static final String VALUE_GRAPHIC_64X32 = "64x32";
    public static final String VALUE_GRAPHIC_80X24 = "80x24";
    public static final String VALUE_GRAPHIC_80X25 = "80x25";
    public static final String VALUE_GRAPHIC_POPPE = "poppe";
    public static final String VALUE_KEYBOARD_PIO00A_HS = "pio00a_hs";
    public static final String VALUE_KEYBOARD_PIO00A_BIT7 = "pio00a_bit7";
    public static final String VALUE_KEYBOARD_SIO84A = "sio84a";
    public static final int DEFAULT_PROMPT_AFTER_RESET_MILLIS_MAX = 2000;
    private static FloppyDiskInfo epos20Disk64x32 = new FloppyDiskInfo("/disks/nanos/epos21_64x32.dump.gz", "EPOS 2.1 Boot-Diskette (64x32 Zeichen)", 2, 2048, true);
    private static FloppyDiskInfo epos20Disk80x24 = new FloppyDiskInfo("/disks/nanos/epos21_80x24.dump.gz", "EPOS 2.1 Boot-Diskette (80x24 Zeichen)", 2, 2048, true);
    private static FloppyDiskInfo nanos22Disk80x25 = new FloppyDiskInfo("/disks/nanos/nanos22_80x25.dump.gz", "NANOS 2.2 Boot-Diskette", 2, 2048, true);
    private static byte[] romEpos = null;
    private static byte[] romNanos = null;
    private static byte[] fontNanos = null;
    private byte[] fontBytes8x6;
    private byte[] fontBytes8x8;
    private byte[] ram1000;
    private byte[] ramVideoText;
    private byte[] ramVideoColor;
    private byte[] romBytes;
    private String romProp;
    private byte[] ram256k;
    private Z80PIO pio00;
    private Z80PIO pio80;
    private Z80SIO sio84;
    private Z80PIO pio88;
    private Z80CTC ctc8C;
    private KCNet kcNet;
    private VDIP vdip;
    private GIDE gide;
    private FDC8272 fdc;
    private FloppyDiskDrive[] fdDrives;
    private boolean fdcTC;
    private boolean tapeInPhase;
    private boolean altFontSelected;
    private boolean colorRamSelected;
    private boolean mode64x32;
    private boolean fillPixLines8And9;
    private boolean bootMemEnabled;
    private boolean swapKeyCharCase;
    private boolean ram256kEnabled;
    private boolean ram256kReadable;
    private int ram256kMemBaseAddr;
    private int ram256kRFBaseAddr;
    private long pasteTStates;
    private Color[] colors;
    private GraphicHW graphicHW;
    private KeyboardHW keyboardHW;

    public NANOS(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        this.graphicHW = this.getGraphicHW(properties);
        if (this.graphicHW == GraphicHW.Poppe_64x32_80x24) {
            this.ramVideoText = new byte[2048];
            this.ramVideoColor = new byte[2048];
            this.colors = new Color[16];
            float f = NANOS.getBrightness(properties);
            if (this.colors != null && f >= 0.0f && f <= 1.0f) {
                for (int i = 0; i < this.colors.length; ++i) {
                    int n = Math.round((float)((i & 8) != 0 ? 255 : 191) * f);
                    this.colors[i] = new Color((i & 1) != 0 ? n : 0, (i & 2) != 0 ? n : 0, (i & 4) != 0 ? n : 0);
                }
            }
        } else {
            this.ramVideoText = null;
            this.ramVideoColor = null;
            this.colors = null;
        }
        this.keyboardHW = this.getKeyboardHW(properties);
        this.swapKeyCharCase = false;
        this.fontBytes8x6 = null;
        this.fontBytes8x8 = null;
        this.romBytes = null;
        this.romProp = null;
        this.ram1000 = new byte[1024];
        this.ram256k = new byte[262144];
        this.fdc = new FDC8272(this, 4);
        this.fdDrives = new FloppyDiskDrive[4];
        Arrays.fill(this.fdDrives, null);
        this.setFDCSpeed(false);
        this.kcNet = null;
        if (this.emulatesKCNet(properties)) {
            this.kcNet = new KCNet("Netzwerk-PIO (E/A-Adressen 80h-83h)");
        }
        this.vdip = null;
        if (this.emulatesUSB(properties)) {
            this.vdip = new VDIP(this.emuThread.getFileTimesViewFactory(), "USB-PIO (E/A-Adressen 88h-8Bh)");
            this.vdip.applySettings(properties);
        }
        this.gide = GIDE.getGIDE(this.screenFrm, properties, this.propPrefix);
        this.pio00 = new Z80PIO("ZRE-PIO (00-03)");
        this.pio80 = null;
        if (this.kcNet == null) {
            this.pio80 = new Z80PIO("PIO (80-83)");
        }
        this.sio84 = new Z80SIO("SIO (84-87)");
        this.pio88 = null;
        if (this.vdip == null) {
            this.pio88 = new Z80PIO("PIO (88-8B)");
        }
        this.ctc8C = new Z80CTC("CTC (8C-8F)");
        ArrayList<Z80InterruptSource> arrayList = new ArrayList<Z80InterruptSource>();
        arrayList.add(this.pio00);
        if (this.kcNet != null) {
            arrayList.add(this.kcNet);
        } else if (this.pio80 != null) {
            arrayList.add(this.pio80);
        }
        arrayList.add(this.sio84);
        if (this.vdip != null) {
            arrayList.add(this.vdip);
        } else if (this.pio88 != null) {
            arrayList.add(this.pio88);
        }
        arrayList.add(this.ctc8C);
        Z80CPU z80CPU = emuThread.getZ80CPU();
        try {
            z80CPU.setInterruptSources(arrayList.toArray(new Z80InterruptSource[arrayList.size()]));
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        this.pio00.addPIOPortListener((Z80PIOPortListener)this, Z80PIO.PortInfo.A);
        this.sio84.addChannelListener(this, 1);
        this.ctc8C.addCTCListener(this);
        this.applyKeyboardSettings(properties);
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
        this.z80MaxSpeedChanged(z80CPU);
    }

    public static FloppyDiskInfo[] getAvailableFloppyDisks() {
        return new FloppyDiskInfo[]{epos20Disk64x32, epos20Disk80x24, nanos22Disk80x25};
    }

    public static int getDefaultSpeedKHz() {
        return 2457;
    }

    @Override
    public FloppyDiskDrive getFloppyDiskDrive(int n) {
        FloppyDiskDrive floppyDiskDrive = null;
        if (this.fdDrives != null && n >= 0 && n < this.fdDrives.length) {
            floppyDiskDrive = this.fdDrives[n];
        }
        return floppyDiskDrive;
    }

    @Override
    public void z80CTCUpdate(Z80CTC z80CTC, int n) {
        if (z80CTC == this.ctc8C) {
            if (n == 0) {
                this.sio84.clockPulseSenderA();
                this.sio84.clockPulseReceiverA();
            } else if (n == 1) {
                this.sio84.clockPulseSenderB();
                this.sio84.clockPulseReceiverB();
            }
        }
    }

    @Override
    public void z80PIOPortStatusChanged(Z80PIO z80PIO, Z80PIO.PortInfo portInfo, Z80PIO.Status status) {
        if (z80PIO == this.pio00 && portInfo == Z80PIO.PortInfo.A && status == Z80PIO.Status.READY_FOR_INPUT && this.keyboardHW == KeyboardHW.PIO00A_HS && this.pasteIter != null) {
            this.pasteTStates = 50000L;
        }
    }

    @Override
    public void z80SIOByteSent(Z80SIO z80SIO, int n, int n2) {
        if (z80SIO == this.sio84 && n == 1) {
            this.emuThread.getPrintMngr().putByte(n2);
            this.sio84.setClearToSendB(false);
            this.sio84.setClearToSendB(true);
        }
    }

    @Override
    public void appendStatusHTMLTo(StringBuilder stringBuilder, Z80CPU z80CPU) {
        stringBuilder.append("<h1>NANOS Konfiguration</h1>\n<table border=\"1\">\n<tr><td>ZRE-ROM/RAM:</td><td>");
        EmuUtil.appendOnOffText(stringBuilder, this.bootMemEnabled);
        stringBuilder.append("</td></tr>\n<tr><td>256K RAM:</td><td>");
        if (this.ram256kEnabled) {
            stringBuilder.append(this.ram256kReadable ? "Lesen und Schreiben" : "Nur Schreiben");
        } else {
            stringBuilder.append("aus");
        }
        stringBuilder.append("</td></tr>\n<tr><td>RAM-Bank f&uuml;r Hauptspeicher:</td><td>");
        stringBuilder.append(this.ram256kMemBaseAddr >> 16);
        stringBuilder.append("</td></tr>\n<tr><td>RAM-Floppy Sektor-Adresse:</td><td>");
        stringBuilder.append(String.format("%05Xh", this.ram256kRFBaseAddr));
        stringBuilder.append("</td></tr>\n");
        if (this.graphicHW == GraphicHW.Poppe_64x32_80x24) {
            stringBuilder.append("<tr><td>Bildschirmformat:</td><td>");
            stringBuilder.append(this.mode64x32 ? VALUE_GRAPHIC_64X32 : VALUE_GRAPHIC_80X24);
            stringBuilder.append("</td></tr>\n");
            if (this.mode64x32) {
                stringBuilder.append("<tr><td>Zeichensatz:</td><td>");
                stringBuilder.append(this.altFontSelected ? "2" : "1 (Standard)");
                stringBuilder.append("</td></tr>\n");
            } else {
                stringBuilder.append("<tr><td>Zeilenzwischenraum:</td><td>");
                stringBuilder.append(this.fillPixLines8And9 ? "Blockgrafik" : "Hintergrundfarbe");
                stringBuilder.append("</td></tr>\n");
            }
            stringBuilder.append("<tr><td>F800h-FFFFh:</td><td>");
            if (this.colorRamSelected) {
                stringBuilder.append("Farb");
            } else {
                stringBuilder.append("Text");
            }
            stringBuilder.append("-RAM</td></tr>\n");
        }
        stringBuilder.append("</table>\n");
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        this.applyKeyboardSettings(properties);
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
        this.loadFonts(properties);
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
        if (bl) {
            bl = TextUtil.equals(this.romProp, EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM));
        }
        if (bl && this.graphicHW != this.getGraphicHW(properties)) {
            bl = false;
        }
        if (bl && this.keyboardHW != this.getKeyboardHW(properties)) {
            bl = false;
        }
        if (bl && this.emulatesKCNet(properties) != (this.kcNet != null)) {
            bl = false;
        }
        if (bl && this.emulatesUSB(properties) != (this.vdip != null)) {
            bl = false;
        }
        if (bl) {
            bl = GIDE.complies(this.gide, properties, this.propPrefix);
        }
        return bl;
    }

    @Override
    public synchronized void cancelPastingText() {
        if (this.keyboardHW == KeyboardHW.PIO00A_HS) {
            if (this.pasteIter != null) {
                this.pasteIter = null;
                this.screenFrm.firePastingTextFinished();
            }
        } else {
            super.cancelPastingText();
        }
    }

    @Override
    public boolean canExtractScreenText() {
        return true;
    }

    @Override
    public void die() {
        this.pio00.removePIOPortListener((Z80PIOPortListener)this, Z80PIO.PortInfo.A);
        this.ctc8C.removeCTCListener(this);
        this.sio84.removeChannelListener(this, 0);
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.setInterruptSources(null);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.removeTStatesListener(this);
        this.fdc.die();
        if (this.kcNet != null) {
            this.kcNet.die();
        }
        if (this.vdip != null) {
            this.vdip.die();
        }
        if (this.gide != null) {
            this.gide.die();
        }
    }

    @Override
    public int getAppStartStackInitValue() {
        return 58880;
    }

    @Override
    public Color getColor(int n) {
        Color color = Color.black;
        if (this.ramVideoColor != null && this.colors != null) {
            if (n >= 0 && n < this.colors.length) {
                color = this.colors[n];
            }
        } else if (n > 0) {
            color = Color.white;
        }
        return color;
    }

    @Override
    public int getColorCount() {
        return this.ramVideoColor != null ? 16 : 2;
    }

    @Override
    public int getColorIndex(int n, int n2) {
        int n3 = 0;
        if (this.graphicHW == GraphicHW.Poppe_64x32_80x24 && this.ramVideoText != null && this.ramVideoColor != null) {
            byte[] byArray = this.fontBytes8x8;
            int n4 = 0;
            int n5 = 8;
            int n6 = 10;
            int n7 = 80;
            int n8 = 1920;
            if (this.mode64x32) {
                byArray = this.fontBytes8x6;
                n5 = 6;
                n6 = 8;
                n7 = 64;
                n8 = 2048;
                if (this.altFontSelected && byArray != null && byArray.length > 2048) {
                    n4 = 2048;
                }
            } else {
                n2 -= 8;
            }
            if (n2 >= 0 && byArray != null) {
                int n9;
                int n10 = n2 % n6;
                int n11 = n2 / n6;
                int n12 = n / n5;
                if (n10 >= 8 && this.fillPixLines8And9) {
                    n10 -= 8;
                    n4 = 2048;
                }
                if ((n9 = n11 * n7 + n12) >= 0 && n9 < n8) {
                    if (n9 < this.ramVideoText.length) {
                        n3 = this.ramVideoColor[n9] & 0xFF;
                    }
                    if (n10 < 8) {
                        int n13;
                        int n14 = 0;
                        if (n9 < this.ramVideoText.length) {
                            n14 = this.ramVideoText[n9] & 0xFF;
                        }
                        if ((n13 = n14 * 8 + n10) >= 0 && n13 < byArray.length) {
                            int n15 = 128;
                            int n16 = n % n5;
                            if (n16 > 0) {
                                n15 >>= n16;
                            }
                            if ((byArray[n13] & n15) == 0) {
                                n3 >>= 4;
                            }
                        }
                    } else {
                        n3 >>= 4;
                    }
                    n3 &= 0xF;
                }
            }
        } else if (this.fontBytes8x8 != null) {
            int n17;
            int n18;
            int n19;
            int n20 = 10;
            int n21 = 80;
            int n22 = 1920;
            switch (this.graphicHW) {
                case Video2_64x32: {
                    n20 = 8;
                    n21 = 64;
                    n22 = 2048;
                    break;
                }
                case Video3_80x25: {
                    n22 = 2000;
                }
            }
            int n23 = n2 % n20;
            int n24 = n2 / n20;
            int n25 = n / 8;
            if (n23 < 8 && (n19 = n24 * n21 + n25) >= 0 && n19 < n22 && (n18 = (n17 = this.emuThread.getRAMByte(n19 + 63488)) * 8 + n23) >= 0 && n18 < this.fontBytes8x8.length) {
                int n26 = 128;
                int n27 = n % 8;
                if (n27 > 0) {
                    n26 >>= n27;
                }
                if ((this.fontBytes8x8[n18] & n26) != 0) {
                    n3 = 1;
                }
            }
        }
        return n3;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        CharRaster charRaster = null;
        switch (this.graphicHW) {
            case Video2_64x32: {
                charRaster = new CharRaster(64, 32, 8, 8, 8, 0);
                break;
            }
            case Video3_80x24: {
                charRaster = new CharRaster(80, 24, 10, 8, 8, 0);
                break;
            }
            case Poppe_64x32_80x24: {
                charRaster = this.mode64x32 ? new CharRaster(64, 32, 8, 8, 6, 0) : new CharRaster(80, 24, 10, 8, 8, 8);
            }
        }
        return charRaster != null ? charRaster : new CharRaster(80, 25, 10, 8, 8, 0);
    }

    @Override
    public FloppyDiskFormat getDefaultFloppyDiskFormat() {
        return FloppyDiskFormat.FMT_780K;
    }

    @Override
    public int getDefaultPromptAfterResetMillisMax() {
        return 2000;
    }

    @Override
    protected long getDelayMillisAfterPasteChar() {
        return 80L;
    }

    @Override
    protected long getDelayMillisAfterPasteEnter() {
        return 200L;
    }

    @Override
    protected long getHoldMillisPasteChar() {
        return 80L;
    }

    @Override
    public String getHelpPage() {
        return "/help/nanos.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2 = 255;
        if (this.bootMemEnabled && (n &= 0xFFFF) < 5120) {
            int n3;
            if (n < 4096 && this.romBytes != null && n < this.romBytes.length) {
                n2 = this.romBytes[n] & 0xFF;
            }
            if (n >= 4096 && n < 5120 && (n3 = n - 4096) < this.ram1000.length) {
                n2 = this.ram1000[n3] & 0xFF;
            }
        } else if (n >= 63488 && this.ramVideoText != null && this.ramVideoColor != null) {
            int n4 = n - 63488;
            if (this.colorRamSelected) {
                if (n4 < this.ramVideoColor.length) {
                    n2 = this.ramVideoColor[n4] & 0xFF;
                }
            } else if (n4 < this.ramVideoText.length) {
                n2 = this.ramVideoText[n4] & 0xFF;
            }
        } else if (this.ram256kEnabled && this.ram256kReadable) {
            if (n >= 63232 && n < 63488) {
                int n5 = this.ram256kRFBaseAddr | n - 63232 & 0xFF;
                if (n5 < this.ram256k.length) {
                    n2 = this.ram256k[n5] & 0xFF;
                }
            } else {
                int n6 = this.ram256kMemBaseAddr | n;
                if (n6 < this.ram256k.length) {
                    n2 = this.ram256k[n6] & 0xFF;
                }
            }
        }
        return n2;
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        switch (this.graphicHW) {
            case Video2_64x32: {
                n4 = 64;
                n5 = 32;
                break;
            }
            case Video3_80x24: {
                n4 = 80;
                n5 = 24;
                break;
            }
            case Video3_80x25: {
                n4 = 80;
                n5 = 25;
                break;
            }
            case Poppe_64x32_80x24: {
                if (this.mode64x32) {
                    n4 = 64;
                    n5 = 32;
                    break;
                }
                n4 = 80;
                n5 = 24;
            }
        }
        if (n >= 0 && n < n4 && n2 >= 0 && n2 < n5) {
            int n6 = 0;
            int n7 = n2 * n4 + n;
            if (this.ramVideoText != null) {
                if (n7 < this.ramVideoText.length) {
                    n6 = this.ramVideoText[n7] & 0xFF;
                }
            } else {
                n6 = this.emuThread.getRAMByte(63488 + n7);
            }
            if (this.fontBytes8x8 == fontNanos) {
                switch (n6) {
                    case 92: {
                        n3 = 632;
                        break;
                    }
                    case 94: {
                        n3 = 172;
                        break;
                    }
                    case 96: {
                        n3 = 92;
                        break;
                    }
                    default: {
                        if (n6 < 32 || n6 >= 127) break;
                        n3 = n6;
                    }
                }
            }
        }
        return n3;
    }

    @Override
    public int getScreenHeight() {
        int n = 0;
        switch (this.graphicHW) {
            case Video2_64x32: 
            case Poppe_64x32_80x24: {
                n = 256;
                break;
            }
            case Video3_80x24: {
                n = 240;
                break;
            }
            case Video3_80x25: {
                n = 250;
            }
        }
        return n;
    }

    @Override
    public int getScreenWidth() {
        int n = 640;
        switch (this.graphicHW) {
            case Video2_64x32: {
                n = 512;
                break;
            }
            case Poppe_64x32_80x24: {
                if (!this.mode64x32) break;
                n = 384;
            }
        }
        return n;
    }

    @Override
    public FloppyDiskInfo[] getSuitableFloppyDisks() {
        FloppyDiskInfo[] floppyDiskInfoArray = null;
        if (this.romBytes == romEpos && this.keyboardHW == KeyboardHW.PIO00A_BIT7) {
            if (this.graphicHW == GraphicHW.Video2_64x32) {
                floppyDiskInfoArray = new FloppyDiskInfo[]{epos20Disk64x32};
            } else if (this.graphicHW == GraphicHW.Video3_80x24) {
                floppyDiskInfoArray = new FloppyDiskInfo[]{epos20Disk80x24};
            } else if (this.graphicHW == GraphicHW.Poppe_64x32_80x24) {
                floppyDiskInfoArray = new FloppyDiskInfo[]{epos20Disk64x32, epos20Disk80x24};
            }
        } else if (this.romBytes == romNanos && this.keyboardHW == KeyboardHW.PIO00A_HS && this.graphicHW == GraphicHW.Video3_80x25) {
            floppyDiskInfoArray = new FloppyDiskInfo[]{nanos22Disk80x25};
        }
        return floppyDiskInfoArray;
    }

    @Override
    public int getSupportedFloppyDiskDriveCount() {
        return this.fdDrives.length;
    }

    @Override
    public boolean getSwapKeyCharCase() {
        return this.swapKeyCharCase;
    }

    @Override
    public String getTitle() {
        return SYSNAME;
    }

    @Override
    protected VDIP getVDIP() {
        return this.vdip;
    }

    @Override
    public boolean isPastingText() {
        return this.keyboardHW == KeyboardHW.PIO00A_HS ? this.pasteIter != null : super.isPastingText();
    }

    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n2 = 0;
        switch (n) {
            case 8: 
            case 37: {
                n2 = 8;
                break;
            }
            case 39: {
                n2 = 9;
                break;
            }
            case 40: {
                n2 = 10;
                break;
            }
            case 38: {
                n2 = 11;
                break;
            }
            case 10: {
                n2 = 13;
                break;
            }
            case 32: {
                n2 = 32;
                break;
            }
            case 127: {
                n2 = 127;
            }
        }
        if (n2 > 0) {
            bl3 = this.keyTyped((char)n2);
        }
        return bl3;
    }

    @Override
    public void keyReleased() {
        this.putKeyChar('\u0000');
    }

    @Override
    public boolean keyTyped(char c) {
        return this.putKeyChar(c);
    }

    @Override
    protected boolean pasteChar(char c) throws InterruptedException {
        boolean bl = false;
        if (this.keyboardHW == KeyboardHW.PIO00A_HS) {
            if (c == '\n') {
                c = (char)13;
            }
            if (c > '\u0000' && c < '\u007f') {
                while (!this.pio00.isReadyPortA()) {
                    Thread.sleep(50L);
                }
                bl = this.putKeyChar(c);
            }
        } else if (this.keyboardHW == KeyboardHW.SIO84A) {
            if (c == '\n') {
                c = (char)13;
            }
            if (c > '\u0000' && c < '\u00ff') {
                while (!this.sio84.isReadyReceiverA()) {
                    Thread.sleep(50L);
                }
                bl = this.putKeyChar(c);
            }
        } else {
            bl = super.pasteChar(c);
        }
        return bl;
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        if (this.kcNet != null && ((n &= 0xFF) & 0xFC) == 128) {
            n3 = this.kcNet.read(n);
        } else if (this.vdip != null && (n & 0xFC) == 136) {
            n3 = this.vdip.read(n);
        } else if (this.gide != null && (n & 0xF0) == 208) {
            int n4 = this.gide.read(n);
            if (n4 >= 0) {
                n3 = n4;
            }
        } else if (n < 128) {
            switch (n & 3) {
                case 0: {
                    n3 = this.pio00.readDataA();
                    break;
                }
                case 1: {
                    n3 = this.pio00.readDataB();
                    break;
                }
                case 2: {
                    n3 = this.pio00.readControlA();
                    break;
                }
                case 3: {
                    n3 = this.pio00.readControlB();
                }
            }
        } else {
            switch (n) {
                case 128: {
                    if (this.pio80 == null) break;
                    n3 = this.pio80.readDataA();
                    break;
                }
                case 129: {
                    if (this.pio80 == null) break;
                    n3 = this.pio80.readDataB();
                    break;
                }
                case 130: {
                    if (this.pio80 == null) break;
                    n3 = this.pio80.readControlA();
                    break;
                }
                case 131: {
                    if (this.pio80 == null) break;
                    n3 = this.pio80.readControlB();
                    break;
                }
                case 132: {
                    n3 = this.sio84.readDataA();
                    break;
                }
                case 133: {
                    n3 = this.sio84.readDataB();
                    break;
                }
                case 134: {
                    n3 = this.sio84.readControlA();
                    break;
                }
                case 135: {
                    n3 = this.sio84.readControlB();
                    break;
                }
                case 136: {
                    if (this.pio88 == null) break;
                    n3 = this.pio88.readDataA();
                    break;
                }
                case 137: {
                    if (this.pio88 == null) break;
                    n3 = this.pio88.readDataB();
                    break;
                }
                case 138: {
                    if (this.pio88 == null) break;
                    n3 = this.pio88.readControlA();
                    break;
                }
                case 139: {
                    if (this.pio88 == null) break;
                    n3 = this.pio88.readControlB();
                    break;
                }
                case 140: 
                case 141: 
                case 142: 
                case 143: {
                    n3 = this.ctc8C.read(n & 3, n2);
                    break;
                }
                case 148: {
                    n3 = this.fdc.readMainStatusReg();
                    break;
                }
                case 149: {
                    n3 = this.fdc.readData();
                    break;
                }
                case 242: {
                    if (this.graphicHW != GraphicHW.Poppe_64x32_80x24) break;
                    n3 = 240;
                    if (this.colorRamSelected) {
                        n3 |= 1;
                    }
                    if (!this.mode64x32) {
                        n3 |= 2;
                    }
                    if (this.fillPixLines8And9) {
                        n3 |= 4;
                    }
                    if (!this.altFontSelected) break;
                    n3 |= 8;
                }
            }
        }
        return n3;
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            if (this.isReloadExtROMsOnPowerOnEnabled(properties)) {
                this.loadROMs(properties);
            }
            this.initSRAM(this.ram1000, properties);
            Arrays.fill(this.ram256k, (byte)-1);
            if (this.ramVideoText != null) {
                this.fillRandom(this.ramVideoText);
            }
            if (this.ramVideoColor != null) {
                this.fillRandom(this.ramVideoColor);
            }
        }
        this.fdc.reset(resetLevel == EmuThread.ResetLevel.POWER_ON);
        boolean bl = resetLevel == EmuThread.ResetLevel.POWER_ON || resetLevel == EmuThread.ResetLevel.COLD_RESET;
        this.pio00.reset(bl);
        if (this.pio80 != null) {
            this.pio80.reset(bl);
        }
        this.sio84.reset(bl);
        this.sio84.setClearToSendA(true);
        this.sio84.setClearToSendB(true);
        if (this.pio88 != null) {
            this.pio88.reset(bl);
        }
        this.ctc8C.reset(bl);
        if (this.gide != null) {
            this.gide.reset();
        }
        this.setFDCSpeed(false);
        this.fdcTC = false;
        for (int i = 0; i < this.fdDrives.length; ++i) {
            FloppyDiskDrive floppyDiskDrive = this.fdDrives[i];
            if (floppyDiskDrive == null) continue;
            floppyDiskDrive.reset();
        }
        switch (this.graphicHW) {
            case Video2_64x32: 
            case Poppe_64x32_80x24: {
                this.setMode64x32(true);
                break;
            }
            case Video3_80x25: 
            case Video3_80x24: {
                this.setMode64x32(false);
            }
        }
        this.altFontSelected = false;
        this.colorRamSelected = false;
        this.fillPixLines8And9 = false;
        this.tapeInPhase = this.emuThread.readTapeInPhase();
        this.bootMemEnabled = true;
        this.ram256kEnabled = false;
        this.ram256kReadable = false;
        this.ram256kMemBaseAddr = 0;
        this.ram256kRFBaseAddr = 0;
        this.pasteTStates = 0L;
        this.pio00.putInValuePortA(0, 255);
    }

    @Override
    public void setFloppyDiskDrive(int n, FloppyDiskDrive floppyDiskDrive) {
        if (this.fdDrives != null && n >= 0 && n < this.fdDrives.length) {
            this.fdDrives[n] = floppyDiskDrive;
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        int n3;
        boolean bl = false;
        if (this.bootMemEnabled && (n &= 0xFFFF) >= 4096 && n < 5120) {
            n3 = n - 4096;
            if (n3 < this.ram1000.length) {
                this.ram1000[n3] = (byte)n2;
            }
            bl = true;
        }
        if (this.ram256kEnabled) {
            if (n >= 63232 && n < 63488) {
                n3 = this.ram256kRFBaseAddr | n - 63232 & 0xFF;
                if (n3 < this.ram256k.length) {
                    this.ram256k[n3] = (byte)n2;
                }
            } else {
                n3 = this.ram256kMemBaseAddr | n;
                if (n3 < this.ram256k.length) {
                    this.ram256k[n3] = (byte)n2;
                }
            }
            bl = true;
        }
        if (n >= 63488) {
            n3 = 0;
            if (this.graphicHW == GraphicHW.Poppe_64x32_80x24 && this.ramVideoText != null && this.ramVideoColor != null) {
                int n4 = n - 63488;
                if (this.colorRamSelected) {
                    if (n4 < this.ramVideoColor.length) {
                        this.ramVideoColor[n4] = (byte)n2;
                        n3 = 1;
                    }
                } else if (n4 < this.ramVideoText.length) {
                    this.ramVideoText[n4] = (byte)n2;
                    n3 = 1;
                }
            }
            if (n3 == 0) {
                this.emuThread.setRAMByte(n, n2);
            }
            this.screenFrm.setScreenDirty(true);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean shouldAskConvertScreenChar() {
        return this.fontBytes8x8 != fontNanos;
    }

    @Override
    public synchronized void startPastingText(String string) {
        if (this.keyboardHW == KeyboardHW.PIO00A_HS) {
            boolean bl = false;
            if (string != null && !string.isEmpty()) {
                this.cancelPastingText();
                StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
                if (this.pio00.isReadyPortA()) {
                    if (this.putKeyChar(stringCharacterIterator.first())) {
                        this.pasteIter = stringCharacterIterator;
                        bl = true;
                    } else {
                        this.fireShowCharNotPasted(stringCharacterIterator);
                    }
                } else {
                    bl = true;
                }
            }
            if (!bl) {
                this.screenFrm.firePastingTextFinished();
            }
        } else {
            super.startPastingText(string);
        }
    }

    @Override
    public boolean supportsPrinter() {
        return true;
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return true;
    }

    @Override
    public boolean supportsTapeIn() {
        return true;
    }

    @Override
    public boolean supportsTapeOut() {
        return true;
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        if (this.kcNet != null && ((n &= 0xFF) & 0xFC) == 128) {
            this.kcNet.write(n, n2);
        } else if (this.vdip != null && (n & 0xFC) == 136) {
            this.vdip.write(n, n2);
        } else if (this.gide != null && (n & 0xF0) == 208) {
            this.gide.write(n, n2);
        } else if (n < 128) {
            switch (n & 3) {
                case 0: {
                    this.pio00.writeDataA(n2);
                    break;
                }
                case 1: {
                    this.pio00.writeDataB(n2);
                    int n4 = this.pio00.fetchOutValuePortB(false);
                    this.bootMemEnabled = (n4 & 0x80) != 0;
                    this.tapeOutPhase = (n4 & 0x40) != 0;
                    break;
                }
                case 2: {
                    this.pio00.writeControlA(n2);
                    break;
                }
                case 3: {
                    this.pio00.writeControlB(n2);
                }
            }
        } else {
            switch (n) {
                case 192: {
                    this.ram256kRFBaseAddr = this.ram256kRFBaseAddr & 0x30000 | n2 << 8 & 0xFF00;
                    break;
                }
                case 194: {
                    this.ram256kMemBaseAddr = n2 << 12 & 0x30000;
                    this.ram256kRFBaseAddr = this.ram256kRFBaseAddr & 0xFF00 | n2 << 10 & 0x30000;
                    break;
                }
                case 196: {
                    this.ram256kEnabled = false;
                    break;
                }
                case 197: {
                    this.ram256kEnabled = true;
                    break;
                }
                case 198: {
                    this.ram256kReadable = false;
                    break;
                }
                case 199: {
                    this.ram256kReadable = true;
                    break;
                }
                case 128: {
                    if (this.pio80 == null) break;
                    this.pio80.writeDataA(n2);
                    break;
                }
                case 129: {
                    if (this.pio80 == null) break;
                    this.pio80.writeDataB(n2);
                    break;
                }
                case 130: {
                    if (this.pio80 == null) break;
                    this.pio80.writeControlA(n2);
                    break;
                }
                case 131: {
                    if (this.pio80 == null) break;
                    this.pio80.writeControlB(n2);
                    break;
                }
                case 132: {
                    this.sio84.writeDataA(n2);
                    break;
                }
                case 133: {
                    this.sio84.writeDataB(n2);
                    break;
                }
                case 134: {
                    this.sio84.writeControlA(n2);
                    break;
                }
                case 135: {
                    this.sio84.writeControlB(n2);
                    break;
                }
                case 136: {
                    if (this.pio88 == null) break;
                    this.pio88.writeDataA(n2);
                    break;
                }
                case 137: {
                    if (this.pio88 == null) break;
                    this.pio88.writeDataB(n2);
                    break;
                }
                case 138: {
                    if (this.pio88 == null) break;
                    this.pio88.writeControlA(n2);
                    break;
                }
                case 139: {
                    if (this.pio88 == null) break;
                    this.pio88.writeControlB(n2);
                    break;
                }
                case 140: 
                case 141: 
                case 142: 
                case 143: {
                    this.ctc8C.write(n & 3, n2, n3);
                    break;
                }
                case 146: {
                    boolean bl;
                    this.setFDCSpeed((n2 & 1) != 0);
                    boolean bl2 = bl = (n2 & 2) != 0;
                    if (bl && bl != this.fdcTC) {
                        this.fdc.fireTC();
                    }
                    this.fdcTC = bl;
                    break;
                }
                case 149: {
                    this.fdc.write(n2);
                    break;
                }
                case 241: {
                    if (this.graphicHW != GraphicHW.Poppe_64x32_80x24) break;
                    this.altFontSelected = (n2 & 8) != 0;
                    this.fillPixLines8And9 = (n2 & 4) != 0;
                    this.setMode64x32((n2 & 2) == 0);
                    break;
                }
                case 242: {
                    if (this.graphicHW != GraphicHW.Poppe_64x32_80x24) break;
                    this.colorRamSelected = (n2 & 1) != 0;
                }
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        if (this.kcNet != null) {
            this.kcNet.z80MaxSpeedChanged(z80CPU);
        }
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        boolean bl = this.emuThread.readTapeInPhase();
        if (bl != this.tapeInPhase) {
            this.tapeInPhase = bl;
            this.pio00.putInValuePortB(this.tapeInPhase ? 32 : 0, 32);
        }
        this.ctc8C.z80TStatesProcessed(z80CPU, n);
        this.fdc.z80TStatesProcessed(z80CPU, n);
        if (this.kcNet != null) {
            this.kcNet.z80TStatesProcessed(z80CPU, n);
        }
        if (this.keyboardHW == KeyboardHW.PIO00A_HS && this.pasteTStates > 0L) {
            CharacterIterator characterIterator;
            this.pasteTStates -= (long)n;
            if (this.pasteTStates <= 0L && (characterIterator = this.pasteIter) != null) {
                char c = characterIterator.next();
                if (c == '\uffff') {
                    this.cancelPastingText();
                } else if (!this.putKeyChar(c)) {
                    this.cancelPastingText();
                    this.fireShowCharNotPasted(characterIterator);
                }
            }
        }
    }

    private void applyKeyboardSettings(Properties properties) {
        switch (EmuUtil.getProperty(properties, this.propPrefix + PROP_KEYBOARD)) {
            case "pio00a_bit7": {
                this.keyboardHW = KeyboardHW.PIO00A_BIT7;
                break;
            }
            case "sio84a": {
                this.keyboardHW = KeyboardHW.SIO84A;
                break;
            }
            default: {
                this.keyboardHW = KeyboardHW.PIO00A_HS;
            }
        }
        this.swapKeyCharCase = EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_KEYBOARD_SWAP_CASE, false);
    }

    private boolean emulatesKCNet(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "kcnet.enabled", false);
    }

    private boolean emulatesUSB(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "vdip.enabled", false);
    }

    private GraphicHW getGraphicHW(Properties properties) {
        GraphicHW graphicHW = GraphicHW.Video3_80x25;
        switch (EmuUtil.getProperty(properties, this.propPrefix + PROP_GRAPHIC)) {
            case "64x32": {
                graphicHW = GraphicHW.Video2_64x32;
                break;
            }
            case "80x24": {
                graphicHW = GraphicHW.Video3_80x24;
                break;
            }
            case "poppe": {
                graphicHW = GraphicHW.Poppe_64x32_80x24;
            }
        }
        return graphicHW;
    }

    private KeyboardHW getKeyboardHW(Properties properties) {
        return EmuUtil.getProperty(properties, this.propPrefix + PROP_KEYBOARD).equals(VALUE_KEYBOARD_PIO00A_BIT7) ? KeyboardHW.PIO00A_BIT7 : KeyboardHW.PIO00A_HS;
    }

    private byte[] getNanosFontBytes() {
        if (fontNanos == null) {
            fontNanos = this.readResource("/rom/nanos/nanosfont.bin");
        }
        return fontNanos;
    }

    private void loadFonts(Properties properties) {
        this.fontBytes8x8 = this.readFontByProperty(properties, this.propPrefix + PROP_FONT_8X8_PREFIX + "file", 4096);
        if (this.fontBytes8x8 == null) {
            this.fontBytes8x8 = this.getNanosFontBytes();
        }
        if (this.graphicHW == GraphicHW.Poppe_64x32_80x24) {
            this.fontBytes8x6 = this.readFontByProperty(properties, this.propPrefix + PROP_FONT_8X6_PREFIX + "file", 4096);
            if (this.fontBytes8x6 == null) {
                this.fontBytes8x6 = this.getNanosFontBytes();
            }
        }
    }

    private void loadROMs(Properties properties) {
        this.romProp = EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM);
        String string = this.romProp.toLowerCase();
        if (this.romProp.length() > "file:".length() && string.startsWith("file:")) {
            this.romBytes = this.readROMFile(this.romProp.substring(5), 4096, "ROM-Inhalt");
        }
        if (this.romBytes == null && string.equalsIgnoreCase(VALUE_EPOS)) {
            if (romEpos == null) {
                romEpos = this.readResource("/rom/nanos/eposrom.bin");
            }
            this.romBytes = romEpos;
        }
        if (this.romBytes == null) {
            if (romNanos == null) {
                romNanos = this.readResource("/rom/nanos/nanosrom.bin");
            }
            this.romBytes = romNanos;
        }
        this.loadFonts(properties);
    }

    private boolean putKeyChar(char c) {
        boolean bl = false;
        if (this.fontBytes8x8 == fontNanos) {
            switch (c) {
                case '\u0278': {
                    c = (char)124;
                    break;
                }
                case '\u00ac': {
                    c = (char)126;
                    break;
                }
                case '\\': {
                    c = (char)96;
                }
            }
        }
        switch (this.keyboardHW) {
            case PIO00A_HS: {
                if (c <= '\u0000' || c > '\u00ff') break;
                this.pio00.putInValuePortA((int)TextUtil.toReverseCase(c), true);
                bl = true;
                break;
            }
            case PIO00A_BIT7: {
                if (c == '\u0000') {
                    this.pio00.putInValuePortA(0, 255);
                    bl = true;
                    break;
                }
                if (c <= '\u0000' || c > '\u007f') break;
                this.pio00.putInValuePortA(c | 0x80, 255);
                bl = true;
                break;
            }
            case SIO84A: {
                if (c <= '\u0000' || c > '\u00ff') break;
                this.sio84.putToReceiverA(TextUtil.toReverseCase(c));
                bl = true;
            }
        }
        return bl;
    }

    private void setFDCSpeed(boolean bl) {
        this.fdc.setTStatesPerMilli(bl ? 4000 : 8000);
    }

    private void setMode64x32(boolean bl) {
        boolean bl2 = this.mode64x32;
        this.mode64x32 = bl;
        if (this.mode64x32 != bl2) {
            this.screenFrm.fireScreenSizeChanged();
        }
    }

    private static enum KeyboardHW {
        PIO00A_HS,
        PIO00A_BIT7,
        SIO84A;

    }

    private static enum GraphicHW {
        Video2_64x32,
        Video3_80x24,
        Video3_80x25,
        Poppe_64x32_80x24;

    }
}

