/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.RAMFloppy;
import jkcemu.base.SaveDlg;
import jkcemu.base.SourceUtil;
import jkcemu.disk.FDC8272;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.disk.FloppyDiskFormat;
import jkcemu.disk.GIDE;
import jkcemu.emusys.ac1_llc2.AbstractSCCHSys;
import jkcemu.etc.VDIP;
import jkcemu.net.KCNet;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80CTCListener;
import z80emu.Z80InterruptSource;
import z80emu.Z80PIO;

public class LLC2
extends AbstractSCCHSys
implements FDC8272.DriveSelector,
Z80CTCListener {
    public static final String SYSNAME = "LLC2";
    public static final String PROP_PREFIX = "jkcemu.llc2.";
    public static final String PROP_SCREEN_RATIO = "screen.ratio";
    public static final String VALUE_SCREEN_RATIO_43 = "4:3";
    public static final String VALUE_SCREEN_RATIO_UNSCALED = "unscaled";
    public static final int FUNCTION_KEY_COUNT = 2;
    public static final boolean DEFAULT_SWAP_KEY_CHAR_CASE = true;
    private static int V24_TSTATES_PER_BIT_INTERN = 337;
    private static int V24_TSTATES_PER_BIT_EXTERN = 312;
    private static byte[] llc2Font = null;
    private static byte[] scchMon91 = null;
    private Z80CTC ctc;
    private Z80PIO pio2;
    private GIDE gide;
    private FDC8272 fdc;
    private RAMFloppy ramFloppy1;
    private RAMFloppy ramFloppy2;
    private BufferedImage screenImg = null;
    private byte[] screenBuf = new byte[16384];
    private byte[] fontBytes;
    private byte[] osBytes = null;
    private String osFile = null;
    private boolean osRomEnabled;
    private boolean bit7InverseMode;
    private boolean screenInverseMode;
    private boolean loudspeakerEnabled;
    private boolean tapeInPhase;
    private boolean keyboardUsed;
    private volatile boolean graphicKeyState;
    private boolean hiRes;
    private int fontOffset;
    private int videoPixelAddr;
    private int videoTextAddr;
    private volatile int tStatesPerLine;
    private int lineTStateCounter;
    private int lineCounter;
    private FloppyDiskDrive curFDDrive;
    private FloppyDiskDrive[] fdDrives;
    private KCNet kcNet;
    private VDIP vdip;

    public LLC2(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        this.pasteFast = false;
        this.ramModule3 = this.emuThread.getExtendedRAM(0x100000);
        this.ramFloppy1 = RAMFloppy.prepare(this.emuThread.getRAMFloppy1(), SYSNAME, RAMFloppy.RFType.MP_3_1988, "RAM-Floppy an E/A-Adressen D0h-D7h", properties, this.propPrefix + "ramfloppy.1.");
        this.ramFloppy2 = RAMFloppy.prepare(this.emuThread.getRAMFloppy2(), SYSNAME, RAMFloppy.RFType.MP_3_1988, "RAM-Floppy an E/A-Adressen B0h-B7h", properties, this.propPrefix + "ramfloppy.2.");
        this.curFDDrive = null;
        this.fdDrives = null;
        this.fdc = null;
        if (this.emulatesFloppyDisk(properties)) {
            this.fdDrives = new FloppyDiskDrive[4];
            Arrays.fill(this.fdDrives, null);
            this.fdc = new FDC8272(this, 4);
        }
        this.ctc = new Z80CTC("CTC (E/A-Adressen F8-FB)");
        this.pio1 = new Z80PIO("PIO (E/A-Adressen E8-EB)");
        this.pio2 = new Z80PIO("V24-PIO (E/A-Adressen E4-E7)");
        this.kcNet = null;
        if (this.emulatesKCNet(properties)) {
            this.kcNet = new KCNet("Netzwerk-PIO (E/A-Adressen C0-C3)");
        }
        this.vdip = null;
        if (this.emulatesUSB(properties)) {
            this.vdip = new VDIP(this.emuThread.getFileTimesViewFactory(), "USB-PIO (E/A-Adressen DC-DF, FC-FF)");
            this.vdip.applySettings(properties);
        }
        this.gide = GIDE.getGIDE(this.screenFrm, properties, this.propPrefix);
        ArrayList<Z80InterruptSource> arrayList = new ArrayList<Z80InterruptSource>();
        arrayList.add(this.ctc);
        arrayList.add(this.pio1);
        arrayList.add(this.pio2);
        if (this.kcNet != null) {
            arrayList.add(this.kcNet);
        }
        if (this.vdip != null) {
            arrayList.add(this.vdip);
        }
        Z80CPU z80CPU = emuThread.getZ80CPU();
        try {
            z80CPU.setInterruptSources(arrayList.toArray(new Z80InterruptSource[arrayList.size()]));
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        this.ctc.setTimerConnection(1, 3);
        this.ctc.addCTCListener(this);
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
        this.z80MaxSpeedChanged(z80CPU);
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
        this.checkAddPCListener(properties);
        this.updScreenRatio(properties);
    }

    public static int getDefaultSpeedKHz() {
        return 3000;
    }

    protected void loadROMs(Properties properties) {
        super.loadROMs(properties, "/rom/llc2/gsbasic.bin");
        this.osFile = EmuUtil.getProperty(properties, this.propPrefix + "os.file");
        this.osBytes = this.readROMFile(this.osFile, 4096, "Monitorprogramm");
        if (this.osBytes == null) {
            if (scchMon91 == null) {
                scchMon91 = this.readResource("/rom/llc2/scchmon_91g.bin");
            }
            this.osBytes = scchMon91;
        }
        this.loadFont(properties);
    }

    @Override
    public FloppyDiskDrive getFloppyDiskDrive(int n) {
        return this.curFDDrive;
    }

    @Override
    public void z80CTCUpdate(Z80CTC z80CTC, int n) {
        if (z80CTC == this.ctc && n == 0 && this.loudspeakerEnabled) {
            this.soundOutPhase = !this.soundOutPhase;
        }
    }

    @Override
    public void appendStatusHTMLTo(StringBuilder stringBuilder, Z80CPU z80CPU) {
        stringBuilder.append("<h1>LLC2 Status</h1>\n<table border=\"1\">\n<tr><td>Monitor-ROM:</td><td>");
        EmuUtil.appendOnOffText(stringBuilder, this.osRomEnabled);
        stringBuilder.append("</td></tr>\n<tr><td>ROM-Disk:</td><td>");
        EmuUtil.appendOnOffText(stringBuilder, this.scchRomdiskEnabled);
        stringBuilder.append("</td></tr>\n<tr><td>ROM-Disk Bank:</td><td>");
        stringBuilder.append(this.scchRomdiskBankAddr >> 14 & 0xF);
        stringBuilder.append("</td></tr>\n<tr><td>Programmpaket X ROM:</td><td>");
        EmuUtil.appendOnOffText(stringBuilder, this.scchPrgXRomEnabled);
        stringBuilder.append("</td></tr>\n<tr><td>BASIC-ROM:</td><td>");
        EmuUtil.appendOnOffText(stringBuilder, this.scchBasicRomEnabled);
        stringBuilder.append("</td></tr>\n<tr><td>Grafikmodus:</td><td>");
        stringBuilder.append(this.hiRes ? "HIRES-Vollgrafik" : "Text");
        stringBuilder.append("</td></tr>\n<tr><td>Bildwiederholspeicher:</td><td>");
        if (this.hiRes) {
            stringBuilder.append(String.format("%04Xh-%04Xh", this.videoPixelAddr, this.videoPixelAddr + 16383));
        } else {
            stringBuilder.append(String.format("%04Xh-%04Xh", this.videoTextAddr, this.videoTextAddr + 2047));
        }
        stringBuilder.append("</td></tr>\n</table>\n");
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        this.loadFont(properties);
        this.checkAddPCListener(properties);
        if (this.updScreenRatio(properties)) {
            this.screenFrm.fireScreenSizeChanged();
        }
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
        if (bl) {
            bl = super.canApplySettings(properties);
        }
        if (bl) {
            bl = TextUtil.equals(this.osFile, EmuUtil.getProperty(properties, this.propPrefix + "os.file"));
        }
        if (bl) {
            bl = RAMFloppy.complies(this.ramFloppy1, SYSNAME, RAMFloppy.RFType.MP_3_1988, properties, this.propPrefix + "ramfloppy.1.");
        }
        if (bl) {
            bl = RAMFloppy.complies(this.ramFloppy2, SYSNAME, RAMFloppy.RFType.MP_3_1988, properties, this.propPrefix + "ramfloppy.2.");
        }
        if (bl) {
            bl = GIDE.complies(this.gide, properties, this.propPrefix);
        }
        if (bl && this.emulatesFloppyDisk(properties) != (this.fdc != null)) {
            bl = false;
        }
        if (bl && this.emulatesKCNet(properties) != (this.kcNet != null)) {
            bl = false;
        }
        if (bl && this.emulatesUSB(properties) != (this.vdip != null)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean canExtractScreenText() {
        return !this.hiRes;
    }

    @Override
    public void die() {
        if (this.gide != null) {
            this.gide.die();
        }
        if (this.ramFloppy1 != null) {
            this.ramFloppy1.deinstall();
        }
        if (this.ramFloppy2 != null) {
            this.ramFloppy2.deinstall();
        }
        this.ctc.removeCTCListener(this);
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.setInterruptSources(null);
        if (this.pasteFast) {
            z80CPU.removePCListener(this);
            this.pasteFast = false;
        }
        if (this.fdc != null) {
            this.fdc.die();
        }
        if (this.kcNet != null) {
            this.kcNet.die();
        }
        if (this.vdip != null) {
            this.vdip.die();
        }
    }

    @Override
    public int getAppStartStackInitValue() {
        return 6230;
    }

    @Override
    public int getBorderColorIndex() {
        return this.screenInverseMode ? 1 : 0;
    }

    @Override
    public int getColorIndex(int n, int n2) {
        int n3 = 0;
        if (n == 0 && this.tStatesPerLine <= 1) {
            this.fillScreenBufLine(n2);
        }
        byte by = 0;
        int n4 = n2 * 64 + n / 8;
        if (n4 >= 0 && n4 < this.screenBuf.length) {
            by = this.screenBuf[n4];
        }
        int n5 = 128;
        int n6 = n % 8;
        if (n6 > 0) {
            n5 >>= n6;
        }
        if ((by & n5) != 0) {
            n3 = 1;
        }
        return n3;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        CharRaster charRaster = null;
        if (!this.hiRes) {
            charRaster = this.screenImg != null ? new CharRaster(64, 32, 12, 12, 8, 0) : new CharRaster(64, 32, 8, 8, 8, 0);
        }
        return charRaster;
    }

    @Override
    public FloppyDiskFormat getDefaultFloppyDiskFormat() {
        return FloppyDiskFormat.FMT_400K;
    }

    @Override
    protected long getDelayMillisAfterPasteChar() {
        return 80L;
    }

    @Override
    protected long getDelayMillisAfterPasteEnter() {
        return 200L;
    }

    @Override
    protected long getHoldMillisPasteChar() {
        return 80L;
    }

    @Override
    public String getHelpPage() {
        return "/help/llc2.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2 = this.getScchMemByte(n &= 0xFFFF, bl);
        if (n2 < 0) {
            n2 = 255;
            if (this.osRomEnabled && n < 49152) {
                if (this.osBytes != null && n < this.osBytes.length) {
                    n2 = this.osBytes[n] & 0xFF;
                }
            } else {
                n2 = this.emuThread.getRAMByte(n);
            }
        }
        return n2;
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        int n3;
        int n4;
        int n5 = -1;
        if (!this.hiRes && (n4 = this.videoTextAddr + n2 * 64 + n) >= this.videoTextAddr && n4 < this.videoTextAddr + 2048 && (n3 = this.emuThread.getRAMByte(n4)) < scchCharToUnicode.length) {
            n5 = scchCharToUnicode[n3];
        }
        return n5;
    }

    @Override
    public int getScreenHeight() {
        return this.screenImg != null ? 384 : 256;
    }

    @Override
    public int getScreenWidth() {
        return 512;
    }

    @Override
    public int getSupportedFloppyDiskDriveCount() {
        return this.fdDrives != null ? this.fdDrives.length : 0;
    }

    @Override
    public boolean getSwapKeyCharCase() {
        return true;
    }

    @Override
    public String getTitle() {
        return SYSNAME;
    }

    @Override
    protected VDIP getVDIP() {
        return this.vdip;
    }

    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        switch (n) {
            case 112: {
                this.screenInverseMode = !this.screenInverseMode;
                this.screenFrm.setScreenDirty(true);
                bl3 = true;
                break;
            }
            case 113: {
                this.graphicKeyState = !this.graphicKeyState;
                bl3 = true;
                break;
            }
            default: {
                bl3 = super.keyPressed(n, bl, bl2);
            }
        }
        return bl3;
    }

    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        switch (c) {
            case '\u00f1': {
                this.screenInverseMode = !this.screenInverseMode;
                this.screenFrm.setScreenDirty(true);
                bl = true;
                break;
            }
            case '\u00f2': {
                this.graphicKeyState = !this.graphicKeyState;
                bl = true;
                break;
            }
            default: {
                bl = super.keyTyped(c);
            }
        }
        return bl;
    }

    @Override
    public boolean paintScreen(Graphics graphics, int n, int n2, int n3) {
        boolean bl = false;
        BufferedImage bufferedImage = this.screenImg;
        if (bufferedImage != null) {
            for (int i = 0; i < 512; ++i) {
                for (int j = 0; j < 256; ++j) {
                    bufferedImage.setRGB(i, j, this.getColorIndex(i, j) > 0 ? -1 : -16777216);
                }
            }
            graphics.drawImage(bufferedImage, n, n2, this.getScreenWidth() * n3, this.getScreenHeight() * n3, this);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        if (this.gide != null && (n & 0xF0) == 128) {
            int n4 = this.gide.read(n);
            if (n4 >= 0) {
                n3 = n4;
            }
        } else if ((n & 0xF8) == 208 && this.ramFloppy1 != null) {
            n3 = this.ramFloppy1.readByte(n & 7);
        } else if ((n & 0xF8) == 176 && this.ramFloppy2 != null) {
            n3 = this.ramFloppy2.readByte(n & 7);
        } else {
            switch (n & 0xFF) {
                case 160: {
                    if (this.fdc == null) break;
                    n3 = this.fdc.readMainStatusReg();
                    break;
                }
                case 161: {
                    if (this.fdc == null) break;
                    n3 = this.fdc.readData();
                    break;
                }
                case 162: 
                case 163: {
                    if (this.fdc == null) break;
                    n3 = this.fdc.readDMA();
                    break;
                }
                case 164: 
                case 165: {
                    if (this.fdc == null) break;
                    n3 = 223;
                    FloppyDiskDrive floppyDiskDrive = this.curFDDrive;
                    if (floppyDiskDrive != null && floppyDiskDrive.isReady()) {
                        n3 |= 0x20;
                        if (this.fdc.getIndexHoleState()) {
                            n3 &= 0xFFFFFFEF;
                        }
                    }
                    if (this.fdc.isInterruptRequest()) {
                        n3 &= 0xFFFFFFBF;
                    }
                    if (!this.fdc.isDMARequest()) break;
                    n3 &= 0xFFFFFF7F;
                    break;
                }
                case 168: 
                case 169: {
                    if (this.fdc == null) break;
                    this.fdc.fireTC();
                    break;
                }
                case 192: 
                case 193: 
                case 194: 
                case 195: {
                    if (this.kcNet == null) break;
                    n3 = this.kcNet.read(n);
                    break;
                }
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 252: 
                case 253: 
                case 254: 
                case 255: {
                    if (this.vdip == null) break;
                    n3 = this.vdip.read(n);
                    break;
                }
                case 224: 
                case 225: 
                case 226: 
                case 227: {
                    this.osRomEnabled = false;
                    break;
                }
                case 228: {
                    this.pio2.putInValuePortA(0, 4);
                    n3 = this.pio2.readDataA();
                    break;
                }
                case 229: {
                    n3 = this.pio2.readDataB();
                    break;
                }
                case 230: {
                    n3 = this.pio2.readControlA();
                    break;
                }
                case 231: {
                    n3 = this.pio2.readControlB();
                    break;
                }
                case 232: {
                    Z80PIO z80PIO = this.pio1;
                    synchronized (z80PIO) {
                        if (!(this.keyboardUsed || this.joystickEnabled && this.joystickSelected)) {
                            this.pio1.putInValuePortA(0, 255);
                            this.keyboardUsed = true;
                        }
                    }
                    n3 = this.pio1.readDataA();
                    break;
                }
                case 233: {
                    this.pio1.putInValuePortB(this.graphicKeyState ? 0 : 4, 4);
                    n3 = this.pio1.readDataB();
                    break;
                }
                case 234: {
                    n3 = this.pio1.readControlA();
                    break;
                }
                case 235: {
                    n3 = this.pio1.readControlB();
                    break;
                }
                case 248: 
                case 249: 
                case 250: 
                case 251: {
                    n3 = this.ctc.read(n & 3, n2);
                }
            }
        }
        return n3;
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON && this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
        if (resetLevel == EmuThread.ResetLevel.POWER_ON || resetLevel == EmuThread.ResetLevel.COLD_RESET) {
            this.ctc.reset(true);
            this.pio1.reset(true);
            this.pio2.reset(true);
        } else {
            this.ctc.reset(false);
            this.pio1.reset(false);
            this.pio2.reset(false);
        }
        if (this.gide != null) {
            this.gide.reset();
        }
        if (this.fdc != null) {
            this.fdc.reset(resetLevel == EmuThread.ResetLevel.POWER_ON);
        }
        if (this.fdDrives != null) {
            for (int i = 0; i < this.fdDrives.length; ++i) {
                FloppyDiskDrive floppyDiskDrive = this.fdDrives[i];
                if (floppyDiskDrive == null) continue;
                floppyDiskDrive.reset();
            }
        }
        this.curFDDrive = null;
        this.osRomEnabled = true;
        this.bit7InverseMode = false;
        this.screenInverseMode = false;
        this.loudspeakerEnabled = false;
        this.tapeInPhase = this.emuThread.readTapeInPhase();
        this.keyboardUsed = false;
        this.joystickSelected = false;
        this.graphicKeyState = false;
        this.hiRes = false;
        this.joystickValue = 31;
        this.keyboardValue = 0;
        this.fontOffset = 0;
        this.lineCounter = 0;
        this.lineTStateCounter = 0;
        this.videoPixelAddr = 49152;
        this.videoTextAddr = 49152;
        this.v24TStatesPerBit = this.osBytes == scchMon91 ? V24_TSTATES_PER_BIT_INTERN : V24_TSTATES_PER_BIT_EXTERN;
        this.screenFrm.fireUpdScreenTextActionsEnabled();
    }

    @Override
    public void saveBasicProgram() {
        int n = SourceUtil.getBasicEndAddr(this.emuThread, 24823);
        if (n >= 24823) {
            new SaveDlg(this.screenFrm, 24823, n, "LLC2-BASIC-Programm speichern", SaveDlg.BasicType.MS_DERIVED_BASIC, EmuUtil.getBasicFileFilter()).setVisible(true);
        } else {
            this.showNoBasic();
        }
    }

    @Override
    public void setFloppyDiskDrive(int n, FloppyDiskDrive floppyDiskDrive) {
        if (this.fdDrives != null && n >= 0 && n < this.fdDrives.length) {
            this.fdDrives[n] = floppyDiskDrive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setJoystickAction(int n, int n2) {
        if (this.joystickEnabled && n == 0) {
            int n3 = 31;
            if ((n2 & 4) != 0) {
                n3 &= 0xFFFFFFFE;
            }
            if ((n2 & 8) != 0) {
                n3 &= 0xFFFFFFFD;
            }
            if ((n2 & 1) != 0) {
                n3 &= 0xFFFFFFFB;
            }
            if ((n2 & 2) != 0) {
                n3 &= 0xFFFFFFF7;
            }
            if ((n2 & 0x30) != 0) {
                n3 &= 0xFFFFFFEF;
            }
            this.joystickValue = n3;
            Z80PIO z80PIO = this.pio1;
            synchronized (z80PIO) {
                if (this.joystickSelected) {
                    this.pio1.putInValuePortA(this.joystickValue, 255);
                }
            }
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        boolean bl;
        int n3 = this.setScchMemByte(n &= 0xFFFF, n2);
        boolean bl2 = n3 >= 0;
        boolean bl3 = bl = n3 > 0;
        if (!(bl2 || this.osRomEnabled && n < 49152)) {
            this.emuThread.setRAMByte(n, n2);
            if (this.hiRes) {
                if (n >= this.videoPixelAddr && n < this.videoPixelAddr + 16384) {
                    this.screenFrm.setScreenDirty(true);
                }
            } else if (n >= this.videoTextAddr && n < this.videoTextAddr + 2048) {
                this.screenFrm.setScreenDirty(true);
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean shouldAskConvertScreenChar() {
        return this.fontBytes != llc2Font;
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsPrinter() {
        return true;
    }

    @Override
    public boolean supportsRAMFloppy1() {
        return this.ramFloppy1 != null;
    }

    @Override
    public boolean supportsRAMFloppy2() {
        return this.ramFloppy2 != null;
    }

    @Override
    public boolean supportsSaveBasic() {
        return true;
    }

    @Override
    public boolean supportsSoundOutMono() {
        return true;
    }

    @Override
    public boolean supportsTapeIn() {
        return true;
    }

    @Override
    public boolean supportsTapeOut() {
        return true;
    }

    @Override
    public void updDebugScreen() {
        for (int i = 0; i < 256; ++i) {
            this.fillScreenBufLine(i);
        }
    }

    @Override
    public void updSysCells(int n, int n2, FileFormat fileFormat, int n3) {
        if (fileFormat != null && (fileFormat.equals(FileFormat.BASIC_PRG) && n == 24823 && n2 > 7 || fileFormat.equals(FileFormat.HEADERSAVE) && n3 == 66 && n <= 24823 && n + n2 > 24830)) {
            int n4 = SourceUtil.getBasicEndAddr(this.emuThread, 24823) + 1;
            this.emuThread.setMemWord(24786, n4);
            this.emuThread.setMemWord(24788, n4);
            this.emuThread.setMemWord(24790, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeIOByte(int n, int n2, int n3) {
        if (this.gide != null && (n & 0xF0) == 128) {
            this.gide.write(n, n2);
        } else if ((n & 0xF8) == 208 && this.ramFloppy1 != null) {
            this.ramFloppy1.writeByte(n & 7, n2);
        } else if ((n & 0xF8) == 176 && this.ramFloppy2 != null) {
            this.ramFloppy2.writeByte(n & 7, n2);
        } else {
            boolean bl = false;
            switch (n & 0xFF) {
                case 161: {
                    if (this.fdc == null) break;
                    this.fdc.write(n2);
                    break;
                }
                case 162: 
                case 163: {
                    if (this.fdc == null) break;
                    this.fdc.writeDMA(n2);
                    break;
                }
                case 166: 
                case 167: {
                    if (this.fdDrives == null) break;
                    FloppyDiskDrive floppyDiskDrive = null;
                    int n4 = 1;
                    for (int i = 0; i < this.fdDrives.length; ++i) {
                        if ((n2 & n4) != 0) {
                            floppyDiskDrive = this.fdDrives[i];
                            break;
                        }
                        n4 <<= 1;
                    }
                    this.curFDDrive = floppyDiskDrive;
                    break;
                }
                case 168: 
                case 169: {
                    if (this.fdc == null) break;
                    this.fdc.fireTC();
                    break;
                }
                case 192: 
                case 193: 
                case 194: 
                case 195: {
                    if (this.kcNet == null) break;
                    this.kcNet.write(n, n2);
                    break;
                }
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 252: 
                case 253: 
                case 254: 
                case 255: {
                    if (this.vdip == null) break;
                    this.vdip.write(n, n2);
                    break;
                }
                case 224: 
                case 225: 
                case 226: 
                case 227: {
                    this.osRomEnabled = false;
                    break;
                }
                case 228: {
                    this.pio2.writeDataA(n2);
                    LLC2 lLC2 = this;
                    synchronized (lLC2) {
                        boolean bl2;
                        boolean bl3 = bl2 = (this.pio2.fetchOutValuePortA(false) & 2) != 0;
                        if (!bl2 && this.v24BitOut && this.v24BitNum == 0) {
                            this.v24ShiftBuf = 0;
                            this.v24TStateCounter = 3 * this.v24TStatesPerBit / 2;
                            ++this.v24BitNum;
                        }
                        this.v24BitOut = bl2;
                        break;
                    }
                }
                case 229: {
                    this.pio2.writeDataB(n2);
                    break;
                }
                case 230: {
                    this.pio2.writeControlA(n2);
                    break;
                }
                case 231: {
                    this.pio2.writeControlB(n2);
                    break;
                }
                case 232: {
                    this.pio1.writeDataA(n2);
                    break;
                }
                case 233: {
                    this.pio1.writeDataB(n2);
                    Z80PIO z80PIO = this.pio1;
                    synchronized (z80PIO) {
                        boolean bl4;
                        int n5 = this.pio1.fetchOutValuePortB(false);
                        boolean bl5 = this.tapeOutPhase = (n5 & 1) != 0;
                        if (this.fontBytes != llc2Font && this.fontBytes.length > 2048) {
                            this.fontOffset = (n5 & 8) != 0 ? (this.fontBytes.length > 4096 ? 4096 : 2048) : 0;
                        }
                        boolean bl6 = bl4 = (n5 & 0x20) != 0;
                        if (bl4 != this.bit7InverseMode) {
                            this.bit7InverseMode = bl4;
                            bl = true;
                        }
                        boolean bl7 = bl4 = (n5 & 0x40) != 0;
                        if (bl4 != this.loudspeakerEnabled) {
                            this.loudspeakerEnabled = bl4;
                            boolean bl8 = this.soundOutPhase = !this.soundOutPhase;
                        }
                        if (this.joystickEnabled) {
                            boolean bl9 = bl4 = (n5 & 0x10) == 0;
                            if (bl4 != this.joystickSelected) {
                                this.joystickSelected = bl4;
                                this.pio1.putInValuePortA(bl4 ? this.joystickValue : this.keyboardValue, 255);
                            }
                        }
                        break;
                    }
                }
                case 234: {
                    this.pio1.writeControlA(n2);
                    break;
                }
                case 235: {
                    this.pio1.writeControlB(n2);
                    break;
                }
                case 236: {
                    this.scchPrgXRomEnabled = (n2 & 1) != 0;
                    this.scchBasicRomEnabled = (n2 & 2) != 0;
                    boolean bl10 = this.scchRomdiskEnabled = (n2 & 8) != 0;
                    if (this.scchRomdiskEnabled) {
                        this.scchRomdiskBankAddr = (n2 & 1 | n2 >> 3 & 0xE) << 14;
                        this.scchPrgXRomEnabled = false;
                        break;
                    }
                    this.scchPrgXRomEnabled = (n2 & 1) != 0;
                    break;
                }
                case 237: {
                    this.rfAddr16to19 = n2 << 16 & 0xF0000;
                    this.rf32NegA15 = (n2 & 0x10) != 0;
                    this.rf32KActive = (n2 & 0x20) != 0;
                    this.rfReadEnabled = (n2 & 0x40) != 0;
                    this.rfWriteEnabled = (n2 & 0x80) != 0;
                    break;
                }
                case 238: {
                    boolean bl11;
                    int n6;
                    int n7 = n6 = (n2 & 0x44) == 4 ? 63488 : 49152;
                    if (n6 != this.videoTextAddr) {
                        this.videoTextAddr = n6;
                        bl = true;
                    }
                    switch (n2 & 0x30) {
                        case 0: {
                            n6 = 49152;
                            break;
                        }
                        case 16: {
                            n6 = 32768;
                            break;
                        }
                        case 32: {
                            n6 = 16384;
                            break;
                        }
                        case 24: {
                            n6 = 0;
                        }
                    }
                    if (n6 != this.videoPixelAddr) {
                        this.videoPixelAddr = n6;
                        bl = true;
                    }
                    boolean bl12 = bl11 = (n2 & 0x40) != 0;
                    if (bl11 == this.hiRes) break;
                    this.hiRes = bl11;
                    bl = true;
                    this.screenFrm.fireUpdScreenTextActionsEnabled();
                    break;
                }
                case 248: 
                case 249: 
                case 250: 
                case 251: {
                    this.ctc.write(n & 3, n2, n3);
                }
            }
            if (bl) {
                this.screenFrm.setScreenDirty(true);
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        this.tStatesPerLine = z80CPU.getMaxSpeedKHz() * 20 / 312;
        if (this.fdc != null) {
            this.fdc.z80MaxSpeedChanged(z80CPU);
        }
        if (this.kcNet != null) {
            this.kcNet.z80MaxSpeedChanged(z80CPU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        boolean bl;
        super.z80TStatesProcessed(z80CPU, n);
        this.ctc.z80TStatesProcessed(z80CPU, n);
        if (this.fdc != null) {
            this.fdc.z80TStatesProcessed(z80CPU, n);
        }
        if (this.kcNet != null) {
            this.kcNet.z80TStatesProcessed(z80CPU, n);
        }
        if (this.tStatesPerLine > 0) {
            this.lineTStateCounter += n;
            if (this.lineTStateCounter >= this.tStatesPerLine) {
                this.lineTStateCounter -= this.tStatesPerLine;
                this.fillScreenBufLine(this.lineCounter - 31);
                ++this.lineCounter;
                if (this.lineCounter >= 312) {
                    this.lineCounter = 0;
                    this.ctc.externalUpdate(2, 1);
                    this.screenFrm.setScreenDirty(true);
                }
            }
        }
        if (this.v24BitNum > 0) {
            LLC2 lLC2 = this;
            synchronized (lLC2) {
                this.v24TStateCounter -= n;
                if (this.v24TStateCounter < 0) {
                    if (this.v24BitNum > 8) {
                        this.emuThread.getPrintMngr().putByte(this.v24ShiftBuf);
                        this.v24BitNum = 0;
                    } else {
                        this.v24ShiftBuf >>= 1;
                        if (this.v24BitOut) {
                            this.v24ShiftBuf |= 0x80;
                        }
                        this.v24TStateCounter = this.v24TStatesPerBit;
                        ++this.v24BitNum;
                    }
                }
            }
        }
        if ((bl = this.emuThread.readTapeInPhase()) != this.tapeInPhase) {
            this.tapeInPhase = bl;
            this.pio1.putInValuePortB(this.tapeInPhase ? 2 : 0, 2);
        }
    }

    private void fillScreenBufLine(int n) {
        block13: {
            if (n < 0 || n >= 256) break block13;
            int n2 = n / 8;
            int n3 = n % 8;
            if (this.hiRes) {
                for (int i = 0; i < 64; ++i) {
                    int n4 = this.emuThread.getRAMByte(this.videoPixelAddr + n3 * 2048 + n2 * 64 + i);
                    if (this.screenInverseMode) {
                        n4 ^= 0xFFFFFFFF;
                    }
                    this.screenBuf[n * 64 + i] = (byte)n4;
                }
            } else {
                boolean bl = false;
                byte[] byArray = null;
                if (!this.hiRes) {
                    byArray = this.fontBytes;
                }
                for (int i = 0; i < 64; ++i) {
                    int n5;
                    int n6 = 0;
                    int n7 = this.emuThread.getRAMByte(this.videoTextAddr + n2 * 64 + i);
                    if (n7 == 16) {
                        bl = false;
                    } else if (n7 == 17) {
                        bl = true;
                    }
                    if (byArray != null && (n5 = this.fontOffset + (n7 & (this.bit7InverseMode ? 127 : 255)) * 8 + n3) >= 0 && n5 < byArray.length) {
                        int n8 = 128;
                        byte by = byArray[n5];
                        for (int j = 0; j < 8; ++j) {
                            if ((by & n8) != 0) {
                                n6 |= n8;
                            }
                            n8 >>= 1;
                        }
                    }
                    if ((bl || this.bit7InverseMode && (n7 & 0x80) != 0) != this.screenInverseMode) {
                        n6 ^= 0xFFFFFFFF;
                    }
                    this.screenBuf[n * 64 + i] = (byte)n6;
                }
            }
        }
    }

    private void loadFont(Properties properties) {
        this.fontBytes = this.readFontByProperty(properties, this.propPrefix + "font.file", 8192);
        if (this.fontBytes == null) {
            if (llc2Font == null) {
                llc2Font = this.readResource("/rom/llc2/llc2font.bin");
            }
            this.fontBytes = llc2Font;
        }
    }

    private boolean updScreenRatio(Properties properties) {
        boolean bl = false;
        boolean bl2 = EmuUtil.getProperty(properties, this.propPrefix + PROP_SCREEN_RATIO).equals(VALUE_SCREEN_RATIO_43);
        if (bl2 != (this.screenImg != null)) {
            this.screenImg = bl2 ? new BufferedImage(512, 256, 1) : null;
            bl = true;
        }
        return bl;
    }
}

