/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.CRC32;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.disk.FDC8272;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.disk.FloppyDiskInfo;
import jkcemu.emusys.kccompact.KCcompactKeyboardFld;
import jkcemu.etc.CRTC6845;
import jkcemu.etc.PPI8255;
import jkcemu.etc.PSG8910;
import jkcemu.print.PrintMngr;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80InstrTStatesMngr;
import z80emu.Z80InterruptSource;

public class KCcompact
extends EmuSys
implements CRTC6845.SyncListener,
FDC8272.DriveSelector,
PPI8255.Callback,
PSG8910.Callback,
Z80InstrTStatesMngr,
Z80InterruptSource {
    public static final String SYSNAME = "KCcompact";
    public static final String SYSTEXT = "KC compact";
    public static final String PROP_PREFIX = "jkcemu.kccompact.";
    public static final String PROP_FDC_ROM_PREFIX = "fdc.rom.";
    public static final int DEFAULT_PROMPT_AFTER_RESET_MILLIS_MAX = 1200;
    private static final FloppyDiskInfo[] availableFloppyDisks = new FloppyDiskInfo[]{new FloppyDiskInfo("/disks/kccompact/kccmicrodos.dump.gz", "KC compact MicroDOS Systemdiskette", 2, 2048, true)};
    private static final int[] colorPalette2Idx = new int[]{13, 13, 19, 25, 1, 7, 10, 16, 7, 25, 24, 26, 6, 8, 15, 17, 1, 19, 18, 20, 0, 2, 9, 11, 4, 22, 21, 23, 3, 5, 12, 14};
    private static final int[][] kbMatrixNormal = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1}, {-1, 91, 13, 93, -1, -1, 92, -1}, {-1, 45, 64, 112, 59, 58, 47, 46}, {48, 57, 111, 105, 108, 107, 109, 44}, {56, 55, 117, 121, 104, 106, 110, 32}, {54, 53, 114, 116, 103, 102, 98, 118}, {52, 51, 101, 119, 115, 100, 99, 120}, {49, 50, 27, 113, 9, 97, -1, 122}, {-1, -1, -1, -1, -1, -1, -1, -1}};
    private static final int[][] kbMatrixShift = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1}, {-1, 123, -1, 125, -1, -1, -1, -1}, {-1, 61, 124, 80, 43, 42, 63, 62}, {95, 41, 79, 73, 76, 75, 77, 60}, {40, 39, 85, 89, 72, 74, 78, -1}, {38, 37, 82, 84, 71, 70, 66, 86}, {36, 35, 69, 87, 83, 68, 67, 88}, {33, 34, -1, 81, -1, 65, -1, 90}, {-1, -1, -1, -1, -1, -1, -1, -1}};
    private static final int[][] kbMatrixControl = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, 16, -1, -1, -1, -1}, {-1, -1, 15, 9, 12, 11, 13, -1}, {-1, -1, 21, 25, 8, 10, 14, -1}, {-1, -1, 18, 20, 7, 6, 2, 22}, {-1, -1, 5, 23, 19, 4, 3, 24}, {-1, -1, -1, 17, -1, 1, -1, 26}, {-1, -1, -1, -1, -1, -1, -1, -1}};
    private static final int[] char128ToUnicode = new int[]{-1, 9624, 9629, 9600, 9622, 9612, 9630, 9627, 9623, 9626, 9616, 9628, 9604, 9625, 9631, 9608, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 94, 180, -1, 163, 169, 182, 167, 96, 188, 189, 190, -1, 247, 172, 191, 161, 945, 946, 947, 948, 949, 952, 955, 956, 960, 963, 966, 934, 967, 969, 931, 937, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9671, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9700, 9701, 9698, 9699, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9830, 9829, 9824, -1, -1, -1, -1, 9794, 9792, 9833, 9834, 9728, -1, -1, -1, -1, -1, -1, -1, 9654, 9664};
    private static byte[] romOS = null;
    private static byte[] romBASIC = null;
    private static byte[] romFDC = null;
    private static Map<Long, Character> pixelCRC32ToChar = null;
    private Color[] colors = new Color[27];
    private int[] regColors;
    private int regColorNum;
    private int borderColorIdx;
    private int romSelect;
    private String osFile;
    private String basicFile;
    private String fdcROMFile;
    private byte[] fdcROMBytes;
    private byte[] osBytes;
    private byte[] basicBytes;
    private byte[] screenBuf;
    private byte[] ramExt;
    private int[] ram16KOffs;
    private int[] keyboardMatrix;
    private int keyboardIdx;
    private int keyboardValue;
    private int psgValue;
    private int lineIrqCounter;
    private int joy0ActionMask;
    private int joy1ActionMask;
    private int screenMode;
    private volatile int screenWidth;
    private boolean screenDirty;
    private boolean screenRefreshEnabled;
    private volatile boolean fixedScreenSize;
    private boolean interruptRequested;
    private boolean centronicsStrobe;
    private boolean basicROMEnabled;
    private boolean osROMEnabled;
    private PSG8910 psg;
    private PPI8255 ppi;
    private CRTC6845 crtc;
    private KCcompactKeyboardFld keyboardFld;
    private FDC8272 fdc;
    private FloppyDiskDrive[] floppyDiskDrives;

    public KCcompact(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        this.createColors(properties);
        if (romOS == null) {
            romOS = this.readResource("/rom/kccompact/kccos.bin");
        }
        this.osBytes = null;
        this.osFile = null;
        this.basicBytes = null;
        this.basicFile = null;
        this.fdcROMBytes = null;
        this.fdcROMFile = null;
        this.keyboardFld = null;
        this.fixedScreenSize = this.isFixedScreenSize(properties);
        this.screenMode = 0;
        this.screenWidth = 320;
        this.screenBuf = new byte[128000];
        this.keyboardMatrix = new int[10];
        this.regColors = new int[16];
        Arrays.fill(this.regColors, 0);
        this.ram16KOffs = new int[4];
        this.crtc = new CRTC6845(1000, this);
        this.ppi = new PPI8255(this);
        this.psg = new PSG8910(1000000, 220, this);
        if (this.emulatesFloppyDisk(properties)) {
            this.ramExt = this.emuThread.getExtendedRAM(65536);
            this.fdc = new FDC8272(this, 4);
            this.floppyDiskDrives = new FloppyDiskDrive[2];
            Arrays.fill(this.floppyDiskDrives, null);
        } else {
            this.ramExt = null;
            this.fdc = null;
            this.floppyDiskDrives = null;
        }
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.setInterruptSources(this);
        z80CPU.setInstrTStatesMngr(this);
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        this.z80MaxSpeedChanged(z80CPU);
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
        this.psg.start();
    }

    public static int getDefaultSpeedKHz() {
        return 4000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeyboardMatrix(int[] nArray) {
        int[] nArray2 = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            int n;
            int n2 = Math.min(nArray.length, this.keyboardMatrix.length);
            for (n = 0; n < n2; ++n) {
                this.keyboardMatrix[n] = nArray[n];
            }
            while (n < this.keyboardMatrix.length) {
                this.keyboardMatrix[n] = 0;
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void crtcHSyncBegin(int n, int n2, int n3) {
        if (this.screenRefreshEnabled) {
            int n4 = n * 640;
            if (n4 >= 0 && n4 + 639 < this.screenBuf.length) {
                int n5 = n4 + 640;
                int n6 = n3 << 2 & 0xC000 | n2 << 11 & 0x3800;
                int n7 = n3 << 1 & 0x7FE;
                int n8 = Math.min(this.crtc.getHCharVisible(), 40) * 2;
                switch (this.screenMode) {
                    case 0: {
                        int n9;
                        int n10;
                        int n11;
                        for (n11 = 0; n11 < n8; ++n11) {
                            n10 = this.emuThread.getRAMByte(n6 | n7);
                            n9 = (byte)this.regColors[n10 << 2 & 8 | n10 >> 3 & 4 | n10 >> 2 & 2 | n10 >> 7 & 1];
                            this.screenBuf[n4++] = n9;
                            this.screenBuf[n4++] = n9;
                            n9 = (byte)this.regColors[n10 << 3 & 8 | n10 >> 2 & 4 | n10 >> 1 & 2 | n10 >> 6 & 1];
                            this.screenBuf[n4++] = n9;
                            this.screenBuf[n4++] = n9;
                            n7 = n7 + 1 & 0x7FF;
                        }
                        break;
                    }
                    case 1: {
                        int n10;
                        int n11;
                        for (n11 = 0; n11 < n8; ++n11) {
                            n10 = this.emuThread.getRAMByte(n6 | n7);
                            this.screenBuf[n4++] = (byte)this.regColors[n10 >> 2 & 2 | n10 >> 7 & 1];
                            this.screenBuf[n4++] = (byte)this.regColors[n10 >> 1 & 2 | n10 >> 6 & 1];
                            this.screenBuf[n4++] = (byte)this.regColors[n10 & 2 | n10 >> 5 & 1];
                            this.screenBuf[n4++] = (byte)this.regColors[n10 << 1 & 2 | n10 >> 4 & 1];
                            n7 = n7 + 1 & 0x7FF;
                        }
                        break;
                    }
                    case 2: {
                        int n9;
                        int n10;
                        int n11;
                        for (n11 = 0; n11 < n8; ++n11) {
                            n10 = this.emuThread.getRAMByte(n6 | n7);
                            n9 = 128;
                            for (int i = 0; i < 8; ++i) {
                                this.screenBuf[n4++] = (byte)this.regColors[(n10 & n9) == 0 ? 0 : 1];
                                n9 >>= 1;
                            }
                            n7 = n7 + 1 & 0x7FF;
                        }
                        break;
                    }
                    default: {
                        n8 = 0;
                    }
                }
                while (n4 < n5) {
                    this.screenBuf[n4++] = (byte)this.borderColorIdx;
                }
            }
            this.screenFrm.setScreenDirty(true);
            this.screenFrm.fireRepaint();
        }
    }

    @Override
    public void crtcHSyncEnd() {
        if (this.lineIrqCounter > 0) {
            --this.lineIrqCounter;
            if (this.lineIrqCounter == 0) {
                this.interruptRequested = true;
                this.lineIrqCounter = 52;
            }
        }
    }

    @Override
    public void crtcVSyncBegin() {
        this.lineIrqCounter = 2;
        if (this.screenDirty) {
            this.screenDirty = false;
            this.screenRefreshEnabled = true;
        } else {
            this.screenRefreshEnabled = false;
        }
    }

    @Override
    public void crtcVSyncEnd() {
    }

    @Override
    public FloppyDiskDrive getFloppyDiskDrive(int n) {
        FloppyDiskDrive floppyDiskDrive = null;
        if (this.floppyDiskDrives != null) {
            floppyDiskDrive = this.floppyDiskDrives[n & 1];
        }
        return floppyDiskDrive;
    }

    @Override
    public int ppiReadPort(PPI8255 pPI8255, int n) {
        int n2 = 255;
        if (n == 0) {
            n2 = this.psgValue;
        } else if (n == 1) {
            n2 = 62;
            if (this.fdc != null) {
                n2 &= 0xDF;
            }
            if (this.crtc.isVSync()) {
                n2 |= 1;
            }
            if (this.emuThread.readTapeInPhase()) {
                n2 |= 0x80;
            }
        }
        return n2;
    }

    @Override
    public void ppiWritePort(PPI8255 pPI8255, int n, int n2, boolean bl) {
        if (n == 2) {
            this.keyboardIdx = n2 & 0xF;
            this.tapeOutPhase = (n2 & 0x20) != 0;
            this.psgValue = this.psg.access((n2 & 0x80) != 0, (n2 & 0x40) != 0, true, this.ppi.fetchOutValueA(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int psgReadPort(PSG8910 pSG8910, int n) {
        int n2 = 255;
        if (n != 0) return n2;
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            int n3 = this.keyboardIdx;
            if (n3 < this.keyboardMatrix.length) {
                n2 = ~this.keyboardMatrix[n3] & 0xFF;
            }
            if (n3 == 6) {
                n2 &= ~KCcompact.getJoyKeyboardMask(this.joy1ActionMask);
            } else {
                if (n3 != 9) return n2;
                n2 &= ~KCcompact.getJoyKeyboardMask(this.joy0ActionMask);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return n2;
        }
    }

    @Override
    public void psgWritePort(PSG8910 pSG8910, int n, int n2) {
    }

    @Override
    public void psgWriteFrame(PSG8910 pSG8910, int n, int n2, int n3) {
        this.emuThread.writeSoundOutFrames(1, (n + n2 + n3) / 6, n / 2 + n2 / 4, n3 / 2 + n2 / 4);
    }

    @Override
    public int z80IntructionProcessed(Z80CPU z80CPU, int n, int n2) {
        int n3 = (n2 + 3) / 4;
        return n3 * 4;
    }

    @Override
    public void appendInterruptStatusHTMLTo(StringBuilder stringBuilder) {
        stringBuilder.append("<table border=\"1\">\n<tr><td>Interrupt angemeldet:</td><td>");
        stringBuilder.append(this.interruptRequested ? "ja" : "nein");
        stringBuilder.append("</td></tr>\n</table>\n");
    }

    @Override
    public int interruptAccept() {
        if (this.lineIrqCounter > 0 && this.lineIrqCounter <= 26) {
            this.lineIrqCounter += 26;
        }
        this.interruptRequested = false;
        return 255;
    }

    @Override
    public void interruptFinish() {
    }

    @Override
    public boolean isInterruptAccepted() {
        return false;
    }

    @Override
    public boolean isInterruptRequested() {
        return this.interruptRequested;
    }

    @Override
    public void reset(boolean bl) {
        Arrays.fill(this.screenBuf, (byte)0);
        Arrays.fill(this.ram16KOffs, 0);
        if (this.ramExt != null) {
            Arrays.fill(this.ramExt, (byte)0);
        }
        Arrays.fill(this.keyboardMatrix, 0);
        this.regColorNum = 0;
        this.borderColorIdx = 0;
        this.keyboardIdx = 0;
        this.keyboardValue = 255;
        this.romSelect = 0;
        this.lineIrqCounter = 0;
        this.interruptRequested = false;
        this.centronicsStrobe = false;
        this.basicROMEnabled = true;
        this.osROMEnabled = true;
        this.screenDirty = true;
        this.screenRefreshEnabled = false;
        this.ppi.reset();
        this.psg.reset();
        if (this.fdc != null) {
            this.fdc.reset(bl);
        }
        if (this.floppyDiskDrives != null) {
            for (int i = 0; i < this.floppyDiskDrives.length; ++i) {
                FloppyDiskDrive floppyDiskDrive = this.floppyDiskDrives[i];
                if (floppyDiskDrive == null) continue;
                floppyDiskDrive.reset();
            }
        }
        this.setScreenMode(1);
    }

    @Override
    public void appendStatusHTMLTo(StringBuilder stringBuilder, Z80CPU z80CPU) {
        stringBuilder.append("<h1>KC compact Status</h1>\n<table border=\"1\">\n<tr><td>Betriebssystem-ROM:</td><td>");
        EmuUtil.appendOnOffText(stringBuilder, this.osROMEnabled);
        stringBuilder.append("</td></tr>\n<tr><td>BASIC-ROM:</td><td>");
        EmuUtil.appendOnOffText(stringBuilder, this.basicROMEnabled);
        stringBuilder.append("</td></tr>\n<tr><td>ROM Select Port:</td><td>");
        stringBuilder.append(this.romSelect);
        stringBuilder.append("</td></tr>\n<tr><td>Im vertikalen Synchronimpuls:</td><td>");
        stringBuilder.append(this.crtc.isVSync() ? "ja" : "nein");
        stringBuilder.append("</td></tr>\n</table>\n");
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        boolean bl = this.isFixedScreenSize(properties);
        if (bl != this.fixedScreenSize) {
            this.fixedScreenSize = bl;
            this.screenFrm.fireScreenSizeChanged();
        }
        this.createColors(properties);
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
        if (bl) {
            bl = TextUtil.equals(this.osFile, EmuUtil.getProperty(properties, this.propPrefix + "os.file"));
        }
        if (bl) {
            bl = TextUtil.equals(this.basicFile, EmuUtil.getProperty(properties, this.propPrefix + "basic." + "file"));
        }
        if (bl && this.fdc != null != this.emulatesFloppyDisk(properties)) {
            bl = false;
        }
        if (bl && this.fdc != null) {
            bl = TextUtil.equals(this.fdcROMFile, EmuUtil.getProperty(properties, this.propPrefix + PROP_FDC_ROM_PREFIX + "file"));
        }
        return bl;
    }

    @Override
    public boolean canExtractScreenText() {
        return true;
    }

    @Override
    public AbstractKeyboardFld createKeyboardFld() {
        this.keyboardFld = new KCcompactKeyboardFld(this);
        return this.keyboardFld;
    }

    @Override
    public void die() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.setInterruptSources(null);
        z80CPU.setInstrTStatesMngr(null);
        this.psg.die();
        if (this.fdc != null) {
            this.fdc.die();
        }
    }

    public static FloppyDiskInfo[] getAvailableFloppyDisks() {
        return availableFloppyDisks;
    }

    @Override
    public int getBorderColorIndex() {
        return this.borderColorIdx;
    }

    @Override
    public Color getColor(int n) {
        return n >= 0 && n < this.colors.length ? this.colors[n] : Color.BLACK;
    }

    @Override
    public int getColorIndex(int n, int n2) {
        int n3;
        int n4 = this.borderColorIdx;
        if (this.fixedScreenSize || this.screenFrm.isFullScreenMode()) {
            if (this.screenMode < 2) {
                n /= 2;
            }
            n2 /= 2;
        }
        if ((n3 = n2 * 640 + n) >= 0 && n3 < this.screenBuf.length) {
            n4 = this.screenBuf[n3];
        }
        return n4;
    }

    @Override
    public int getColorCount() {
        return this.colors.length;
    }

    @Override
    protected boolean getConvertKeyCharToISO646DE() {
        return false;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        CharRaster charRaster = null;
        int n = 0;
        switch (this.screenMode) {
            case 0: {
                n = 20;
                break;
            }
            case 1: {
                n = 40;
                break;
            }
            case 2: {
                n = 80;
            }
        }
        if (n > 0) {
            int n2 = this.getScreenHeight() / 25;
            charRaster = new CharRaster(n, 25, n2, n2, this.getScreenWidth() / n, 0);
        }
        return charRaster;
    }

    @Override
    public String getHelpPage() {
        return "/help/kccompact.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2 = 255;
        if ((n &= 0xFFFF) < 16384 && this.osROMEnabled) {
            if (this.osBytes != null && n < this.osBytes.length) {
                n2 = this.osBytes[n] & 0xFF;
            }
        } else if (n >= 49152 && this.basicROMEnabled) {
            int n3;
            boolean bl2 = false;
            byte[] byArray = this.fdcROMBytes;
            if (this.fdc != null) {
                if (this.romSelect == 6) {
                    n3 = n - 49152 + 16384;
                    if (n3 >= 16384 && n3 < byArray.length) {
                        n2 = byArray[n3] & 0xFF;
                        bl2 = true;
                    }
                } else if (this.romSelect == 7) {
                    byArray = this.fdcROMBytes;
                    n3 = n - 49152;
                    if (n3 >= 0 && n3 < 16384 && n3 < byArray.length) {
                        n2 = byArray[n3] & 0xFF;
                        bl2 = true;
                    }
                }
            }
            if (!bl2 && (byArray = this.basicBytes) != null && (n3 = n - 49152) >= 0 && n3 < byArray.length) {
                n2 = byArray[n3] & 0xFF;
            }
        } else {
            int n4 = n + this.ram16KOffs[n >> 14 & 3];
            if (n4 >= 65536) {
                if (this.ramExt != null && (n4 &= 0xFFFF) < this.ramExt.length) {
                    n2 = this.ramExt[n4] & 0xFF;
                }
            } else {
                n2 = this.emuThread.getRAMByte(n);
            }
        }
        return n2;
    }

    @Override
    public int getResetStartAddress(EmuThread.ResetLevel resetLevel) {
        return 0;
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        Map<Long, Character> map;
        int n3 = -1;
        if (n >= 0 && n < charRaster.getColCount() && n2 >= 0 && n2 < charRaster.getRowCount() && (map = this.getPixelCRC32ToCharMap()) != null) {
            CRC32 cRC32 = new CRC32();
            CRC32 cRC322 = new CRC32();
            int n4 = charRaster.getCharWidth();
            int n5 = charRaster.getCharHeight();
            int n6 = n4 / 8;
            int n7 = n5 / 8;
            int n8 = n * n4;
            int n9 = n2 * n5;
            for (int i = 0; i < n5; i += n7) {
                int n10 = 0;
                for (int j = 0; j < n4; j += n6) {
                    n10 <<= 1;
                    if (this.getColorIndex(n8 + j, n9 + i) != this.regColors[0]) continue;
                    n10 |= 1;
                }
                cRC32.update(~n10 & 0xFF);
                cRC322.update(n10);
            }
            Character c = map.get(cRC32.getValue());
            if (c == null) {
                c = map.get(cRC322.getValue());
            }
            if (c != null) {
                n3 = c.charValue();
            }
        }
        return n3;
    }

    @Override
    public int getScreenHeight() {
        return this.fixedScreenSize || this.screenFrm.isFullScreenMode() ? 400 : 200;
    }

    @Override
    public int getScreenWidth() {
        return this.fixedScreenSize || this.screenFrm.isFullScreenMode() ? 640 : this.screenWidth;
    }

    @Override
    public FloppyDiskInfo[] getSuitableFloppyDisks() {
        return this.fdc != null ? availableFloppyDisks : null;
    }

    @Override
    public int getSupportedFloppyDiskDriveCount() {
        return this.floppyDiskDrives != null ? this.floppyDiskDrives.length : 0;
    }

    @Override
    public int getSupportedJoystickCount() {
        return 2;
    }

    @Override
    public String getTitle() {
        return SYSTEXT;
    }

    @Override
    public boolean isAutoScreenRefresh() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            switch (n) {
                case 37: {
                    this.keyboardMatrix[1] = this.keyboardMatrix[1] | 1;
                    bl3 = true;
                    break;
                }
                case 39: {
                    this.keyboardMatrix[0] = this.keyboardMatrix[0] | 2;
                    bl3 = true;
                    break;
                }
                case 38: {
                    this.keyboardMatrix[0] = this.keyboardMatrix[0] | 1;
                    bl3 = true;
                    break;
                }
                case 40: {
                    this.keyboardMatrix[0] = this.keyboardMatrix[0] | 4;
                    bl3 = true;
                    break;
                }
                case 32: {
                    this.keyboardMatrix[5] = this.keyboardMatrix[5] | 0x80;
                    bl3 = true;
                    break;
                }
                case 10: {
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 4;
                    bl3 = true;
                    break;
                }
                case 27: {
                    this.keyboardMatrix[8] = this.keyboardMatrix[8] | 4;
                    bl3 = true;
                    break;
                }
                case 9: {
                    this.keyboardMatrix[8] = this.keyboardMatrix[8] | 0x10;
                    bl3 = true;
                    break;
                }
                case 8: {
                    this.keyboardMatrix[9] = this.keyboardMatrix[9] | 0x80;
                    bl3 = true;
                    break;
                }
                case 127: {
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 1;
                    bl3 = true;
                    break;
                }
                case 112: {
                    this.keyboardMatrix[1] = this.keyboardMatrix[1] | 0x20;
                    bl3 = true;
                    break;
                }
                case 113: {
                    this.keyboardMatrix[1] = this.keyboardMatrix[1] | 0x40;
                    bl3 = true;
                    break;
                }
                case 114: {
                    this.keyboardMatrix[0] = this.keyboardMatrix[0] | 0x20;
                    bl3 = true;
                    break;
                }
                case 115: {
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 0x10;
                    bl3 = true;
                    break;
                }
                case 116: {
                    this.keyboardMatrix[1] = this.keyboardMatrix[1] | 0x80;
                    bl3 = true;
                    break;
                }
                case 117: {
                    this.keyboardMatrix[0] = this.keyboardMatrix[0] | 0x40;
                    bl3 = true;
                    break;
                }
                case 118: {
                    this.keyboardMatrix[0] = this.keyboardMatrix[0] | 0x80;
                    bl3 = true;
                    break;
                }
                case 119: {
                    this.keyboardMatrix[1] = this.keyboardMatrix[1] | 2;
                    bl3 = true;
                }
            }
            if (bl3) {
                if (bl2) {
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 0x20;
                }
                if (bl) {
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 0x80;
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (bl3) {
                this.updKeyboardFld();
            }
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased() {
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            Arrays.fill(this.keyboardMatrix, 0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.updKeyboardFld();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        if (c > '\u0000') {
            int[] nArray = this.keyboardMatrix;
            // MONITORENTER : this.keyboardMatrix
            bl = this.setCharInKBMatrix(kbMatrixNormal, c);
            if (!bl) {
                bl = this.setCharInKBMatrix(kbMatrixShift, c);
                if (bl) {
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 0x20;
                } else {
                    bl = this.setCharInKBMatrix(kbMatrixControl, c);
                    if (bl) {
                        this.keyboardMatrix[2] = this.keyboardMatrix[2] | 0x80;
                    }
                }
            }
            // MONITOREXIT : nArray
        }
        if (!bl) return bl;
        this.updKeyboardFld();
        return bl;
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        if (this.fdc != null && (n & 0x580) == 256) {
            n3 = (n & 1) == 0 ? (n3 &= this.fdc.readMainStatusReg()) : (n3 &= this.fdc.readData());
        }
        if ((n & 0x800) == 0) {
            n3 &= this.ppi.read(n >> 8, 255);
        }
        if ((n & 0x4000) == 0 && (n & 0x300) == 768) {
            n3 &= this.crtc.read();
        }
        return n3;
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON && this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
        this.joy0ActionMask = 0;
        this.joy1ActionMask = 0;
    }

    @Override
    public void setFloppyDiskDrive(int n, FloppyDiskDrive floppyDiskDrive) {
        if (this.floppyDiskDrives != null && n >= 0 && n < this.floppyDiskDrives.length) {
            this.floppyDiskDrives[n] = floppyDiskDrive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setJoystickAction(int n, int n2) {
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            if (n == 0) {
                this.joy0ActionMask = n2;
            } else if (n == 1) {
                this.joy1ActionMask = n2;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        boolean bl = false;
        int n3 = (n & 0xFFFF) + this.ram16KOffs[n >> 14 & 3];
        if (n3 >= 65536) {
            if (this.ramExt != null && (n3 &= 0xFFFF) < this.ramExt.length) {
                this.ramExt[n3] = (byte)n2;
                bl = true;
            }
        } else {
            this.emuThread.setRAMByte(n3, n2);
            if ((n3 & 0xC000) == (this.crtc.getStartAddr() << 2 & 0xC000)) {
                this.screenDirty = true;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public void soundOutFrameRateChanged(int n) {
        this.psg.setFrameRate(n);
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsKeyboardFld() {
        return true;
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return true;
    }

    @Override
    public boolean supportsPrinter() {
        return true;
    }

    @Override
    public boolean supportsSoundOut8Bit() {
        return true;
    }

    @Override
    public boolean supportsSoundOutMono() {
        return true;
    }

    @Override
    public boolean supportsSoundOutStereo() {
        return true;
    }

    @Override
    public boolean supportsTapeIn() {
        return true;
    }

    @Override
    public boolean supportsTapeOut() {
        return true;
    }

    public String toString() {
        return "Zentrale Zustandssteuerung";
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        PrintMngr printMngr;
        n2 &= 0xFF;
        if (this.fdc != null && (n & 0x580) == 256) {
            this.fdc.write(n2);
        }
        if ((n & 0x800) == 0) {
            this.ppi.write(n >> 8, n2);
        }
        if ((n & 0x1000) == 0 && (n & 0x300) == 768 && (printMngr = this.emuThread.getPrintMngr()) != null) {
            boolean bl;
            boolean bl2 = bl = (n2 & 0x80) != 0;
            if (bl != this.centronicsStrobe) {
                this.centronicsStrobe = bl;
                if (bl) {
                    printMngr.putByte(this.ppi.fetchOutValueC() & 0x80 | n2 & 0x7F);
                }
            }
        }
        if ((n & 0x2000) == 0) {
            this.romSelect = n2;
        }
        if ((n & 0x4000) == 0) {
            switch (n & 0x300) {
                case 0: {
                    this.crtc.setRegNum(n2);
                    break;
                }
                case 256: {
                    this.crtc.write(n2);
                    this.screenDirty = true;
                }
            }
        }
        if ((n & 0x8000) == 0) {
            block4 : switch (n2 & 0xC0) {
                case 0: {
                    this.regColorNum = n2;
                    break;
                }
                case 64: {
                    if ((n2 & 0xC0) == 64) {
                        if ((this.regColorNum & 0x10) != 0) {
                            this.borderColorIdx = colorPalette2Idx[n2 & 0x1F];
                        } else {
                            this.regColors[this.regColorNum & 0xF] = colorPalette2Idx[n2 & 0x1F];
                        }
                    } else if ((this.regColorNum & 0x10) != 0) {
                        this.borderColorIdx = 0;
                    } else {
                        this.regColors[this.regColorNum & 0xF] = 0;
                    }
                    this.screenDirty = true;
                    break;
                }
                case 128: {
                    this.osROMEnabled = (n2 & 4) == 0;
                    boolean bl = this.basicROMEnabled = (n2 & 8) == 0;
                    if ((n2 & 0x10) != 0) {
                        this.lineIrqCounter = 52;
                    }
                    this.setScreenMode(n2 & 3);
                    break;
                }
                case 192: {
                    Arrays.fill(this.ram16KOffs, 0);
                    switch (n2 & 7) {
                        case 1: {
                            this.ram16KOffs[3] = 65536;
                            break block4;
                        }
                        case 2: {
                            Arrays.fill(this.ram16KOffs, 65536);
                            break block4;
                        }
                        case 4: {
                            this.ram16KOffs[1] = 786432;
                            break block4;
                        }
                        case 5: {
                            this.ram16KOffs[1] = 0x100000;
                            break block4;
                        }
                        case 6: {
                            this.ram16KOffs[1] = 0x140000;
                            break block4;
                        }
                        case 7: {
                            this.ram16KOffs[1] = 0x180000;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        this.crtc.z80MaxSpeedChanged(z80CPU);
        if (this.fdc != null) {
            this.fdc.z80MaxSpeedChanged(z80CPU);
        }
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        this.crtc.z80TStatesProcessed(z80CPU, n);
        if (this.fdc != null) {
            this.fdc.z80TStatesProcessed(z80CPU, n);
        }
    }

    private void addPixelCRC32ToMap(Map<Long, Character> map, int n, char c) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(romOS, 14336 + n * 8, 8);
        map.put(cRC32.getValue(), Character.valueOf(c));
    }

    private void createColors(Properties properties) {
        float f = KCcompact.getBrightness(properties);
        if (f >= 0.0f && f <= 1.0f) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < this.colors.length; ++i) {
                int n4 = Math.round((float)n * f);
                int n5 = Math.round((float)n2 * f);
                int n6 = Math.round((float)n3 * f);
                this.colors[i] = new Color(n4 << 16 | n5 << 8 | n6);
                if (n3 == 0) {
                    n3 = 128;
                    continue;
                }
                if (n3 == 128) {
                    n3 = 255;
                    continue;
                }
                n3 = 0;
                if (n == 0) {
                    n = 128;
                    continue;
                }
                if (n == 128) {
                    n = 255;
                    continue;
                }
                n = 0;
                n2 = n2 == 0 ? 128 : 255;
            }
        }
    }

    private boolean emulatesFloppyDisk(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "fdc.enabled", false);
    }

    private static int getJoyKeyboardMask(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 4;
        }
        if ((n & 2) != 0) {
            n2 |= 8;
        }
        if ((n & 8) != 0) {
            n2 |= 2;
        }
        if ((n & 4) != 0) {
            n2 |= 1;
        }
        if ((n & 0x10) != 0) {
            n2 |= 0x10;
        }
        if ((n & 0x20) != 0) {
            n2 |= 0x20;
        }
        return n2;
    }

    private Map<Long, Character> getPixelCRC32ToCharMap() {
        if (pixelCRC32ToChar == null && romOS != null && romOS.length >= 16384) {
            int n;
            HashMap<Long, Character> hashMap = new HashMap<Long, Character>();
            for (n = 32; n <= 126; ++n) {
                this.addPixelCRC32ToMap(hashMap, n, (char)n);
            }
            for (n = 0; n < char128ToUnicode.length; ++n) {
                int n2 = char128ToUnicode[n];
                if (n2 < 0) continue;
                this.addPixelCRC32ToMap(hashMap, n + 128, (char)n2);
            }
            pixelCRC32ToChar = hashMap;
        }
        return pixelCRC32ToChar;
    }

    private boolean isFixedScreenSize(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "fixed_screen_size", false);
    }

    private void loadROMs(Properties properties) {
        this.osFile = EmuUtil.getProperty(properties, this.propPrefix + "os.file");
        this.osBytes = this.readROMFile(this.osFile, 16384, "Betriebssystem-ROM");
        if (this.osBytes == null) {
            this.osBytes = romOS;
        }
        this.basicFile = EmuUtil.getProperty(properties, this.propPrefix + "basic." + "file");
        this.basicBytes = this.readROMFile(this.basicFile, 16384, "BASIC-ROM");
        if (this.basicBytes == null) {
            if (romBASIC == null) {
                romBASIC = this.readResource("/rom/kccompact/kccbasic.bin");
            }
            this.basicBytes = romBASIC;
        }
        if (this.fdc != null) {
            this.fdcROMFile = EmuUtil.getProperty(properties, this.propPrefix + PROP_FDC_ROM_PREFIX + "file");
            this.fdcROMBytes = this.readROMFile(this.fdcROMFile, 32768, "FDC-ROM");
            if (this.fdcROMBytes == null) {
                if (romFDC == null) {
                    romFDC = this.readResource("/rom/kccompact/basdos.bin");
                }
                this.fdcROMBytes = romFDC;
            }
        } else {
            this.fdcROMFile = null;
            this.fdcROMBytes = null;
        }
    }

    private boolean setCharInKBMatrix(int[][] nArray, char c) {
        boolean bl = false;
        int n = Math.min(this.keyboardMatrix.length, nArray.length);
        block0: for (int i = 0; i < n; ++i) {
            int n2 = 1;
            int[] nArray2 = nArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                if (c == nArray2[j]) {
                    int n3 = i;
                    this.keyboardMatrix[n3] = this.keyboardMatrix[n3] | n2;
                    bl = true;
                    continue block0;
                }
                n2 <<= 1;
            }
        }
        return bl;
    }

    private void setScreenMode(int n) {
        if (n >= 0 && n <= 2 && this.screenMode != n) {
            int n2 = 320;
            if (n == 2) {
                n2 = 640;
            }
            this.screenMode = n;
            this.screenWidth = n2;
            if (!this.fixedScreenSize) {
                this.screenFrm.fireScreenSizeChanged();
            }
        }
    }

    private void updKeyboardFld() {
        if (this.keyboardFld != null) {
            this.keyboardFld.updKeySelection(this.keyboardMatrix);
        }
    }
}

