/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jkcemu.Main;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.BaseDlg;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.SourceUtil;
import jkcemu.base.UserCancelException;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.disk.FloppyDiskFormat;
import jkcemu.disk.FloppyDiskInfo;
import jkcemu.emusys.kc85.AbstractKC85KeyboardFld;
import jkcemu.emusys.kc85.AbstractKC85Module;
import jkcemu.emusys.kc85.D004;
import jkcemu.emusys.kc85.D005KeyboardFld;
import jkcemu.emusys.kc85.KC85CharRecognizer;
import jkcemu.emusys.kc85.KC85JoystickModule;
import jkcemu.emusys.kc85.KC85KeyboardFld;
import jkcemu.emusys.kc85.KC85LEDFld;
import jkcemu.emusys.kc85.KC85PlainRAMModule;
import jkcemu.emusys.kc85.KC85ROM8KModule;
import jkcemu.emusys.kc85.KC85SegmentedRAMModule;
import jkcemu.emusys.kc85.M003;
import jkcemu.emusys.kc85.M006;
import jkcemu.emusys.kc85.M008;
import jkcemu.emusys.kc85.M011;
import jkcemu.emusys.kc85.M021;
import jkcemu.emusys.kc85.M025;
import jkcemu.emusys.kc85.M028;
import jkcemu.emusys.kc85.M033;
import jkcemu.emusys.kc85.M035;
import jkcemu.emusys.kc85.M040;
import jkcemu.emusys.kc85.M045;
import jkcemu.emusys.kc85.M046;
import jkcemu.emusys.kc85.M047;
import jkcemu.emusys.kc85.M048;
import jkcemu.emusys.kc85.M052;
import jkcemu.etc.VDIP;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80CTCListener;
import z80emu.Z80InterruptSource;
import z80emu.Z80MaxSpeedListener;
import z80emu.Z80MemView;
import z80emu.Z80Memory;
import z80emu.Z80PIO;
import z80emu.Z80TStatesListener;

public class KC85
extends EmuSys
implements Z80CTCListener {
    public static final String SYSNAME_HC900 = "HC900";
    public static final String SYSNAME_KC85_2 = "KC85_2";
    public static final String SYSNAME_KC85_3 = "KC85_3";
    public static final String SYSNAME_KC85_4 = "KC85_4";
    public static final String SYSNAME_KC85_5 = "KC85_5";
    public static final String SYSTEXT_HC900 = "HC900";
    public static final String SYSTEXT_KC85_2 = "KC85/2";
    public static final String SYSTEXT_KC85_3 = "KC85/3";
    public static final String SYSTEXT_KC85_4 = "KC85/4";
    public static final String SYSTEXT_KC85_5 = "KC85/5";
    public static final String PROP_PREFIX_HC900 = "jkcemu.hc900.";
    public static final String PROP_PREFIX_KC85_2 = "jkcemu.kc85_2.";
    public static final String PROP_PREFIX_KC85_3 = "jkcemu.kc85_3.";
    public static final String PROP_PREFIX_KC85_4 = "jkcemu.kc85_4.";
    public static final String PROP_PREFIX_KC85_5 = "jkcemu.kc85_5.";
    public static final String PROP_NAME = "name";
    public static final String PROP_TYPEBYTE = "typebyte";
    public static final String PROP_MODULE_PREFIX = "module.";
    public static final String PROP_D004_ENABLED = "d004.enabled";
    public static final String PROP_D004_ROM = "d004.rom";
    public static final String PROP_D004_MAXSPEED_KHZ = "d004.maxspeed.khz";
    public static final String PROP_ROM_BASIC_FILE = "rom.basic.file";
    public static final String PROP_ROM_CAOS_C_FILE = "rom.caos_c.file";
    public static final String PROP_ROM_CAOS_E_FILE = "rom.caos_e.file";
    public static final String PROP_ROM_CAOS_F_FILE = "rom.caos_f.file";
    public static final String PROP_ROM_M052_FILE = "rom.m052.file";
    public static final String PROP_EMULATE_VIDEO_TIMING = "emulate_video_timing";
    public static final String PROP_KEYS_DIRECT_TO_BUFFER = "keys.direct_to_buffer";
    public static final String VALUE_STANDARD = "standard";
    public static final boolean DEFAULT_SWAP_KEY_CHAR_CASE = true;
    public static final int DEFAULT_PROMPT_AFTER_RESET_MILLIS_MAX_2 = 3000;
    public static final int DEFAULT_PROMPT_AFTER_RESET_MILLIS_MAX_4 = 1500;
    public static final String[] basicTokens = new String[]{"END", "FOR", "NEXT", "DATA", "INPUT", "DIM", "READ", "LET", "GOTO", "RUN", "IF", "RESTORE", "GOSUB", "RETURN", "REM", "STOP", "OUT", "ON", "NULL", "WAIT", "DEF", "POKE", "DOKE", "AUTO", "LINES", "CLS", "WIDTH", "BYE", "!", "CALL", "PRINT", "CONT", "LIST", "CLEAR", "CLOAD", "CSAVE", "NEW", "TAB(", "TO", "FN", "SPC(", "THEN", "NOT", "STEP", "+", "-", "*", "/", "^", "AND", "OR", ">", "=", "<", "SGN", "INT", "ABS", "USR", "FRE", "INP", "POS", "SQR", "RND", "LN", "EXP", "COS", "SIN", "TAN", "ATN", "PEEK", "DEEK", "PI", "LEN", "STR$", "VAL", "ASC", "CHR$", "LEFT$", "RIGHT$", "MID$", "LOAD", "TRON", "TROFF", "EDIT", "ELSE", "INKEY$", "JOYST", "STRING$", "INSTR", "RENUMBER", "DELETE", "PAUSE", "BEEP", "WINDOW", "BORDER", "INK", "PAPER", "AT", "COLOR", "SOUND", "PSET", "PRESET", "BLOAD", "VPEEK", "VPOKE", "LOCATE", "KEYLIST", "KEY", "SWITCH", "PTEST", "CLOSE", "OPEN", "RANDOMIZE", "VGET$", "LINE", "CIRCLE", "CSRLIN"};
    private static final int DEFAULT_SPEED_2_KHZ = 1750;
    private static final int DEFAULT_SPEED_4_KHZ = 1773;
    private static final int SUTAB = 47024;
    private static final int SCREEN_WIDTH = 320;
    private static final int SCREEN_HEIGHT = 256;
    private static final FloppyDiskInfo[] availableFloppyDisks = new FloppyDiskInfo[]{new FloppyDiskInfo("/disks/kc85/kc85caos.dump.gz", "KC85 CAOS Systemdiskette", 2, 2048, true), new FloppyDiskInfo("/disks/kc85/kc85microdos.dump.gz", "KC85 MicroDOS Systemdiskette", 2, 2048, true)};
    private static final int[][] rawRGBValues = new int[][]{{0, 0, 0}, {0, 0, 255}, {255, 0, 0}, {255, 0, 255}, {0, 255, 0}, {0, 255, 255}, {255, 255, 0}, {255, 255, 255}, {0, 0, 0}, {160, 0, 255}, {255, 160, 0}, {255, 0, 160}, {0, 255, 160}, {0, 160, 255}, {160, 255, 0}, {255, 255, 255}, {0, 0, 0}, {0, 0, 160}, {160, 0, 0}, {160, 0, 160}, {0, 160, 0}, {0, 160, 160}, {160, 160, 0}, {160, 160, 160}};
    private static int[] char2KeyNum = new int[]{-1, 24, 41, 60, 61, 115, -1, -1, 6, 122, 118, 120, 9, 126, 127, 25, 8, 121, 119, 76, 57, -1, 114, -1, 123, 7, 56, 77, 86, 87, -1, 40, 70, 117, 5, 21, 101, 37, 85, 53, 69, 59, 27, 104, 74, 10, 90, 106, 42, 116, 4, 20, 100, 36, 84, 52, 68, 58, 26, 105, 75, 11, 91, 107, 43, 2, 94, 110, 98, 16, 34, 82, 50, 64, 66, 72, 88, 78, 62, 54, 38, 112, 96, 18, 32, 48, 46, 0, 30, 14, 80, -1, -1, -1, 22, 102, -1, 3, 95, 111, 99, 17, 35, 83, 51, 65, 67, 73, 89, 79, 63, 55, 39, 113, 97, 19, 33, 49, 47, 1, 31, 15, 81, -1, 103, -1, -1, -1};
    private static final int PRE_F1_MASK = 31744;
    private static final String[] cpuFlags = new String[]{"NZ", "Z", "NC", "C", "PO", "PE", "P", "M"};
    private static final String[] sysCallNames = new String[]{"CRT", "MBO", "UOT1", "UOT2", "KBD", "MBI", "USIN1", "USIN2", "ISRO", "CSRO", "ISRI", "CSRI", "KBDS", "BYE", "KBDZ", "COLOR", "LOAD", "VERIF", "LOOP", "NORM", "WAIT", "LARG", "INTB", "INLIN", "RHEX", "ERRM", "HLHX", "HLDE", "AHEX", "ZSUCH", "SOUT", "SIN", "NOUT", "NIN", "GARG", "OSTR", "OCHR", "CUCP", "MODU", "JUMP", "LDMA", "LDAM", "BRKT", "SPACE", "CRLF", "HOME", "MODI", "PUDE", "PUSE", "SIXD", "DABR", "TCIF", "PADR", "TON", "SAVE", "MBIN", "MBOUT", "KEY", "KEYLI", "DISP", "WININ", "WINAK", "LINE", "CIRCLE", "SQR", "MULT", "CSTBT", "INIEA", "INIME", "ZKOUT", "MENU", "V24OUT", "V24DUP"};
    private static Map<String, byte[]> resources = new HashMap<String, byte[]>();
    private static byte[] basic_x4_c000 = null;
    private static byte[] basic_c000 = null;
    private static byte[] hc900_e000 = null;
    private static byte[] hc900_f000 = null;
    private static byte[] caos22_e000 = null;
    private static byte[] caos22_f000 = null;
    private static byte[] caos31_e000 = null;
    private static byte[] caos42_c000 = null;
    private static byte[] caos42_e000 = null;
    private static byte[] caos45_c000 = null;
    private static byte[] caos45_e000 = null;
    private static Boolean defaultEmulateVideoTiming = null;
    private int kcTypeNum;
    private String sysName;
    private String basicFile = null;
    private String caosFileC = null;
    private String caosFileE = null;
    private String caosFileF = null;
    private String m052File = null;
    private Boolean kout;
    private volatile boolean blinkEnabled;
    private volatile boolean blinkState;
    private volatile boolean hiColorRes;
    private boolean charSetUnknown = false;
    private boolean keyDirectToBuf = false;
    private boolean pasteFast = false;
    private boolean basicC000Enabled;
    private boolean caosC000Enabled;
    private boolean caosE000Enabled;
    private boolean irmEnabled;
    private boolean ram0Enabled;
    private boolean ram0Writeable;
    private boolean ram4Enabled;
    private boolean ram4Writeable;
    private boolean ram8Enabled;
    private boolean ram8Writeable;
    private boolean ramColorEnabled;
    private boolean screenDirty;
    private boolean screenRefreshEnabled;
    private boolean screen1Enabled;
    private volatile boolean screen1Visible;
    private boolean biState;
    private boolean h4State;
    private boolean soundOutPhaseL = false;
    private boolean soundOutPhaseR = false;
    private boolean tapeInPhase;
    private int ram8SegNum;
    private int keyNumStageBuf;
    private int keyNumStageNum;
    private long keyNumStageMillis;
    private volatile int keyNumPressed;
    private int keyNumProcessing;
    private int keyShiftBitCnt;
    private int keyShiftValue;
    private int keyTStates;
    private int lastIX;
    private int curSoundOutTStates = 0;
    private int soundOutTStates = 0;
    private int soundOutValueM;
    private int soundOutValueL;
    private int soundOutValueR;
    private volatile int tStatesLinePos0;
    private volatile int tStatesLinePos1;
    private volatile int tStatesLinePos2;
    private volatile int tStatesPerLine;
    private int lineTStateCounter;
    private int lineCounter;
    private int basicSegNum;
    private byte[] basicC000;
    private byte[] caosC000;
    private byte[] caosE000;
    private byte[] caosF000;
    private byte[] screenBufUsed;
    private byte[] screenBufSaved;
    private byte[] ram8;
    private byte[] ramColor0;
    private byte[] ramColor1;
    private byte[] ramPixel0;
    private byte[] ramPixel1;
    private int[] rgbValues;
    private Color[] colors;
    private AbstractKC85Module[] modules;
    private KC85CharRecognizer charRecognizer;
    private AbstractKC85KeyboardFld keyboardFld = null;
    private KC85LEDFld ledFld = null;
    private Z80PIO pio;
    private Z80CTC ctc;
    private KC85JoystickModule joyModule;
    private VDIP vdip;
    private D004 d004;
    private String d004RomProp;

    public KC85(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, "");
        this.sysName = EmuUtil.getProperty(properties, "jkcemu.system");
        switch (this.sysName) {
            case "HC900": {
                this.kcTypeNum = 2;
                this.propPrefix = PROP_PREFIX_HC900;
                break;
            }
            case "KC85_2": {
                this.kcTypeNum = 2;
                this.propPrefix = PROP_PREFIX_KC85_2;
                break;
            }
            case "KC85_3": {
                this.kcTypeNum = 3;
                this.propPrefix = PROP_PREFIX_KC85_3;
                break;
            }
            case "KC85_4": {
                this.kcTypeNum = 4;
                this.propPrefix = PROP_PREFIX_KC85_4;
                break;
            }
            default: {
                this.kcTypeNum = 5;
                this.propPrefix = PROP_PREFIX_KC85_5;
            }
        }
        this.ram8 = null;
        if (this.kcTypeNum == 4) {
            this.ram8 = this.emuThread.getExtendedRAM(32768);
        } else if (this.kcTypeNum > 4) {
            this.ram8 = this.emuThread.getExtendedRAM(229376);
        }
        this.ramColor0 = new byte[16384];
        this.ramColor1 = new byte[16384];
        this.ramPixel0 = new byte[16384];
        this.ramPixel1 = new byte[16384];
        Object object = emuThread.getZ80CPU();
        this.ctc = new Z80CTC("CTC (E/A-Adressen 8Ch-8Fh)");
        this.pio = new Z80PIO("PIO (E/A-Adressen 88h-8Bh)");
        this.joyModule = null;
        this.d004 = null;
        this.d004RomProp = "";
        if (this.emulatesD004(properties)) {
            byte[] byArray = null;
            this.d004RomProp = this.getD004RomProp(properties);
            if (this.d004RomProp.length() > "file:".length() && this.d004RomProp.toLowerCase().startsWith("file:")) {
                try {
                    byArray = EmuUtil.readFile(new File(this.d004RomProp.substring("file:".length())), true, 16384);
                }
                catch (IOException iOException) {
                    BaseDlg.showErrorDlg((Component)this.emuThread.getScreenFrm(), "D004-ROM-Datei kann nicht geladen werden.\nEs wird der Standard-ROM verwendet.", iOException);
                }
            }
            if (byArray == null) {
                String string = null;
                string = this.d004RomProp.equals("2.0") ? "/rom/kc85/d004_20.bin" : (this.d004RomProp.equals("3.3") ? (this.kcTypeNum >= 4 ? "/rom/kc85/d004_33_4.bin" : "/rom/kc85/d004_33_3.bin") : (this.kcTypeNum > 4 ? "/rom/kc85/d004_33_4.bin" : "/rom/kc85/d004_20.bin"));
                byArray = EmuUtil.readResource(this.emuThread.getScreenFrm(), string);
            }
            this.d004 = new D004(this.emuThread.getScreenFrm(), properties, this.propPrefix, byArray);
        }
        this.vdip = null;
        this.modules = this.createModules(properties);
        if (this.modules != null) {
            try {
                ArrayList<Z80InterruptSource> arrayList = new ArrayList<Z80InterruptSource>();
                arrayList.add(this.ctc);
                arrayList.add(this.pio);
                for (int i = 0; i < this.modules.length; ++i) {
                    AbstractKC85Module abstractKC85Module = this.modules[i];
                    if (abstractKC85Module instanceof M052 && this.vdip == null) {
                        this.vdip = ((M052)abstractKC85Module).getVDIP();
                    }
                    if (abstractKC85Module instanceof Z80InterruptSource) {
                        arrayList.add((Z80InterruptSource)((Object)abstractKC85Module));
                    }
                    if (abstractKC85Module instanceof Z80MaxSpeedListener) {
                        ((Z80MaxSpeedListener)((Object)abstractKC85Module)).z80MaxSpeedChanged((Z80CPU)object);
                        ((Z80CPU)object).addMaxSpeedListener((Z80MaxSpeedListener)((Object)abstractKC85Module));
                    }
                    if (!(abstractKC85Module instanceof Z80TStatesListener)) continue;
                    ((Z80CPU)object).addTStatesListener((Z80TStatesListener)((Object)abstractKC85Module));
                }
                ((Z80CPU)object).setInterruptSources(arrayList.toArray(new Z80InterruptSource[arrayList.size()]));
            }
            catch (ArrayStoreException arrayStoreException) {}
        } else {
            ((Z80CPU)object).setInterruptSources(this.ctc, this.pio);
        }
        this.ctc.addCTCListener(this);
        ((Z80CPU)object).addTStatesListener(this);
        ((Z80CPU)object).addMaxSpeedListener(this);
        this.screenBufUsed = null;
        this.screenBufSaved = null;
        this.rgbValues = new int[rawRGBValues.length];
        this.colors = new Color[rawRGBValues.length];
        this.charRecognizer = new KC85CharRecognizer();
        this.applySettings(properties);
        this.z80MaxSpeedChanged((Z80CPU)object);
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
    }

    public static FloppyDiskInfo[] getAvailableFloppyDisks() {
        return availableFloppyDisks;
    }

    public static boolean getDefaultEmulateVideoTiming() {
        return Runtime.getRuntime().availableProcessors() >= 2;
    }

    public static int getDefaultSpeedKHz(Properties properties) {
        int n = 1773;
        switch (EmuUtil.getProperty(properties, "jkcemu.system")) {
            case "HC900": 
            case "KC85_2": 
            case "KC85_3": {
                n = 1750;
            }
        }
        return n;
    }

    public int getKCTypeNum() {
        return this.kcTypeNum;
    }

    public static int getRawColorCount() {
        return rawRGBValues.length;
    }

    public static int getRawRGB(int n) {
        int[] nArray;
        int n2 = -16777216;
        if (n >= 0 && n < rawRGBValues.length && (nArray = rawRGBValues[n]).length >= 3) {
            n2 |= nArray[0] << 16 & 0xFF0000;
            n2 |= nArray[1] << 8 & 0xFF00;
            n2 |= nArray[2] & 0xFF;
        }
        return n2;
    }

    public void setKeyNumPressed(int n) {
        this.keyNumPressed = n;
    }

    @Override
    public void z80CTCUpdate(Z80CTC z80CTC, int n) {
        if (z80CTC == this.ctc) {
            switch (n) {
                case 0: {
                    this.soundOutPhaseR = !this.soundOutPhaseR;
                    this.updSoundOut();
                    break;
                }
                case 1: {
                    this.soundOutPhaseL = !this.soundOutPhaseL;
                    this.updSoundOut();
                    break;
                }
                case 2: {
                    boolean bl = this.blinkState = !this.blinkState;
                    if (this.screenBufUsed != null) {
                        this.screenDirty = true;
                        break;
                    }
                    this.screenFrm.setScreenDirty(true);
                }
            }
        }
    }

    @Override
    public void appendStatusHTMLTo(StringBuilder stringBuilder, Z80CPU z80CPU) {
        if (z80CPU == this.emuThread.getZ80CPU()) {
            int n = this.pio.fetchOutValuePortA(false);
            stringBuilder.append("<h1>");
            EmuUtil.appendHTML(stringBuilder, this.getTitle());
            stringBuilder.append(" Status</h1>\n<table border=\"1\">\n");
            if (this.kcTypeNum >= 4) {
                stringBuilder.append("<tr><td>CAOS ROM C:</td><td>");
                EmuUtil.appendOnOffText(stringBuilder, this.caosC000Enabled);
                stringBuilder.append("</td></tr>\n");
            }
            stringBuilder.append("<tr><td>CAOS ROM");
            if (this.kcTypeNum >= 4) {
                stringBuilder.append(" E");
            }
            stringBuilder.append(":</td><td>");
            EmuUtil.appendOnOffText(stringBuilder, this.caosE000Enabled);
            stringBuilder.append("</td></tr>\n");
            if (this.kcTypeNum >= 3) {
                stringBuilder.append("<tr><td>BASIC");
                if (this.kcTypeNum > 4) {
                    stringBuilder.append("/USER");
                }
                stringBuilder.append("-ROM:</td><td>");
                if (this.basicC000Enabled) {
                    if (this.kcTypeNum >= 4 && this.caosC000Enabled) {
                        stringBuilder.append("von CAOS C &uuml;berdeckt");
                    } else {
                        if (this.kcTypeNum > 4) {
                            stringBuilder.append("Bank ");
                            stringBuilder.append(this.basicSegNum);
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append("ein");
                    }
                } else {
                    stringBuilder.append("aus");
                }
                stringBuilder.append("</td></tr>\n");
            }
            stringBuilder.append("<tr><td>RAM 0:</td><td>");
            if (this.ram0Enabled) {
                stringBuilder.append("ein");
                if (!this.ram0Writeable) {
                    stringBuilder.append("(schreibgesch&uuml;tzt)");
                }
            } else {
                stringBuilder.append("aus");
            }
            stringBuilder.append("</td></tr>\n");
            if (this.kcTypeNum >= 4) {
                stringBuilder.append("<tr><td>RAM 4:</td><td>");
                if (this.ram4Enabled) {
                    stringBuilder.append("ein");
                    if (!this.ram4Writeable) {
                        stringBuilder.append("(schreibgesch&uuml;tzt)");
                    }
                } else {
                    stringBuilder.append("aus");
                }
                stringBuilder.append("</td></tr>\n<tr><td>RAM 8:</td><td>");
                if (this.ram8Enabled) {
                    if (this.kcTypeNum > 4) {
                        stringBuilder.append("Bank ");
                        stringBuilder.append(this.ram8SegNum);
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append("ein");
                    if (!this.ram8Writeable) {
                        stringBuilder.append("(schreibgesch&uuml;tzt)");
                    }
                    if (this.irmEnabled) {
                        stringBuilder.append(", aber vom IRM &uuml;berdeckt");
                    }
                } else {
                    stringBuilder.append("aus");
                }
                stringBuilder.append("</td></tr>\n");
            }
            stringBuilder.append("<tr><td>IRM:</td><td>");
            if (this.irmEnabled) {
                if (this.kcTypeNum >= 4) {
                    stringBuilder.append("Bank ");
                    stringBuilder.append(this.screen1Enabled ? "1" : "0");
                    stringBuilder.append(this.ramColorEnabled ? " Farb" : " Pixel");
                    stringBuilder.append("ebene ");
                }
                stringBuilder.append("ein");
            } else {
                stringBuilder.append("aus");
            }
            stringBuilder.append("</td></tr>\n");
            if (this.kcTypeNum >= 4) {
                stringBuilder.append("<tr><td>Bildausgabe:</td><td>IRM-Bank ");
                stringBuilder.append(this.screen1Visible ? "1" : "0");
                stringBuilder.append("</td></tr>\n<tr><td>Hohe Farbaufl&ouml;sung:</td><td>");
                EmuUtil.appendOnOffText(stringBuilder, this.hiColorRes);
                stringBuilder.append("</td></tr>\n");
            }
            stringBuilder.append("<tr><td>Blinken:</td><td>");
            EmuUtil.appendOnOffText(stringBuilder, this.blinkEnabled);
            stringBuilder.append("</td></tr>\n");
            if (this.kcTypeNum >= 4) {
                stringBuilder.append("<tr><td>K&nbsp;OUT:</td><td>");
                stringBuilder.append(n >> 4 & 1);
                stringBuilder.append("</td></tr>\n");
            }
            stringBuilder.append("<tr><td>Motorschaltspannung:</td><td>");
            EmuUtil.appendOnOffText(stringBuilder, (n & 0x40) != 0);
            stringBuilder.append("</td></tr>\n<tr><td>");
            stringBuilder.append(this.kcTypeNum >= 4 ? "SYSTEM" : "TAPE");
            stringBuilder.append("-LED:</td><td>");
            EmuUtil.appendOnOffText(stringBuilder, (n & 0x20) != 0);
            stringBuilder.append("</td></tr>\n</table>\n");
            AbstractKC85Module[] abstractKC85ModuleArray = this.modules;
            if (abstractKC85ModuleArray != null && abstractKC85ModuleArray.length > 0) {
                stringBuilder.append("<h2>Module</h2>\n<table border=\"1\">\n<tr><th>Schacht</th><th>Modul</th><th>Strukturbyte</th><th>Status</th><th>Adresse</th><th>Segment</th><th>Sonstiges</th></tr>\n");
                for (AbstractKC85Module abstractKC85Module : abstractKC85ModuleArray) {
                    stringBuilder.append("<tr><td>");
                    stringBuilder.append(String.format("%02Xh", abstractKC85Module.getSlot()));
                    stringBuilder.append("</td><td>");
                    stringBuilder.append(abstractKC85Module.getModuleName());
                    stringBuilder.append("</td><td>");
                    String string = abstractKC85Module.getTypeByteText();
                    if (string != null) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append("</td><td>");
                    if (abstractKC85Module.isEnabled()) {
                        Boolean bl = abstractKC85Module.getReadWrite();
                        if (bl != null) {
                            stringBuilder.append(bl != false ? "RW" : "RO");
                        } else {
                            stringBuilder.append("ein");
                        }
                    } else {
                        stringBuilder.append("aus");
                    }
                    stringBuilder.append("</td><td>");
                    int n2 = abstractKC85Module.getBegAddr();
                    if (n2 >= 0) {
                        stringBuilder.append(String.format("%04Xh", n2));
                    }
                    stringBuilder.append("</td><td>");
                    int n3 = abstractKC85Module.getSegmentNum();
                    if (n3 >= 0) {
                        stringBuilder.append(n3);
                    }
                    stringBuilder.append("</td><td>");
                    abstractKC85Module.appendEtcInfoHTMLTo(stringBuilder);
                    stringBuilder.append("</td></tr>\n");
                }
                stringBuilder.append("</table>\n");
            }
        }
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        if (EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_EMULATE_VIDEO_TIMING, KC85.getDefaultEmulateVideoTiming())) {
            if (this.screenBufSaved == null) {
                this.screenBufSaved = new byte[81920];
            }
            this.screenBufUsed = this.screenBufSaved;
        } else {
            this.screenBufUsed = null;
        }
        this.createColors(properties);
        this.applyPasteFast(properties);
        if (this.d004 != null) {
            this.d004.applySettings(properties);
        }
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = this.emulatesD004(properties);
        boolean bl2 = EmuUtil.getProperty(properties, "jkcemu.system").equals(this.sysName);
        if (bl2 && this.kcTypeNum > 2 && !TextUtil.equals(this.basicFile, this.getProperty(properties, PROP_ROM_BASIC_FILE))) {
            bl2 = false;
        }
        if (bl2 && this.kcTypeNum > 3 && !TextUtil.equals(this.caosFileC, this.getProperty(properties, PROP_ROM_CAOS_C_FILE))) {
            bl2 = false;
        }
        if (bl2 && !TextUtil.equals(this.caosFileE, this.getProperty(properties, PROP_ROM_CAOS_E_FILE))) {
            bl2 = false;
        }
        if (bl2 && !TextUtil.equals(this.caosFileF, this.getProperty(properties, PROP_ROM_CAOS_F_FILE))) {
            bl2 = false;
        }
        if (bl2 && !TextUtil.equals(this.m052File, this.getProperty(properties, PROP_ROM_M052_FILE))) {
            bl2 = false;
        }
        if (bl2) {
            if (bl) {
                if (this.d004 == null || !this.d004RomProp.equals(this.getD004RomProp(properties))) {
                    bl2 = false;
                }
            } else if (this.d004 != null) {
                bl2 = false;
            }
        }
        if (bl2 && this.d004 != null) {
            bl2 = this.d004.canApplySettings(properties);
        }
        if (bl2 && properties != null) {
            Object object;
            Object object2;
            int n = EmuUtil.getIntProperty(properties, this.propPrefix + PROP_MODULE_PREFIX + "count", 0);
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>(n + 1);
            boolean bl3 = true;
            int n2 = 8;
            while (bl3 && n > 0 && n2 < 256) {
                bl3 = false;
                object2 = String.format("%s%s%02X.", this.propPrefix, PROP_MODULE_PREFIX, n2);
                String string = properties.getProperty((String)object2 + PROP_NAME);
                if (string == null || string.isEmpty()) continue;
                object = properties.getProperty((String)object2 + PROP_TYPEBYTE);
                String string2 = properties.getProperty((String)object2 + "file");
                int n3 = 1;
                if (string.equals("M035x4")) {
                    string = "M035";
                    n3 = 4;
                } else if (string.equals("M052")) {
                    string2 = this.m052File;
                }
                for (int i = 0; i < n3; ++i) {
                    String[] stringArray = new String[]{String.valueOf(n2 + i), string, object, string2};
                    arrayList.add(stringArray);
                }
                --n;
                n2 += 4;
                bl3 = true;
            }
            if (bl && this.d004 != null) {
                object2 = new String[]{String.valueOf(this.d004.getSlot()), this.d004.getModuleName(), this.d004.getTypeByteText(), null};
                arrayList.add((Object[])object2);
            }
            if ((object2 = this.modules) != null) {
                if (arrayList.size() == ((Object[])object2).length) {
                    for (int i = 0; i < ((Object[])object2).length; ++i) {
                        object = (String[])arrayList.get(i);
                        if (((AbstractKC85Module)object2[i]).equalsModule(object[0], object[1], object[2], object[3])) continue;
                        bl2 = false;
                        break;
                    }
                } else {
                    bl2 = false;
                }
            } else if (!arrayList.isEmpty()) {
                bl2 = false;
            }
        }
        return bl2;
    }

    @Override
    public boolean canExtractScreenText() {
        return true;
    }

    @Override
    public AbstractKeyboardFld createKeyboardFld() throws UserCancelException {
        block5: {
            block4: {
                if (this.kcTypeNum < 4) break block4;
                switch (BaseDlg.showOptionDlg(this.screenFrm, "Welche Tastatur m\u00f6chten Sie sehen,\ndie originale oder die D005?", "Tastaturauswahl", "Original", "D005", "Abbrechen")) {
                    case 0: {
                        this.keyboardFld = new KC85KeyboardFld(this);
                        break block5;
                    }
                    case 1: {
                        this.keyboardFld = new D005KeyboardFld(this);
                        break block5;
                    }
                    default: {
                        throw new UserCancelException();
                    }
                }
            }
            this.keyboardFld = new KC85KeyboardFld(this);
        }
        return this.keyboardFld;
    }

    @Override
    public void die() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        this.ctc.removeCTCListener(this);
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.setInterruptSources(null);
        if (this.d004 != null) {
            this.d004.fireStop();
            this.d004.die();
        }
        if (this.modules != null) {
            for (int i = 0; i < this.modules.length; ++i) {
                AbstractKC85Module abstractKC85Module = this.modules[i];
                if (abstractKC85Module instanceof Z80TStatesListener) {
                    z80CPU.removeTStatesListener((Z80TStatesListener)((Object)abstractKC85Module));
                }
                if (abstractKC85Module instanceof Z80MaxSpeedListener) {
                    z80CPU.removeMaxSpeedListener((Z80MaxSpeedListener)((Object)abstractKC85Module));
                }
                abstractKC85Module.die();
            }
        }
    }

    @Override
    public boolean getAutoLoadInputOnSoftReset() {
        return false;
    }

    @Override
    public int getBasicMemByte(int n) {
        return this.getMemByteInternal(n, false, false, false);
    }

    @Override
    public int getBorderColorIndex() {
        return 0;
    }

    @Override
    public Color getColor(int n) {
        Color color = null;
        if (this.colors != null && n >= 0 && n < this.colors.length) {
            color = this.colors[n];
        }
        return color != null ? color : super.getColor(n);
    }

    @Override
    public int getColorCount() {
        return this.rgbValues.length;
    }

    @Override
    public int getColorIndex(int n, int n2) {
        int n3 = 0;
        byte[] byArray = this.screenBufUsed;
        if (byArray != null) {
            int n4 = n2 * 320 + n;
            if (n4 >= 0 && n4 < byArray.length) {
                n3 = byArray[n4];
            }
        } else {
            int n5 = n / 8;
            if (this.kcTypeNum > 3) {
                boolean bl = this.screen1Visible;
                byte[] byArray2 = this.screen1Visible ? this.ramPixel1 : this.ramPixel0;
                byte[] byArray3 = this.screen1Visible ? this.ramColor1 : this.ramColor0;
                int n6 = n5 * 256 + n2;
                if (n6 >= 0 && n6 < byArray2.length) {
                    byte by = byArray2[n6];
                    byte by2 = byArray3[n6];
                    int n7 = 128;
                    int n8 = n % 8;
                    if (n8 > 0) {
                        n7 >>= n8;
                    }
                    n3 = this.hiColorRes ? ((by & n7) != 0 ? ((by2 & n7) != 0 ? 7 : 2) : ((by2 & n7) != 0 ? 5 : 0)) : this.getColorIndex((int)by2, (by & n7) != 0);
                }
            } else {
                int n9 = -1;
                int n10 = -1;
                if (n5 < 32) {
                    n9 = n2 << 5 & 0x1E00 | n2 << 7 & 0x180 | n2 << 3 & 0x60 | n5 & 0x1F;
                    n10 = 0x2800 | n2 << 3 & 0x7E0 | n5 & 0x1F;
                } else {
                    n9 = 0x2000 | n2 << 3 & 0x600 | n2 << 7 & 0x180 | n2 << 3 & 0x60 | n2 >> 1 & 0x18 | n5 & 7;
                    n10 = 0x3000 | n2 << 1 & 0x180 | n2 << 3 & 0x60 | n2 >> 1 & 0x18 | n5 & 7;
                }
                if (n9 >= 0 && n9 < this.ramPixel0.length && n10 >= 0 && n10 < this.ramPixel0.length) {
                    byte by = this.ramPixel0[n9];
                    byte by3 = this.ramPixel0[n10];
                    int n11 = 128;
                    int n12 = n % 8;
                    if (n12 > 0) {
                        n11 >>= n12;
                    }
                    n3 = this.getColorIndex((int)by3, (by & n11) != 0);
                }
            }
        }
        return n3;
    }

    @Override
    public boolean getConvertKeyCharToISO646DE() {
        return false;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        this.copyPixelsToCharRecognizer();
        return this.charRecognizer.recognizeCharRaster();
    }

    @Override
    public FloppyDiskFormat getDefaultFloppyDiskFormat() {
        return FloppyDiskFormat.FMT_780K_I3;
    }

    @Override
    protected long getDelayMillisAfterPasteChar() {
        return this.pasteFast ? 0L : super.getDelayMillisAfterPasteChar();
    }

    @Override
    protected long getDelayMillisAfterPasteEnter() {
        return this.pasteFast ? 0L : super.getDelayMillisAfterPasteEnter();
    }

    @Override
    protected long getHoldMillisPasteChar() {
        return this.pasteFast ? 0L : super.getHoldMillisPasteChar();
    }

    @Override
    public String getHelpPage() {
        return "/help/kc85.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        return this.getMemByteInternal(n, this.irmEnabled, bl, false);
    }

    @Override
    public int getResetStartAddress(EmuThread.ResetLevel resetLevel) {
        return resetLevel == EmuThread.ResetLevel.WARM_RESET ? 57344 : 61440;
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        this.copyPixelsToCharRecognizer();
        return this.charRecognizer.getChar(charRaster, n2, n);
    }

    @Override
    public int getScreenHeight() {
        return 256;
    }

    @Override
    public int getScreenWidth() {
        return 320;
    }

    @Override
    public KC85LEDFld getSecondScreenDevice() {
        if (this.ledFld == null) {
            this.ledFld = new KC85LEDFld(this, Main.getProperties());
            this.ledFld.setPioAValue(this.pio.fetchOutValuePortA(false));
        }
        return this.ledFld;
    }

    @Override
    public String getSecondSystemName() {
        return this.d004 != null ? "D004" : null;
    }

    @Override
    public Z80CPU getSecondZ80CPU() {
        return this.d004 != null ? this.d004.getZ80CPU() : null;
    }

    @Override
    public Z80Memory getSecondZ80Memory() {
        return this.d004 != null ? this.d004.getZ80Memory() : null;
    }

    @Override
    public FloppyDiskInfo[] getSuitableFloppyDisks() {
        return this.d004 != null ? availableFloppyDisks : null;
    }

    @Override
    public int getSupportedFloppyDiskDriveCount() {
        return this.d004 != null ? this.d004.getSupportedFloppyDiskDriveCount() : 0;
    }

    @Override
    public int getSupportedJoystickCount() {
        return this.joyModule != null ? 1 : 0;
    }

    @Override
    public boolean getSwapKeyCharCase() {
        return true;
    }

    @Override
    public String getTitle() {
        String string = SYSTEXT_KC85_5;
        switch (this.sysName) {
            case "HC900": {
                string = "HC900";
                break;
            }
            case "KC85_2": {
                string = SYSTEXT_KC85_2;
                break;
            }
            case "KC85_3": {
                string = SYSTEXT_KC85_3;
                break;
            }
            case "KC85_4": {
                string = SYSTEXT_KC85_4;
            }
        }
        return string;
    }

    @Override
    protected VDIP getVDIP() {
        return this.vdip;
    }

    @Override
    public boolean hasKCBasicInROM() {
        return this.kcTypeNum > 2;
    }

    @Override
    public boolean isAutoScreenRefresh() {
        return this.screenBufUsed != null;
    }

    @Override
    public boolean isSecondSystemRunning() {
        return this.d004 != null ? this.d004.isRunning() : false;
    }

    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n2 = this.getKeyTabAddrIfPCMode();
        boolean bl4 = n2 >= 0;
        int n3 = -1;
        int n4 = -1;
        switch (n) {
            case 8: {
                n4 = bl4 ? 40 : 24;
                break;
            }
            case 37: {
                n4 = bl2 ? 7 : 6;
                break;
            }
            case 39: {
                n4 = bl2 ? 123 : 122;
                break;
            }
            case 40: {
                n4 = bl2 ? 119 : 118;
                break;
            }
            case 38: {
                n4 = bl2 ? 121 : 120;
                break;
            }
            case 35: {
                n4 = 123;
                break;
            }
            case 34: {
                n4 = 119;
                break;
            }
            case 33: {
                n4 = 121;
                break;
            }
            case 10: {
                n4 = bl2 ? 127 : 126;
                break;
            }
            case 36: {
                n4 = bl2 ? 9 : 8;
                break;
            }
            case 155: {
                n4 = bl2 ? 57 : 56;
                break;
            }
            case 9: {
                n4 = bl4 ? 71 : 115;
                break;
            }
            case 27: {
                n4 = bl4 ? 125 : 77;
                break;
            }
            case 127: {
                if (bl4) {
                    if (bl) {
                        n4 |= 0x7C00;
                        break;
                    }
                    n4 = 24;
                    break;
                }
                n4 = bl2 ? 41 : 40;
                break;
            }
            case 32: {
                int n5 = n4 = bl2 ? 71 : 70;
                if (!bl4 || !bl) break;
                n4 |= 0x7C00;
                break;
            }
            case 112: {
                int n6 = n4 = bl2 ? 125 : 124;
                if (!bl4) break;
                n3 = bl2 ? 247 : 241;
                break;
            }
            case 113: {
                n4 = bl2 ? 13 : 12;
                break;
            }
            case 114: {
                n4 = bl2 ? 29 : 28;
                break;
            }
            case 115: {
                int n7 = n4 = bl2 ? 109 : 108;
                if (!bl4 || !bl) break;
                n4 |= 0x7C00;
                break;
            }
            case 116: {
                int n8 = n4 = bl2 ? 45 : 44;
                if (!bl4 || !bl) break;
                n4 |= 0x7C00;
                break;
            }
            case 117: {
                n4 = bl2 ? 93 : 92;
                break;
            }
            case 118: {
                n4 = bl2 ? 61 : 60;
                break;
            }
            case 119: {
                n4 = bl2 ? 77 : 76;
                break;
            }
            case 120: {
                n4 = bl2 ? 25 : 24;
                break;
            }
            case 122: {
                n4 = 86;
                break;
            }
            case 123: {
                n4 = 87;
                break;
            }
            case 49: {
                if (!bl4 || !bl) break;
                n4 = 31796;
                break;
            }
            case 50: {
                if (!bl4 || !bl) break;
                n4 = 31812;
            }
        }
        if (n4 >= 0) {
            if (this.keyDirectToBuf) {
                if (n3 <= 0) {
                    n3 = this.keyNumToChar(n4, n2, bl);
                }
                if (n3 > 0) {
                    bl3 = this.putCharToKeyBuffer((char)n3);
                }
            }
            if (!bl3) {
                this.setKeyNumPressed(n4);
            }
            this.updKeyboardFld(n4);
            bl3 = true;
        }
        return bl3;
    }

    @Override
    public void keyReleased() {
        int n;
        this.keyNumPressed = -1;
        this.updKeyboardFld(-1);
        if (this.keyDirectToBuf && (n = this.getRegIX()) >= 0) {
            this.setMemByte(n + 13, 0);
            this.setMemByte(n + 8, this.getMemByte(n + 8, false) & 0xFE);
        }
    }

    @Override
    public boolean keyTyped(char n) {
        boolean bl = false;
        int n2 = this.getKeyTabAddrIfPCMode();
        boolean bl2 = n2 >= 0;
        int n3 = this.charToKeyNum((char)n, bl2);
        if (n3 >= 0) {
            if (this.keyDirectToBuf) {
                int n4 = n;
                if (n3 == (n3 & 0xFF)) {
                    n4 = this.keyNumToChar(n3, n2, n < 32);
                } else if (n > 0) {
                    n4 = TextUtil.umlautToISO646DE((char)n);
                }
                if (n4 > 0) {
                    bl = this.putCharToKeyBuffer((char)n4);
                }
            }
            if (!bl) {
                this.setKeyNumPressed(n3);
                bl = true;
            }
        } else if (n > 0 && this.keyDirectToBuf) {
            bl = this.putCharToKeyBuffer(TextUtil.umlautToISO646DE((char)n));
        }
        this.updKeyboardFld(n3);
        return bl;
    }

    @Override
    public void loadIntoMem(int n, byte[] byArray, int n2, int n3, FileFormat fileFormat, int n4) {
        if (byArray != null) {
            boolean bl = this.irmEnabled;
            if (fileFormat != null && (fileFormat.equals(FileFormat.KCB) || fileFormat.equals(FileFormat.KCTAP_BASIC_PRG) || fileFormat.equals(FileFormat.KCTAP_BASIC_DATA) || fileFormat.equals(FileFormat.KCTAP_BASIC_ASC) || fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG) || fileFormat.equals(FileFormat.KCBASIC_HEAD_DATA) || fileFormat.equals(FileFormat.KCBASIC_HEAD_ASC) || fileFormat.equals(FileFormat.KCBASIC_PRG))) {
                bl = false;
            }
            int n5 = n;
            for (int i = n3; n2 < byArray.length && n5 < 65536 && i > 0; --i) {
                this.setMemByteInternal(n5++, byArray[n2++], bl);
            }
            this.updSysCells(n, n3, fileFormat, n4);
        }
    }

    @Override
    public void loadIntoSecondSystem(byte[] byArray, int n, int n2) {
        if (this.d004 != null) {
            this.d004.loadIntoRAM(byArray, n, n2);
        }
    }

    @Override
    public void openBasicProgram() {
        SourceUtil.openKCBasicProgram(this.screenFrm, this.getKCBasicBegAddr(), basicTokens);
    }

    @Override
    protected boolean pasteChar(char c) throws InterruptedException {
        boolean bl = false;
        if ((this.pasteFast || this.keyDirectToBuf) && c > '\u0000' && c <= '\u00ff') {
            int n;
            if (c == '\n') {
                c = (char)13;
            }
            if ((n = this.getRegIX()) >= 0) {
                if ((this.getMemByte(n + 8, false) & 1) != 0) {
                    do {
                        Thread.sleep(10L);
                    } while ((this.getMemByte(n + 8, false) & 1) != 0);
                }
                this.setMemByte(n + 13, c);
                this.setMemByte(n + 8, this.getMemByte(n + 8, false) | 1);
                bl = true;
            }
        }
        if (!bl) {
            bl = super.pasteChar(c);
        }
        return bl;
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        block0 : switch (n & 0xFF) {
            case 128: {
                if (this.modules == null) break;
                int n4 = n >> 8 & 0xFF;
                for (int i = 0; i < this.modules.length; ++i) {
                    if (this.modules[i].getSlot() != n4) continue;
                    n3 = this.modules[i].getTypeByte();
                    break block0;
                }
                break;
            }
            case 136: {
                n3 = this.pio.readDataA();
                break;
            }
            case 137: {
                n3 = this.pio.readDataB();
                break;
            }
            case 138: {
                n3 = this.pio.readControlA();
                break;
            }
            case 139: {
                n3 = this.pio.readControlB();
                break;
            }
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                n3 = this.ctc.read(n & 3, n2);
                break;
            }
            default: {
                if (this.modules == null) break;
                for (int i = 0; i < this.modules.length; ++i) {
                    int n5 = this.modules[i].readIOByte(n, n2);
                    if (n5 < 0) continue;
                    n3 = n5;
                    break block0;
                }
            }
        }
        return n3;
    }

    @Override
    public int readMemByte(int n, boolean bl) {
        return this.getMemByteInternal(n, this.irmEnabled, bl, true);
    }

    @Override
    public int reassembleSysCall(Z80MemView z80MemView, int n, StringBuilder stringBuilder, boolean bl, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = this.getRegIX();
        if (n6 >= 0 && z80MemView == this.emuThread) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11 = z80MemView.getMemByte(n6 + 9, false);
            int n12 = z80MemView.getMemByte(n, false);
            if (n <= 65534 && (n12 == 127 || n12 == n11) && z80MemView.getMemByte(n + 1, false) == n12) {
                int n13;
                n10 = n13 = stringBuilder.length();
                if (!bl) {
                    stringBuilder.append(String.format("%04X  %02X %02X", n, n12, n12));
                }
                KC85.appendSpacesToCol(stringBuilder, n10, n2);
                stringBuilder.append("DB");
                KC85.appendSpacesToCol(stringBuilder, n10, n3);
                if (n12 >= 160) {
                    stringBuilder.append(String.format("0%02XH,0%02XH", n12, n12));
                } else {
                    stringBuilder.append(String.format("%02XH,%02XH", n12, n12));
                }
                KC85.appendSpacesToCol(stringBuilder, n10, n4);
                stringBuilder.append(";MENU ITEM\n");
                n10 = stringBuilder.length();
                long l = 0L;
                n9 = 0;
                n7 = n8 = n + 2;
                n12 = z80MemView.getMemByte(n7++, false);
                while (n7 < 65535 && n12 >= 48 && (n12 < 96 || n12 < 127 && this.kcTypeNum > 4)) {
                    if (n9 == 5) {
                        if (!bl) {
                            stringBuilder.append(String.format("%04X  %02X %02X %02X %02X %02X", n8, l >> 32 & 0xFFL, l >> 24 & 0xFFL, l >> 16 & 0xFFL, l >> 8 & 0xFFL, l & 0xFFL));
                        }
                        KC85.appendSpacesToCol(stringBuilder, n10, n2);
                        stringBuilder.append("DB");
                        KC85.appendSpacesToCol(stringBuilder, n10, n3);
                        stringBuilder.append('\'');
                        stringBuilder.append((char)(l >> 32 & 0xFFL));
                        stringBuilder.append((char)(l >> 24 & 0xFFL));
                        stringBuilder.append((char)(l >> 16 & 0xFFL));
                        stringBuilder.append((char)(l >> 8 & 0xFFL));
                        stringBuilder.append((char)(l & 0xFFL));
                        stringBuilder.append("'\n");
                        n8 = n7 - 1;
                        n9 = 0;
                        n10 = stringBuilder.length();
                    }
                    l = l << 8 | (long)(n12 & 0xFF);
                    ++n9;
                    n12 = z80MemView.getMemByte(n7++, false);
                }
                if (n9 > 0) {
                    int n14;
                    if (!bl) {
                        stringBuilder.append(String.format("%04X ", n8));
                        for (n14 = 0; n14 < n9; ++n14) {
                            stringBuilder.append(String.format(" %02X", l >> (n9 - n14 - 1) * 8 & 0xFFL));
                        }
                    }
                    KC85.appendSpacesToCol(stringBuilder, n10, n2);
                    stringBuilder.append("DB");
                    KC85.appendSpacesToCol(stringBuilder, n10, n3);
                    stringBuilder.append('\'');
                    for (n14 = 0; n14 < n9; ++n14) {
                        stringBuilder.append((char)(l >> (n9 - n14 - 1) * 8 & 0xFFL));
                    }
                    stringBuilder.append("'\n");
                }
                if (n7 >= n + 4 && n12 >= 0 && (n12 <= 1 || n12 <= 31 && this.kcTypeNum > 4)) {
                    n10 = stringBuilder.length();
                    if (!bl) {
                        stringBuilder.append(String.format("%04X  %02X", n7 - 1, n12));
                    }
                    KC85.appendSpacesToCol(stringBuilder, n10, n2);
                    stringBuilder.append("DB");
                    KC85.appendSpacesToCol(stringBuilder, n10, n3);
                    stringBuilder.append(String.format("%02XH", n12));
                    stringBuilder.append('\n');
                    n5 = n7 - n;
                } else {
                    stringBuilder.setLength(n13);
                }
            }
            if (n5 == 0) {
                n12 = z80MemView.getMemByte(n, true);
                String string = null;
                switch (n12) {
                    case 195: {
                        string = "JP";
                        break;
                    }
                    case 205: {
                        string = "CALL";
                    }
                }
                if (string != null && z80MemView.getMemWord(n + 1) == 61443) {
                    n10 = stringBuilder.length();
                    int n15 = z80MemView.getMemByte(n + 3, false);
                    if (!bl) {
                        stringBuilder.append(String.format("%04X  %02X 03 F0", n, n12));
                    }
                    KC85.appendSpacesToCol(stringBuilder, n10, n2);
                    stringBuilder.append(string);
                    KC85.appendSpacesToCol(stringBuilder, n10, n3);
                    stringBuilder.append("0F003H\n");
                    n10 = stringBuilder.length();
                    if (!bl) {
                        stringBuilder.append(String.format("%04X  %02X", n + 3 & 0xFFFF, n15));
                    }
                    KC85.appendSpacesToCol(stringBuilder, n10, n2);
                    stringBuilder.append("DB");
                    KC85.appendSpacesToCol(stringBuilder, n10, n3);
                    if (n15 >= 160) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(String.format("%02XH", n15));
                    if (n15 >= 0 && n15 < sysCallNames.length) {
                        KC85.appendSpacesToCol(stringBuilder, n10, n4);
                        stringBuilder.append(';');
                        stringBuilder.append(sysCallNames[n15]);
                    }
                    stringBuilder.append('\n');
                    n5 = 4;
                    if (n15 == 35) {
                        n5 += this.reassembleStringTerm0(z80MemView, n + n5, stringBuilder, bl, n2, n3);
                    }
                }
            }
            if (n5 == 0) {
                int n16;
                n12 = z80MemView.getMemByte(n, true);
                String string = null;
                String string2 = null;
                Object var14_19 = null;
                if ((n12 & 0xC7) == 194) {
                    string = "JP";
                } else if ((n12 & 0xC7) == 196) {
                    string = "CALL";
                }
                if (string != null) {
                    n16 = n12 >> 3 & 7;
                    if (n16 >= 0 && n16 < cpuFlags.length) {
                        string2 = cpuFlags[n16];
                    } else {
                        string = null;
                    }
                } else if (n12 == 195) {
                    string = "JP";
                } else if (n12 == 205) {
                    string = "CALL";
                }
                if (string != null) {
                    n16 = z80MemView.getMemWord(n + 1);
                    n9 = this.getMemByteInternal(47025, true, false, false) << 8 & 0xFF00 | this.getMemByteInternal(47024, true, false, false) & 0xFF;
                    n8 = 0;
                    while (n8 < sysCallNames.length) {
                        if (n16 == z80MemView.getMemWord(n9)) {
                            n7 = stringBuilder.length();
                            if (!bl) {
                                stringBuilder.append(String.format("%04X  %02X %02X %02X", n, n12, n16 >> 8 & 0xFF, n16 & 0xFF));
                            }
                            KC85.appendSpacesToCol(stringBuilder, n7, n2);
                            stringBuilder.append(string);
                            KC85.appendSpacesToCol(stringBuilder, n7, n3);
                            if (string2 != null) {
                                stringBuilder.append(string2);
                                stringBuilder.append(',');
                            }
                            if (n16 >= 40960) {
                                stringBuilder.append('0');
                            }
                            stringBuilder.append(String.format("%04XH", n16));
                            KC85.appendSpacesToCol(stringBuilder, n7, n4);
                            stringBuilder.append(';');
                            stringBuilder.append(sysCallNames[n8]);
                            stringBuilder.append('\n');
                            n5 = 3;
                            if (n8 != 35) break;
                            n5 += this.reassembleStringTerm0(z80MemView, n + n5, stringBuilder, bl, n2, n3);
                            break;
                        }
                        ++n8;
                        n9 += 2;
                    }
                }
            }
        }
        return n5;
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        boolean bl = false;
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            bl = true;
            if (this.isReloadExtROMsOnPowerOnEnabled(properties)) {
                this.loadROMs(properties);
            }
            if (this.ram8 != null) {
                Arrays.fill(this.ram8, (byte)0);
            }
            Arrays.fill(this.ramColor0, (byte)0);
            Arrays.fill(this.ramColor1, (byte)0);
            Arrays.fill(this.ramPixel0, (byte)0);
            Arrays.fill(this.ramPixel1, (byte)0);
            if (this.modules != null) {
                for (int i = 0; i < this.modules.length; ++i) {
                    this.modules[i].clearRAM();
                }
            }
        }
        if (resetLevel == EmuThread.ResetLevel.COLD_RESET) {
            bl = true;
        }
        this.basicSegNum = 0;
        this.basicC000Enabled = false;
        this.caosC000Enabled = false;
        this.caosE000Enabled = true;
        this.kout = null;
        this.blinkEnabled = false;
        this.blinkState = false;
        this.biState = false;
        this.h4State = false;
        this.hiColorRes = false;
        this.irmEnabled = true;
        this.ram0Enabled = true;
        this.ram0Writeable = true;
        this.ram4Writeable = this.ram4Enabled = this.kcTypeNum > 3;
        this.ram8Enabled = false;
        this.ram8SegNum = 2;
        this.ram8Writeable = false;
        this.ramColorEnabled = false;
        this.screen1Enabled = false;
        this.screen1Visible = false;
        this.screenDirty = true;
        this.screenRefreshEnabled = false;
        this.soundOutPhaseL = false;
        this.soundOutPhaseL = false;
        this.soundOutValueM = 0;
        this.soundOutValueL = 0;
        this.soundOutValueR = 0;
        this.curSoundOutTStates = 0;
        this.tapeInPhase = this.emuThread.readTapeInPhase();
        this.lineTStateCounter = 0;
        this.lineCounter = 0;
        this.lastIX = -1;
        this.keyNumStageBuf = 0;
        this.keyNumStageNum = 0;
        this.keyNumStageMillis = -1L;
        this.keyNumPressed = -1;
        this.keyNumProcessing = -1;
        this.keyShiftBitCnt = 0;
        this.keyShiftValue = 0;
        this.keyTStates = 0;
        this.ctc.reset(bl);
        this.pio.reset(bl);
        this.updSoundOut();
    }

    @Override
    public void saveBasicProgram() {
        SourceUtil.saveKCBasicProgram(this.screenFrm, this.getKCBasicBegAddr());
    }

    @Override
    public boolean setBasicMemByte(int n, int n2) {
        return this.setMemByteInternal(n, n2, false);
    }

    @Override
    public void setFloppyDiskDrive(int n, FloppyDiskDrive floppyDiskDrive) {
        if (this.d004 != null) {
            this.d004.setDrive(n, floppyDiskDrive);
        }
    }

    @Override
    public void setJoystickAction(int n, int n2) {
        KC85JoystickModule kC85JoystickModule = this.joyModule;
        if (kC85JoystickModule != null) {
            kC85JoystickModule.setJoystickAction(n, n2);
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        return this.setMemByteInternal(n, n2, this.irmEnabled);
    }

    @Override
    public boolean shouldAskConvertScreenChar() {
        return this.charSetUnknown;
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsKeyboardFld() {
        return true;
    }

    @Override
    public boolean supportsOpenBasic() {
        return true;
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return true;
    }

    @Override
    public boolean supportsPrinter() {
        boolean bl = false;
        AbstractKC85Module[] abstractKC85ModuleArray = this.modules;
        if (abstractKC85ModuleArray != null) {
            for (AbstractKC85Module abstractKC85Module : abstractKC85ModuleArray) {
                if (!abstractKC85Module.supportsPrinter()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Override
    public boolean supportsSaveBasic() {
        return true;
    }

    @Override
    public boolean supportsSoundOut8Bit() {
        return true;
    }

    @Override
    public boolean supportsSoundOutMono() {
        return true;
    }

    @Override
    public boolean supportsSoundOutStereo() {
        return true;
    }

    @Override
    public boolean supportsTapeIn() {
        return true;
    }

    @Override
    public boolean supportsTapeOut() {
        return true;
    }

    @Override
    public void updSysCells(int n, int n2, FileFormat fileFormat, int n3) {
        SourceUtil.updKCBasicSysCells(this.emuThread, n, n2, fileFormat, n3);
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        int n4 = 0;
        block0 : switch (n & 0xFF) {
            case 128: {
                if (this.modules == null) break;
                int n5 = n >> 8 & 0xFF;
                for (int i = 0; i < this.modules.length; ++i) {
                    if (this.modules[i].getSlot() != n5) continue;
                    this.modules[i].setStatus(n2);
                    break block0;
                }
                break;
            }
            case 132: 
            case 133: {
                if (this.kcTypeNum <= 3) break;
                this.screen1Visible = (n2 & 1) != 0;
                this.ramColorEnabled = (n2 & 2) != 0;
                this.screen1Enabled = (n2 & 4) != 0;
                this.hiColorRes = (n2 & 8) == 0;
                this.ram8SegNum = n2 >> 4 & 0xF;
                if (this.screenBufUsed != null) {
                    this.screenDirty = true;
                    break;
                }
                this.screenFrm.setScreenDirty(true);
                break;
            }
            case 134: 
            case 135: {
                if (this.kcTypeNum <= 3) break;
                this.ram4Enabled = (n2 & 1) != 0;
                this.ram4Writeable = (n2 & 2) != 0;
                this.basicSegNum = ~n2 >> 5 & 3;
                this.caosC000Enabled = (n2 & 0x80) != 0;
                break;
            }
            case 136: {
                this.pio.writeDataA(n2);
                n4 = this.pio.fetchOutValuePortA(false);
                this.caosE000Enabled = (n4 & 1) != 0;
                this.ram0Enabled = (n4 & 2) != 0;
                this.irmEnabled = (n4 & 4) != 0;
                this.ram0Writeable = (n4 & 8) != 0;
                boolean bl = this.basicC000Enabled = (n4 & 0x80) != 0;
                if (this.kcTypeNum >= 4) {
                    boolean bl2;
                    boolean bl3 = bl2 = (n4 & 0x10) != 0;
                    if (this.keyboardFld != null) {
                        if (this.kout != null) {
                            if (bl2 != this.kout) {
                                this.keyboardFld.fireKOut();
                            }
                        } else {
                            this.keyboardFld.fireKOut();
                        }
                    }
                    this.kout = bl2;
                }
                if (this.screenBufUsed != null) {
                    this.screenDirty = true;
                } else {
                    this.screenFrm.setScreenDirty(true);
                }
                this.ledFld.setPioAValue(n4);
                break;
            }
            case 137: {
                this.pio.writeDataB(n2);
                n4 = this.pio.fetchOutValuePortB(false);
                if (this.kcTypeNum > 3) {
                    if ((n4 & 1) == 0) {
                        this.soundOutPhaseL = false;
                        this.soundOutPhaseR = false;
                        this.updSoundOut();
                    }
                    this.ram8Enabled = (n4 & 0x20) != 0;
                    this.ram8Writeable = (n4 & 0x40) != 0;
                }
                this.blinkEnabled = (n4 & 0x80) != 0;
                break;
            }
            case 138: {
                this.pio.writeControlA(n2);
                break;
            }
            case 139: {
                this.pio.writeControlB(n2);
                break;
            }
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                this.ctc.write(n & 3, n2, n3);
                break;
            }
            default: {
                if (this.modules == null) break;
                for (int i = 0; i < this.modules.length && !this.modules[i].writeIOByte(n, n2, n3); ++i) {
                }
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        int n = this.kcTypeNum < 4 ? 1750 : 1773;
        int n2 = z80CPU.getMaxSpeedKHz() * 112 / n;
        this.tStatesLinePos0 = (int)Math.round((double)n2 * 32.0 / 112.0);
        this.tStatesLinePos1 = (int)Math.round((double)n2 * 64.0 / 112.0);
        this.tStatesLinePos2 = (int)Math.round((double)n2 * 96.0 / 112.0);
        this.tStatesPerLine = n2;
        this.soundOutTStates = z80CPU.getMaxSpeedKHz() / 50;
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        int n2;
        int n3;
        super.z80TStatesProcessed(z80CPU, n);
        this.ctc.z80TStatesProcessed(z80CPU, n);
        int n4 = this.tStatesPerLine;
        if (n4 > 0) {
            this.lineTStateCounter += n;
            if (this.lineTStateCounter >= n4) {
                this.lineTStateCounter %= n4;
                if (this.lineCounter < 311) {
                    if (this.screenRefreshEnabled) {
                        this.updScreenLine();
                        this.screenFrm.setScreenDirty(true);
                    }
                    ++this.lineCounter;
                } else {
                    this.lineCounter = 0;
                    if (this.screenDirty && this.screenBufUsed != null) {
                        this.screenDirty = false;
                        this.screenFrm.fireRepaint();
                        this.screenRefreshEnabled = true;
                    } else {
                        this.screenRefreshEnabled = false;
                    }
                }
            }
            n3 = this.lineCounter < 256 ? 1 : 0;
            n2 = 0;
            if (this.lineTStateCounter >= this.tStatesLinePos0 && this.lineTStateCounter < this.tStatesLinePos1 || this.lineTStateCounter >= this.tStatesLinePos2) {
                n2 = 1;
            }
            if (n2 != this.h4State) {
                this.h4State = n2;
                this.ctc.externalUpdate(0, n2 != 0);
                this.ctc.externalUpdate(1, n2 != 0);
            }
            if (n3 != this.biState) {
                this.biState = n3;
                this.ctc.externalUpdate(2, n3 != 0);
                this.ctc.externalUpdate(3, n3 != 0);
                KC85JoystickModule kC85JoystickModule = this.joyModule;
                if (kC85JoystickModule != null) {
                    kC85JoystickModule.setBIState(n3 != 0);
                }
            }
        }
        if (this.emuThread.readTapeInPhase() != this.tapeInPhase) {
            this.tapeInPhase = !this.tapeInPhase;
            this.pio.strobePortA();
        }
        if (this.soundOutTStates > 0) {
            if (this.curSoundOutTStates > 0) {
                this.curSoundOutTStates -= n;
            } else {
                this.curSoundOutTStates = this.soundOutTStates;
                this.emuThread.writeSoundOutValue(this.soundOutValueM, this.soundOutValueL, this.soundOutValueR);
            }
        }
        if (this.keyShiftBitCnt <= 0) {
            if (this.keyTStates > 0) {
                this.keyTStates -= n;
            }
            if (this.keyTStates <= 0) {
                n3 = this.getSingleKeyNum() ^ 1;
                if (n3 >= 0) {
                    this.keyNumProcessing = n3;
                    this.keyShiftValue = n3;
                    this.keyShiftBitCnt = 8;
                }
                this.keyTStates = 0;
            }
        }
        if (this.keyShiftBitCnt > 0) {
            n3 = 0;
            if (this.keyShiftBitCnt == 8) {
                n3 = 1;
            } else if (this.keyShiftBitCnt < 8) {
                if ((this.keyShiftValue & 1) != 0) {
                    if (this.keyTStates >= 12496) {
                        n3 = 1;
                        this.keyShiftValue >>= 1;
                    }
                } else if (this.keyTStates >= 8960) {
                    n3 = 1;
                    this.keyShiftValue >>= 1;
                }
            }
            if (n3) {
                this.pio.strobePortB();
                if (this.keyShiftBitCnt == 1) {
                    n2 = this.getSingleKeyNum() ^ 1;
                    this.keyTStates = n2 >= 0 ? (n2 == this.keyNumProcessing ? 25253 : 34055) : 0;
                    this.keyShiftBitCnt = 0;
                } else {
                    this.keyTStates = 0;
                    --this.keyShiftBitCnt;
                }
            } else {
                this.keyTStates += n;
            }
        }
    }

    private void applyPasteFast(Properties properties) {
        this.keyDirectToBuf = EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_KEYS_DIRECT_TO_BUFFER, false);
        this.pasteFast = EmuUtil.getBooleanProperty(properties, this.propPrefix + "paste.fast", true);
    }

    private int charToKeyNum(char c, boolean bl) {
        int n = -1;
        if (bl) {
            if (c > '\u0000' && c < ' ') {
                n = 0x7C00 | char2KeyNum[c + 64];
            } else {
                switch (c) {
                    case '[': 
                    case '\u00c4': {
                        n = 31844;
                        break;
                    }
                    case '\\': 
                    case '\u00d6': {
                        n = 31780;
                        break;
                    }
                    case ']': 
                    case '\u00dc': {
                        n = 31828;
                        break;
                    }
                    case '{': 
                    case '\u00e4': {
                        n = 31860;
                        break;
                    }
                    case '\u00f6': {
                        n = 31748;
                        break;
                    }
                    case '}': 
                    case '\u00fc': {
                        n = 31764;
                        break;
                    }
                    case '~': 
                    case '\u00df': {
                        n = 31786;
                    }
                }
            }
        }
        if (n < 0 && c > '\u0000' && c < char2KeyNum.length) {
            n = char2KeyNum[c];
        }
        return n;
    }

    private void copyPixelsToCharRecognizer() {
        if (this.kcTypeNum > 3) {
            byte[] byArray = this.screen1Visible ? this.ramPixel1 : this.ramPixel0;
            for (int i = 0; i < 40; ++i) {
                for (int j = 0; j < 256; ++j) {
                    this.charRecognizer.setPixelByte(i, j, byArray[i << 8 | j]);
                }
            }
        } else {
            int n;
            int n2;
            for (n2 = 0; n2 < 32; ++n2) {
                for (n = 0; n < 256; ++n) {
                    this.charRecognizer.setPixelByte(n2, n, this.ramPixel0[n << 5 & 0x1E00 | n << 7 & 0x180 | n << 3 & 0x60 | n2 & 0x1F]);
                }
            }
            for (n2 = 32; n2 < 40; ++n2) {
                for (n = 0; n < 256; ++n) {
                    this.charRecognizer.setPixelByte(n2, n, this.ramPixel0[0x2000 | n << 3 & 0x600 | n << 7 & 0x180 | n << 3 & 0x60 | n >> 1 & 0x18 | n2 & 7]);
                }
            }
        }
    }

    private void createColors(Properties properties) {
        float f = KC85.getBrightness(properties);
        if (f >= 0.0f && f <= 1.0f) {
            for (int i = 0; i < rawRGBValues.length; ++i) {
                int n = Math.round((float)rawRGBValues[i][0] * f);
                int n2 = Math.round((float)rawRGBValues[i][1] * f);
                int n3 = Math.round((float)rawRGBValues[i][2] * f);
                this.rgbValues[i] = n << 16 | n2 << 8 | n3;
                this.colors[i] = new Color(this.rgbValues[i]);
            }
        }
    }

    private AbstractKC85Module[] createModules(Properties properties) {
        int n;
        AbstractKC85Module[] abstractKC85ModuleArray = null;
        ArrayList<D004> arrayList = null;
        if (properties != null && (n = EmuUtil.getIntProperty(properties, this.propPrefix + PROP_MODULE_PREFIX + "count", 0)) > 0) {
            String string;
            String string2;
            arrayList = new ArrayList<D004>();
            int n2 = 8;
            boolean bl = true;
            while (bl && n2 < 256 && n > 0 && (string2 = properties.getProperty((string = String.format("%s%s%02X.", this.propPrefix, PROP_MODULE_PREFIX, n2)) + PROP_NAME)) != null) {
                String string3;
                if (string2.equals("M003")) {
                    arrayList.add((D004)((Object)new M003(n2, this.emuThread)));
                } else if (string2.equals("M006")) {
                    arrayList.add((D004)((Object)new M006(n2, this.emuThread)));
                } else if (string2.equals("M008")) {
                    M008 m008 = new M008(n2);
                    if (this.joyModule == null) {
                        this.joyModule = m008;
                    }
                    arrayList.add((D004)((Object)m008));
                } else if (string2.equals("M011")) {
                    arrayList.add((D004)((Object)new M011(n2)));
                } else if (string2.equals("M012")) {
                    arrayList.add((D004)((Object)new KC85ROM8KModule(n2, this.emuThread, "M012", "/rom/kc85/m012.bin")));
                } else if (string2.equals("M021")) {
                    M021 m021 = new M021(n2, this.emuThread);
                    if (this.joyModule == null) {
                        this.joyModule = m021;
                    }
                    arrayList.add((D004)((Object)m021));
                } else if (string2.equals("M022")) {
                    arrayList.add((D004)((Object)new KC85PlainRAMModule(n2, 244, "M022", 16384, false)));
                } else if (string2.equals("M025")) {
                    int n3 = 247;
                    string3 = properties.getProperty(string + PROP_TYPEBYTE);
                    if (string3 != null && string3.equals("FB")) {
                        n3 = 251;
                    }
                    arrayList.add((D004)((Object)new M025(n2, n3, this.screenFrm, properties.getProperty(string + "file"))));
                } else if (string2.equals("M026")) {
                    arrayList.add((D004)((Object)new KC85ROM8KModule(n2, this.emuThread, "M026", "/rom/kc85/m026.bin")));
                } else if (string2.equals("M027")) {
                    arrayList.add((D004)((Object)new KC85ROM8KModule(n2, this.emuThread, "M027", "/rom/kc85/m027.bin")));
                } else if (string2.equals("M028")) {
                    int n4 = 248;
                    string3 = properties.getProperty(string + PROP_TYPEBYTE);
                    if (string3 != null && string3.equals("FC")) {
                        n4 = 252;
                    }
                    arrayList.add((D004)((Object)new M028(n2, n4, this.screenFrm, properties.getProperty(string + "file"))));
                } else if (string2.equals("M032")) {
                    arrayList.add((D004)((Object)new KC85SegmentedRAMModule(n2, 121, "M032", 262144)));
                } else if (string2.equals("M033")) {
                    arrayList.add((D004)((Object)new M033(n2, this.emuThread)));
                } else if (string2.equals("M034")) {
                    arrayList.add((D004)((Object)new KC85SegmentedRAMModule(n2, 122, "M034", 524288)));
                } else if (string2.equals("M035")) {
                    arrayList.add((D004)((Object)new M035(n2)));
                } else if (string2.equals("M035x4")) {
                    arrayList.add((D004)((Object)new M035(n2)));
                    arrayList.add((D004)((Object)new M035(n2 + 1)));
                    arrayList.add((D004)((Object)new M035(n2 + 2)));
                    arrayList.add((D004)((Object)new M035(n2 + 3)));
                } else if (string2.equals("M036")) {
                    arrayList.add((D004)((Object)new KC85SegmentedRAMModule(n2, 120, "M036", 131072)));
                } else if (string2.equals("M040")) {
                    int n5 = 247;
                    string3 = properties.getProperty(string + PROP_TYPEBYTE);
                    if (string3 != null) {
                        if (string3.equals("1") || string3.equals("01")) {
                            n5 = 1;
                        } else if (string3.equals("F8")) {
                            n5 = 248;
                        }
                    }
                    arrayList.add((D004)((Object)new M040(n2, this.emuThread, n5, this.screenFrm, properties.getProperty(string + "file"))));
                } else if (string2.equals("M045")) {
                    arrayList.add((D004)((Object)new M045(n2, this.screenFrm, properties.getProperty(string + "file"))));
                } else if (string2.equals("M046")) {
                    arrayList.add((D004)((Object)new M046(n2, this.screenFrm, properties.getProperty(string + "file"))));
                } else if (string2.equals("M047")) {
                    arrayList.add((D004)((Object)new M047(n2, this.screenFrm, properties.getProperty(string + "file"))));
                } else if (string2.equals("M048")) {
                    arrayList.add((D004)((Object)new M048(n2, this.screenFrm, properties.getProperty(string + "file"))));
                } else if (string2.equals("M052")) {
                    arrayList.add((D004)((Object)new M052(n2, this.emuThread.getScreenFrm(), this.emuThread.getFileTimesViewFactory(), properties.getProperty(this.propPrefix + PROP_ROM_M052_FILE))));
                } else if (string2.equals("M120")) {
                    arrayList.add((D004)((Object)new KC85PlainRAMModule(n2, 240, "M120", 8192, true)));
                } else if (string2.equals("M122")) {
                    arrayList.add((D004)((Object)new KC85PlainRAMModule(n2, 241, "M122", 16384, true)));
                } else if (string2.equals("M124")) {
                    arrayList.add((D004)((Object)new KC85PlainRAMModule(n2, 242, "M124", 32768, true)));
                } else {
                    bl = false;
                }
                if (!bl) continue;
                n2 += 4;
                --n;
            }
        }
        if (this.d004 != null) {
            if (arrayList != null) {
                arrayList.add(this.d004);
            } else {
                abstractKC85ModuleArray = new AbstractKC85Module[]{this.d004};
            }
        }
        if (arrayList != null && (n = arrayList.size()) > 0) {
            try {
                abstractKC85ModuleArray = arrayList.toArray(new AbstractKC85Module[n]);
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
        }
        return abstractKC85ModuleArray;
    }

    private boolean emulatesD004(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_D004_ENABLED, false);
    }

    private int getColorIndex(int n, boolean bl) {
        if (!this.hiColorRes && this.blinkEnabled && this.blinkState && (n & 0x80) != 0) {
            bl = false;
        }
        return bl ? n >> 3 & 0xF : (n & 7) + 16;
    }

    private String getD004RomProp(Properties properties) {
        String string = EmuUtil.getProperty(properties, this.propPrefix + PROP_D004_ROM).toLowerCase();
        return string.equals("2.0") || string.equals("3.2") || string.equals("3.3") || string.startsWith("file:") ? string : VALUE_STANDARD;
    }

    private int getKCBasicBegAddr() {
        int n = 11265;
        if (this.kcTypeNum > 2) {
            n = 1025;
        } else if (this.modules != null) {
            for (int i = 0; i < this.modules.length; ++i) {
                AbstractKC85Module abstractKC85Module = this.modules[i];
                if (!(abstractKC85Module instanceof M006) || !abstractKC85Module.isEnabled()) continue;
                n = 1025;
            }
        }
        return n;
    }

    private int getKeyTabAddrIfPCMode() {
        int n = -1;
        if (this.d004 != null && this.d004.isRunning()) {
            boolean bl = false;
            int n2 = this.pio.getInterruptVectorPortB();
            int n3 = -1;
            switch (this.emuThread.getZ80CPU().getInterruptMode()) {
                case 0: {
                    if (this.getMemByte(56, false) != 195) break;
                    n3 = 57;
                    break;
                }
                case 1: {
                    int n4;
                    if ((n2 & 0xC7) != 199 || this.getMemByte(n4 = n2 & 0x38, false) != 195) break;
                    n3 = n4 + 1;
                    break;
                }
                case 2: {
                    n3 = this.emuThread.getZ80CPU().getRegI() << 8 & 0xFF00 | n2 & 0xFF;
                }
            }
            if (n3 >= 0 && this.getMemWord(n3) >= 57344) {
                bl = true;
            }
            if (!bl) {
                n = this.d004.getZ80Memory().getMemWord(65460);
            }
        }
        return n;
    }

    private int getMemByteInternal(int n, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        int n3 = 255;
        boolean bl4 = false;
        if ((n &= 0xFFFF) >= 0 && n < 16384) {
            if (this.ram0Enabled) {
                n3 = this.emuThread.getRAMByte(n);
                bl4 = true;
            }
        } else if (n >= 16384 && n < 32768) {
            if (this.ram4Enabled) {
                n3 = this.emuThread.getRAMByte(n);
                bl4 = true;
            }
        } else if (n >= 32768 && n < 49152) {
            n2 = n - 32768;
            if (bl) {
                byte[] byArray = null;
                byArray = n < 43008 || this.caosC000Enabled && !this.caosE000Enabled ? (this.screen1Enabled ? (this.ramColorEnabled ? this.ramColor1 : this.ramPixel1) : (this.ramColorEnabled ? this.ramColor0 : this.ramPixel0)) : this.ramPixel0;
                if (byArray != null && n2 < byArray.length) {
                    n3 = byArray[n2] & 0xFF;
                }
                bl4 = true;
            } else if (this.ram8Enabled && this.ram8 != null) {
                if (this.kcTypeNum == 4) {
                    if ((this.ram8SegNum & 1) != 0) {
                        n2 += 16384;
                    }
                    if (n2 < this.ram8.length) {
                        n3 = this.ram8[n2] & 0xFF;
                    }
                } else if (this.kcTypeNum > 4) {
                    if (this.ram8SegNum == 0) {
                        n3 = this.emuThread.getRAMByte(n - 32768);
                    } else if (this.ram8SegNum == 1) {
                        n3 = this.emuThread.getRAMByte(n - 16384);
                    } else {
                        n2 = (this.ram8SegNum - 2) * 16384 + n - 32768;
                        if (n2 >= 0 && n2 < this.ram8.length) {
                            n3 = this.ram8[n2] & 0xFF;
                        }
                    }
                }
                bl4 = true;
            }
        } else if (n >= 49152 && n < 57344) {
            n2 = n - 49152;
            if (this.kcTypeNum >= 4 && this.caosC000Enabled) {
                if (this.caosC000 != null) {
                    if (n2 < this.caosC000.length) {
                        n3 = this.caosC000[n2] & 0xFF;
                    }
                    if (n < 53248 || this.caosC000.length > 4096 || this.kcTypeNum > 4) {
                        bl4 = true;
                    }
                } else if (n < 53248 || this.kcTypeNum > 4) {
                    bl4 = true;
                }
            } else if (this.basicC000Enabled && this.basicC000 != null) {
                if (this.kcTypeNum > 4 && this.basicC000.length > 8192) {
                    switch (this.basicSegNum) {
                        case 0: {
                            n2 += 24576;
                            break;
                        }
                        case 1: {
                            n2 += 8192;
                            break;
                        }
                        case 2: {
                            n2 += 16384;
                        }
                    }
                }
                if (n2 < this.basicC000.length) {
                    n3 = this.basicC000[n2] & 0xFF;
                }
                bl4 = true;
            }
        } else if (n >= 57344 && this.caosE000Enabled) {
            if (this.kcTypeNum >= 3 || n < 61440) {
                if (this.caosE000 != null && (n2 = n - 57344) < this.caosE000.length) {
                    n3 = this.caosE000[n2] & 0xFF;
                }
            } else if (this.caosF000 != null && (n2 = n - 61440) < this.caosF000.length) {
                n3 = this.caosF000[n2] & 0xFF;
            }
            if (this.kcTypeNum >= 3 || (n & 0x800) == 0) {
                bl4 = true;
            }
        }
        if (!bl4 && this.modules != null) {
            for (n2 = 0; n2 < this.modules.length; ++n2) {
                int n4;
                if (bl2 && bl3 && this.modules[n2].getSlot() >= 16) {
                    this.emuThread.getZ80CPU().addWaitStates(1);
                }
                if ((n4 = this.modules[n2].readMemByte(n)) < 0) continue;
                n3 = n4;
                break;
            }
        }
        return n3 >= 0 ? n3 : 255;
    }

    private String getProperty(Properties properties, String string) {
        return EmuUtil.getProperty(properties, this.propPrefix + string);
    }

    private int getRegIX() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        if (z80CPU.getIFF1()) {
            int n = z80CPU.getRegIX();
            if (z80CPU.getIFF1()) {
                this.lastIX = n;
            }
        }
        return this.lastIX;
    }

    private byte[] getResource(String string) {
        byte[] byArray = null;
        if (string != null) {
            if (resources.containsKey(string)) {
                byArray = resources.get(string);
            } else {
                byArray = EmuUtil.readResource(this.screenFrm, string);
                resources.put(string, byArray);
            }
        }
        return byArray;
    }

    private int getSingleKeyNum() {
        int n = -1;
        if (this.keyNumStageNum > 0) {
            switch (this.keyNumStageNum) {
                case 1: {
                    if (System.currentTimeMillis() < this.keyNumStageMillis) {
                        ++this.keyNumStageNum;
                        break;
                    }
                    this.keyNumStageMillis = -1L;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n = this.keyNumStageBuf & 0xFF;
                    break;
                }
                case 8: {
                    n = this.keyNumStageBuf >> 8 & 0xFF;
                }
            }
            --this.keyNumStageNum;
        } else {
            int n2 = this.keyNumPressed;
            if (n2 >= 0) {
                if ((n2 & 0xFF00) != 0) {
                    this.keyNumStageBuf = n2;
                    this.keyNumStageNum = 8;
                    this.keyNumStageMillis = System.currentTimeMillis() + 300L;
                    n = n2 >> 8 & 0xFF;
                } else {
                    n = n2 & 0xFF;
                }
            }
        }
        return n;
    }

    private int keyNumToChar(int n, int n2, boolean bl) {
        int n3 = -1;
        if (n >= 0) {
            int n4 = n & 0xFF;
            if (n2 >= 0) {
                int n5 = n4 / 2 * 3;
                if (bl) {
                    n5 += 2;
                }
                if (n4 % 2 != 0) {
                    ++n5;
                }
                n3 = this.getMemByte(n2 + n5, false);
            } else {
                int n6 = this.getRegIX();
                if (n6 >= 0) {
                    n3 = this.getMemByte(this.getMemWord(n6 + 14) + n4, false);
                }
            }
        }
        return n3;
    }

    private void loadROMs(Properties properties) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (this.kcTypeNum == 2) {
            if (this.sysName.equals("HC900")) {
                string3 = "/rom/kc85/hc900_e000.bin";
                string4 = "/rom/kc85/hc900_f000.bin";
            } else {
                string3 = "/rom/kc85/caos22_e000.bin";
                string4 = "/rom/kc85/caos22_f000.bin";
            }
        } else if (this.kcTypeNum == 3) {
            string = "/rom/kc85/basic_c000.bin";
            string3 = "/rom/kc85/caos31_e000.bin";
        } else if (this.kcTypeNum == 4) {
            string = "/rom/kc85/basic_c000.bin";
            string2 = "/rom/kc85/caos42_c000.bin";
            string3 = "/rom/kc85/caos42_e000.bin";
        } else {
            string = "/rom/kc85/user45_c000.bin";
            string2 = "/rom/kc85/caos45_c000.bin";
            string3 = "/rom/kc85/caos45_e000.bin";
        }
        this.basicFile = null;
        this.basicC000 = null;
        if (this.kcTypeNum > 2) {
            this.basicFile = this.getProperty(properties, PROP_ROM_BASIC_FILE);
            this.basicC000 = this.readROMFile(this.basicFile, this.kcTypeNum > 4 ? 32768 : 8192, "BASIC-ROM");
        }
        if (this.basicC000 == null) {
            this.basicC000 = this.getResource(string);
        }
        this.caosFileC = null;
        this.caosC000 = null;
        if (this.kcTypeNum >= 4) {
            this.caosFileC = this.getProperty(properties, PROP_ROM_CAOS_C_FILE);
            this.caosC000 = this.readROMFile(this.caosFileC, 8192, "CAOS-ROM C");
        }
        if (this.caosC000 != null) {
            this.charSetUnknown = true;
        } else {
            this.caosC000 = this.getResource(string2);
        }
        this.caosFileE = this.getProperty(properties, PROP_ROM_CAOS_E_FILE);
        this.caosE000 = this.readROMFile(this.caosFileE, this.kcTypeNum < 3 ? 2048 : 8192, "CAOS-ROM E oder E+F");
        if (this.caosE000 != null) {
            this.charSetUnknown = true;
        } else {
            this.caosE000 = this.getResource(string3);
        }
        this.caosFileF = this.getProperty(properties, PROP_ROM_CAOS_F_FILE);
        this.caosF000 = this.readROMFile(this.caosFileF, this.kcTypeNum < 3 ? 2048 : 4096, "CAOS-ROM F");
        if (this.caosF000 != null) {
            this.charSetUnknown = true;
        }
        if (this.caosE000 != null && this.caosF000 == null && this.caosE000.length > 4096) {
            this.caosF000 = new byte[this.caosE000.length - 4096];
            System.arraycopy(this.caosE000, 4096, this.caosF000, 0, this.caosF000.length);
        }
        if (this.caosF000 == null) {
            this.caosF000 = this.getResource(string4);
        }
        this.m052File = this.getProperty(properties, PROP_ROM_M052_FILE);
        AbstractKC85Module[] abstractKC85ModuleArray = this.modules;
        if (abstractKC85ModuleArray != null) {
            for (AbstractKC85Module abstractKC85Module : abstractKC85ModuleArray) {
                abstractKC85Module.reload(this.screenFrm);
            }
        }
    }

    private boolean putCharToKeyBuffer(char c) {
        int n;
        boolean bl = false;
        if (c <= '\u00ff' && (n = this.getRegIX()) >= 0) {
            this.setMemByte(n + 13, c);
            this.setMemByte(n + 8, this.getMemByte(n + 8, false) | 1);
            bl = true;
        }
        return bl;
    }

    private int reassembleStringTerm0(Z80MemView z80MemView, int n, StringBuilder stringBuilder, boolean bl, int n2, int n3) {
        int n4 = 0;
        int[] nArray = new int[4];
        boolean bl2 = true;
        do {
            int n5;
            int n6;
            int n7 = 0;
            while (n7 < nArray.length) {
                n6 = z80MemView.getMemByte(n + n7, false);
                nArray[n7++] = n6;
                if (n6 != 0) continue;
                bl2 = false;
                break;
            }
            n6 = stringBuilder.length();
            if (!bl) {
                stringBuilder.append(String.format("%04X ", n));
                for (n5 = 0; n5 < n7; ++n5) {
                    stringBuilder.append(String.format(" %02X", nArray[n5]));
                }
            }
            KC85.appendSpacesToCol(stringBuilder, n6, n2);
            stringBuilder.append("DB");
            KC85.appendSpacesToCol(stringBuilder, n6, n3);
            n5 = 0;
            for (int i = 0; i < n7; ++i) {
                int n8 = nArray[i];
                if (n8 >= 32 && n8 < 127) {
                    if (n5 == 0) {
                        if (i > 0) {
                            stringBuilder.append(',');
                        }
                        stringBuilder.append('\'');
                        n5 = 1;
                    }
                    stringBuilder.append((char)n8);
                    continue;
                }
                if (n5 != 0) {
                    stringBuilder.append('\'');
                    n5 = 0;
                }
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(String.format("%02XH", n8));
            }
            if (n5 != 0) {
                stringBuilder.append('\'');
            }
            stringBuilder.append('\n');
            n += n7;
            n4 += n7;
        } while (bl2);
        return n4;
    }

    private boolean setMemByteInternal(int n, int n2, boolean bl) {
        int n3;
        boolean bl2 = false;
        boolean bl3 = false;
        if ((n &= 0xFFFF) >= 0 && n < 16384) {
            if (this.ram0Enabled) {
                if (this.ram0Writeable) {
                    this.emuThread.setRAMByte(n, n2);
                    bl2 = true;
                }
                bl3 = true;
            }
        } else if (n >= 16384 && n < 32768) {
            if (this.ram4Enabled) {
                if (this.ram4Writeable) {
                    this.emuThread.setRAMByte(n, n2);
                    bl2 = true;
                }
                bl3 = true;
            }
        } else if (n >= 32768 && n < 49152) {
            n3 = n - 32768;
            if (bl) {
                byte[] byArray = null;
                byArray = n < 43008 || this.caosC000Enabled && !this.caosE000Enabled ? (this.screen1Enabled ? (this.ramColorEnabled ? this.ramColor1 : this.ramPixel1) : (this.ramColorEnabled ? this.ramColor0 : this.ramPixel0)) : this.ramPixel0;
                if (byArray != null && n3 < byArray.length) {
                    byArray[n3] = (byte)n2;
                    if (this.screenBufUsed != null) {
                        this.screenDirty = true;
                    } else {
                        this.screenFrm.setScreenDirty(true);
                    }
                    bl2 = true;
                }
                bl3 = true;
            } else if (this.ram8Enabled && this.ram8 != null) {
                if (this.ram8Writeable) {
                    if (this.kcTypeNum == 4) {
                        if ((this.ram8SegNum & 1) != 0) {
                            n3 += 16384;
                        }
                        if (n3 < this.ram8.length) {
                            this.ram8[n3] = (byte)n2;
                            bl2 = true;
                        }
                    } else if (this.kcTypeNum > 4) {
                        if (this.ram8SegNum == 0) {
                            this.emuThread.setRAMByte(n - 32768, n2);
                        } else if (this.ram8SegNum == 1) {
                            this.emuThread.setRAMByte(n - 16384, n2);
                        } else {
                            n3 = (this.ram8SegNum - 2) * 16384 + n - 32768;
                            if (n3 >= 0 && n3 < this.ram8.length) {
                                this.ram8[n3] = (byte)n2;
                            }
                        }
                    }
                }
                bl3 = true;
            }
        } else if (n >= 49152 && n < 57344) {
            if (this.kcTypeNum >= 4 && this.caosC000Enabled) {
                if (this.caosC000 != null) {
                    if (n < 53248 || this.caosC000.length > 4096 || this.kcTypeNum > 4) {
                        bl3 = true;
                    }
                } else if (n < 53248 || this.kcTypeNum > 4) {
                    bl3 = true;
                }
            }
        } else if (n >= 57344 && this.caosE000Enabled && (this.kcTypeNum >= 3 || (n & 0x800) == 0)) {
            bl3 = true;
        }
        if (!bl3 && this.modules != null) {
            int n4;
            for (n3 = 0; n3 < this.modules.length && (n4 = this.modules[n3].writeMemByte(n, n2)) != 1; ++n3) {
                if (n4 <= 1) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    private void updSoundOut() {
        this.soundOutValueL = this.soundOutPhaseL ? 0 : 55;
        this.soundOutValueR = this.soundOutPhaseR ? 0 : 55;
        int n = (this.soundOutValueL + this.soundOutValueR) * 3 / 2;
        int n2 = this.pio.fetchOutValuePortB(false);
        if ((n2 & 0x10) != 0) {
            n = n * 30 / 100;
        }
        if ((n2 & 8) != 0) {
            n = n * 46 / 100;
        }
        if ((n2 & 4) != 0) {
            n = n * 62 / 100;
        }
        if ((n2 & 2) != 0) {
            n = n * 78 / 100;
        }
        if (this.kcTypeNum < 4 && (n2 & 1) != 0) {
            n = n * 87 / 100;
        }
        this.soundOutValueM = n;
        this.tapeOutPhase = this.soundOutPhaseL;
    }

    private void updKeyboardFld(int n) {
        if (this.keyboardFld != null) {
            this.keyboardFld.updKeySelection(n);
        }
    }

    private void updScreenLine() {
        byte[] byArray = this.screenBufUsed;
        int n = this.lineCounter;
        if (byArray != null && n >= 0 && n < 256) {
            int n2 = n * 320;
            int n3 = 0;
            for (int i = 0; i < 40; ++i) {
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                if (this.kcTypeNum > 3) {
                    n8 = this.screen1Visible ? 1 : 0;
                    byte[] byArray2 = n8 != 0 ? this.ramPixel1 : this.ramPixel0;
                    byte[] byArray3 = n8 != 0 ? this.ramColor1 : this.ramColor0;
                    n7 = i * 256 + n;
                    if (n7 < 0 || n7 >= byArray2.length) continue;
                    n6 = byArray2[n7];
                    n5 = byArray3[n7];
                    n4 = 128;
                    for (int j = 0; j < 8 && n3 < 320; ++j) {
                        int n9 = 0;
                        n9 = this.hiColorRes ? ((n6 & n4) != 0 ? ((n5 & n4) != 0 ? 7 : 2) : ((n5 & n4) != 0 ? 5 : 0)) : this.getColorIndex(n5, (n6 & n4) != 0);
                        if (n9 >= 0 && n9 < this.rgbValues.length) {
                            byArray[n2 + n3] = (byte)n9;
                            ++n3;
                        }
                        n4 >>= 1;
                    }
                    continue;
                }
                n8 = -1;
                int n10 = -1;
                if (i < 32) {
                    n8 = n << 5 & 0x1E00 | n << 7 & 0x180 | n << 3 & 0x60 | i & 0x1F;
                    n10 = 0x2800 | n << 3 & 0x7E0 | i & 0x1F;
                } else {
                    n8 = 0x2000 | n << 3 & 0x600 | n << 7 & 0x180 | n << 3 & 0x60 | n >> 1 & 0x18 | i & 7;
                    n10 = 0x3000 | n << 1 & 0x180 | n << 3 & 0x60 | n >> 1 & 0x18 | i & 7;
                }
                if (n8 < 0 || n8 >= this.ramPixel0.length || n10 < 0 || n10 >= this.ramPixel0.length) continue;
                byte by = this.ramPixel0[n8];
                n7 = this.ramPixel0[n10];
                n6 = 128;
                for (n5 = 0; n5 < 8 && n3 < 320; ++n5) {
                    n4 = this.getColorIndex(n7, (by & n6) != 0);
                    if (n4 >= 0 && n4 < this.rgbValues.length) {
                        byArray[n2 + n3] = (byte)n4;
                        ++n3;
                    }
                    n6 >>= 1;
                }
            }
        }
    }
}

