/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.CRC32;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.SaveDlg;
import jkcemu.base.SourceUtil;
import jkcemu.emusys.huebler.AbstractHueblerMC;
import jkcemu.etc.VDIP;
import jkcemu.net.KCNet;
import z80emu.Z80CPU;
import z80emu.Z80InterruptSource;
import z80emu.Z80MemView;

public class HueblerGraphicsMC
extends AbstractHueblerMC {
    public static final String SYSNAME = "HueblerGraphicsMC";
    public static final String SYSTEXT = "H\u00fcbler-Grafik-MC";
    public static final String PROP_PREFIX = "jkcemu.hgmc.";
    public static final String PROP_BASIC = "basic";
    public static final int DEFAULT_PROMPT_AFTER_RESET_MILLIS_MAX = 1000;
    public static final boolean DEFAULT_SWAP_KEY_CHAR_CASE = true;
    private static final String[] basicTokens = new String[]{"END", "FOR", "NEXT", "DATA", "PRINT #", "INPUT #", "INPUT", "DIM", "READ", "LET", "GO TO", "FNEND", "IF", "RESTORE", "GO SUB", "RETURN", "REM", "STOP", "OUT", "ON", "NULL", "WAIT", "DEF", "POKE", "PRINT", "CLEAR", "FNRETURN", "SAVE", "!", "ELSE", "LPRINT", "TRACE", "LTRACE", "RANDOMIZE", "SWITCH", "LWIDTH", "LNULL", "WIDTH", "LVAR", "LLVAR", "'", "PRECISION", "CALL", "ERASE", "SWAP", "LINE", "RUN", "LOAD", "NEW", "AUTO", "COPY", "ALOAD", "AMERGE", "ASAVE", "LIST", "LLIST", "RENUMBER", "DELETE", "EDIT", "DEG", "RAD", "WHILE", "WEND", "REPEAT", "UNTIL", "ERROR", "RESUME", "OPEN", "CLOSE", "CLS", "CURSOR", "DRAW", "MOVE", "PLOT", "PEN", "PAGE", "SYSTEM", "CONT", "USING", "PI", "TAB(", "TO", "FN", "SPC(", "THEN", "NOT", "STEP", "+", "-", "*", "/", "DIV", "MOD", "^", "AND", "OR", "XOR", ">", "=", "<"};
    private static final String[] basicTokensFF = new String[]{"SGN", "INT", "FIX", "ABS", "USR", "FRE", "INP", "POS", "LPOS", "EOF", "SQR", "RND", "LOG", "EXP", "COS", "SIN", "TAN", "ATN", "PEEK", "FRAC", "LGT", "SQU", "BIN$", "HEX$", "LEN", "STR$", "VAL", "ASC", "SPACE$", "CHR$", "LEFT$", "RIGHT$", "MID$", "INKEY$", "STRING$", "ERR", "ERL", "POINT", "INSTR"};
    private static final String[] sysCallNames = new String[]{"START", "CI", "RI", "CO", "POO", "LO", "CSTS", "IOBYTE", "IOSET", "MEMSI", "MAIN"};
    private static byte[] monBytes = null;
    private static byte[] monBasicBytes = null;
    private static Map<Long, Character> pixelCRC32ToChar = null;
    private byte[] romBytes = null;
    private String romFile = null;
    private boolean romEnabled = true;
    private boolean basic;
    private int videoBaseAddr = 0;
    private KCNet kcNet;
    private VDIP vdip;

    public HueblerGraphicsMC(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        this.createIOSystem();
        this.kcNet = null;
        if (this.emulatesKCNet(properties)) {
            this.kcNet = new KCNet("Netzwerk-PIO (E/A-Adressen C0h-C3h)");
        }
        this.vdip = null;
        if (this.emulatesUSB(properties)) {
            this.vdip = new VDIP(this.emuThread.getFileTimesViewFactory(), "USB-PIO (E/A-Adressen FCh-FFh)");
        }
        Z80CPU z80CPU = emuThread.getZ80CPU();
        if (this.kcNet != null || this.vdip != null) {
            ArrayList<Z80InterruptSource> arrayList = new ArrayList<Z80InterruptSource>();
            arrayList.add(this.ctc);
            arrayList.add(this.pio);
            if (this.kcNet != null) {
                arrayList.add(this.kcNet);
            }
            if (this.vdip != null) {
                arrayList.add(this.vdip);
            }
            try {
                z80CPU.setInterruptSources(arrayList.toArray(new Z80InterruptSource[arrayList.size()]));
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
            if (this.vdip != null) {
                this.vdip.applySettings(properties);
            }
        }
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        this.checkAddPCListener(properties);
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
        this.z80MaxSpeedChanged(z80CPU);
    }

    public static String getBasicProgram(Z80MemView z80MemView) {
        StringBuilder stringBuilder = new StringBuilder(16384);
        int n = 14192;
        int n2 = z80MemView.getMemWord(n);
        while (n2 > n + 5 && z80MemView.getMemByte(n2 - 1, false) == 0) {
            int n3;
            int n4;
            stringBuilder.append(z80MemView.getMemWord(n += 2));
            n += 2;
            int n5 = 0;
            while (n < n2) {
                int n6 = z80MemView.getMemByte(n, false);
                if (n6 == 32) {
                    ++n5;
                    ++n;
                    continue;
                }
                if (n6 == 0) break;
                for (n4 = 0; n4 <= n5; ++n4) {
                    stringBuilder.append(' ');
                }
            }
            String[] stringArray = basicTokens;
            n4 = 0;
            block3: while (n < n2 && (n3 = z80MemView.getMemByte(n++, false)) != 0) {
                if (n3 == 34) {
                    stringBuilder.append((char)n3);
                    while (n < n2 && (n3 = z80MemView.getMemByte(n++, false)) != 0) {
                        stringBuilder.append((char)n3);
                        if (n3 != 34) continue;
                        continue block3;
                    }
                    continue;
                }
                if (n4 != 0 && n3 == 157) {
                    stringBuilder.append("ELSE");
                    n4 = 0;
                    continue;
                }
                if (n4 != 0) {
                    stringBuilder.append(':');
                    n4 = 0;
                }
                if (n3 == 58) {
                    n4 = 1;
                    continue;
                }
                if (n3 == 255) {
                    stringArray = basicTokensFF;
                    continue;
                }
                if (n3 >= 128) {
                    int n7 = n3 - 128;
                    if (n7 >= 0 && n7 < stringArray.length) {
                        stringBuilder.append(stringArray[n7]);
                    }
                } else {
                    stringBuilder.append((char)n3);
                }
                stringArray = basicTokens;
            }
            stringBuilder.append('\n');
            n = n2;
            n2 = z80MemView.getMemWord(n);
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    public static int getDefaultSpeedKHz() {
        return 1500;
    }

    public static boolean getDefaultSwapKeyCharCase() {
        return true;
    }

    @Override
    public void appendStatusHTMLTo(StringBuilder stringBuilder, Z80CPU z80CPU) {
        stringBuilder.append("<h1>H&uuml;bler-Grafik-MC Status</h1>\n<table border=\"1\">\n<tr><td>ROM:</td><td>");
        EmuUtil.appendOnOffText(stringBuilder, this.romEnabled);
        stringBuilder.append("</td></tr>\n<tr><td>Bildwiederholspeicher:</td><td>");
        stringBuilder.append(String.format("%04Xh-%04Xh", this.videoBaseAddr, this.videoBaseAddr + 8191));
        stringBuilder.append("</td></tr>\n</table>\n");
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        this.checkAddPCListener(properties);
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
        if (bl && this.hasBasic(properties) != this.basic) {
            bl = false;
        }
        if (bl && this.emulatesKCNet(properties) != (this.kcNet != null)) {
            bl = false;
        }
        if (bl && this.emulatesUSB(properties) != (this.vdip != null)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean canExtractScreenText() {
        return true;
    }

    @Override
    public void die() {
        super.die();
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        if (this.kcNet != null) {
            this.kcNet.die();
        }
        if (this.vdip != null) {
            this.vdip.die();
        }
    }

    @Override
    public int getAppStartStackInitValue() {
        return 65387;
    }

    @Override
    public int getColorIndex(int n, int n2) {
        int n3 = this.emuThread.getRAMByte(this.videoBaseAddr + n2 * 32 + n / 8);
        int n4 = 1;
        int n5 = n % 8;
        if (n5 > 0) {
            n4 <<= n5;
        }
        return (n3 & n4) != 0 ? 1 : 0;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        return new CharRaster(32, 25, 10, 8, 8, 0);
    }

    @Override
    public String getHelpPage() {
        return "/help/hgmc.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2 = 255;
        if (this.romEnabled && (n &= 0xFFFF) < 32768) {
            if (!this.basic) {
                n &= 0x3FFF;
            }
            if (this.romBytes != null && n < this.romBytes.length) {
                n2 = this.romBytes[n] & 0xFF;
            }
        } else {
            n2 = this.emuThread.getRAMByte(n);
        }
        return n2;
    }

    @Override
    public int getResetStartAddress(EmuThread.ResetLevel resetLevel) {
        return 0;
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        Map<Long, Character> map;
        int n3 = -1;
        if (n >= 0 && n < 32 && n2 >= 0 && n2 < 32 && (map = this.getPixelCRC32ToCharMap()) != null) {
            CRC32 cRC32 = new CRC32();
            CRC32 cRC322 = new CRC32();
            int n4 = this.videoBaseAddr + n2 * 32 * 10 + n;
            for (int i = 0; i < 8; ++i) {
                int n5 = this.getMemByte(n4, false);
                cRC32.update(n5);
                cRC322.update(~n5 & 0xFF);
                n4 += 32;
            }
            Character c = map.get(cRC32.getValue());
            if (c == null) {
                c = map.get(cRC322.getValue());
            }
            if (c != null) {
                n3 = c.charValue();
            }
        }
        return n3;
    }

    @Override
    public int getScreenHeight() {
        return 256;
    }

    @Override
    public int getScreenWidth() {
        return 256;
    }

    @Override
    public boolean getSwapKeyCharCase() {
        return HueblerGraphicsMC.getDefaultSwapKeyCharCase();
    }

    @Override
    public String getTitle() {
        return SYSTEXT;
    }

    @Override
    protected VDIP getVDIP() {
        return this.vdip;
    }

    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n2 = 0;
        switch (n) {
            case 36: {
                n2 = 1;
                break;
            }
            case 8: 
            case 37: {
                n2 = 8;
                break;
            }
            case 9: {
                n2 = 9;
                break;
            }
            case 40: {
                n2 = 10;
                break;
            }
            case 10: {
                n2 = 13;
                break;
            }
            case 39: {
                n2 = 21;
                break;
            }
            case 38: {
                n2 = 26;
                break;
            }
            case 32: {
                n2 = 32;
                break;
            }
            case 127: {
                n2 = 127;
            }
        }
        if (n2 > 0) {
            this.keyChar = n2;
            bl3 = true;
        }
        return bl3;
    }

    @Override
    public void openBasicProgram() {
        String string = HueblerGraphicsMC.getBasicProgram(this.emuThread);
        if (string != null) {
            this.screenFrm.openText(string);
        } else {
            this.showNoBasic();
        }
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 0;
        switch (n & 0xFF) {
            case 192: 
            case 193: 
            case 194: 
            case 195: {
                if (this.kcNet == null) break;
                n3 = this.kcNet.read(n);
                break;
            }
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                if (this.vdip == null) break;
                n3 = this.vdip.read(n);
                break;
            }
            default: {
                n3 = super.readIOByte(n, n2);
            }
        }
        return n3;
    }

    @Override
    public int reassembleSysCall(Z80MemView z80MemView, int n, StringBuilder stringBuilder, boolean bl, int n2, int n3, int n4) {
        return this.reassSysCallTable(z80MemView, n, 61440, sysCallNames, stringBuilder, bl, n2, n3, n4);
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON && this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
        this.romEnabled = true;
    }

    @Override
    public void saveBasicProgram() {
        int n = SourceUtil.getBasicEndAddr(this.emuThread, 14192);
        if (n >= 14192) {
            new SaveDlg(this.screenFrm, 14192, n, "BASIC-Programm speichern", SaveDlg.BasicType.MS_DERIVED_BASIC, EmuUtil.getBasicFileFilter()).setVisible(true);
        } else {
            this.showNoBasic();
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        boolean bl = false;
        if (!this.romEnabled || (n &= 0xFFFF) >= 32768) {
            this.emuThread.setRAMByte(n, n2);
            if (n >= this.videoBaseAddr && n < this.videoBaseAddr + 8192) {
                this.screenFrm.setScreenDirty(true);
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsOpenBasic() {
        return true;
    }

    @Override
    public boolean supportsSaveBasic() {
        return true;
    }

    @Override
    public void updSysCells(int n, int n2, FileFormat fileFormat, int n3) {
        int n4;
        if (fileFormat != null && (fileFormat.equals(FileFormat.BASIC_PRG) && n == 14192 && n2 > 7 || fileFormat.equals(FileFormat.HEADERSAVE) && n3 == 66 && n <= 14192 && n + n2 > 14199) && (n4 = SourceUtil.getBasicEndAddr(this.emuThread, 14192) + 1) > 14192) {
            this.emuThread.setMemWord(409, n4);
            this.emuThread.setMemWord(411, n4);
            this.emuThread.setMemWord(413, n4);
        }
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        switch (n & 0xFC) {
            case 0: {
                this.romEnabled = false;
                break;
            }
            case 4: {
                this.romEnabled = true;
                break;
            }
            case 16: {
                this.videoBaseAddr = n2 << 8 & 0xE000;
                this.screenFrm.setScreenDirty(true);
                break;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: {
                if (this.kcNet == null) break;
                this.kcNet.write(n, n2);
                break;
            }
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                if (this.vdip == null) break;
                this.vdip.write(n, n2);
                break;
            }
            default: {
                super.writeIOByte(n, n2, n3);
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        if (this.kcNet != null) {
            this.kcNet.z80MaxSpeedChanged(z80CPU);
        }
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        if (this.kcNet != null) {
            this.kcNet.z80TStatesProcessed(z80CPU, n);
        }
    }

    private void checkAddPCListener(Properties properties) {
        this.checkAddPCListener(properties, this.propPrefix + "catch_print_calls");
    }

    private boolean hasBasic(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_BASIC, true);
    }

    private boolean emulatesKCNet(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "kcnet.enabled", false);
    }

    private boolean emulatesUSB(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "vdip.enabled", false);
    }

    private void ensureMonBytesLoaded() {
        if (monBytes == null) {
            monBytes = this.readResource("/rom/huebler/mon30.bin");
        }
    }

    private Map<Long, Character> getPixelCRC32ToCharMap() {
        if (pixelCRC32ToChar == null) {
            this.ensureMonBytesLoaded();
            if (monBytes != null && monBytes.length >= 3597) {
                HashMap<Long, Character> hashMap = new HashMap<Long, Character>();
                CRC32 cRC32 = new CRC32();
                int n = 2829;
                for (int i = 32; i <= 126; ++i) {
                    cRC32.reset();
                    cRC32.update(monBytes, n, 8);
                    hashMap.put(cRC32.getValue(), Character.valueOf((char)i));
                    n += 8;
                }
                pixelCRC32ToChar = hashMap;
            }
        }
        return pixelCRC32ToChar;
    }

    private void loadROMs(Properties properties) {
        this.romFile = EmuUtil.getProperty(properties, this.propPrefix + "rom." + "file");
        this.romBytes = this.readROMFile(this.romFile, 32768, "ROM-Inhalt");
        if (this.romBytes == null) {
            if (this.hasBasic(properties)) {
                monBasicBytes = this.readResource("/rom/huebler/mon30p_hbasic33p.bin");
                this.romBytes = monBasicBytes;
                this.basic = true;
            } else {
                this.ensureMonBytesLoaded();
                this.romBytes = monBytes;
                this.basic = false;
            }
        }
    }
}

