/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.etc.C80KeyboardFld;
import z80emu.Z80CPU;
import z80emu.Z80PIO;

public class C80
extends EmuSys {
    public static final String SYSNAME = "C80";
    public static final String SYSTEXT = "C-80";
    public static final String PROP_PREFIX = "jkcemu.c80.";
    private static final int[][] keyMatrix = new int[][]{{82, 71, 68, 65, 55, 52, 49, 0}, {43, 45, 69, 66, 56, 53, 50, 48}, {0, 0, 70, 67, 57, 54, 51, 77}};
    private static byte[] mon = null;
    private C80KeyboardFld keyboardFld;
    private int[] keyboardMatrix;
    private int[] digitStatus;
    private int[] digitValues;
    private byte[] ram;
    private int curDigitIdx;
    private int pio1BValue;
    private int a4TStates;
    private long curDisplayTStates;
    private long displayCheckTStates;
    private boolean displayReset;
    private boolean tapeInPhase;
    private Z80PIO pio1;
    private Z80PIO pio2;

    public C80(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        if (mon == null) {
            mon = this.readResource("/rom/c80/c80mon.bin");
        }
        this.ram = new byte[1024];
        this.a4TStates = 0;
        this.curDisplayTStates = 0L;
        this.displayCheckTStates = 0L;
        this.curDigitIdx = -1;
        this.digitStatus = new int[8];
        this.digitValues = new int[8];
        this.keyboardMatrix = new int[8];
        this.keyboardFld = null;
        Z80CPU z80CPU = emuThread.getZ80CPU();
        this.pio1 = new Z80PIO("PIO 1");
        this.pio2 = new Z80PIO("PIO 2");
        z80CPU.setInterruptSources(this.pio1, this.pio2);
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        this.z80MaxSpeedChanged(z80CPU);
    }

    public static int getDefaultSpeedKHz() {
        return 455;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeyboardMatrix(int[] nArray) {
        int[] nArray2 = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            int n;
            int n2 = Math.min(nArray.length, this.keyboardMatrix.length);
            for (n = 0; n < n2; ++n) {
                this.keyboardMatrix[n] = nArray[n];
            }
            while (n < this.keyboardMatrix.length) {
                this.keyboardMatrix[n] = 0;
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        return EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
    }

    @Override
    public AbstractKeyboardFld createKeyboardFld() {
        this.keyboardFld = new C80KeyboardFld(this);
        return this.keyboardFld;
    }

    @Override
    public void die() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.setInterruptSources(null);
    }

    @Override
    public int getAppStartStackInitValue() {
        return 4055;
    }

    @Override
    public Color getColor(int n) {
        Color color = Color.black;
        switch (n) {
            case 1: {
                color = this.colorRedDark;
                break;
            }
            case 2: {
                color = this.colorRedLight;
            }
        }
        return color;
    }

    @Override
    public int getColorCount() {
        return 3;
    }

    @Override
    public String getHelpPage() {
        return "/help/c80.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2;
        int n3 = 255;
        if ((n &= 0xFFFF) < 2048 && mon != null) {
            if (n < mon.length) {
                n3 = mon[n] & 0xFF;
            }
        } else if ((n &= 0xFBFF) >= 2048 && (n2 = n - 2048) < this.ram.length) {
            n3 = this.ram[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public int getScreenHeight() {
        return 85;
    }

    @Override
    public int getScreenWidth() {
        return this.digitValues.length * 65 - 15;
    }

    @Override
    public String getTitle() {
        return SYSTEXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            switch (n) {
                case 10: {
                    this.keyboardMatrix[0] = this.keyboardMatrix[0] | 2;
                    bl3 = true;
                    break;
                }
                case 27: {
                    this.emuThread.fireReset(EmuThread.ResetLevel.WARM_RESET);
                    bl3 = true;
                    break;
                }
                case 78: {
                    this.emuThread.getZ80CPU().fireNMI();
                    bl3 = true;
                    break;
                }
                case 112: {
                    this.keyboardMatrix[7] = this.keyboardMatrix[7] | 1;
                    bl3 = true;
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (bl3) {
                this.updKeyboardFld();
            }
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased() {
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            Arrays.fill(this.keyboardMatrix, 0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.updKeyboardFld();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        if (c > '\u0000') {
            int[] nArray = this.keyboardMatrix;
            // MONITORENTER : this.keyboardMatrix
            char c2 = Character.toUpperCase(c);
            int n = 1;
            for (int i = 0; !bl && i < keyMatrix.length; n <<= 1, ++i) {
                for (int j = 0; !bl && j < keyMatrix[i].length; ++j) {
                    if (c2 != keyMatrix[i][j]) continue;
                    int n2 = j;
                    this.keyboardMatrix[n2] = this.keyboardMatrix[n2] | n;
                    bl = true;
                }
            }
            // MONITOREXIT : nArray
        }
        if (!bl) return bl;
        this.updKeyboardFld();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paintScreen(Graphics graphics, int n, int n2, int n3) {
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            for (int i = 0; i < this.digitValues.length; ++i) {
                C80.paint7SegDigit(graphics, n, n2, this.digitValues[i], this.colorRedDark, this.colorRedLight, n3);
                n += 65 * n3;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        if ((n & 0x40) == 0) {
            switch (n & 3) {
                case 0: {
                    n3 &= this.pio1.readDataA();
                    break;
                }
                case 1: {
                    n3 &= this.pio1.readDataB();
                    break;
                }
                case 2: {
                    n3 &= this.pio1.readControlA();
                    break;
                }
                case 3: {
                    n3 &= this.pio1.readControlB();
                }
            }
        }
        if ((n & 0x80) == 0) {
            switch (n & 3) {
                case 0: {
                    n3 &= this.pio2.readDataA();
                    break;
                }
                case 1: {
                    n3 &= this.pio2.readDataB();
                    break;
                }
                case 2: {
                    n3 &= this.pio2.readControlA();
                    break;
                }
                case 3: {
                    n3 &= this.pio2.readControlB();
                }
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            this.initSRAM(this.ram, properties);
        }
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            Arrays.fill(this.digitStatus, 0);
            Arrays.fill(this.digitValues, 0);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            nArray = this.keyboardMatrix;
            synchronized (this.keyboardMatrix) {
                Arrays.fill(this.keyboardMatrix, 0);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.pio1.putInValuePortA(255, false);
                this.displayReset = false;
                this.tapeInPhase = this.emuThread.readTapeInPhase();
                return;
            }
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        int n3;
        boolean bl = false;
        if ((n &= 0xFBFF) >= 2048 && (n3 = n - 2048) < this.ram.length) {
            this.ram[n3] = (byte)n2;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean supportsKeyboardFld() {
        return true;
    }

    @Override
    public boolean supportsTapeIn() {
        return true;
    }

    @Override
    public boolean supportsTapeOut() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void writeIOByte(int n, int n2, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        if ((n & 0x40) == 0) {
            switch (n & 3) {
                case 0: {
                    this.pio1.writeDataA(n2);
                    n4 = this.pio1.fetchOutValuePortA(false);
                    if ((n4 & 0x20) == 0) {
                        this.displayReset = true;
                    }
                    this.tapeOutPhase = (n4 & 0x40) != 0;
                    break;
                }
                case 1: {
                    int[] nArray;
                    this.pio1.writeDataB(n2);
                    bl2 = this.pio1.isReadyPortB();
                    this.pio1BValue = this.pio1.fetchOutValuePortB(bl2);
                    n4 = 255;
                    if (bl2) {
                        nArray = this.digitValues;
                        // MONITORENTER : this.digitValues
                        if (this.displayReset) {
                            this.curDigitIdx = 0;
                            this.displayReset = false;
                        } else {
                            this.curDigitIdx = this.curDigitIdx >= 0 && this.curDigitIdx < this.digitValues.length - 1 ? ++this.curDigitIdx : -1;
                        }
                        if (this.curDigitIdx >= 0 && this.curDigitIdx < this.digitValues.length) {
                            this.digitStatus[this.curDigitIdx] = 2;
                            if (this.pio1BValue != this.digitValues[this.curDigitIdx]) {
                                this.digitValues[this.curDigitIdx] = this.pio1BValue;
                                bl = true;
                            }
                        }
                        // MONITOREXIT : nArray
                        this.a4TStates = this.emuThread.getZ80CPU().getMaxSpeedKHz();
                        n4 &= 0xEF;
                    }
                    nArray = this.keyboardMatrix;
                    // MONITORENTER : this.keyboardMatrix
                    int n5 = 1;
                    for (int i = 0; i < this.keyboardMatrix.length; n5 <<= 1, ++i) {
                        if ((this.pio1BValue & n5) != 0) continue;
                        n4 &= ~this.keyboardMatrix[i];
                    }
                    // MONITOREXIT : nArray
                    this.pio1.putInValuePortA(n4, 23);
                    break;
                }
                case 2: {
                    this.pio1.writeControlA(n2);
                    break;
                }
                case 3: {
                    this.pio1.writeControlB(n2);
                    break;
                }
            }
        }
        if ((n & 0x80) == 0) {
            switch (n & 3) {
                case 0: {
                    this.pio2.writeDataA(n2);
                    break;
                }
                case 1: {
                    this.pio2.writeDataB(n2);
                    break;
                }
                case 2: {
                    this.pio2.writeControlA(n2);
                    break;
                }
                case 3: {
                    this.pio2.writeControlB(n2);
                    break;
                }
            }
        }
        if (!bl) return;
        this.screenFrm.setScreenDirty(true);
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        this.displayCheckTStates = z80CPU.getMaxSpeedKHz() * 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        boolean bl = this.emuThread.readTapeInPhase();
        if (bl != this.tapeInPhase) {
            this.tapeInPhase = bl;
            this.pio1.putInValuePortA(this.tapeInPhase ? 128 : 0, 128);
        }
        if (this.a4TStates > 0) {
            this.a4TStates -= n;
            if (this.a4TStates <= 0) {
                this.pio1.putInValuePortA(16, 16);
            }
        }
        if (this.displayCheckTStates <= 0L) return;
        this.curDisplayTStates += (long)n;
        if (this.curDisplayTStates <= this.displayCheckTStates) return;
        boolean bl2 = false;
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            for (int i = 0; i < this.digitValues.length; ++i) {
                if (this.digitStatus[i] > 0) {
                    int n2 = i;
                    this.digitStatus[n2] = this.digitStatus[n2] - 1;
                    continue;
                }
                if (this.digitValues[i] == 0) continue;
                this.digitValues[i] = 0;
                bl2 = true;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (bl2) {
                this.screenFrm.setScreenDirty(true);
            }
            this.curDisplayTStates = 0L;
            return;
        }
    }

    private void updKeyboardFld() {
        if (this.keyboardFld != null) {
            this.keyboardFld.updKeySelection(this.keyboardMatrix);
        }
    }
}

