/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Properties;
import jkcemu.base.DeviceIO;
import jkcemu.base.EmuUtil;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.FloppyDiskFormat;
import jkcemu.disk.SectorData;
import jkcemu.disk.SectorID;

public class PlainDisk
extends AbstractFloppyDisk {
    public static final String PROP_DRIVE = "drive";
    private String fileName;
    private FileLock fileLock;
    private DeviceIO.RandomAccessDevice rad;
    private RandomAccessFile raf;
    private byte[] diskBytes;
    private boolean readOnly;
    private boolean appendable;
    private int sectorSizeCode;

    public static PlainDisk createForDrive(Frame frame, String string, DeviceIO.RandomAccessDevice randomAccessDevice, boolean bl, FloppyDiskFormat floppyDiskFormat) {
        return new PlainDisk(frame, floppyDiskFormat.getSides(), floppyDiskFormat.getCylinders(), floppyDiskFormat.getSectorsPerCylinder(), floppyDiskFormat.getSectorSize(), 0, string, randomAccessDevice, null, null, null, bl, false);
    }

    public static PlainDisk createForByteArray(Frame frame, String string, byte[] byArray, FloppyDiskFormat floppyDiskFormat, int n) throws IOException {
        PlainDisk plainDisk = null;
        if (byArray != null) {
            plainDisk = new PlainDisk(frame, floppyDiskFormat.getSides(), floppyDiskFormat.getCylinders(), floppyDiskFormat.getSectorsPerCylinder(), floppyDiskFormat.getSectorSize(), n, string, null, null, null, byArray, true, false);
        }
        return plainDisk;
    }

    public static PlainDisk createForByteArray(Frame frame, String string, byte[] byArray, FloppyDiskFormat floppyDiskFormat) throws IOException {
        return PlainDisk.createForByteArray(frame, string, byArray, floppyDiskFormat, 0);
    }

    public static PlainDisk createForFile(Frame frame, String string, RandomAccessFile randomAccessFile, boolean bl, FloppyDiskFormat floppyDiskFormat) {
        return new PlainDisk(frame, floppyDiskFormat.getSides(), floppyDiskFormat.getCylinders(), floppyDiskFormat.getSectorsPerCylinder(), floppyDiskFormat.getSectorSize(), 0, string, null, randomAccessFile, null, null, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String export(AbstractFloppyDisk abstractFloppyDisk, File file) throws IOException {
        boolean bl;
        FileOutputStream fileOutputStream;
        IOException iOException;
        StringBuilder stringBuilder;
        block23: {
            stringBuilder = null;
            iOException = null;
            fileOutputStream = null;
            bl = false;
            try {
                fileOutputStream = new FileOutputStream(file);
                bl = true;
                boolean bl2 = false;
                int n = abstractFloppyDisk.getSides();
                int n2 = abstractFloppyDisk.getCylinders();
                int n3 = abstractFloppyDisk.getSectorsPerCylinder();
                int n4 = abstractFloppyDisk.getSectorSize();
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        int n5 = abstractFloppyDisk.getSectorsOfCylinder(i, j);
                        if (n5 != n3) {
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder(1024);
                            }
                            stringBuilder.append(String.format("Seite %d, Spur %d: %d anstelle von %d Sektoren vorhanden", j + 1, i, n5, n3));
                        }
                        for (int k = 0; k < n3; ++k) {
                            int n6;
                            SectorData sectorData = abstractFloppyDisk.getSectorByID(i, j, i, j, k + 1, -1);
                            if (sectorData == null) {
                                throw new IOException(String.format("Seite %d, Spur %d: Sektor %d nicht gefunden\n\nDas Format unterst\u00fctzt keine freie Sektoranordnung.", j + 1, i, k + 1));
                            }
                            if (sectorData.checkError() || sectorData.hasBogusID() || sectorData.isDeleted()) {
                                if (stringBuilder == null) {
                                    stringBuilder = new StringBuilder(1024);
                                }
                                stringBuilder.append(String.format("Seite %d, Spur %d, Sektor %d:", j + 1, i, sectorData.getSectorNum()));
                                n6 = 0;
                                if (sectorData.hasBogusID()) {
                                    stringBuilder.append(" Sektor-ID generiert");
                                    n6 = 1;
                                }
                                if (sectorData.checkError()) {
                                    if (n6 != 0) {
                                        stringBuilder.append(',');
                                    }
                                    stringBuilder.append(" CRC-Fehler");
                                    n6 = 1;
                                }
                                if (sectorData.isDeleted()) {
                                    if (n6 != 0) {
                                        stringBuilder.append(',');
                                    }
                                    stringBuilder.append(" als gel\u00f6scht markiert");
                                    n6 = 1;
                                    bl2 = true;
                                }
                                stringBuilder.append('\n');
                            }
                            if (sectorData.isDeleted()) {
                                bl2 = true;
                                if (stringBuilder == null) {
                                    stringBuilder = new StringBuilder(1024);
                                }
                                stringBuilder.append(String.format("Seite %d, Spur %d: Sektor %d ist als gel\u00f6scht markiert\n", j + 1, i, sectorData.getSectorNum()));
                            }
                            if (sectorData.getDataLength() > n4) {
                                throw new IOException(String.format("Seite %d, Spur %d: Sektor %d ist zu gro\u00df.\n\nDas Format unterst\u00fctzt keine \u00fcbergro\u00dfen Sektoren.", j + 1, i, sectorData.getSectorNum()));
                            }
                            for (n6 = sectorData.writeTo(fileOutputStream, n4); n6 < n4; ++n6) {
                                ((OutputStream)fileOutputStream).write(0);
                            }
                        }
                    }
                }
                ((OutputStream)fileOutputStream).close();
                fileOutputStream = null;
                if (stringBuilder == null) break block23;
                stringBuilder.append("\nDie angezeigten Informationen k\u00f6nnen in einer einfachen Abbilddatei nicht gespeichert werden\nund sind deshalb in der erzeugten Datei nicht mehr enthalten.\n");
                if (!bl2) break block23;
                stringBuilder.append("\nGel\u00f6schte Sektoren werden in einfachen Abbilddateien nicht unterst\u00fctzt\nund sind deshalb als normale Sektoren enthalten.\n");
            }
            catch (IOException iOException2) {
                try {
                    iOException = iOException2;
                }
                catch (Throwable throwable) {
                    EmuUtil.closeSilent(fileOutputStream);
                    throw throwable;
                }
                EmuUtil.closeSilent(fileOutputStream);
            }
        }
        EmuUtil.closeSilent(fileOutputStream);
        if (iOException != null) {
            if (bl) {
                file.delete();
            }
            throw iOException;
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlainDisk newFile(Frame frame, File file) throws IOException {
        PlainDisk plainDisk = null;
        FileLock fileLock = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            fileLock = EmuUtil.lockFile(file, randomAccessFile);
            randomAccessFile.setLength(0L);
            plainDisk = new PlainDisk(frame, 0, 0, 0, 0, 0, file.getPath(), null, randomAccessFile, fileLock, null, false, true);
            if (plainDisk != null) return plainDisk;
        }
        catch (Throwable throwable) {
            if (plainDisk != null) throw throwable;
            EmuUtil.releaseSilent(fileLock);
            EmuUtil.closeSilent(randomAccessFile);
            throw throwable;
        }
        EmuUtil.releaseSilent(fileLock);
        EmuUtil.closeSilent(randomAccessFile);
        return plainDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlainDisk openFile(Frame frame, File file, boolean bl, FloppyDiskFormat floppyDiskFormat) throws IOException {
        PlainDisk plainDisk = null;
        FileLock fileLock = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, bl ? "r" : "rw");
            if (!bl) {
                fileLock = EmuUtil.lockFile(file, randomAccessFile);
            }
            if ((plainDisk = new PlainDisk(frame, floppyDiskFormat.getSides(), floppyDiskFormat.getCylinders(), floppyDiskFormat.getSectorsPerCylinder(), floppyDiskFormat.getSectorSize(), 0, file.getPath(), null, randomAccessFile, fileLock, null, bl, !bl)) != null) return plainDisk;
        }
        catch (Throwable throwable) {
            if (plainDisk != null) throw throwable;
            EmuUtil.releaseSilent(fileLock);
            EmuUtil.closeSilent(randomAccessFile);
            throw throwable;
        }
        EmuUtil.releaseSilent(fileLock);
        EmuUtil.closeSilent(randomAccessFile);
        return plainDisk;
    }

    @Override
    public synchronized void closeSilent() {
        EmuUtil.releaseSilent(this.fileLock);
        EmuUtil.closeSilent(this.raf);
        EmuUtil.closeSilent(this.rad);
    }

    @Override
    public boolean formatTrack(int n, int n2, SectorID[] sectorIDArray, byte[] byArray) {
        boolean bl = false;
        if (!(this.readOnly || this.rad == null && this.raf == null || sectorIDArray == null || byArray == null)) {
            int n3 = this.getSectorSize();
            if (sectorIDArray.length > 0 && (n3 == 0 || n3 == byArray.length) && this.appendable) {
                bl = true;
                try {
                    for (int i = 0; i < sectorIDArray.length; ++i) {
                        int n4 = sectorIDArray[i].getSectorNum() - 1;
                        long l = this.calcFilePos(n, n2, n4);
                        if (l >= 0L) {
                            int n5;
                            if (this.rad != null) {
                                this.rad.seek(l);
                                this.rad.write(byArray, 0, byArray.length);
                            } else {
                                this.raf.seek(l);
                                this.raf.write(byArray);
                            }
                            int n6 = n5 = (n2 & 1) != 0 ? 2 : 1;
                            if (n5 > this.getSides()) {
                                this.setSides(n5);
                            }
                            if (n >= this.getCylinders()) {
                                this.setCylinders(n + 1);
                            }
                            if (sectorIDArray.length > this.getSectorsPerCylinder()) {
                                this.setSectorsPerCylinder(sectorIDArray.length);
                            }
                            if (this.getSectorSize() != 0) continue;
                            this.setSectorSize(byArray.length);
                            this.sectorSizeCode = sectorIDArray[0].getSizeCode();
                            continue;
                        }
                        bl = false;
                    }
                }
                catch (IOException iOException) {
                    bl = false;
                    this.fireShowError("Anh\u00e4ngen von Sektoren fehlgeschlagen", iOException);
                }
            } else {
                bl = super.formatTrack(n, n2, sectorIDArray, byArray);
            }
        }
        return bl;
    }

    @Override
    public String getFileFormatText() {
        return "Einfache Abbilddatei";
    }

    @Override
    public synchronized SectorData getSectorByIndex(int n, int n2, int n3) {
        return this.getSectorByIndexInternal(n, n2, this.sectorIndexToInterleave(n3));
    }

    @Override
    public SectorData getSectorByID(int n, int n2, int n3, int n4, int n5, int n6) {
        SectorData sectorData = this.getSectorByIndexInternal(n, n2, n5 - 1);
        if (sectorData != null && (sectorData.getCylinder() != n3 || sectorData.getHead() != n4 || sectorData.getSectorNum() != n5 || n6 >= 0 && sectorData.getSizeCode() != n6)) {
            sectorData = null;
        }
        return sectorData;
    }

    @Override
    public int getSectorOffset() {
        return 0;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void putSettingsTo(Properties properties, String string) {
        super.putSettingsTo(properties, string);
        if (properties != null && this.fileName != null) {
            if (this.rad != null) {
                properties.setProperty(string + PROP_DRIVE, this.fileName);
            } else {
                properties.setProperty(string + "file", this.fileName);
            }
        }
    }

    @Override
    public boolean writeSector(int n, int n2, SectorData sectorData, byte[] byArray, int n3, boolean bl) {
        int n4;
        long l;
        boolean bl2 = false;
        if (!(this.readOnly || this.rad == null && this.raf == null || sectorData == null || byArray == null || bl || sectorData.getDisk() != this || n3 != this.getSectorSize() || (l = this.calcFilePos(n, n2, n4 = sectorData.getIndexOnCylinder())) != sectorData.getFilePos())) {
            try {
                if (this.rad != null) {
                    this.rad.seek(l);
                    this.rad.write(byArray, 0, n3);
                } else {
                    this.raf.seek(l);
                    this.raf.write(byArray, 0, n3);
                }
                bl2 = true;
            }
            catch (IOException iOException) {
                this.fireShowWriteError(n, n2, sectorData.getSectorNum(), iOException);
                sectorData.setError(true);
            }
        }
        return bl2;
    }

    private PlainDisk(Frame frame, int n, int n2, int n3, int n4, int n5, String string, DeviceIO.RandomAccessDevice randomAccessDevice, RandomAccessFile randomAccessFile, FileLock fileLock, byte[] byArray, boolean bl, boolean bl2) {
        super(frame, n, n2, n3, n4, n5);
        this.fileName = string;
        this.rad = randomAccessDevice;
        this.raf = randomAccessFile;
        this.fileLock = fileLock;
        this.diskBytes = byArray;
        this.readOnly = bl;
        this.appendable = bl2;
        this.sectorSizeCode = SectorData.getSizeCode(n4);
    }

    private long calcFilePos(int n, int n2, int n3) {
        n2 &= 1;
        long l = -1L;
        int n4 = this.getSectorSize();
        if (n >= 0 && n3 >= 0) {
            int n5 = this.getSides();
            int n6 = this.getCylinders();
            int n7 = this.getSectorsPerCylinder();
            if (n2 < n5 && n3 < n7 && n4 > 0) {
                int n8 = n5 * n7 * n;
                if (n2 > 0) {
                    n8 += n7;
                }
                l = (long)(n8 += n3) * (long)n4;
            } else if (n == 0 && n6 <= 1) {
                if (n2 == 0 && n3 == 0) {
                    l = 0L;
                } else if (n4 > 0) {
                    if (n2 == 0) {
                        l = n3 * n4;
                    } else if (n2 == 1 && n7 > 0) {
                        l = (n7 + n3) * n4;
                    }
                }
            }
        }
        return l;
    }

    private synchronized SectorData getSectorByIndexInternal(int n, int n2, int n3) {
        SectorData sectorData = null;
        int n4 = this.getSectorSize();
        long l = this.calcFilePos(n, n2, n3);
        if (n4 > 0 && l >= 0L) {
            if (this.diskBytes != null) {
                if (l <= Integer.MAX_VALUE) {
                    sectorData = new SectorData(n3, n, n2, n3 + 1, this.sectorSizeCode, this.diskBytes, (int)l, n4);
                }
            } else if (this.rad != null || this.raf != null) {
                try {
                    byte[] byArray = new byte[n4];
                    int n5 = -1;
                    if (this.rad != null) {
                        this.rad.seek(l);
                        n5 = this.rad.read(byArray, 0, byArray.length);
                    } else {
                        this.raf.seek(l);
                        n5 = this.raf.read(byArray);
                    }
                    if (n5 > 0) {
                        while (n5 < byArray.length) {
                            int n6 = -1;
                            n6 = this.rad != null ? this.rad.read(byArray, n5, byArray.length - n5) : this.raf.read(byArray, n5, byArray.length - n5);
                            if (n6 <= 0) break;
                            n5 += n6;
                        }
                    }
                    if (n5 > 0) {
                        sectorData = new SectorData(n3, n, n2, n3 + 1, this.sectorSizeCode, byArray, 0, n5);
                    }
                }
                catch (IOException iOException) {
                    this.fireShowReadError(n, n2, n3 + 1, iOException);
                    sectorData = new SectorData(n3, n, n2, n3 + 1, this.sectorSizeCode, null, 0, 0);
                    sectorData.setError(true);
                }
            }
            if (sectorData != null) {
                sectorData.setDisk(this);
                sectorData.setFilePos(l);
                sectorData.setFilePortionLen(n4);
            }
        }
        return sectorData;
    }
}

