/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.disk.HardDiskInfo;
import jkcemu.disk.HardDiskListDlg;

public class HardDiskTableModel
extends AbstractTableModel {
    private static final String[] colNames = new String[]{"Hersteller", "Modell", "Zylinder", "K\u00f6pfe", "Sektoren pro Spur", "Gr\u00f6\u00dfe"};
    private HardDiskListDlg owner;
    private List<HardDiskInfo> rows;

    public HardDiskTableModel(HardDiskListDlg hardDiskListDlg) {
        this.owner = hardDiskListDlg;
        this.rows = new ArrayList<HardDiskInfo>();
    }

    public void addRow(HardDiskInfo hardDiskInfo) {
        this.rows.add(hardDiskInfo);
    }

    public HardDiskInfo getRow(int n) {
        return n >= 0 && n < this.rows.size() ? this.rows.get(n) : null;
    }

    public int indexOf(HardDiskInfo hardDiskInfo) {
        return this.rows.indexOf(hardDiskInfo);
    }

    public void removeRow(int n) {
        if (n >= 0 && n < this.rows.size()) {
            this.rows.remove(n);
        }
    }

    public void sort() {
        try {
            Collections.sort(this.rows);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n >= 0 && n < colNames.length ? String.class : Object.class;
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return n >= 0 && n < colNames.length ? colNames[n] : "";
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        HardDiskInfo hardDiskInfo = this.getRow(n);
        if (hardDiskInfo != null) {
            switch (n2) {
                case 0: {
                    object = hardDiskInfo.getProducer();
                    break;
                }
                case 1: {
                    object = hardDiskInfo.getDiskModel();
                    break;
                }
                case 2: {
                    object = hardDiskInfo.getCylinders();
                    break;
                }
                case 3: {
                    object = hardDiskInfo.getHeads();
                    break;
                }
                case 4: {
                    object = hardDiskInfo.getSectorsPerTrack();
                    break;
                }
                case 5: {
                    object = EmuUtil.formatSize((long)hardDiskInfo.getCylinders() * (long)hardDiskInfo.getHeads() * (long)hardDiskInfo.getSectorsPerTrack() * 512L, true, false);
                }
            }
        }
        return object;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 >= 2 && n2 <= 4;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string;
        HardDiskInfo hardDiskInfo;
        if (object != null && (hardDiskInfo = this.getRow(n)) != null && n2 >= 2 && n2 <= 4 && (string = object.toString()) != null && !(string = string.trim()).isEmpty()) {
            String string2 = null;
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = string + ": Ung\u00fcltige Eingabe (Zahl erwartet)";
            }
            if (string2 == null) {
                try {
                    switch (n2) {
                        case 2: {
                            hardDiskInfo.setCylinders(n3);
                            this.owner.setDataChanged();
                            break;
                        }
                        case 3: {
                            hardDiskInfo.setHeads(n3);
                            this.owner.setDataChanged();
                            break;
                        }
                        case 4: {
                            hardDiskInfo.setSectorsPerTrack(n3);
                            this.owner.setDataChanged();
                        }
                    }
                    this.fireTableRowsUpdated(n, n);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    string2 = illegalArgumentException.getMessage();
                }
            }
            if (string2 != null) {
                BaseDlg.showErrorDlg((Component)this.owner, string2);
            }
        }
    }
}

