/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import jkcemu.base.EmuUtil;
import jkcemu.text.TextUtil;

public class HardDiskInfo
implements Comparable<HardDiskInfo> {
    private String producer;
    private String diskModel;
    private String fullInfo;
    private String fullDiskModel;
    private String typeSizeInfo;
    private int cylinders;
    private int heads;
    private int sectorsPerTrack;

    public HardDiskInfo(String string, String string2, int n, int n2, int n3) throws IllegalArgumentException {
        this.producer = TextUtil.emptyToNull(string);
        this.diskModel = TextUtil.emptyToNull(string2);
        this.fullInfo = null;
        this.fullDiskModel = null;
        this.typeSizeInfo = null;
        this.setCylinders(n);
        this.setHeads(n2);
        this.setSectorsPerTrack(n3);
    }

    public int getCylinders() {
        return this.cylinders;
    }

    public String getDiskModel() {
        return this.diskModel;
    }

    public String getFullDiskModel() {
        if (this.fullDiskModel == null) {
            this.fullDiskModel = this.producer != null ? (this.diskModel != null ? String.format("%s %s", this.producer, this.diskModel) : String.format("%s %dx%dx%d", this.producer, this.cylinders, this.heads, this.sectorsPerTrack)) : (this.diskModel != null ? this.diskModel : String.format("%dx%dx%d", this.cylinders, this.heads, this.sectorsPerTrack));
        }
        return this.fullDiskModel;
    }

    public int getHeads() {
        return this.heads;
    }

    public String getProducer() {
        return this.producer;
    }

    public int getSectorsPerTrack() {
        return this.sectorsPerTrack;
    }

    public String getTypeSizeInfo() {
        if (this.typeSizeInfo == null) {
            StringBuilder stringBuilder = new StringBuilder(64);
            if (this.diskModel != null) {
                stringBuilder.append(this.diskModel);
            }
            this.appendSizeInfo(stringBuilder);
            this.typeSizeInfo = stringBuilder.toString();
        }
        return this.typeSizeInfo;
    }

    public void setCylinders(int n) throws IllegalArgumentException {
        this.checkBounds("Zylinder", n, 65536);
        this.cylinders = n;
        this.fullInfo = null;
        this.typeSizeInfo = null;
    }

    public void setDiskModel(String string) {
        this.diskModel = string;
        this.fullInfo = null;
        this.fullDiskModel = null;
        this.typeSizeInfo = null;
    }

    public void setHeads(int n) throws IllegalArgumentException {
        this.checkBounds("K\u00f6pfe", n, 16);
        this.heads = n;
        this.fullInfo = null;
        this.typeSizeInfo = null;
    }

    public void setProducer(String string) {
        this.producer = string;
        this.fullInfo = null;
        this.fullDiskModel = null;
    }

    public void setSectorsPerTrack(int n) throws IllegalArgumentException {
        this.checkBounds("Sektoren pro Spur", n, 255);
        this.sectorsPerTrack = n;
        this.fullInfo = null;
        this.typeSizeInfo = null;
    }

    @Override
    public int compareTo(HardDiskInfo hardDiskInfo) {
        int n = EmuUtil.compare(this.producer, hardDiskInfo.producer);
        if (n == 0) {
            n = EmuUtil.compare(this.diskModel, hardDiskInfo.diskModel);
        }
        return n;
    }

    public String toString() {
        if (this.fullInfo == null) {
            StringBuilder stringBuilder = new StringBuilder(128);
            if (this.producer != null) {
                stringBuilder.append(this.producer);
            }
            if (this.diskModel != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.diskModel);
            }
            this.appendSizeInfo(stringBuilder);
            this.fullInfo = stringBuilder.toString();
        }
        return this.fullInfo;
    }

    private void appendSizeInfo(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" / ");
        }
        EmuUtil.appendSizeText(stringBuilder, (long)this.cylinders * (long)this.heads * (long)this.sectorsPerTrack * 512L, false, false);
        stringBuilder.append(" (");
        stringBuilder.append(this.cylinders);
        stringBuilder.append('x');
        stringBuilder.append(this.heads);
        stringBuilder.append('x');
        stringBuilder.append(this.sectorsPerTrack);
        stringBuilder.append(')');
    }

    private void checkBounds(String string, int n, int n2) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException(string + ": Wert zu klein (mindestens 1)");
        }
        if (n > n2) {
            throw new IllegalArgumentException(String.format("%s: Wert zu gro\u00df (maximal %d)", string, n2));
        }
    }
}

