/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import jkcemu.Main;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileNameFld;
import jkcemu.base.OptionDlg;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;
import jkcemu.disk.HardDiskInfo;
import jkcemu.disk.HardDiskListDlg;

public class GIDESettingsFld
extends AbstractSettingsFld {
    private static final String ACTION_HD_NONE = "harddisk.none";
    private static final String ACTION_HD_SELECT = "harddisk.select";
    private static final int DISK_CNT = 2;
    private int appliedIOBaseAddr;
    private int defaultIOBaseAddr;
    private int popupDiskIdx;
    private JPopupMenu popupMenu;
    private JMenuItem mnuDiskNone;
    private JCheckBox btnEnabled;
    private JComboBox<String> comboIOBaseAddr;
    private HardDiskInfo[] diskTypes;
    private JLabel[] titleLabels;
    private JTextField[] diskTypeFlds;
    private JButton[] diskTypeBtns;
    private FileNameFld[] fileNameFlds;
    private JButton[] selectBtns;
    private int[] offsets;

    public GIDESettingsFld(SettingsFrm settingsFrm, String string) {
        this(settingsFrm, string, -1, new int[0]);
    }

    public GIDESettingsFld(SettingsFrm settingsFrm, String string, int n, int ... nArray) {
        super(settingsFrm, string);
        int n2;
        this.defaultIOBaseAddr = n;
        this.appliedIOBaseAddr = -1;
        this.popupDiskIdx = -1;
        this.popupMenu = null;
        this.mnuDiskNone = null;
        this.diskTypes = new HardDiskInfo[2];
        this.titleLabels = new JLabel[2];
        this.diskTypeFlds = new JTextField[2];
        this.diskTypeBtns = new JButton[2];
        this.fileNameFlds = new FileNameFld[2];
        this.selectBtns = new JButton[2];
        this.offsets = new int[2];
        Arrays.fill(this.offsets, 0);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        int n3 = n2 = nArray != null ? nArray.length : 0;
        if (n2 > 1) {
            this.btnEnabled = new JCheckBox("GIDE emulieren an E/A-Basisadresse:");
            this.comboIOBaseAddr = new JComboBox();
            this.comboIOBaseAddr.setEditable(false);
            for (int i = 0; i < n2; ++i) {
                this.comboIOBaseAddr.addItem(String.format("%02Xh", nArray[i]));
            }
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            jPanel.add((Component)this.btnEnabled, gridBagConstraints2);
            gridBagConstraints2.insets.left = 5;
            ++gridBagConstraints2.gridx;
            jPanel.add(this.comboIOBaseAddr, gridBagConstraints2);
            this.add((Component)jPanel, gridBagConstraints);
        } else {
            this.btnEnabled = new JCheckBox("GIDE emulieren");
            this.comboIOBaseAddr = null;
            this.add((Component)this.btnEnabled, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        for (int i = 0; i < 2; ++i) {
            this.addDiskFlds(i, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this.btnEnabled.addActionListener(this);
        if (this.comboIOBaseAddr != null) {
            this.comboIOBaseAddr.addActionListener(this);
        }
    }

    public int getAppliedIOBaseAddr() {
        return this.appliedIOBaseAddr;
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        block15: {
            int n = -1;
            try {
                String string;
                block16: {
                    Object object;
                    if (properties == null) break block15;
                    boolean bl2 = this.btnEnabled.isSelected();
                    EmuUtil.setProperty(properties, this.propPrefix + "gide.enabled", bl2);
                    if (this.comboIOBaseAddr != null && (object = this.comboIOBaseAddr.getSelectedItem()) != null && (string = object.toString()) != null) {
                        if ((string = string.trim().toUpperCase()).endsWith("H")) {
                            string = string.substring(0, string.length() - 1);
                        }
                        try {
                            int n2 = Integer.parseInt(string, 16);
                            EmuUtil.setProperty(properties, this.propPrefix + "gide.io_base_addr", n2);
                            if (bl && bl2) {
                                n = n2;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (!bl || !bl2) break block16;
                            throw new UserInputException("E/A-Basisadresse: Ung\u00fcltige Eingabe");
                        }
                    }
                }
                for (int i = 0; i < 2; ++i) {
                    string = this.createPrefix(i);
                    HardDiskInfo hardDiskInfo = this.diskTypes[i];
                    if (hardDiskInfo != null) {
                        File file = this.fileNameFlds[i].getFile();
                        if (file != null) {
                            properties.setProperty(string + "file", file.getPath());
                        } else {
                            properties.setProperty(string + "file", "");
                            if (bl) {
                                throw new UserInputException(String.format("%d. Festplatte: Abbilddatei nicht ausgew\u00e4hlt", i + 1));
                            }
                        }
                        EmuUtil.setProperty(properties, string + "offset", this.offsets[i]);
                        EmuUtil.setProperty(properties, string + "model", hardDiskInfo.getFullDiskModel());
                        EmuUtil.setProperty(properties, string + "cylinders", hardDiskInfo.getCylinders());
                        EmuUtil.setProperty(properties, string + "heads", hardDiskInfo.getHeads());
                        EmuUtil.setProperty(properties, string + "sectors_per_track", hardDiskInfo.getSectorsPerTrack());
                        continue;
                    }
                    properties.setProperty(string + "model", "");
                    properties.setProperty(string + "cylinders", "");
                    properties.setProperty(string + "heads", "");
                    properties.setProperty(string + "sectors_per_track", "");
                    properties.setProperty(string + "file", "");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new UserInputException(numberFormatException.getMessage());
            }
            finally {
                this.appliedIOBaseAddr = n;
            }
        }
    }

    @Override
    public boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.btnEnabled) {
                bl = true;
                this.updFieldsEnabled();
                this.fireDataChanged();
            } else if (object == this.comboIOBaseAddr) {
                bl = true;
                this.fireDataChanged();
            } else {
                String string;
                int n = this.indexOf(this.diskTypeBtns, object);
                if (n >= 0) {
                    bl = true;
                    this.showDiskTypePopup(n);
                }
                if (!bl && (n = this.indexOf(this.selectBtns, object)) >= 0) {
                    bl = true;
                    this.doFileSelect(n);
                }
                if (!bl && eventObject instanceof ActionEvent && (string = ((ActionEvent)eventObject).getActionCommand()) != null && string.startsWith("harddisk.")) {
                    bl = true;
                    if (string.equals(ACTION_HD_SELECT)) {
                        HardDiskInfo hardDiskInfo = HardDiskListDlg.showHardDiskListDlg(this.settingsFrm);
                        if (hardDiskInfo != null && (n = this.popupDiskIdx) >= 0 && n < this.diskTypes.length) {
                            this.diskTypes[n] = hardDiskInfo;
                            this.diskTypeFlds[n].setText(hardDiskInfo.toString());
                            try {
                                this.diskTypeFlds[n].setCaretPosition(0);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                            this.updFieldsEnabled();
                            this.fireDataChanged();
                        }
                    } else {
                        n = this.popupDiskIdx;
                        if (n >= 0 && n < this.diskTypes.length && string.equals(ACTION_HD_NONE)) {
                            this.diskTypes[n] = null;
                            this.diskTypeFlds[n].setText("");
                            this.setFile(n, null, 0);
                            this.updFieldsEnabled();
                            this.fireDataChanged();
                        }
                    }
                }
            }
        }
        return bl;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = false;
        DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
        if (dropTargetContext != null) {
            Component component = dropTargetContext.getComponent();
            for (int i = 0; i < 2; ++i) {
                if (component != this.fileNameFlds[i] || this.fileNameFlds[i].isEnabled()) continue;
                dropTargetDragEvent.rejectDrag();
                bl = true;
                break;
            }
        }
        if (!bl) {
            super.dragEnter(dropTargetDragEvent);
        }
    }

    @Override
    public boolean fileDropped(Component component, File file) {
        boolean bl = false;
        if (component != null && file != null) {
            for (int i = 0; i < 2; ++i) {
                if (component != this.fileNameFlds[i] || !this.fileNameFlds[i].isEnabled()) continue;
                this.setFile(i, file, 0);
                this.updFieldsEnabled();
                Main.setLastFile(file, "disk");
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        JPopupMenu jPopupMenu = this.popupMenu;
        if (jPopupMenu != null) {
            SwingUtilities.updateComponentTreeUI(jPopupMenu);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.btnEnabled.setEnabled(bl);
        this.updFieldsEnabled();
    }

    @Override
    public void updFields(Properties properties) {
        this.btnEnabled.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "gide.enabled", false));
        if (this.comboIOBaseAddr != null) {
            this.comboIOBaseAddr.setSelectedItem(String.format("%02Xh", EmuUtil.getIntProperty(properties, this.propPrefix + "gide.io_base_addr", this.defaultIOBaseAddr)));
        }
        for (int i = 0; i < 2; ++i) {
            String string = this.createPrefix(i);
            String string2 = EmuUtil.getProperty(properties, string + "model");
            if (string2.isEmpty()) continue;
            int n = EmuUtil.getIntProperty(properties, string + "cylinders", 0);
            int n2 = EmuUtil.getIntProperty(properties, string + "heads", 0);
            int n3 = EmuUtil.getIntProperty(properties, string + "sectors_per_track", 0);
            if (n <= 0 || n2 <= 0 || n3 <= 0) continue;
            try {
                this.diskTypes[i] = new HardDiskInfo(null, string2, n, n2, n3);
                String string3 = EmuUtil.getProperty(properties, string + "file");
                this.setFile(i, string3.isEmpty() ? null : new File(string3), 0);
                this.diskTypeFlds[i].setText(this.diskTypes[i].toString());
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.updFieldsEnabled();
    }

    private void addDiskFlds(int n, GridBagConstraints gridBagConstraints) {
        this.diskTypes[n] = null;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)new JSeparator(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.titleLabels[n] = n == 0 ? new JLabel("1. Festplatte (Master):") : new JLabel(String.format("%d. Festplatte (Slave):", n + 1));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.titleLabels[n], gridBagConstraints);
        this.diskTypeFlds[n] = new JTextField();
        this.diskTypeFlds[n].setEditable(false);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.diskTypeFlds[n], gridBagConstraints);
        this.diskTypeBtns[n] = this.createImageButton("/images/disk/harddiskmodel.png", "Festplattenmodell ausw\u00e4hlen");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.diskTypeBtns[n], gridBagConstraints);
        this.fileNameFlds[n] = new FileNameFld();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.fileNameFlds[n], gridBagConstraints);
        this.selectBtns[n] = this.createImageButton("/images/file/open.png", "Festplattenabbilddatei ausw\u00e4hlen");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx += 2;
        this.add((Component)this.selectBtns[n], gridBagConstraints);
        this.enableFileDrop(this.fileNameFlds[n]);
    }

    private JMenuItem addToPopupMenu(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
        this.popupMenu.add(jMenuItem);
        return jMenuItem;
    }

    private String createPrefix(int n) {
        return String.format("%s%s%d.", this.propPrefix, "harddisk.", n + 1);
    }

    private void doFileSelect(int n) {
        if (n >= 0 && n < 2) {
            File file = this.fileNameFlds[n].getFile();
            if (file == null) {
                file = Main.getLastDirFile("disk");
            }
            int n2 = -1;
            File file2 = EmuUtil.showFileOpenDlg(this.settingsFrm, "Festplattenabbilddatei ausw\u00e4hlen", file, new FileFilter[0]);
            if (file2 != null) {
                String string = null;
                if (file2.exists()) {
                    if (!file2.isFile()) {
                        string = "Datei ist keine regul\u00e4re Datei";
                    }
                } else {
                    switch (OptionDlg.showOptionDlg(this.settingsFrm, "Die angegebene Datei existiert nicht.\nFormatieren Sie bitte das betreffende Laufwerk vom emulierten System aus,\ndamit die Datei angelegt wird und einen Inhalt erh\u00e4lt.\n\nWelchen Typ soll die Datei haben?\nEine RAW-Datei enth\u00e4lt das reine Abbild und kann mit geeigneten Programmen\ndirekt auf eine Festplatte oder DOM geschrieben werden.\nEine kompatible Abbilddatei entspricht dem Format \u00e4lterer JKCEMU-Versionen\nund kann auch in manch anderem Emulator verwendet werden.\nAllerdings lassen sich kompatible Abbilddateien nicht mit \u00fcblichen Werkzeugen\ndirekt auf eine Festplatte oder DOM schreiben.", "Neue Abbilddatei", 0, "RAW-Datei", "Kompatible Abbilddatei")) {
                        case 0: {
                            n2 = 0;
                            break;
                        }
                        case 1: {
                            n2 = 256;
                            break;
                        }
                        default: {
                            file2 = null;
                        }
                    }
                }
                if (string != null) {
                    BaseDlg.showErrorDlg((Component)this, file2.getPath() + ": " + string);
                    file2 = null;
                }
            }
            if (file2 != null) {
                this.setFile(n, file2, n2);
                this.updFieldsEnabled();
                Main.setLastFile(file2, "disk");
                this.fireDataChanged();
            }
        }
    }

    private int indexOf(Object[] objectArray, Object object) {
        int n = -1;
        for (int i = 0; i < objectArray.length; ++i) {
            if (object != objectArray[i]) continue;
            n = i;
            break;
        }
        return n;
    }

    private void setFile(int n, File file, int n2) {
        int n3;
        this.fileNameFlds[n].setFile(file);
        this.offsets[n] = file != null ? (file.exists() ? ((n3 = (int)(file.length() % 512L)) >= 256 ? 256 : 0) : n2) : 0;
    }

    private void showDiskTypePopup(int n) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.addToPopupMenu("Festplatte ausw\u00e4hlen...", ACTION_HD_SELECT);
            this.popupMenu.addSeparator();
            this.mnuDiskNone = this.addToPopupMenu("Festplatte nicht emulieren", ACTION_HD_NONE);
        }
        if (this.mnuDiskNone != null) {
            this.mnuDiskNone.setEnabled(this.diskTypes[n] != null);
        }
        this.popupDiskIdx = n;
        this.popupMenu.show(this.diskTypeBtns[n], 0, this.diskTypeBtns[n].getHeight());
    }

    public void updFieldsEnabled() {
        boolean bl;
        boolean bl2 = bl = this.isEnabled() && this.btnEnabled.isSelected();
        if (this.comboIOBaseAddr != null) {
            this.comboIOBaseAddr.setEnabled(bl);
        }
        for (int i = 0; i < 2; ++i) {
            boolean bl3 = false;
            if (bl) {
                if (i > 0) {
                    if (this.diskTypes[i - 1] != null) {
                        bl3 = true;
                    }
                } else {
                    bl3 = true;
                }
            }
            this.titleLabels[i].setEnabled(bl3);
            this.diskTypeFlds[i].setEnabled(bl3);
            this.diskTypeBtns[i].setEnabled(bl3);
            if (bl3 && this.diskTypes[i] == null) {
                bl3 = false;
            }
            this.fileNameFlds[i].setEnabled(bl3);
            this.selectBtns[i].setEnabled(bl3);
        }
    }
}

