/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import jkcemu.base.EmuUtil;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.AnaDisk;

public class FloppyDiskInfo
implements Comparable<FloppyDiskInfo> {
    private String resource;
    private String infoText;
    private int sysTracks;
    private int blockSize;
    private boolean blockNum16Bit;

    public FloppyDiskInfo(String string, String string2, int n, int n2, boolean bl) {
        this.resource = string;
        this.infoText = string2;
        this.sysTracks = n;
        this.blockSize = n2;
        this.blockNum16Bit = bl;
    }

    public boolean getBlockNum16Bit() {
        return this.blockNum16Bit;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public String getResource() {
        return this.resource;
    }

    public int getSysTracks() {
        return this.sysTracks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFloppyDisk openDisk(Frame frame) throws IOException {
        AnaDisk anaDisk = null;
        InputStream inputStream = null;
        GZIPInputStream gZIPInputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream(this.resource);
            if (inputStream == null) {
                throw new IOException("Resource " + this.resource + " kann nicht ge\u00f6ffnet werden");
            }
            if (this.resource.endsWith(".dump.gz")) {
                gZIPInputStream = new GZIPInputStream(inputStream);
                anaDisk = AnaDisk.readResourceStream(frame, gZIPInputStream, this.resource);
            }
        }
        finally {
            EmuUtil.closeSilent(gZIPInputStream);
            EmuUtil.closeSilent(inputStream);
        }
        if (anaDisk == null) {
            throw new IOException("Resource " + this.resource + " kann nicht gelesen werden");
        }
        return anaDisk;
    }

    @Override
    public int compareTo(FloppyDiskInfo floppyDiskInfo) {
        String string = this.infoText;
        String string2 = floppyDiskInfo.infoText;
        if (string == null) {
            string = "";
        }
        return string.compareTo(string2 != null ? string2 : "");
    }

    public String toString() {
        return this.infoText;
    }
}

