/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jkcemu.base.BaseDlg;
import jkcemu.disk.FloppyDiskFormat;
import jkcemu.disk.FloppyDiskFormatSelectFld;

public class FloppyDiskFormatDlg
extends BaseDlg
implements ChangeListener {
    private static final String TEXT_CHOOSE = "Bitte ausw\u00e4hlen!";
    private static final Color COLOR_EMPHASIZED = Color.red;
    private static final Color COLOR_RECOGNIZED = new Color(-16744704);
    private static boolean lastApplyReadOnly = false;
    private static boolean lastForceLowerCase = true;
    private boolean approved;
    private Boolean recognizedBlockNum16Bit;
    private Integer recognizedSysTracks;
    private FloppyDiskFormat selectedFmt;
    private FloppyDiskFormatSelectFld fmtSelectFld;
    private JComboBox<Object> comboFmt;
    private JCheckBox btnReadOnly;
    private JCheckBox btnApplyReadOnly;
    private JCheckBox btnAutoRefresh;
    private JCheckBox btnForceLowerCase;
    private JSpinner spinnerSysTracks;
    private JComboBox<Integer> comboBlockSize;
    private JRadioButton btnBlockNum8Bit;
    private JRadioButton btnBlockNum16Bit;
    private JSpinner spinnerDirBlocks;
    private JLabel labelDirSizeUnit;
    private JLabel infoSysTracks;
    private JLabel infoBlockSize;
    private JLabel infoBlockNumFmt;
    private JButton btnOK;
    private JButton btnCancel;

    public FloppyDiskFormatDlg(Window window, FloppyDiskFormat floppyDiskFormat, Flag ... flagArray) {
        super(window, "Datei laden");
        int n;
        int n2;
        Object object;
        this.setTitle("JKCEMU Diskettenformat");
        this.approved = false;
        this.recognizedBlockNum16Bit = null;
        this.recognizedSysTracks = null;
        this.selectedFmt = null;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0);
        if (FloppyDiskFormatDlg.containsFlag(flagArray, Flag.FULL_FORMAT)) {
            this.fmtSelectFld = new FloppyDiskFormatSelectFld(false);
            this.fmtSelectFld.setFormat(floppyDiskFormat);
            this.add((Component)this.fmtSelectFld, gridBagConstraints);
            ++gridBagConstraints.gridy;
        } else {
            this.fmtSelectFld = null;
        }
        if (FloppyDiskFormatDlg.containsFlag(flagArray, Flag.PHYS_FORMAT)) {
            this.comboFmt = new JComboBox();
            this.comboFmt.setEditable(false);
            if (floppyDiskFormat == null) {
                this.comboFmt.addItem("--- Bitte ausw\u00e4hlen ---");
            }
            if ((object = FloppyDiskFormat.getFormats()) != null) {
                FloppyDiskFormat floppyDiskFormat2;
                n2 = 0;
                for (n = 0; n < ((FloppyDiskFormat[])object).length; ++n) {
                    floppyDiskFormat2 = object[n];
                    if (floppyDiskFormat2.getSides() != 2 || floppyDiskFormat2.getCylinders() != 80 || floppyDiskFormat2.getSectorSize() < 512) continue;
                    this.comboFmt.addItem(floppyDiskFormat2);
                    n2 = 1;
                }
                for (n = 0; n < ((FloppyDiskFormat[])object).length; ++n) {
                    floppyDiskFormat2 = object[n];
                    if (floppyDiskFormat2.getSides() == 2 && floppyDiskFormat2.getCylinders() == 80 && floppyDiskFormat2.getSectorSize() >= 512) continue;
                    if (n2 != 0) {
                        this.comboFmt.addItem("--- \u00c4ltere Formate ---");
                        n2 = 0;
                    }
                    this.comboFmt.addItem(floppyDiskFormat2);
                }
            }
            if (floppyDiskFormat != null) {
                this.comboFmt.setSelectedItem(floppyDiskFormat);
            }
            this.add(this.comboFmt, gridBagConstraints);
            ++gridBagConstraints.gridy;
        } else {
            this.comboFmt = null;
        }
        if (FloppyDiskFormatDlg.containsFlag(flagArray, Flag.SYSTEM_TRACKS)) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            this.add((Component)new JLabel("Systemspuren:"), gridBagConstraints);
            this.spinnerSysTracks = new JSpinner(new SpinnerNumberModel(0, 0, 9, 1));
            ++gridBagConstraints.gridx;
            this.add((Component)this.spinnerSysTracks, gridBagConstraints);
            this.infoSysTracks = new JLabel(TEXT_CHOOSE);
            this.infoSysTracks.setForeground(COLOR_EMPHASIZED);
            gridBagConstraints.gridx += 2;
            this.add((Component)this.infoSysTracks, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
        } else {
            this.spinnerSysTracks = null;
            this.infoSysTracks = null;
        }
        this.comboBlockSize = null;
        if (FloppyDiskFormatDlg.containsFlag(flagArray, Flag.BLOCK_SIZE)) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            this.add((Component)new JLabel("Blockgr\u00f6\u00dfe:"), gridBagConstraints);
            this.comboBlockSize = new JComboBox();
            this.comboBlockSize.setEditable(false);
            this.comboBlockSize.addItem(1);
            this.comboBlockSize.addItem(2);
            this.comboBlockSize.addItem(4);
            this.comboBlockSize.addItem(8);
            this.comboBlockSize.addItem(16);
            this.comboBlockSize.setSelectedItem(2);
            ++gridBagConstraints.gridx;
            this.add(this.comboBlockSize, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)new JLabel("KByte"), gridBagConstraints);
            this.infoBlockSize = new JLabel(TEXT_CHOOSE);
            this.infoBlockSize.setForeground(COLOR_EMPHASIZED);
            ++gridBagConstraints.gridx;
            this.add((Component)this.infoBlockSize, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
        }
        this.btnBlockNum8Bit = null;
        this.btnBlockNum16Bit = null;
        if (FloppyDiskFormatDlg.containsFlag(flagArray, Flag.BLOCK_NUM_SIZE)) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            this.add((Component)new JLabel("Blocknummern:"), gridBagConstraints);
            object = new ButtonGroup();
            this.btnBlockNum8Bit = new JRadioButton("8 Bit", false);
            ((ButtonGroup)object).add(this.btnBlockNum8Bit);
            ++gridBagConstraints.gridx;
            this.add((Component)this.btnBlockNum8Bit, gridBagConstraints);
            this.btnBlockNum16Bit = new JRadioButton("16 Bit", true);
            ((ButtonGroup)object).add(this.btnBlockNum16Bit);
            ++gridBagConstraints.gridx;
            this.add((Component)this.btnBlockNum16Bit, gridBagConstraints);
            this.infoBlockNumFmt = new JLabel(TEXT_CHOOSE);
            this.infoBlockNumFmt.setForeground(COLOR_EMPHASIZED);
            ++gridBagConstraints.gridx;
            this.add((Component)this.infoBlockNumFmt, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
        }
        this.spinnerDirBlocks = null;
        this.labelDirSizeUnit = null;
        if (FloppyDiskFormatDlg.containsFlag(flagArray, Flag.DIR_BLOCKS)) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            this.add((Component)new JLabel("Directory-Gr\u00f6\u00dfe:"), gridBagConstraints);
            this.spinnerDirBlocks = new JSpinner(new SpinnerNumberModel(1, 1, 9, 1));
            ++gridBagConstraints.gridx;
            this.add((Component)this.spinnerDirBlocks, gridBagConstraints);
            this.labelDirSizeUnit = new JLabel();
            ++gridBagConstraints.gridx;
            this.add((Component)this.labelDirSizeUnit, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            this.updDirSizeUnitLabel();
        }
        object = null;
        this.btnApplyReadOnly = null;
        this.btnReadOnly = null;
        this.btnAutoRefresh = null;
        this.btnForceLowerCase = null;
        if (flagArray != null) {
            object = new ArrayList(4);
            block8: for (n2 = 0; n2 < flagArray.length; ++n2) {
                if (flagArray[n2] == null) continue;
                switch (flagArray[n2]) {
                    case APPLY_READONLY: {
                        this.btnApplyReadOnly = new JCheckBox("Schreibschutzattribut anwenden", lastApplyReadOnly);
                        object.add(this.btnApplyReadOnly);
                        continue block8;
                    }
                    case READONLY: {
                        this.btnReadOnly = new JCheckBox("Schreibschutz (Nur-Lese-Modus)", true);
                        object.add(this.btnReadOnly);
                        continue block8;
                    }
                    case AUTO_REFRESH: {
                        this.btnAutoRefresh = new JCheckBox("Automatisch aktualisieren", false);
                        object.add(this.btnAutoRefresh);
                        continue block8;
                    }
                    case FORCE_LOWERCASE: {
                        this.btnForceLowerCase = new JCheckBox("Dateinamen klein schreiben", lastForceLowerCase);
                        object.add(this.btnForceLowerCase);
                    }
                }
            }
        }
        if (object != null && (n2 = object.size()) > 0) {
            gridBagConstraints.anchor = n2 > 1 ? 17 : 10;
            gridBagConstraints.insets.bottom = 0;
            gridBagConstraints.gridwidth = 0;
            for (n = 0; n < n2; ++n) {
                if (n == 1) {
                    gridBagConstraints.insets.top = 0;
                }
                if (n == n2 - 1) {
                    gridBagConstraints.insets.bottom = 5;
                }
                this.add((Component)object.get(n), gridBagConstraints);
                ++gridBagConstraints.gridy;
            }
        }
        this.updReadOnlyDependingFlds();
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jPanel, gridBagConstraints);
        this.btnOK = new JButton("OK");
        this.btnOK.addActionListener(this);
        this.btnOK.addKeyListener(this);
        jPanel.add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
        jPanel.add(this.btnCancel);
        if (this.labelDirSizeUnit != null) {
            if (this.spinnerDirBlocks != null) {
                this.spinnerDirBlocks.addChangeListener(this);
            }
            if (this.comboBlockSize != null) {
                this.comboBlockSize.addActionListener(this);
            }
        }
        if (this.btnReadOnly != null) {
            this.btnReadOnly.addActionListener(this);
        }
        this.pack();
        this.setParentCentered();
        this.setResizable(true);
    }

    public boolean getApplyReadOnly() {
        return this.btnApplyReadOnly != null ? this.btnApplyReadOnly.isSelected() : false;
    }

    public boolean getAutoRefresh() {
        boolean bl = false;
        if (this.btnAutoRefresh != null) {
            bl = this.btnAutoRefresh.isSelected();
        }
        return bl;
    }

    public boolean getBlockNum16Bit() {
        boolean bl = true;
        if (this.fmtSelectFld != null) {
            bl = this.fmtSelectFld.isBlockNum16Bit();
        } else if (this.btnBlockNum16Bit != null) {
            bl = this.btnBlockNum16Bit.isSelected();
        }
        return bl;
    }

    public int getBlockSize() {
        Object object;
        int n = 2048;
        if (this.fmtSelectFld != null) {
            n = this.fmtSelectFld.getBlockSize();
        } else if (this.comboBlockSize != null && (object = this.comboBlockSize.getSelectedItem()) != null && object instanceof Integer) {
            n = (Integer)object * 1024;
        }
        return n;
    }

    public int getDirBlocks() {
        int n = 2;
        if (this.fmtSelectFld != null) {
            n = this.fmtSelectFld.getDirBlocks();
        } else if (this.spinnerDirBlocks != null) {
            n = FloppyDiskFormatDlg.getIntValue(this.spinnerDirBlocks);
        }
        return n;
    }

    public boolean getForceLowerCase() {
        return this.btnForceLowerCase != null ? this.btnForceLowerCase.isSelected() : false;
    }

    public FloppyDiskFormat getFormat() {
        return this.selectedFmt;
    }

    public boolean getReadOnly() {
        return this.btnReadOnly != null ? this.btnReadOnly.isSelected() : false;
    }

    public int getSysTracks() {
        int n = 2;
        if (this.fmtSelectFld != null) {
            n = this.fmtSelectFld.getSysTracks();
        } else if (this.spinnerSysTracks != null) {
            n = FloppyDiskFormatDlg.getIntValue(this.spinnerSysTracks);
        }
        return n;
    }

    public void setAutoRefresh(boolean bl) {
        if (this.btnAutoRefresh != null) {
            this.btnAutoRefresh.setSelected(bl);
        }
    }

    public void setForceLowerCase(boolean bl) {
        if (this.btnForceLowerCase != null) {
            this.btnForceLowerCase.setSelected(bl);
        }
    }

    public void setRecognizedBlockNum16Bit(Boolean bl) {
        if (bl != null) {
            boolean bl2 = bl;
            if (this.fmtSelectFld != null) {
                this.fmtSelectFld.setBlockNum16Bit(bl2);
            }
            if (bl2) {
                if (this.btnBlockNum16Bit != null) {
                    this.btnBlockNum16Bit.setSelected(true);
                }
            } else if (this.btnBlockNum8Bit != null) {
                this.btnBlockNum8Bit.setSelected(true);
            }
        }
        if (this.infoBlockNumFmt != null) {
            String string = TEXT_CHOOSE;
            Color color = COLOR_EMPHASIZED;
            if (bl != null) {
                string = String.format("%s Bit Blocknummern erkannt", bl != false ? "16" : "8");
                color = COLOR_RECOGNIZED;
            }
            this.infoBlockNumFmt.setText(string);
            this.infoBlockNumFmt.setForeground(color);
            this.pack();
        }
    }

    public void setRecognizedBlockSize(Integer n) {
        if (n != null) {
            if (this.fmtSelectFld != null) {
                this.fmtSelectFld.setBlockSize(n);
            }
            if (this.comboBlockSize != null) {
                this.comboBlockSize.setSelectedItem(n / 1024);
                this.updDirSizeUnitLabel();
            }
        }
        if (this.infoBlockSize != null) {
            String string = TEXT_CHOOSE;
            Color color = COLOR_EMPHASIZED;
            if (n != null) {
                string = String.format("%d KByte erkannt, aber bitte trotzdem pr\u00fcfen!", n / 1024);
            }
            this.infoBlockSize.setText(string);
            this.infoBlockSize.setForeground(color);
            this.pack();
        }
    }

    public void setRecognizedSysTracks(Integer n) {
        if (n != null) {
            if (this.fmtSelectFld != null) {
                this.fmtSelectFld.setSysTracks(n);
            }
            if (this.spinnerSysTracks != null) {
                try {
                    this.spinnerSysTracks.setValue(n);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (this.infoSysTracks != null) {
            String string = TEXT_CHOOSE;
            Color color = COLOR_EMPHASIZED;
            if (n != null) {
                string = n == 1 ? "1 Systemspur erkannt" : String.format("%d Systemspuren erkannt", n);
                color = COLOR_RECOGNIZED;
            }
            this.infoSysTracks.setText(string);
            this.infoSysTracks.setForeground(color);
            this.pack();
        }
    }

    public boolean wasApproved() {
        return this.approved;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.spinnerDirBlocks) {
            this.updDirSizeUnitLabel();
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.btnOK) {
                bl = true;
                if (this.fmtSelectFld != null) {
                    this.selectedFmt = this.fmtSelectFld.getFormat();
                    this.approved = true;
                } else if (this.comboFmt != null) {
                    Object object2 = this.comboFmt.getSelectedItem();
                    if (object2 != null && object2 instanceof FloppyDiskFormat) {
                        this.selectedFmt = (FloppyDiskFormat)object2;
                        this.approved = true;
                    }
                } else {
                    this.approved = true;
                }
                if (this.approved) {
                    if (this.btnApplyReadOnly != null) {
                        lastApplyReadOnly = this.btnApplyReadOnly.isSelected();
                    }
                    if (this.btnForceLowerCase != null) {
                        lastForceLowerCase = this.btnForceLowerCase.isSelected();
                    }
                    this.doClose();
                }
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            } else if (object == this.comboBlockSize) {
                bl = true;
                this.updDirSizeUnitLabel();
            } else if (object == this.btnReadOnly) {
                bl = true;
                this.updReadOnlyDependingFlds();
            }
        }
        return bl;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        Object object;
        if (windowEvent.getWindow() == this && this.comboFmt != null && this.btnOK != null && (object = this.comboFmt.getSelectedItem()) != null && object instanceof FloppyDiskFormat) {
            this.btnOK.requestFocus();
        }
    }

    private static boolean containsFlag(Flag[] flagArray, Flag flag) {
        boolean bl = false;
        if (flagArray != null && flag != null) {
            for (int i = 0; i < flagArray.length; ++i) {
                if (flagArray[i] == null || !flagArray[i].equals((Object)flag)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static int getIntValue(JSpinner jSpinner) {
        Object object;
        int n = 0;
        if (jSpinner != null && (object = jSpinner.getValue()) != null && object instanceof Number) {
            n = ((Number)object).intValue();
        }
        return n;
    }

    private void updDirSizeUnitLabel() {
        if (this.labelDirSizeUnit != null) {
            StringBuilder stringBuilder = new StringBuilder(40);
            stringBuilder.append("Bl\u00f6cke");
            int n = this.getDirBlocks();
            if (n > 0) {
                stringBuilder.append(" (");
                stringBuilder.append(n * this.getBlockSize() / 32);
                stringBuilder.append(" Eintr\u00e4ge)");
            }
            this.labelDirSizeUnit.setText(stringBuilder.toString());
        }
    }

    private void updReadOnlyDependingFlds() {
        if (this.btnReadOnly != null && this.btnForceLowerCase != null) {
            this.btnForceLowerCase.setEnabled(!this.btnReadOnly.isSelected());
        }
    }

    public static enum Flag {
        READONLY,
        FULL_FORMAT,
        PHYS_FORMAT,
        SYSTEM_TRACKS,
        BLOCK_SIZE,
        BLOCK_NUM_SIZE,
        DIR_BLOCKS,
        APPLY_READONLY,
        AUTO_REFRESH,
        FORCE_LOWERCASE;

    }
}

