/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

public class FloppyDiskFormat {
    public static final FloppyDiskFormat FMT_400K = new FloppyDiskFormat(1, 80, 5, 1024, 1, 0, 2, 2048, true, false, "400K (LLC2 CP/L)");
    public static final FloppyDiskFormat FMT_624K = new FloppyDiskFormat(2, 80, 16, 256, 1, 2, 2, 2048, true, false, "624K Standard (PC/M)");
    public static final FloppyDiskFormat FMT_711K_I5_BASDOS = new FloppyDiskFormat(2, 80, 9, 512, 5, 1, 1, 4096, false, false, "711K (KC compact BASDOS)");
    public static final FloppyDiskFormat FMT_720K = new FloppyDiskFormat(2, 80, 9, 512, 1, 0, 2, 2048, true, false, "720K Standard (A5105 RBASIC/SCPX)");
    public static final FloppyDiskFormat FMT_780K = new FloppyDiskFormat(2, 80, 5, 1024, 1, 2, 2, 2048, true, false, "780K Standard (CAOS, NANOS, Z1013 CP/M)");
    public static final FloppyDiskFormat FMT_780K_I2 = new FloppyDiskFormat(2, 80, 5, 1024, 2, 2, 2, 2048, true, false, "780K mit Interleave 2:1 (A5105 RBASIC/SCPX)");
    public static final FloppyDiskFormat FMT_780K_I3 = new FloppyDiskFormat(2, 80, 5, 1024, 3, 2, 2, 2048, true, false, "780K mit Interleave 3:1 (MicroDOS)");
    public static final FloppyDiskFormat FMT_780K_I3_DATESTAMPER = new FloppyDiskFormat(2, 80, 5, 1024, 3, 2, 2, 2048, true, true, "780K mit Interleave 3:1 und DateStamper (ZDOS/ML-DOS)");
    public static final FloppyDiskFormat FMT_800K_I4 = new FloppyDiskFormat(2, 80, 5, 1024, 4, 0, 3, 2048, true, false, "800K mit Interleave 4:1 (Z9001 CP/A)");
    private static final FloppyDiskFormat[] formats = new FloppyDiskFormat[]{new FloppyDiskFormat(2, 80, 9, 512), new FloppyDiskFormat(2, 80, 5, 1024), new FloppyDiskFormat(2, 80, 15, 512), new FloppyDiskFormat(2, 80, 18, 512), new FloppyDiskFormat(2, 80, 11, 1024), new FloppyDiskFormat(2, 80, 36, 512), new FloppyDiskFormat(2, 80, 16, 256), new FloppyDiskFormat(1, 80, 5, 1024), new FloppyDiskFormat(1, 80, 16, 256), new FloppyDiskFormat(1, 40, 16, 256), new FloppyDiskFormat(2, 40, 16, 256), new FloppyDiskFormat(1, 40, 8, 512), new FloppyDiskFormat(1, 40, 9, 512), new FloppyDiskFormat(2, 40, 8, 512), new FloppyDiskFormat(2, 40, 9, 512), new FloppyDiskFormat(1, 40, 5, 1024), new FloppyDiskFormat(2, 40, 5, 1024)};
    private static Integer maxDiskSize = null;
    private int sides;
    private int cyls;
    private int sectorsPerCyl;
    private int sectorSize;
    private int interleave;
    private int diskSize;
    private int sysTracks;
    private int dirBlocks;
    private int blockSize;
    private boolean blockNum16Bit;
    private boolean dateStamper;
    private String infoText;

    public FloppyDiskFormat(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2, String string) {
        this.sides = n;
        this.cyls = n2;
        this.sectorsPerCyl = n3;
        this.sectorSize = n4;
        this.interleave = n5;
        this.diskSize = n * n2 * n3 * n4;
        this.sysTracks = n6;
        this.dirBlocks = n7;
        this.blockSize = n8;
        this.blockNum16Bit = bl;
        this.dateStamper = bl2;
        if (string != null) {
            this.infoText = string;
        } else {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(this.diskSize / 1024);
            stringBuilder.append(" KByte, ");
            stringBuilder.append(n2);
            stringBuilder.append(" Spuren a ");
            stringBuilder.append(n3);
            stringBuilder.append(" * ");
            stringBuilder.append(n4);
            stringBuilder.append(" Bytes");
            switch (n) {
                case 1: {
                    stringBuilder.append(", einseitig");
                    break;
                }
                case 2: {
                    stringBuilder.append(", doppelseitig");
                }
            }
            this.infoText = stringBuilder.toString();
        }
    }

    public FloppyDiskFormat(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 1, -1, -1, -1, true, false, null);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getCylinders() {
        return this.cyls;
    }

    public int getDirBlocks() {
        return this.dirBlocks;
    }

    public int getDiskSize() {
        return this.diskSize;
    }

    public static FloppyDiskFormat getFormat(int n, int n2, int n3, int n4) {
        FloppyDiskFormat floppyDiskFormat = null;
        for (int i = 0; i < formats.length; ++i) {
            FloppyDiskFormat floppyDiskFormat2 = formats[i];
            if (floppyDiskFormat2.getSides() != n || floppyDiskFormat2.getCylinders() != n2 || floppyDiskFormat2.getSectorsPerCylinder() != n3 || floppyDiskFormat2.getSectorSize() != n4) continue;
            floppyDiskFormat = floppyDiskFormat2;
            break;
        }
        return floppyDiskFormat;
    }

    public static FloppyDiskFormat getFormatByDiskSize(long l) {
        FloppyDiskFormat floppyDiskFormat = null;
        if (l > 0L) {
            for (int i = 0; i < formats.length; ++i) {
                if ((long)formats[i].getDiskSize() != l) continue;
                if (floppyDiskFormat != null) {
                    floppyDiskFormat = null;
                    break;
                }
                floppyDiskFormat = formats[i];
            }
        }
        return floppyDiskFormat;
    }

    public static FloppyDiskFormat[] getFormats() {
        return formats;
    }

    public int getInterleave() {
        return this.interleave;
    }

    public static int getMaxDiskSize() {
        if (maxDiskSize == null) {
            int n = 0;
            for (int i = 0; i < formats.length; ++i) {
                int n2 = formats[i].getDiskSize();
                if (n2 <= n) continue;
                n = n2;
            }
            maxDiskSize = n;
        }
        return maxDiskSize;
    }

    public int getSectorsPerCylinder() {
        return this.sectorsPerCyl;
    }

    public int getSectorSize() {
        return this.sectorSize;
    }

    public int getSides() {
        return this.sides;
    }

    public int getSysTracks() {
        return this.sysTracks;
    }

    public boolean isBlockNum16Bit() {
        return this.blockNum16Bit;
    }

    public boolean isDateStamperEnabled() {
        return this.dateStamper;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof FloppyDiskFormat) {
            FloppyDiskFormat floppyDiskFormat = (FloppyDiskFormat)object;
            if (floppyDiskFormat.sides == this.sides && floppyDiskFormat.cyls == this.cyls && floppyDiskFormat.sectorsPerCyl == this.sectorsPerCyl && floppyDiskFormat.sectorSize == this.sectorSize && floppyDiskFormat.diskSize == this.diskSize && floppyDiskFormat.sysTracks == this.sysTracks && floppyDiskFormat.dirBlocks == this.dirBlocks && floppyDiskFormat.blockSize == this.blockSize && floppyDiskFormat.blockNum16Bit == this.blockNum16Bit && floppyDiskFormat.dateStamper == this.dateStamper) {
                bl = true;
            }
        }
        return bl;
    }

    public String toString() {
        return this.infoText;
    }
}

