/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTML;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.ByteDataSource;
import jkcemu.base.EmuUtil;
import jkcemu.base.HelpFrm;
import jkcemu.base.HexCharFld;
import jkcemu.base.ReplyBytesDlg;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.DiskUtil;
import jkcemu.disk.SectorData;

public class DiskImgViewFrm
extends BaseFrm
implements ByteDataSource,
CaretListener,
DropTargetListener,
HyperlinkListener {
    private static final String HELP_PAGE = "/help/disk/diskimgviewer.htm";
    private static final String MARK_BOGUS_ID = "*";
    private static final String MARK_NO_DATA = "no_data";
    private static final String MARK_DELETED = "del";
    private static final String MARK_ERROR = "err";
    private static final String PROP_SPLIT_POS = "split.position";
    private static final int PREF_SECTORLIST_W = 300;
    private static final int PREF_SECTORDATA_W = 300;
    private static final int PREF_SECTORDATA_H = 200;
    private static final String HTML_ACTION_KEY_PREFIX = "sector:";
    private static final String HTML_ACTION_HREF_PREFIX = "href=sector:";
    private static final String TITLE = "JKCEMU Diskettenabbilddatei-Inspektor";
    private static final String NOT_RECOGNIZED = "nicht erkannt";
    private static DiskImgViewFrm instance = null;
    private AbstractFloppyDisk disk;
    private File file;
    private SectorData selectedSector;
    private boolean lastBigEndian;
    private ReplyBytesDlg.InputFormat lastInputFmt;
    private String lastFindText;
    private byte[] findBytes;
    private int findCyl;
    private int findHead;
    private int findSectorIdx;
    private int findDataPos;
    private JMenuItem mnuOpen;
    private JMenuItem mnuClose;
    private JMenuItem mnuBytesCopyAscii;
    private JMenuItem mnuBytesCopyHex;
    private JMenuItem mnuBytesCopyDump;
    private JMenuItem mnuFind;
    private JMenuItem mnuFindNext;
    private JMenuItem mnuHelpContent;
    private JSplitPane splitPane;
    private JEditorPane fldFileContent;
    private JTextField fldFileName;
    private JTextField fldPhysFormat;
    private JTextField fldRemark;
    private JTextField fldTimestamp;
    private JTextField fldLogFormat;
    private JTextField fldBlockSize;
    private JTextField fldBlockNumFmt;
    private JTextField fldSectorPos;
    private JTextField fldSectorID;
    private JTextField fldSectorEtc;
    private HexCharFld fldSectorData;
    private JButton btnSectorCopy;
    private JButton btnSectorExport;
    private JScrollPane spSectorData;
    private JLabel sectorDataInfo;

    public static void open() {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new DiskImgViewFrm();
        }
        instance.toFront();
        instance.setVisible(true);
    }

    public static void open(File file) {
        DiskImgViewFrm.open();
        if (file != null) {
            instance.openFile(file);
        }
    }

    @Override
    public int getAddrOffset() {
        return 0;
    }

    @Override
    public int getDataByte(int n) {
        SectorData sectorData = this.selectedSector;
        return sectorData != null ? sectorData.getDataByte(n) : 0;
    }

    @Override
    public int getDataLength() {
        SectorData sectorData = this.selectedSector;
        return sectorData != null ? sectorData.getDataLength() : 0;
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        int n = this.fldSectorData.getCaretPosition();
        boolean bl = n >= 0 && n < this.getDataLength();
        this.mnuBytesCopyAscii.setEnabled(bl);
        this.mnuBytesCopyHex.setEnabled(bl);
        this.mnuBytesCopyDump.setEnabled(bl);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        File file = EmuUtil.fileDrop(this, dropTargetDropEvent);
        if (file != null) {
            this.openFile(file);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        String string;
        Object object;
        AttributeSet attributeSet;
        Element element;
        if (this.disk != null && hyperlinkEvent.getSource() == this.fldFileContent && hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED) && (element = hyperlinkEvent.getSourceElement()) != null && (attributeSet = element.getAttributes()) != null && (object = attributeSet.getAttribute(HTML.Tag.A)) != null && (string = object.toString()) != null && string.startsWith(HTML_ACTION_HREF_PREFIX)) {
            string = string.substring(HTML_ACTION_HREF_PREFIX.length());
            try {
                String[] stringArray = string.split(":");
                if (stringArray != null && stringArray.length == 3) {
                    this.showSector(Integer.parseInt(stringArray[0].trim()), Integer.parseInt(stringArray[1].trim()), Integer.parseInt(stringArray[2].trim()));
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean applySettings(Properties properties, boolean bl) {
        boolean bl2 = super.applySettings(properties, bl);
        int n = EmuUtil.getIntProperty(properties, this.getSettingsPrefix() + PROP_SPLIT_POS, -1);
        if (n >= 0) {
            this.splitPane.setDividerLocation(n);
        }
        return bl2;
    }

    @Override
    public boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.mnuOpen) {
                bl = true;
                this.doFileOpen();
            } else if (object == this.mnuClose) {
                bl = true;
                this.doClose();
            } else if (object == this.mnuBytesCopyAscii) {
                bl = true;
                this.fldSectorData.copySelectedBytesAsAscii();
            } else if (object == this.mnuBytesCopyHex) {
                bl = true;
                this.fldSectorData.copySelectedBytesAsHex();
            } else if (object == this.mnuBytesCopyDump) {
                bl = true;
                this.fldSectorData.copySelectedBytesAsDump();
            } else if (object == this.mnuFind) {
                bl = true;
                this.doFind();
            } else if (object == this.mnuFindNext) {
                bl = true;
                this.doFindNext();
            } else if (object == this.mnuHelpContent) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            } else if (object == this.btnSectorCopy) {
                bl = true;
                this.doSectorCopy();
            } else if (object == this.btnSectorExport) {
                bl = true;
                this.doSectorExport();
            }
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = super.doClose();
        if (bl && !Main.checkQuit(this)) {
            if (this.disk != null) {
                this.disk.closeSilent();
            }
            this.disk = null;
            this.file = null;
            this.mnuFind.setEnabled(false);
            this.fldFileName.setText("");
            this.fldPhysFormat.setText("");
            this.fldRemark.setText("");
            this.fldTimestamp.setText("");
            this.fldLogFormat.setText("");
            this.fldBlockSize.setText("");
            this.fldBlockNumFmt.setText("");
            this.fldFileContent.setContentType("text/plain");
            this.fldFileContent.setText("");
            this.fldFileContent.setCaretPosition(0);
            this.clearSectorDetails();
        }
        return bl;
    }

    @Override
    public void putSettingsTo(Properties properties) {
        if (properties != null) {
            super.putSettingsTo(properties);
            properties.setProperty(this.getSettingsPrefix() + PROP_SPLIT_POS, String.valueOf(this.splitPane.getDividerLocation()));
        }
    }

    private DiskImgViewFrm() {
        this.setTitle(TITLE);
        Main.updIcon(this);
        this.disk = null;
        this.file = null;
        this.selectedSector = null;
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        jMenuBar.add(jMenu);
        this.mnuOpen = this.createJMenuItem("\u00d6ffnen...", KeyStroke.getKeyStroke(79, 2));
        jMenu.add(this.mnuOpen);
        jMenu.addSeparator();
        this.mnuClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuClose);
        JMenu jMenu2 = new JMenu("Bearbeiten");
        jMenu2.setMnemonic(66);
        jMenuBar.add(jMenu2);
        this.mnuBytesCopyHex = this.createJMenuItem("Ausgw\u00e4hlte Bytes als Hexadezimalzahlen kopieren");
        this.mnuBytesCopyHex.setEnabled(false);
        jMenu2.add(this.mnuBytesCopyHex);
        this.mnuBytesCopyAscii = this.createJMenuItem("Ausgw\u00e4hlte Bytes als ASCII-Text kopieren");
        this.mnuBytesCopyAscii.setEnabled(false);
        jMenu2.add(this.mnuBytesCopyAscii);
        this.mnuBytesCopyDump = this.createJMenuItem("Ausgw\u00e4hlte Bytes als Hex-ASCII-Dump kopieren");
        this.mnuBytesCopyDump.setEnabled(false);
        jMenu2.add(this.mnuBytesCopyDump);
        jMenu2.addSeparator();
        this.mnuFind = this.createJMenuItem("Suchen...", KeyStroke.getKeyStroke(70, 2));
        this.mnuFind.setEnabled(false);
        jMenu2.add(this.mnuFind);
        this.mnuFindNext = this.createJMenuItem("Weitersuchen", KeyStroke.getKeyStroke(114, 0));
        this.mnuFindNext.setEnabled(false);
        jMenu2.add(this.mnuFindNext);
        JMenu jMenu3 = new JMenu("?");
        jMenuBar.add(jMenu3);
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu3.add(this.mnuHelpContent);
        this.setLayout(new BorderLayout());
        this.fldFileContent = new JEditorPane();
        this.fldFileContent.setEditable(false);
        this.fldFileContent.setPreferredSize(new Dimension(300, 1));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.splitPane = new JSplitPane(1, false, new JScrollPane(this.fldFileContent), jPanel);
        this.add((Component)this.splitPane, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Datei"));
        jPanel.add((Component)jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        jPanel2.add((Component)new JLabel("Dateiname:"), gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)new JLabel("Format:"), gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)new JLabel("Bemerkung:"), gridBagConstraints2);
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)new JLabel("Zeitstempel:"), gridBagConstraints2);
        this.fldFileName = new JTextField();
        this.fldFileName.setEditable(false);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets.bottom = 0;
        gridBagConstraints2.gridy = 0;
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.fldFileName, gridBagConstraints2);
        this.fldPhysFormat = new JTextField();
        this.fldPhysFormat.setEditable(false);
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)this.fldPhysFormat, gridBagConstraints2);
        this.fldRemark = new JTextField();
        this.fldRemark.setEditable(false);
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)this.fldRemark, gridBagConstraints2);
        this.fldTimestamp = new JTextField();
        this.fldTimestamp.setEditable(false);
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)this.fldTimestamp, gridBagConstraints2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Automatische CP/M-Diskettenformaterkennung"));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        jPanel3.add((Component)new JLabel("Systemspuren / Directory:"), gridBagConstraints3);
        ++gridBagConstraints3.gridy;
        jPanel3.add((Component)new JLabel("Blockgr\u00f6\u00dfe:"), gridBagConstraints3);
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        jPanel3.add((Component)new JLabel("Blocknummernformat:"), gridBagConstraints3);
        this.fldLogFormat = new JTextField();
        this.fldLogFormat.setEditable(false);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets.bottom = 0;
        gridBagConstraints3.gridy = 0;
        ++gridBagConstraints3.gridx;
        jPanel3.add((Component)this.fldLogFormat, gridBagConstraints3);
        this.fldBlockSize = new JTextField();
        this.fldBlockSize.setEditable(false);
        ++gridBagConstraints3.gridy;
        jPanel3.add((Component)this.fldBlockSize, gridBagConstraints3);
        this.fldBlockNumFmt = new JTextField();
        this.fldBlockNumFmt.setEditable(false);
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        jPanel3.add((Component)this.fldBlockNumFmt, gridBagConstraints3);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder("Sektor"));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        jPanel4.add((Component)new JLabel("Sektorposition:"), gridBagConstraints4);
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)new JLabel("Sektor-ID:"), gridBagConstraints4);
        gridBagConstraints4.insets.bottom = 5;
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)new JLabel("Sonstiges:"), gridBagConstraints4);
        this.fldSectorPos = new JTextField();
        this.fldSectorPos.setEditable(false);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.insets.bottom = 0;
        gridBagConstraints4.gridy = 0;
        ++gridBagConstraints4.gridx;
        jPanel4.add((Component)this.fldSectorPos, gridBagConstraints4);
        this.fldSectorID = new JTextField();
        this.fldSectorID.setEditable(false);
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)this.fldSectorID, gridBagConstraints4);
        this.fldSectorEtc = new JTextField();
        this.fldSectorEtc.setEditable(false);
        gridBagConstraints4.insets.bottom = 5;
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)this.fldSectorEtc, gridBagConstraints4);
        this.sectorDataInfo = new JLabel("Bitte in der linken Ansicht einen Sektor anklicken");
        this.sectorDataInfo.setHorizontalAlignment(0);
        this.sectorDataInfo.setVerticalAlignment(0);
        this.fldSectorData = new HexCharFld(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.setPreferredSize(new Dimension(300, 200));
        this.spSectorData = new JScrollPane(jPanel5);
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)this.spSectorData, gridBagConstraints4);
        JPanel jPanel6 = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints4.anchor = 10;
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.weighty = 0.0;
        ++gridBagConstraints4.gridy;
        jPanel4.add((Component)jPanel6, gridBagConstraints4);
        this.btnSectorCopy = new JButton("Sektordaten kopieren");
        this.btnSectorCopy.setEnabled(false);
        jPanel6.add(this.btnSectorCopy);
        this.btnSectorExport = new JButton("Sektordaten exportieren...");
        this.btnSectorExport.setEnabled(false);
        jPanel6.add(this.btnSectorExport);
        new DropTarget(this.fldFileContent, this).setActive(true);
        this.fldFileContent.addHyperlinkListener(this);
        this.fldSectorData.addCaretListener(this);
        this.btnSectorCopy.addActionListener(this);
        this.btnSectorExport.addActionListener(this);
        this.resetFind();
        this.setResizable(true);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.pack();
            this.setLocationByPlatform(true);
        }
        this.fldFileContent.setPreferredSize(null);
    }

    private void doFileOpen() {
        this.openFile(EmuUtil.showFileOpenDlg(this, "Diskettenabbilddatei \u00f6ffnen", Main.getLastDirFile("disk"), EmuUtil.getPlainDiskFileFilter(), EmuUtil.getAnaDiskFileFilter(), EmuUtil.getCopyQMFileFilter(), EmuUtil.getDskFileFilter(), EmuUtil.getImageDiskFileFilter(), EmuUtil.getTeleDiskFileFilter()));
    }

    private void doFind() {
        if (this.disk != null) {
            ReplyBytesDlg replyBytesDlg = new ReplyBytesDlg(this, "Bytes suchen", this.lastInputFmt, this.lastBigEndian, this.lastFindText);
            replyBytesDlg.setVisible(true);
            byte[] byArray = replyBytesDlg.getApprovedBytes();
            if (byArray != null && byArray.length > 0) {
                this.resetFind();
                this.findBytes = byArray;
                this.lastInputFmt = replyBytesDlg.getApprovedInputFormat();
                this.lastBigEndian = replyBytesDlg.getApprovedBigEndian();
                this.lastFindText = replyBytesDlg.getApprovedText();
                this.doFindNext();
                this.mnuFindNext.setEnabled(true);
            }
        }
    }

    private void doFindNext() {
        if (this.disk != null && this.findBytes != null && this.findBytes.length > 0) {
            if (this.findCyl < 0) {
                this.findCyl = 0;
            }
            if (this.findHead < 0) {
                this.findHead = 0;
            }
            int n = this.disk.getCylinders();
            int n2 = this.disk.getSides();
            for (int i = this.findCyl; i < n; ++i) {
                for (int j = this.findHead; j < n2; ++j) {
                    if (this.findSectorIdx < 0) {
                        this.findSectorIdx = 0;
                    }
                    int n3 = this.disk.getSectorsOfCylinder(i, j);
                    for (int k = this.findSectorIdx; k < n3; ++k) {
                        SectorData sectorData = this.disk.getSectorByIndex(i, j, k);
                        if (sectorData == null) continue;
                        if (this.findDataPos < 0) {
                            this.findDataPos = 0;
                        }
                        int n4 = sectorData.getDataLength();
                        for (int i2 = this.findDataPos; i2 < n4; ++i2) {
                            int n5;
                            int n6;
                            boolean bl = true;
                            for (n6 = 0; n6 < this.findBytes.length; ++n6) {
                                n5 = i2 + n6;
                                if (n5 < n4) {
                                    if ((byte)sectorData.getDataByte(n5) == this.findBytes[n6]) continue;
                                    bl = false;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            if (!bl) continue;
                            this.showSector(i, j, k);
                            n6 = i2 + this.findBytes.length - 1;
                            n5 = i2;
                            final HexCharFld hexCharFld = this.fldSectorData;
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    hexCharFld.setSelection(n6, n5);
                                }
                            });
                            this.findDataPos = i2 + 1;
                            if (this.findDataPos >= n4) {
                                this.findDataPos = 0;
                                ++this.findSectorIdx;
                                if (this.findSectorIdx >= n3) {
                                    this.findSectorIdx = 0;
                                    if (++j >= n2) {
                                        ++this.findCyl;
                                    }
                                }
                            }
                            return;
                        }
                    }
                }
            }
            BaseDlg.showInfoDlg(this, "Byte-Folge nicht gefunden");
        }
    }

    private void doSectorCopy() {
        int n;
        SectorData sectorData = this.selectedSector;
        if (sectorData != null && (n = sectorData.getDataLength()) > 0) {
            StringBuilder stringBuilder = new StringBuilder(n * 3);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(i % 16 == 0 ? (char)'\n' : ' ');
                }
                stringBuilder.append(String.format("%02X", sectorData.getDataByte(i)));
            }
            stringBuilder.append('\n');
            EmuUtil.copyToClipboard(this, stringBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSectorExport() {
        int n;
        SectorData sectorData = this.selectedSector;
        if (sectorData != null && (n = sectorData.getDataLength()) > 0) {
            int n2;
            String string;
            File file = Main.getLastDirFile("sector");
            if (file == null && this.file != null) {
                file = this.file.getParentFile();
            }
            String string2 = "";
            if (this.file != null && (string = this.file.getName()) != null && (n2 = string.indexOf(46)) > 0) {
                string2 = string.substring(0, n2) + "_";
            }
            string = String.format("%ssector_%d_%d_%d_%d.bin", string2, sectorData.getCylinder(), sectorData.getHead(), sectorData.getSectorNum(), sectorData.getSizeCode());
            File file2 = EmuUtil.showFileSaveDlg(this, "Sektordaten exportieren", file != null ? new File(file, string) : new File(string), EmuUtil.getBinaryFileFilter());
            if (file2 != null) {
                try {
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(file2);
                        sectorData.writeTo(fileOutputStream, -1);
                        ((OutputStream)fileOutputStream).close();
                        fileOutputStream = null;
                        Main.setLastFile(file2, "sector");
                    }
                    catch (Throwable throwable) {
                        EmuUtil.closeSilent(fileOutputStream);
                        throw throwable;
                    }
                    EmuUtil.closeSilent(fileOutputStream);
                }
                catch (IOException iOException) {
                    BaseDlg.showErrorDlg((Component)this, iOException);
                }
            }
        }
    }

    private void clearSectorDetails() {
        this.selectedSector = null;
        this.fldSectorPos.setText("");
        this.fldSectorID.setText("");
        this.fldSectorEtc.setText("");
        this.btnSectorCopy.setEnabled(false);
        this.btnSectorExport.setEnabled(false);
        if (this.disk != null) {
            this.setSectorDataView(this.sectorDataInfo);
        } else {
            this.setSectorDataView(null);
        }
    }

    private void openFile(File file) {
        if (file != null) {
            try {
                AbstractFloppyDisk abstractFloppyDisk = DiskUtil.readDiskFile(this, file, false);
                if (abstractFloppyDisk != null) {
                    boolean bl;
                    int n;
                    int n2;
                    if (this.disk != null) {
                        this.disk.closeSilent();
                    }
                    this.disk = abstractFloppyDisk;
                    this.file = file;
                    Main.setLastFile(file, "disk");
                    this.setTitle("JKCEMU Diskettenabbilddatei-Inspektor: " + file.getPath());
                    int n3 = abstractFloppyDisk.getCylinders();
                    int n4 = abstractFloppyDisk.getSides();
                    int n5 = abstractFloppyDisk.getSectorsPerCylinder();
                    int n6 = abstractFloppyDisk.getSectorSize();
                    DiskImgViewFrm.setText(this.fldFileName, file.getName());
                    DiskImgViewFrm.setText(this.fldPhysFormat, String.format("%d KByte brutto (%d x %d x %d x %d)", n3 * n4 * n6 * n5 / 1024, n3, n4, n5, n6));
                    DiskImgViewFrm.setText(this.fldRemark, abstractFloppyDisk.getRemark());
                    Date date = abstractFloppyDisk.getDiskDate();
                    if (date != null) {
                        DiskImgViewFrm.setText(this.fldTimestamp, DateFormat.getDateTimeInstance(2, 2).format(date));
                    }
                    StringBuilder stringBuilder = new StringBuilder(8192);
                    int n7 = 2048;
                    float f = 0.0f;
                    AtomicInteger atomicInteger = new AtomicInteger(-1);
                    AtomicInteger atomicInteger2 = new AtomicInteger(-1);
                    byte[] byArray = DiskUtil.findAndReadDirBytes(null, null, null, abstractFloppyDisk, atomicInteger);
                    if (atomicInteger.get() > 0 && (n2 = abstractFloppyDisk.getSides() * abstractFloppyDisk.getSectorsPerCylinder() * abstractFloppyDisk.getSectorSize()) > 0) {
                        f = atomicInteger.floatValue() / (float)n2;
                    }
                    Boolean bl2 = DiskUtil.checkBlockNum16Bit(byArray, abstractFloppyDisk.getDiskSize(), atomicInteger2);
                    if (atomicInteger2.get() > 0) {
                        n7 = atomicInteger2.get();
                    }
                    if (byArray.length > 0) {
                        n = Math.round(f * 100.0f);
                        if (n == 0) {
                            stringBuilder.append("Keine Systemspur");
                        } else if (n == 100) {
                            stringBuilder.append("1 Systemspur");
                        } else {
                            NumberFormat numberFormat = NumberFormat.getNumberInstance();
                            if (numberFormat instanceof DecimalFormat) {
                                ((DecimalFormat)numberFormat).applyPattern("#0.##");
                            }
                            stringBuilder.append(numberFormat.format(f));
                            stringBuilder.append(" Systemspuren");
                        }
                        stringBuilder.append(", ");
                        bl = false;
                        if (DiskUtil.isFilledDir(byArray)) {
                            if (byArray.length % 1024 == 0) {
                                stringBuilder.append(String.format("%d KByte", byArray.length / 1024));
                            } else {
                                stringBuilder.append(String.format("%d Byte", byArray.length));
                            }
                        } else {
                            stringBuilder.append("leeres");
                        }
                        stringBuilder.append(" Directory");
                    } else {
                        stringBuilder.append(NOT_RECOGNIZED);
                    }
                    DiskImgViewFrm.setText(this.fldLogFormat, stringBuilder.toString());
                    if (atomicInteger2.get() > 0) {
                        stringBuilder.setLength(0);
                        if (n7 % 1024 == 0) {
                            stringBuilder.append(String.format("%d KByte", n7 / 1024));
                        } else {
                            stringBuilder.append(String.format("%d Byte", n7));
                        }
                        stringBuilder.append(", nicht zu 100% sicher erkennbar!");
                        DiskImgViewFrm.setText(this.fldBlockSize, stringBuilder.toString());
                    } else {
                        DiskImgViewFrm.setText(this.fldBlockSize, NOT_RECOGNIZED);
                    }
                    if (bl2 != null) {
                        DiskImgViewFrm.setText(this.fldBlockNumFmt, bl2 != false ? "16 Bit" : "8 Bit");
                    } else {
                        DiskImgViewFrm.setText(this.fldBlockNumFmt, NOT_RECOGNIZED);
                    }
                    stringBuilder.setLength(0);
                    stringBuilder.append("<html>\n");
                    if (n3 < 1 || n4 < 1) {
                        stringBuilder.append("Diskettenabbilddatei ist leer!");
                    } else {
                        int n8;
                        n = 0;
                        bl = false;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        stringBuilder.append("<table border=\"1\">\n<tr><th>Spur</th>");
                        for (n8 = 0; n8 < n4; ++n8) {
                            stringBuilder.append("<th>Sektoren Seite&nbsp;");
                            stringBuilder.append(n8 + 1);
                            stringBuilder.append(" (Kopf&nbsp;");
                            stringBuilder.append(n8);
                            stringBuilder.append(")</th>");
                        }
                        stringBuilder.append("</tr>\n");
                        for (n8 = 0; n8 < n3; ++n8) {
                            stringBuilder.append("<tr><td align=\"right\">");
                            stringBuilder.append(n8);
                            stringBuilder.append("</td>");
                            for (int i = 0; i < n4; ++i) {
                                stringBuilder.append("<td align=\"left\" nowrap=\"nowrap\">");
                                int n9 = abstractFloppyDisk.getSectorsOfCylinder(n8, i);
                                for (int j = 0; j < n9; ++j) {
                                    int n10;
                                    int n11;
                                    int n12;
                                    SectorData sectorData = abstractFloppyDisk.getSectorByIndex(n8, i, j);
                                    if (sectorData == null) continue;
                                    if (j > 0) {
                                        stringBuilder.append("&nbsp;");
                                    }
                                    stringBuilder.append("<a href=\"");
                                    stringBuilder.append(HTML_ACTION_KEY_PREFIX);
                                    stringBuilder.append(n8);
                                    stringBuilder.append(':');
                                    stringBuilder.append(i);
                                    stringBuilder.append(':');
                                    stringBuilder.append(j);
                                    stringBuilder.append("\">[");
                                    stringBuilder.append(sectorData.getSectorNum());
                                    if (sectorData.hasBogusID()) {
                                        n = 1;
                                        stringBuilder.append(MARK_BOGUS_ID);
                                    }
                                    if ((n12 = sectorData.getCylinder()) != n8) {
                                        stringBuilder.append(",c=");
                                        stringBuilder.append(n12);
                                    }
                                    if ((n11 = sectorData.getHead()) != i) {
                                        stringBuilder.append(",h=");
                                        stringBuilder.append(n11);
                                    }
                                    if ((n10 = sectorData.getDataLength()) != n6) {
                                        stringBuilder.append(",n=");
                                        stringBuilder.append(sectorData.getSizeCode());
                                    }
                                    if (n10 == 0) {
                                        bl = true;
                                        stringBuilder.append(',');
                                        stringBuilder.append(MARK_NO_DATA);
                                    }
                                    if (sectorData.isDeleted()) {
                                        bl3 = true;
                                        stringBuilder.append(',');
                                        stringBuilder.append(MARK_DELETED);
                                    }
                                    if (sectorData.checkError()) {
                                        bl4 = true;
                                        stringBuilder.append(',');
                                        stringBuilder.append(MARK_ERROR);
                                    }
                                    stringBuilder.append("]</a>");
                                }
                                stringBuilder.append("</td>");
                            }
                            stringBuilder.append("</tr>\n");
                        }
                        stringBuilder.append("</table>\n");
                        if (n != 0 || bl || bl3 || bl4) {
                            stringBuilder.append("<br/>\nAgenda:<br/>\n<table border=\"0\">\n");
                            if (n != 0) {
                                stringBuilder.append("<tr><td valign=\"top\">");
                                stringBuilder.append(MARK_BOGUS_ID);
                                stringBuilder.append("</td><td valign=\"top\">Sektor-ID generiert, da Sektorkopf nicht gelesen werden konnte</td></tr>\n");
                            }
                            if (bl) {
                                stringBuilder.append("<tr><td valign=\"top\">");
                                stringBuilder.append(MARK_NO_DATA);
                                stringBuilder.append("</td><td valign=\"top\">Sektor ohne Datenbereich</td></tr>\n");
                            }
                            if (bl3) {
                                stringBuilder.append("<tr><td valign=\"top\">");
                                stringBuilder.append(MARK_DELETED);
                                stringBuilder.append("</td><td valign=\"top\">Sektor mit L&ouml;schmarkierung</td></tr>\n");
                            }
                            if (bl3) {
                                stringBuilder.append("<tr><td>");
                                stringBuilder.append(MARK_ERROR);
                                stringBuilder.append("</td><td valign=\"top\">Sektordaten mit CRC-Fehler gelesen</td></tr>\n");
                            }
                            stringBuilder.append("</table>\n");
                        }
                    }
                    stringBuilder.append("</html>");
                    this.fldFileContent.setContentType("text/html");
                    DiskImgViewFrm.setText(this.fldFileContent, stringBuilder.toString());
                    this.clearSectorDetails();
                    this.resetFind();
                    this.mnuFind.setEnabled(true);
                }
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this, iOException);
            }
        }
    }

    private void resetFind() {
        this.lastBigEndian = false;
        this.lastInputFmt = null;
        this.lastFindText = null;
        this.findBytes = null;
        this.findCyl = 0;
        this.findHead = 0;
        this.findSectorIdx = 0;
        this.findDataPos = 0;
        this.mnuFindNext.setEnabled(false);
    }

    private void setSectorDataView(Component component) {
        JViewport jViewport = this.spSectorData.getViewport();
        if (jViewport != null) {
            jViewport.setView(component);
        }
    }

    private static void setText(JTextComponent jTextComponent, String string) {
        jTextComponent.setText(string != null ? string : "");
        jTextComponent.setCaretPosition(0);
    }

    private void showSector(int n, int n2, int n3) {
        SectorData sectorData = this.disk.getSectorByIndex(n, n2, n3);
        if (sectorData != null) {
            DiskImgViewFrm.setText(this.fldSectorPos, String.format("Spur %d, Seite %d, Index %d\n", n, n2 + 1, n3));
            DiskImgViewFrm.setText(this.fldSectorID, String.format("C=%d, H=%d, R=%d, N=%d\n", sectorData.getCylinder(), sectorData.getHead(), sectorData.getSectorNum(), sectorData.getSizeCode()));
            String string = "";
            if (sectorData.isDeleted() || sectorData.checkError() || sectorData.hasBogusID()) {
                StringBuilder stringBuilder = new StringBuilder(128);
                if (sectorData.isDeleted()) {
                    stringBuilder.append("Sektor gel\u00f6scht");
                }
                if (sectorData.checkError()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("Lesefehler");
                }
                if (sectorData.hasBogusID()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("Sektor-ID generiert (Sektorkopf war nicht lesbar)");
                }
                string = stringBuilder.toString();
            }
            DiskImgViewFrm.setText(this.fldSectorEtc, string);
            this.selectedSector = sectorData;
            this.setSectorDataView(this.fldSectorData);
            this.fldSectorData.refresh();
            this.btnSectorCopy.setEnabled(true);
            this.btnSectorExport.setEnabled(true);
        } else {
            this.clearSectorDetails();
        }
    }

    private static class DataFoundException
    extends Exception {
        private DataFoundException() {
        }
    }
}

