/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Frame;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileTimesView;
import jkcemu.base.FileTimesViewFactory;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.DateStamper;
import jkcemu.disk.DiskUtil;
import jkcemu.disk.SectorData;

public class DirectoryFloppyDisk
extends AbstractFloppyDisk {
    public static final String PROP_AUTO_REFRESH = "auto_refresh";
    public static final String PROP_BLOCK_NUMBER_SIZE = "block_number_size";
    public static final String PROP_BLOCK_SIZE = "block_size";
    public static final String PROP_DATESTAMPER = "datestamper";
    public static final String PROP_DIR_BLOCKS = "dir_blocks";
    public static final String PROP_DIRECTORY = "directory";
    public static final String PROP_FORCE_LOWERCASE = "force_lowercase";
    public static final String PROP_SYSTEM_TRACKS = "system_tracks";
    public static final String SYS_FILE_NAME = "@boot.sys";
    private static EntryNameComparator entryNameComparator = null;
    private File dirFile;
    private File sysFile;
    private long lastBuildMillis;
    private Map<String, File> fileMap;
    private Map<String, Exception> errorMap;
    private byte[] dirBytes;
    private SectorData[] sectors;
    private int sectorSizeCode;
    private int sectorsPerBlock;
    private int dirBlocks;
    private int dirSectors;
    private int maxDirEntries;
    private int extentsPerDirEntry;
    private int sysTracks;
    private int sysSectors;
    private int blockSize;
    private boolean blockNum16Bit;
    private boolean autoRefresh;
    private boolean forceLowerCase;
    private boolean readOnly;
    private boolean dsEnabled;
    private byte[] dsBytes;
    private int dsFirstSector;
    private int dsSectors;
    private FileTimesViewFactory ftvFactory;
    private String remark;
    private volatile boolean refreshFired;

    public DirectoryFloppyDisk(Frame frame, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, FileTimesViewFactory fileTimesViewFactory, File file, boolean bl3, boolean bl4, boolean bl5) {
        super(frame, n, n2, n3, n4);
        this.dirFile = file;
        this.sysFile = new File(this.dirFile, SYS_FILE_NAME);
        this.sysTracks = n5;
        this.sysSectors = n5 * n * n3;
        this.blockSize = n7;
        this.blockNum16Bit = bl;
        this.sectorsPerBlock = n7 / n4;
        this.dirBlocks = n6;
        this.dirSectors = n6 * this.sectorsPerBlock;
        this.sectorSizeCode = SectorData.getSizeCode(n4);
        this.autoRefresh = bl3;
        this.readOnly = bl4;
        this.forceLowerCase = bl5;
        this.lastBuildMillis = -1L;
        this.fileMap = new HashMap<String, File>();
        this.errorMap = null;
        this.dirBytes = null;
        this.dsEnabled = bl2;
        this.dsBytes = null;
        this.dsFirstSector = -1;
        this.dsSectors = 0;
        this.ftvFactory = fileTimesViewFactory;
        this.maxDirEntries = 0;
        this.sectors = new SectorData[n * n2 * n3];
        this.refreshFired = false;
        this.extentsPerDirEntry = DiskUtil.getExtentsPerDirEntry(n7, bl);
        this.remark = this.autoRefresh ? "Automatische Aktualisierung aktiv" : "Keine automatische Aktualisierung";
        Arrays.fill(this.sectors, null);
    }

    public void fireRefresh() {
        this.refreshFired = true;
    }

    public File getDirFile() {
        return this.dirFile;
    }

    @Override
    public String getFileFormatText() {
        return null;
    }

    @Override
    public String getFormatText() {
        String string = super.getFormatText();
        if (string != null && this.dsEnabled) {
            string = string + ", DateStamper";
        }
        return string;
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    @Override
    public synchronized SectorData getSectorByIndex(int n, int n2, int n3) {
        int n4;
        SectorData sectorData = null;
        if (this.dirBytes == null) {
            this.rebuildDisk();
        } else if ((n == 0 || n == this.sysTracks) && n2 == 0 && n3 == 0) {
            long l;
            if (this.refreshFired) {
                this.refreshFired = false;
                this.rebuildDisk();
            } else if (this.autoRefresh && (l = System.currentTimeMillis()) != -1L && (this.lastBuildMillis == -1L || this.lastBuildMillis < l - 5000L)) {
                this.rebuildDisk();
            }
        }
        int n5 = this.getSectorsPerCylinder();
        int n6 = this.getSectorSize();
        if (n >= 0 && n5 > 0 && n3 >= 0 && n3 < n5 && (n4 = this.computeAbsSectorIdx(n, n2, n3)) >= 0 && n4 < this.sectors.length) {
            sectorData = this.sectors[n4];
            if (sectorData == null) {
                if (n < this.sysTracks) {
                    if (this.sysFile.exists()) {
                        int n7 = 0;
                        byte[] byArray = this.readFile(this.sysFile);
                        if (byArray != null) {
                            for (int i = 0; n7 < this.sysSectors && i < byArray.length; i += n6) {
                                this.setSectorData(n7++, byArray, i, this.getSectorSize(), false);
                            }
                        }
                    }
                } else {
                    File file;
                    String string;
                    int n8 = n4 - this.sysSectors;
                    int n9 = n8 * n6 / this.blockSize;
                    if (n9 > 0 && (string = this.findEntryNameByDataBlock(n9)) != null && (file = this.fileMap.get(string)) != null) {
                        this.loadFileIntoSectors(file, this.getBlockNumsByEntryName(string, null));
                    }
                }
                sectorData = this.sectors[n4];
            }
            if (sectorData == null) {
                this.setSectorData(n4, null, 0, this.getSectorSize(), false);
                sectorData = this.sectors[n4];
            }
        }
        return sectorData;
    }

    @Override
    public SectorData getSectorByID(int n, int n2, int n3, int n4, int n5, int n6) {
        SectorData sectorData = this.getSectorByIndex(n, n2, n5 - 1);
        if (sectorData != null && (sectorData.getCylinder() != n3 || sectorData.getHead() != n4 || sectorData.getSectorNum() != n5 || n6 >= 0 && sectorData.getSizeCode() != n6)) {
            sectorData = null;
        }
        return sectorData;
    }

    @Override
    public int getSectorOffset() {
        return 0;
    }

    @Override
    protected int getSysTracks() {
        return this.sysTracks;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void putSettingsTo(Properties properties, String string) {
        super.putSettingsTo(properties, string);
        if (properties != null) {
            properties.setProperty(string + PROP_DIRECTORY, this.dirFile.getPath());
            properties.setProperty(string + PROP_SYSTEM_TRACKS, Integer.toString(this.sysTracks));
            properties.setProperty(string + PROP_BLOCK_SIZE, Integer.toString(this.blockSize));
            properties.setProperty(string + PROP_BLOCK_NUMBER_SIZE, this.blockNum16Bit ? "16" : "8");
            properties.setProperty(string + PROP_DIR_BLOCKS, Integer.toString(this.dirBlocks));
            properties.setProperty(string + PROP_DATESTAMPER, Boolean.toString(this.dsEnabled));
            properties.setProperty(string + PROP_AUTO_REFRESH, Boolean.toString(this.autoRefresh));
            properties.setProperty(string + "readonly", Boolean.toString(this.isReadOnly()));
            properties.setProperty(string + PROP_FORCE_LOWERCASE, Boolean.toString(this.forceLowerCase));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean writeSector(int n, int n2, SectorData sectorData, byte[] byArray, int n3, boolean bl) {
        boolean bl2 = false;
        if (!this.readOnly && byArray != null && n3 > 0 && !bl) {
            int n4;
            if (n3 > byArray.length) {
                n3 = byArray.length;
            }
            if ((n4 = this.computeAbsSectorIdx(n, n2, sectorData.getSectorNum() - 1)) >= 0 && n4 < this.sectors.length) {
                RandomAccessFile randomAccessFile = null;
                try {
                    List<Integer> list;
                    int n5;
                    String string;
                    int n6;
                    int n7 = this.getSectorSize();
                    int n8 = Math.min(n3, n7);
                    byte[] byArray2 = new byte[n8];
                    System.arraycopy(byArray, 0, byArray2, 0, n8);
                    this.setSectorData(n4, byArray2, 0, n8, false);
                    if (n4 < this.sysSectors) {
                        randomAccessFile = new RandomAccessFile(this.sysFile, "rw");
                        randomAccessFile.seek(n4 * this.getSectorSize());
                        randomAccessFile.write(byArray, 0, Math.min(n3, n7));
                        randomAccessFile.close();
                        randomAccessFile = null;
                    } else if (n4 >= this.sysSectors && n4 < this.sysSectors + this.dirSectors) {
                        this.writeDirSector(n4, byArray, n3);
                    } else if (this.dsEnabled && n4 >= this.dsFirstSector && n4 < this.dsFirstSector + this.dsSectors) {
                        this.writeDsSector(n4, byArray, n3);
                    } else if (n4 >= this.sysSectors + this.dirSectors && (n6 = n4 - this.sysSectors) >= 0 && (string = this.findEntryNameByDataBlock(n5 = n6 / this.sectorsPerBlock)) != null && (list = this.getBlockNumsByEntryName(string, null)) != null) {
                        File file = null;
                        int n9 = 0;
                        for (Integer n10 : list) {
                            if (n10.equals(n5)) {
                                file = this.fileMap.get(string);
                                break;
                            }
                            ++n9;
                        }
                        if (file != null) {
                            int n11 = n6 - n5 * this.sectorsPerBlock;
                            randomAccessFile = new RandomAccessFile(file, "rw");
                            randomAccessFile.seek((n9 * this.sectorsPerBlock + n11) * this.getSectorSize());
                            randomAccessFile.write(byArray, 0, Math.min(n3, n7));
                            randomAccessFile.close();
                            randomAccessFile = null;
                        }
                    }
                    EmuUtil.closeSilent(randomAccessFile);
                }
                catch (IOException iOException) {
                    this.sectors[n4] = null;
                    this.fireShowError("E/A-Fehler", iOException);
                    bl2 = false;
                }
                finally {
                    EmuUtil.closeSilent(randomAccessFile);
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    private int computeAbsSectorIdx(int n, int n2, int n3) {
        int n4 = -1;
        int n5 = this.getSectorsPerCylinder();
        if (n >= 0 && n5 > 0 && n3 >= 0 && n3 < n5) {
            n4 = n * this.getSides() * n5;
            if ((n2 & 1) != 0) {
                n4 += n5;
            }
            n4 += n3;
        }
        return n4;
    }

    private void ensureFileLoaded(String string) {
        List<Integer> list;
        File file;
        if (string != null && this.dirBytes != null && this.sectors != null && (file = this.fileMap.get(string)) != null && (list = this.getBlockNumsByEntryName(string, null)) != null) {
            block0: for (Integer n : list) {
                int n2 = this.sysSectors + n * this.sectorsPerBlock;
                for (int i = 0; i < this.sectorsPerBlock; ++i) {
                    if (n2 < 0 || n2 >= this.sectors.length) continue;
                    if (this.sectors[n2] == null) {
                        this.loadFileIntoSectors(file, list);
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
    }

    private String extractEntryName(byte[] byArray, int n) {
        String string = null;
        int n2 = byArray[n] & 0xFF;
        if (n2 != 229 && (n2 & 0xF0) == 0) {
            char[] cArray = new char[12];
            cArray[0] = (char)(n2 + 48);
            for (int i = 1; i < 12; ++i) {
                cArray[i] = (char)(byArray[n + i] & 0x7F);
            }
            string = new String(cArray);
        }
        return string;
    }

    private int findEntryBegPosByNameAndExtent(String string, int n) {
        int n2 = -1;
        if (string != null && this.dirBytes != null && string.length() == 12) {
            int n3 = 0;
            while (n3 + 31 < this.dirBytes.length) {
                int n4;
                int n5 = this.dirBytes[n3] & 0xFF;
                if (n5 != 229 && (n5 & 0xF0) == 0 && (n4 = DiskUtil.getExtentNumByEntryPos(this.dirBytes, n3)) >= n && n4 < n + this.extentsPerDirEntry) {
                    boolean bl = false;
                    if ((n5 & 0xF) == string.charAt(0) - 48) {
                        bl = true;
                        for (int i = 1; i < 12; ++i) {
                            if ((this.dirBytes[n3 + i] & 0x7F) == string.charAt(i)) continue;
                            bl = false;
                            break;
                        }
                    }
                    if (bl) {
                        n2 = n3;
                        break;
                    }
                }
                n3 += 32;
            }
        }
        return n2;
    }

    private String findEntryNameByDataBlock(int n) {
        String string = null;
        if (this.dirBytes != null) {
            int n2 = 0;
            while (string == null && n2 + 31 < this.dirBytes.length) {
                int n3 = this.dirBytes[n2] & 0xFF;
                if (n3 != 229 && (n3 & 0xF0) == 0) {
                    int n4;
                    int n5 = n2 + 16;
                    if (this.blockNum16Bit) {
                        for (n4 = 0; n4 < 8; ++n4) {
                            if (EmuUtil.getWord(this.dirBytes, n5) == n) {
                                string = this.extractEntryName(this.dirBytes, n2);
                                break;
                            }
                            n5 += 2;
                        }
                    } else {
                        for (n4 = 0; n4 < 16; ++n4) {
                            if ((this.dirBytes[n5] & 0xFF) == n) {
                                string = this.extractEntryName(this.dirBytes, n2);
                                break;
                            }
                            ++n5;
                        }
                    }
                }
                n2 += 32;
            }
        }
        return string;
    }

    private List<Integer> getBlockNumsByEntryName(String string, AtomicInteger atomicInteger) {
        ArrayList<Integer> arrayList = null;
        if (string != null && this.dirBytes != null) {
            if (atomicInteger != null) {
                atomicInteger.set(-1);
            }
            int n = 0;
            int n2 = this.findEntryBegPosByNameAndExtent(string, n);
            while (n2 >= 0 && n2 < this.dirBytes.length) {
                int n3;
                int n4;
                int n5;
                int n6 = (this.dirBytes[n2 + 15] & 0xFF) * 128;
                int n7 = DiskUtil.getExtentNumByEntryPos(this.dirBytes, n2);
                if (n7 > n && this.extentsPerDirEntry > 1) {
                    n5 = (this.blockNum16Bit ? 8 : 16) / this.extentsPerDirEntry;
                    n6 += n5 * this.blockSize;
                }
                n5 = n2 + 16;
                if (this.blockNum16Bit) {
                    for (n4 = 0; n4 < 8; ++n4) {
                        n3 = EmuUtil.getWord(this.dirBytes, n5);
                        if (n3 > 0) {
                            if (arrayList == null) {
                                arrayList = new ArrayList<Integer>(32);
                            }
                            arrayList.add(n3);
                        }
                        n5 += 2;
                    }
                } else {
                    for (n4 = 0; n4 < 16; ++n4) {
                        n3 = this.dirBytes[n5] & 0xFF;
                        if (n3 > 0) {
                            if (arrayList == null) {
                                arrayList = new ArrayList(32);
                            }
                            arrayList.add(n3);
                            if (n6 == 0) {
                                n6 = 256;
                            }
                        }
                        ++n5;
                    }
                }
                if (atomicInteger != null) {
                    if (atomicInteger.get() < 0) {
                        atomicInteger.set(n6);
                    } else {
                        atomicInteger.addAndGet(n6);
                    }
                }
                n2 = this.findEntryBegPosByNameAndExtent(string, n += this.extentsPerDirEntry);
            }
        }
        return arrayList;
    }

    private static boolean isInSameMinute(Long l, Long l2) {
        boolean bl = false;
        if (l != null && l2 != null && l2 >= l && l2 < l + 60000L) {
            bl = true;
        }
        return bl;
    }

    private void loadFileIntoSectors(File file, List<Integer> list) {
        int n;
        byte[] byArray = this.readFile(file);
        if (list != null && (n = this.getSectorSize()) > 0) {
            int n2 = 0;
            for (Integer n3 : list) {
                if (n3 < this.dirBlocks) continue;
                for (int i = 0; i < this.sectorsPerBlock; ++i) {
                    this.setSectorData(this.sysSectors + n3 * this.sectorsPerBlock + i, byArray, n2, n, byArray == null);
                    n2 += n;
                }
            }
        }
    }

    private byte[] readFile(File file) {
        byte[] byArray = null;
        try {
            byArray = EmuUtil.readFile(file, false, this.getDiskSize());
        }
        catch (IOException iOException) {
            String string = file.getPath();
            if (string != null && !string.isEmpty()) {
                if (this.errorMap == null) {
                    this.errorMap = new HashMap<String, Exception>();
                }
                this.errorMap.put(string, iOException);
            }
            this.fireShowError(string + ": Lesen der zugrunde liegenden Datei" + " fehlgeschlagen", iOException);
        }
        return byArray;
    }

    private void rebuildDisk() {
        int n;
        block46: {
            if (this.dirBytes == null) {
                this.dirBytes = new byte[this.dirBlocks * this.blockSize];
                this.maxDirEntries = this.dirBytes.length / 32;
            }
            Arrays.fill(this.dirBytes, (byte)-27);
            Arrays.fill(this.sectors, null);
            this.sysSectors = this.getSides() * this.sysTracks * this.getSectorsPerCylinder();
            this.fileMap.clear();
            if (this.errorMap != null) {
                this.errorMap.clear();
            }
            this.lastBuildMillis = System.currentTimeMillis();
            try {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                Set set;
                n = DiskUtil.getExtentsPerDirEntry(this.blockSize, this.blockNum16Bit);
                HashMap<String, File> hashMap = new HashMap<String, File>();
                DateStamper dateStamper = null;
                boolean bl = false;
                if (this.dsEnabled) {
                    hashMap.put("0!!!TIME&DAT", null);
                    dateStamper = new DateStamper(this.ftvFactory, this.dirBlocks * this.blockSize / 32, this.dsBytes);
                }
                for (int i = 0; !bl && i < 16; ++i) {
                    File[] fileArray;
                    set = this.dirFile;
                    if (i > 0) {
                        set = new File((File)((Object)set), Integer.toString(i));
                    }
                    if ((fileArray = ((File)((Object)set)).listFiles()) == null) continue;
                    for (n6 = 0; n6 < fileArray.length; ++n6) {
                        String string;
                        String string2;
                        File file = fileArray[n6];
                        if (file == null || !file.isFile() || !file.canRead() || file.equals(this.sysFile) || (string2 = fileArray[n6].getName()) == null || (string = string2.trim().toUpperCase()) == null) continue;
                        n5 = string.length();
                        if (this.dsEnabled && string2.equals("!!!TIME&.DAT") || n5 <= 0 || n5 >= 13 || n5 != string2.length()) continue;
                        StringBuilder stringBuilder = new StringBuilder(12);
                        stringBuilder.append((char)(i + 48));
                        n4 = 1;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        for (int j = 0; j < n5; ++j) {
                            char c = string.charAt(j);
                            if (DiskUtil.isValidCPMFileNameChar(c)) {
                                n3 = stringBuilder.length();
                                if (!bl3 && n4 < 9 || bl3 && n4 < 12) {
                                    stringBuilder.append(c);
                                    ++n4;
                                    continue;
                                }
                                bl2 = true;
                                break;
                            }
                            if (c == '.') {
                                if (n4 > 0) {
                                    while (n4 < 9) {
                                        stringBuilder.append(' ');
                                        ++n4;
                                    }
                                    bl3 = true;
                                    continue;
                                }
                                bl2 = true;
                                break;
                            }
                            bl2 = true;
                            break;
                        }
                        if (bl2 || n4 <= 1) continue;
                        while (n4 < 12) {
                            stringBuilder.append(' ');
                            ++n4;
                        }
                        String string3 = stringBuilder.toString();
                        if (hashMap.containsKey(string3)) {
                            hashMap.put(string3, null);
                            continue;
                        }
                        hashMap.put(string3, file);
                        if (hashMap.size() < this.maxDirEntries) continue;
                        bl = true;
                    }
                }
                String[] stringArray = null;
                set = hashMap.keySet();
                if (set != null && (n2 = set.size()) > 0) {
                    stringArray = set.toArray(new String[n2]);
                }
                if (stringArray == null) break block46;
                if (entryNameComparator == null) {
                    entryNameComparator = new EntryNameComparator();
                }
                try {
                    Arrays.sort(stringArray, entryNameComparator);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                int n7 = -1;
                n6 = 0;
                int n8 = this.dirBlocks;
                int n9 = this.getDiskSize() / this.blockSize - n8;
                int n10 = Math.max(32 / n, 1);
                n5 = (this.blockNum16Bit ? 8 : 16) * this.blockSize;
                int n11 = n5 / 128;
                for (n4 = 0; n4 < stringArray.length; ++n4) {
                    long l;
                    String string = stringArray[n4];
                    if (string == null) continue;
                    File file = null;
                    long l2 = -1L;
                    n3 = 0;
                    if (this.dsEnabled && string.equals("0!!!TIME&DAT")) {
                        l2 = this.maxDirEntries * 16;
                        n3 = 1;
                        n7 = n8;
                    } else {
                        file = (File)hashMap.get(string);
                        if (file != null) {
                            l2 = file.length();
                            n3 = file.canWrite();
                        }
                    }
                    if (l2 < 0L) continue;
                    long l3 = (l2 + (long)n5 - 1L) / (long)n5;
                    if (l3 < 1L) {
                        l3 = 1L;
                    }
                    if ((long)n6 + l3 * 32L <= (long)this.dirBytes.length && l3 <= (long)n10 && (l = (l2 + (long)this.blockSize - 1L) / (long)this.blockSize) <= (long)n9) {
                        int n12 = 0;
                        int n13 = 0;
                        while ((long)n13 < l3) {
                            int n14;
                            int n15;
                            int n16;
                            int n17 = n6 + 9;
                            int n18 = string.length();
                            this.dirBytes[n6++] = n18 > 0 ? (byte)(string.charAt(0) - 48) : (byte)0;
                            for (n16 = 1; n16 < 12; ++n16) {
                                n15 = 32;
                                if (n16 < n18) {
                                    n15 = string.charAt(n16);
                                }
                                this.dirBytes[n6++] = (byte)(n15 & 0x7F);
                            }
                            if (n3 == 0) {
                                int n19 = n17;
                                this.dirBytes[n19] = (byte)(this.dirBytes[n19] | 0x80);
                            }
                            n16 = 0;
                            if (l2 > 0L) {
                                n16 = Math.min((int)((l2 + 127L) / 128L), n11);
                            }
                            n15 = n16 % 128;
                            if (n16 > 0 && n15 == 0) {
                                n15 = 128;
                            }
                            int n20 = (n16 + 127) / 128;
                            int n21 = n12;
                            if (n20 > 1 && n20 <= n) {
                                n21 = n12 + n20 - 1;
                            }
                            this.dirBytes[n6++] = (byte)n21;
                            this.dirBytes[n6++] = 0;
                            this.dirBytes[n6++] = 0;
                            if (l2 > 0L && (n16 %= 128) == 0) {
                                n16 = 128;
                            }
                            this.dirBytes[n6++] = (byte)n16;
                            if (this.blockNum16Bit) {
                                for (n14 = 0; n14 < 8; ++n14) {
                                    if (l > 0L) {
                                        this.dirBytes[n6++] = (byte)n8;
                                        this.dirBytes[n6++] = (byte)(n8 >> 8);
                                        ++n8;
                                        --l;
                                        --n9;
                                        l2 -= (long)this.blockSize;
                                        continue;
                                    }
                                    this.dirBytes[n6++] = 0;
                                    this.dirBytes[n6++] = 0;
                                }
                            } else {
                                for (n14 = 0; n14 < 16; ++n14) {
                                    if (l > 0L) {
                                        this.dirBytes[n6++] = (byte)n8++;
                                        --l;
                                        --n9;
                                        l2 -= (long)this.blockSize;
                                        continue;
                                    }
                                    this.dirBytes[n6++] = 0;
                                }
                            }
                            if (dateStamper != null) {
                                dateStamper.addFileTimes(file);
                            }
                            n12 += n;
                            ++n13;
                        }
                    }
                    this.fileMap.put(string, file);
                }
                if (dateStamper != null && n7 >= 0) {
                    this.dsBytes = dateStamper.getDateTimeByteBuffer();
                    n4 = this.getSectorSize();
                    if (this.dsBytes != null && n4 > 0) {
                        int n22;
                        this.dsFirstSector = n22 = this.sysSectors + n7 * this.sectorsPerBlock;
                        this.dsSectors = this.dsBytes.length / n4;
                        for (int i = 0; i < this.dsBytes.length; i += n4) {
                            this.setSectorData(n22++, this.dsBytes, i, n4, false);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((n = this.getSectorSize()) > 0) {
            int n23 = this.sysSectors;
            for (int i = 0; i < this.dirBytes.length; i += n) {
                this.setSectorData(n23++, this.dirBytes, i, n, false);
            }
        }
    }

    private void setSectorData(int n, byte[] byArray, int n2, int n3, boolean bl) {
        if (n >= 0 && n < this.sectors.length) {
            int n4;
            int n5 = this.getSides();
            int n6 = this.getSectorsPerCylinder();
            if (n5 > 0 && n6 > 0 && n3 > 0 && (n4 = n / (n5 * n6)) >= 0 && n4 < this.getCylinders()) {
                int n7 = 0;
                int n8 = n - n4 * n5 * n6;
                if (n8 >= n6) {
                    ++n7;
                    n8 -= n6;
                }
                if (n7 < n5 && n8 >= 0 && n8 < n6) {
                    this.sectors[n] = new SectorData(n8, n4, n7, n8 + 1, this.sectorSizeCode, byArray, n2, n3);
                    this.sectors[n].setError(bl);
                }
            }
        }
    }

    private void writeDirSector(int n, byte[] byArray, int n2) throws IOException {
        int n3;
        if (this.dirBytes != null && (n3 = (n - this.sysSectors) * this.getSectorSize()) >= 0) {
            TreeSet<String> treeSet = null;
            TreeSet<String> treeSet2 = null;
            int n4 = 0;
            int n5 = n3;
            while (n5 + 31 < this.dirBytes.length && n4 + 31 < n2) {
                File file;
                byte by;
                boolean bl = false;
                for (int i = 0; i < 32; ++i) {
                    by = byArray[n4 + i];
                    byte by2 = this.dirBytes[n5 + i];
                    if (i >= 1 && i <= 11) {
                        by = (byte)(by & 0x7F);
                        by2 = (byte)(by2 & 0x7F);
                    }
                    if (by == by2) continue;
                    bl = true;
                    break;
                }
                String string = this.extractEntryName(byArray, n4);
                if (bl) {
                    String string2;
                    if (string != null) {
                        if (treeSet2 == null) {
                            treeSet2 = new TreeSet<String>();
                        }
                        treeSet2.add(string);
                    }
                    if (this.dirBytes[12] == 0 && this.dirBytes[14] == 0 && (string2 = this.extractEntryName(this.dirBytes, n5)) != null) {
                        if (treeSet == null) {
                            treeSet = new TreeSet<String>();
                        }
                        treeSet.add(string2);
                        this.ensureFileLoaded(string2);
                    }
                } else if (byArray[n4 + 12] == 0 && byArray[n4 + 14] == 0 && (by = byArray[n4 + 9]) != this.dirBytes[n5 + 9] && (file = this.fileMap.get(string)) != null) {
                    EmuUtil.setFileWritable(file, (by & 0x80) == 0);
                }
                n5 += 32;
                n4 += 32;
            }
            if (treeSet2 != null) {
                for (String string : treeSet2) {
                    this.ensureFileLoaded(string);
                    if (treeSet == null) continue;
                    treeSet.remove(string);
                }
            }
            System.arraycopy(byArray, 0, this.dirBytes, n3, Math.min(this.dirBytes.length - n3, n2));
            if (treeSet2 != null) {
                for (String string : treeSet2) {
                    this.writeFileByEntryName(string, this.fileMap.get(string));
                }
            }
            if (treeSet != null) {
                for (String string : treeSet) {
                    File file = this.fileMap.get(string);
                    if (file == null || this.findEntryBegPosByNameAndExtent(string, 0) >= 0 || !file.exists()) continue;
                    this.ensureFileLoaded(string);
                    if (file.delete()) continue;
                    throw new IOException(file.getPath() + ":\nDatei konnte nicht gel\u00f6scht werden");
                }
            }
        }
    }

    private void writeDsSector(int n, byte[] byArray, int n2) throws IOException {
        byte[] byArray2 = this.dsBytes;
        int n3 = this.dsFirstSector;
        if (this.dsEnabled && byArray2 != null && this.dsFirstSector >= 0) {
            int n4 = this.getSectorSize();
            int n5 = (n - this.dsFirstSector) * n4;
            if (n4 > 0 && n5 >= 0) {
                int n6 = 0;
                int n7 = n5 / 16 * 32;
                while (n6 + 15 < n2 && n5 + 15 < byArray2.length) {
                    if (n7 + 31 < this.dirBytes.length && (this.dirBytes[n7 + 12] & 0x1F) == 0 && (this.dirBytes[n7 + 14] & 0x3F) == 0) {
                        FileTimesView fileTimesView;
                        File file;
                        String string;
                        int n8;
                        Long l = null;
                        Long l2 = null;
                        Long l3 = null;
                        for (n8 = 0; n8 < 5; ++n8) {
                            if (byArray[n6 + n8] == byArray2[n5 + n8]) continue;
                            l = DateStamper.getMillis(byArray, n6);
                            break;
                        }
                        for (n8 = 5; n8 < 10; ++n8) {
                            if (byArray[n6 + n8] == byArray2[n5 + n8]) continue;
                            l2 = DateStamper.getMillis(byArray, n6 + 5);
                            break;
                        }
                        for (n8 = 10; n8 < 15; ++n8) {
                            if (byArray[n6 + n8] == byArray2[n5 + n8]) continue;
                            l3 = DateStamper.getMillis(byArray, n6 + 10);
                            break;
                        }
                        if ((l != null || l2 != null || l3 != null) && (string = this.extractEntryName(this.dirBytes, n7)) != null && (file = this.fileMap.get(string)) != null && (fileTimesView = this.ftvFactory.getFileTimesView(file)) != null) {
                            if (DirectoryFloppyDisk.isInSameMinute(l, fileTimesView.getCreationMillis())) {
                                l = null;
                            }
                            if (DirectoryFloppyDisk.isInSameMinute(l2, fileTimesView.getLastAccessMillis())) {
                                l2 = null;
                            }
                            if (DirectoryFloppyDisk.isInSameMinute(l3, fileTimesView.getLastModifiedMillis())) {
                                l3 = null;
                            }
                            if (l != null || l2 != null || l3 != null) {
                                fileTimesView.setTimesInMillis(l, l2, l3);
                            }
                        }
                    }
                    System.arraycopy(byArray, n6, this.dsBytes, n5, 16);
                    n6 += 16;
                    n5 += 16;
                    n7 += 32;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileByEntryName(String string, File file) throws IOException {
        int n;
        if (string != null && this.dirBytes != null && this.sectors != null && (n = string.length()) == 12) {
            Object object;
            Object object2;
            if (file == null) {
                int n2;
                for (int i = 1; i < n; ++i) {
                    if (string.charAt(i) >= ' ') continue;
                    throw new IOException("Anlegen der Datei nicht m\u00f6glich, da der Dateiname nicht konforme Zeichen enthalten w\u00fcrde.\n\nM\u00f6glicherweise stimmt aber auch die beim Diskettenformat eingestellte Directory-Gr\u00f6\u00dfe (Anzahl der Bl\u00f6cke)\nnicht mit der \u00fcberein, mit der das im Emulator laufende Programm bzw. Betriebssystem arbeitet.");
                }
                object2 = null;
                object = string.substring(1).trim();
                object2 = ((String)object).isEmpty() ? "@noname" : (((String)object).equals(".") ? "@dot" : (((String)object).equals("..") ? "@dotdot" : String.format("%s.%s", string.substring(1, 9).trim(), string.substring(9).trim())));
                if (this.forceLowerCase) {
                    object2 = ((String)object2).toLowerCase();
                }
                if ((n2 = string.charAt(0) - 48) == 0 && ((String)object2).equals(SYS_FILE_NAME)) {
                    throw new IOException("Eine Datei mit dem Namen @boot.sys kann vom emulierten System aus nicht angelegt  werden,\nda JKCEMU diese Datei f\u00fcr die Systemspuren verwendet.");
                }
                File file2 = this.dirFile;
                if (n2 > 0) {
                    file2 = new File(file2, Integer.toString(n2));
                    file2.mkdir();
                }
                file = new File(file2, (String)object2);
                this.fileMap.put(string, file);
            }
            if (this.errorMap != null && (object2 = file.getPath()) != null && (object = this.errorMap.get(object2)) != null) {
                throw new IOException(((Throwable)object).getMessage());
            }
            object2 = null;
            try {
                object2 = new RandomAccessFile(file, "rw");
                object = new AtomicInteger(-1);
                List<Integer> list = this.getBlockNumsByEntryName(string, (AtomicInteger)object);
                if (list != null) {
                    int n3 = this.getSectorSize();
                    int n4 = 0;
                    for (Integer n5 : list) {
                        int n6 = this.sysSectors + n5 * this.sectorsPerBlock;
                        for (int i = 0; i < this.sectorsPerBlock; ++i) {
                            if (n6 >= 0 && n6 < this.sectors.length && this.sectors[n6] != null) {
                                ((RandomAccessFile)object2).seek(n4);
                                this.sectors[n6].writeTo((RandomAccessFile)object2, n3);
                            }
                            n4 += n3;
                            ++n6;
                        }
                    }
                }
                if (((AtomicInteger)object).get() >= 0) {
                    ((RandomAccessFile)object2).setLength(((AtomicInteger)object).get());
                }
                ((RandomAccessFile)object2).close();
                object2 = null;
            }
            finally {
                EmuUtil.closeSilent((Closeable)object2);
            }
        }
    }

    private static class EntryNameComparator
    implements Comparator<String> {
        private EntryNameComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            int n = 0;
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            boolean bl = string.startsWith("0@");
            boolean bl2 = string2.startsWith("0@");
            n = bl && !bl2 ? -1 : (!bl && bl2 ? 1 : string.compareTo(string2));
            return n;
        }

        @Override
        public boolean equals(Object object) {
            return object == this;
        }
    }
}

