/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import jkcemu.base.EmuUtil;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.SectorData;
import jkcemu.disk.SectorID;
import jkcemu.text.CharConverter;

public class CopyQMDisk
extends AbstractFloppyDisk {
    private static final long[] crcTable = new long[]{0L, 1996959894L, 3993919788L, 2567524794L, 124634137L, 1886057615L, 3915621685L, 2657392035L, 249268274L, 2044508324L, 3772115230L, 2547177864L, 162941995L, 2125561021L, 3887607047L, 2428444049L, 498536548L, 1789927666L, 4089016648L, 2227061214L, 450548861L, 1843258603L, 4107580753L, 2211677639L, 325883990L, 1684777152L, 4251122042L, 2321926636L, 335633487L, 1661365465L, 4195302755L, 2366115317L, 997073096L, 1281953886L, 3579855332L, 2724688242L, 1006888145L, 1258607687L, 3524101629L, 2768942443L, 901097722L, 1119000684L, 3686517206L, 2898065728L, 853044451L, 1172266101L, 3705015759L, 2882616665L, 651767980L, 1373503546L, 3369554304L, 3218104598L, 565507253L, 1454621731L, 3485111705L, 3099436303L, 671266974L, 1594198024L, 3322730930L, 2970347812L, 795835527L, 1483230225L, 3244367275L, 3060149565L, 1994146192L, 31158534L, 2563907772L, 4023717930L, 1907459465L, 112637215L, 2680153253L, 3904427059L, 2013776290L, 251722036L, 2517215374L, 3775830040L, 2137656763L, 141376813L, 2439277719L, 3865271297L, 1802195444L, 476864866L, 2238001368L, 4066508878L, 1812370925L, 453092731L, 2181625025L, 4111451223L, 1706088902L, 314042704L, 2344532202L, 4240017532L, 1658658271L, 366619977L, 2362670323L, 4224994405L, 1303535960L, 984961486L, 2747007092L, 3569037538L, 1256170817L, 1037604311L, 2765210733L, 3554079995L, 1131014506L, 879679996L, 2909243462L, 3663771856L, 1141124467L, 855842277L, 2852801631L, 3708648649L, 1342533948L, 654459306L, 3188396048L, 3373015174L, 1466479909L, 544179635L, 3110523913L, 3462522015L, 1591671054L, 702138776L, 2966460450L, 3352799412L, 1504918807L, 783551873L, 3082640443L, 3233442989L, 3988292384L, 2596254646L, 62317068L, 1957810842L, 3939845945L, 2647816111L, 81470997L, 1943803523L, 3814918930L, 2489596804L, 225274430L, 2053790376L, 3826175755L, 2466906013L, 167816743L, 2097651377L, 4027552580L, 2265490386L, 503444072L, 1762050814L, 4150417245L, 2154129355L, 426522225L, 1852507879L, 4275313526L, 2312317920L, 282753626L, 1742555852L, 4189708143L, 2394877945L, 397917763L, 1622183637L, 3604390888L, 2714866558L, 953729732L, 1340076626L, 3518719985L, 2797360999L, 1068828381L, 1219638859L, 3624741850L, 2936675148L, 906185462L, 1090812512L, 3747672003L, 2825379669L, 829329135L, 1181335161L, 3412177804L, 3160834842L, 628085408L, 1382605366L, 3423369109L, 3138078467L, 570562233L, 1426400815L, 3317316542L, 2998733608L, 733239954L, 1555261956L, 3268935591L, 3050360625L, 752459403L, 1541320221L, 2607071920L, 3965973030L, 1969922972L, 40735498L, 2617837225L, 3943577151L, 1913087877L, 83908371L, 2512341634L, 3803740692L, 2075208622L, 213261112L, 2463272603L, 3855990285L, 2094854071L, 198958881L, 2262029012L, 4057260610L, 1759359992L, 534414190L, 2176718541L, 4139329115L, 1873836001L, 414664567L, 2282248934L, 4279200368L, 1711684554L, 285281116L, 2405801727L, 4167216745L, 1634467795L, 376229701L, 2685067896L, 3608007406L, 1308918612L, 956543938L, 2808555105L, 3495958263L, 1231636301L, 1047427035L, 2932959818L, 3654703836L, 1088359270L, 936918000L, 2847714899L, 3736837829L, 1202900863L, 817233897L, 3183342108L, 3401237130L, 1404277552L, 615818150L, 3134207493L, 3453421203L, 1423857449L, 601450431L, 3009837614L, 3294710456L, 1567103746L, 711928724L, 3020668471L, 3272380065L, 1510334235L, 755167117L};
    private String fileName;
    private String remark;
    private Date diskDate;
    private byte[] diskBytes;
    private int sectorSizeCode;
    private int sectorOffset;
    private int skew;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String export(AbstractFloppyDisk abstractFloppyDisk, File file, String string) throws IOException {
        OutputStream outputStream;
        StringBuilder stringBuilder;
        block49: {
            stringBuilder = null;
            outputStream = null;
            try {
                byte by;
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                Object object;
                int n6;
                int n7;
                int n8;
                int n9;
                SectorData sectorData;
                int n10;
                boolean bl = false;
                int n11 = abstractFloppyDisk.getDiskSize();
                int n12 = abstractFloppyDisk.getSides();
                int n13 = abstractFloppyDisk.getCylinders();
                int n14 = abstractFloppyDisk.getSectorsPerCylinder();
                int n15 = abstractFloppyDisk.getSectorSize();
                int n16 = n12 * n13 * n14;
                int n17 = abstractFloppyDisk.getSectorOffset();
                int n18 = 1;
                int n19 = -1;
                if (n13 > 0 && (n10 = abstractFloppyDisk.getSectorsOfCylinder(0, 0)) > 2 && (sectorData = abstractFloppyDisk.getSectorByIndex(0, 0, 0)) != null) {
                    n9 = sectorData.getSectorNum() + 1;
                    for (n8 = 1; n8 < n10; ++n8) {
                        sectorData = abstractFloppyDisk.getSectorByIndex(0, 0, n8);
                        if (sectorData == null || sectorData.getSectorNum() != n9) continue;
                        n18 = n8;
                        break;
                    }
                }
                n10 = 0;
                if (n13 > 1 && n19 > 0 && (n7 = abstractFloppyDisk.getSectorsOfCylinder(1, 0)) > 1) {
                    SectorData sectorData2;
                    for (n9 = 0; n9 < n7 && (sectorData2 = abstractFloppyDisk.getSectorByIndex(1, 0, n9)) != null; ++n9) {
                        if (sectorData2.getSectorNum() != n19) continue;
                        n10 = n9;
                    }
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n11);
                for (n9 = 0; n9 < n13; ++n9) {
                    for (n8 = 0; n8 < n12; ++n8) {
                        int n20 = abstractFloppyDisk.getSectorsOfCylinder(n9, n8);
                        if (n20 != n14) {
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder(1024);
                            }
                            stringBuilder.append(String.format("Seite %d, Spur %d: %d anstelle von %d Sektoren vorhanden", n8 + 1, n9, n20, n14));
                        }
                        for (n6 = 0; n6 < n14; ++n6) {
                            object = abstractFloppyDisk.getSectorByID(n9, n8, n9, n8, n6 + 1 + n17, -1);
                            if (object == null) {
                                throw new IOException(String.format("Seite %d, Spur %d: Sektor %d nicht gefunden\n\nDas CopyQM-Format unterst\u00fctzt keine freie Sektoranordnung.", n8 + 1, n9, n6 + 1));
                            }
                            if (((SectorData)object).checkError() || ((SectorData)object).hasBogusID() || ((SectorData)object).isDeleted()) {
                                if (stringBuilder == null) {
                                    stringBuilder = new StringBuilder(1024);
                                }
                                stringBuilder.append(String.format("Seite %d, Spur %d, Sektor %d:", n8 + 1, n9, ((SectorID)object).getSectorNum()));
                                n5 = 0;
                                if (((SectorData)object).hasBogusID()) {
                                    stringBuilder.append(" Sektor-ID generiert");
                                    n5 = 1;
                                }
                                if (((SectorData)object).checkError()) {
                                    if (n5 != 0) {
                                        stringBuilder.append(',');
                                    }
                                    stringBuilder.append(" CRC-Fehler");
                                    n5 = 1;
                                }
                                if (((SectorData)object).isDeleted()) {
                                    if (n5 != 0) {
                                        stringBuilder.append(',');
                                    }
                                    stringBuilder.append(" als gel\u00f6scht markiert");
                                    n5 = 1;
                                    bl = true;
                                }
                                stringBuilder.append('\n');
                            }
                            if (((SectorData)object).getDataLength() > n15) {
                                throw new IOException(String.format("Seite %d, Spur %d: Sektor %d ist zu gro\u00df.\n\nDas CopyQM-Format unterst\u00fctzt keine \u00fcbergro\u00dfen Sektoren.", n8 + 1, n9, ((SectorID)object).getSectorNum()));
                            }
                            for (n5 = ((SectorData)object).writeTo(byteArrayOutputStream, n15); n5 < n15; ++n5) {
                                byteArrayOutputStream.write(0);
                            }
                        }
                    }
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                n8 = 0;
                ByteArrayOutputStream byteArrayOutputStream2 = null;
                if (string == null) {
                    string = abstractFloppyDisk.getRemark();
                }
                if (string != null && (n6 = string.length()) > 0) {
                    object = new CharConverter(CharConverter.Encoding.CP850);
                    byteArrayOutputStream2 = new ByteArrayOutputStream(n6);
                    for (n5 = 0; n5 < n6 && (n4 = string.charAt(n5)) != 0 && n4 != 26; ++n5) {
                        if ((n4 = (char)((CharConverter)object).toCharsetByte((char)n4)) <= 0 || byteArrayOutputStream2.size() >= 32766) continue;
                        byteArrayOutputStream2.write(n4);
                    }
                    n8 = byteArrayOutputStream2.size();
                }
                ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream(256);
                EmuUtil.writeASCII(byteArrayOutputStream3, "CQ");
                byteArrayOutputStream3.write(20);
                byteArrayOutputStream3.write(n15);
                byteArrayOutputStream3.write(n15 >> 8);
                for (n3 = 0; n3 < 6; ++n3) {
                    byteArrayOutputStream3.write(0);
                }
                byteArrayOutputStream3.write(n13 + n12 * n14);
                for (n3 = 0; n3 < 4; ++n3) {
                    byteArrayOutputStream3.write(0);
                }
                byteArrayOutputStream3.write(n14);
                byteArrayOutputStream3.write(n14 >> 8);
                byteArrayOutputStream3.write(n12);
                byteArrayOutputStream3.write(n12 >> 8);
                for (n3 = 0; n3 < 8; ++n3) {
                    byteArrayOutputStream3.write(0);
                }
                EmuUtil.writeASCII(byteArrayOutputStream3, String.valueOf(n11 / 1024));
                byteArrayOutputStream3.write(75);
                if (n12 == 1) {
                    EmuUtil.writeASCII(byteArrayOutputStream3, " Single-Sided");
                } else if (n12 == 2) {
                    EmuUtil.writeASCII(byteArrayOutputStream3, " Double-Sided");
                }
                for (n3 = byteArrayOutputStream3.size(); n3 < 88; ++n3) {
                    byteArrayOutputStream3.write(0);
                }
                byteArrayOutputStream3.write(1);
                byteArrayOutputStream3.write(n11 / 1024 / 1024);
                byteArrayOutputStream3.write(n13);
                byteArrayOutputStream3.write(n13);
                long l = CopyQMDisk.computeCRC(byArray, byArray.length);
                for (n4 = 0; n4 < 4; ++n4) {
                    byteArrayOutputStream3.write((int)l);
                    l >>= 8;
                }
                EmuUtil.writeASCII(byteArrayOutputStream3, "** NONE **");
                byteArrayOutputStream3.write(0);
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                Date date = abstractFloppyDisk.getDiskDate();
                if (date != null) {
                    gregorianCalendar.clear();
                    gregorianCalendar.setTime(date);
                }
                int n21 = gregorianCalendar.get(11) << 11 & 0xF800 | gregorianCalendar.get(12) << 5 & 0x7E0 | gregorianCalendar.get(13) / 2 & 0x1F;
                int n22 = gregorianCalendar.get(1) - 1980 << 9 & 0xFE00 | gregorianCalendar.get(2) + 1 << 5 & 0x1E0 | gregorianCalendar.get(5) & 0x1F;
                byteArrayOutputStream3.write(n21);
                byteArrayOutputStream3.write(n21 >> 8);
                byteArrayOutputStream3.write(n22);
                byteArrayOutputStream3.write(n22 >> 8);
                byteArrayOutputStream3.write(n8);
                byteArrayOutputStream3.write(n8 >> 8);
                byteArrayOutputStream3.write(n17);
                byteArrayOutputStream3.write(0);
                byteArrayOutputStream3.write(0);
                byteArrayOutputStream3.write(n18);
                byteArrayOutputStream3.write(n10);
                int n23 = 1;
                if (abstractFloppyDisk.getDiskSize() >= 368640) {
                    n23 = 2;
                }
                if (abstractFloppyDisk.getCylinders() >= 50 && abstractFloppyDisk.getSectorSize() == 512) {
                    n2 = abstractFloppyDisk.getSectorsPerCylinder();
                    if (n2 >= 8 && n2 <= 10) {
                        n23 = 3;
                    } else if (n2 >= 17) {
                        n23 = 4;
                    }
                }
                byteArrayOutputStream3.write(n23);
                for (n2 = 0; n2 < 13; ++n2) {
                    byteArrayOutputStream3.write(0);
                }
                byte[] byArray2 = byteArrayOutputStream3.toByteArray();
                int n24 = 0;
                byte[] byArray3 = byArray2;
                int n25 = byArray3.length;
                for (n = 0; n < n25; ++n) {
                    by = byArray3[n];
                    n24 += by & 0xFF;
                }
                outputStream = EmuUtil.createOptionalGZipOutputStream(file);
                if (byArray2 != null) {
                    outputStream.write(byArray2);
                    outputStream.write(-n24);
                    if (byteArrayOutputStream2 != null && n8 > 0) {
                        byteArrayOutputStream2.writeTo(outputStream);
                    }
                    if (byArray != null) {
                        int n26;
                        int n27 = n15 * n14;
                        if (n27 >= 32768) {
                            n27 = n15;
                        }
                        if (n27 >= 32768) {
                            n27 = Short.MAX_VALUE;
                        }
                        for (n25 = 0; n25 < byArray.length; n25 += n26) {
                            n = n25;
                            by = byArray[n++];
                            for (n26 = 1; n26 < n27 && n < byArray.length && byArray[n] == by; ++n26, ++n) {
                            }
                            int n28 = n26 / n15;
                            if (n28 > 0) {
                                n26 = n28 * n15;
                                int n29 = -n26;
                                outputStream.write(n29);
                                outputStream.write(n29 >> 8);
                                outputStream.write(by);
                                continue;
                            }
                            n26 = Math.min(n15, byArray.length - n25);
                            outputStream.write(n26);
                            outputStream.write(n26 >> 8);
                            outputStream.write(byArray, n25, n26);
                        }
                    }
                }
                outputStream.close();
                outputStream = null;
                if (stringBuilder == null) break block49;
                stringBuilder.append("\nDie angezeigten Informationen k\u00f6nnen in einer CopyQM-Datei nicht gespeichert werden\nund sind deshalb in der erzeugten Datei nicht mehr enthalten.\n");
                if (bl) {
                    stringBuilder.append("\nGel\u00f6schte Sektoren werden in CopyQM-Dateien nicht unterst\u00fctzt\nund sind deshalb als normale Sektoren enthalten.\n");
                }
            }
            catch (Throwable throwable) {
                EmuUtil.closeSilent(outputStream);
                throw throwable;
            }
        }
        EmuUtil.closeSilent(outputStream);
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    public static boolean isCopyQMFileHeader(byte[] byArray) {
        boolean bl = false;
        if (byArray != null && byArray.length >= 3 && byArray[0] == 67 && byArray[1] == 81 && byArray[2] == 20) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CopyQMDisk readFile(Frame frame, File file) throws IOException {
        CopyQMDisk copyQMDisk = null;
        InputStream inputStream = null;
        Object var4_4 = null;
        try {
            int n;
            int n2;
            Object object;
            int n3;
            int n4;
            int n5;
            int n6;
            byte[] byArray;
            inputStream = new FileInputStream(file);
            if (EmuUtil.isGZipFile(file)) {
                inputStream = new GZIPInputStream(inputStream);
            }
            if (EmuUtil.read(inputStream, byArray = new byte[133]) != byArray.length) {
                CopyQMDisk.throwNoCopyQMFile();
            }
            if (byArray[0] != 67 || byArray[1] != 81 || byArray[2] != 20) {
                CopyQMDisk.throwNoCopyQMFile();
            }
            int n7 = EmuUtil.getWord(byArray, 3);
            int n8 = SectorData.getSizeCode(n7);
            if (n7 < 1 || n8 < 0) {
                CopyQMDisk.throwUnsupportedCopyQMFmt(String.format("%d Byte Sektorgr\u00f6\u00dfe nicht unterst\u00fctzt", n7));
            }
            if ((n6 = EmuUtil.getWord(byArray, 16)) < 1) {
                CopyQMDisk.throwUnsupportedCopyQMFmt(String.format("Sektoren pro Spur", n6));
            }
            if ((n5 = byArray[18] & 0xFF) < 1 || n5 > 2) {
                CopyQMDisk.throwUnsupportedCopyQMFmt(String.format("%d Seiten nicht unterst\u00fctzt", n5));
            }
            if ((n4 = byArray[91] & 0xFF) < (n3 = byArray[90] & 0xFF)) {
                n4 = n3;
            }
            if (n4 < 1) {
                CopyQMDisk.throwUnsupportedCopyQMFmt(String.format("%d Spuren nicht unterst\u00fctzt", n5));
            }
            int n9 = byArray[113] & 0xFF;
            Date date = null;
            int n10 = EmuUtil.getWord(byArray, 107);
            int n11 = EmuUtil.getWord(byArray, 109);
            int n12 = 1980 + (n11 >> 9 & 0x7F);
            int n13 = n11 >> 5 & 0xF;
            int n14 = n11 & 0x1F;
            int n15 = n10 >> 11 & 0x1F;
            int n16 = n10 >> 5 & 0x3F;
            int n17 = (n10 & 0x1F) * 2;
            if (n13 >= 1 && n13 <= 12 && n14 >= 1 && n14 <= 31 && n15 < 24 && n16 < 60 && n17 < 60) {
                date = new GregorianCalendar(n12, n13 - 1, n14, n15, n16, n17).getTime();
            }
            String string = null;
            int n18 = EmuUtil.getWord(byArray, 111);
            if (n18 < 0) {
                CopyQMDisk.throwUnsupportedCopyQMFmt(String.format("Mysteri\u00f6se Kommentarl\u00e4nge: %d", n18));
            }
            if (n18 > 0) {
                CharConverter charConverter = new CharConverter(CharConverter.Encoding.CP850);
                object = new StringBuilder(n18);
                while (n18 > 0 && (n2 = inputStream.read()) >= 0) {
                    if ((n2 = (int)charConverter.toUnicode((char)n2)) > 0) {
                        ((StringBuilder)object).append((char)n2);
                    }
                    --n18;
                }
                string = ((StringBuilder)object).toString().trim();
            }
            int n19 = n5 * n4 * n6 * n7;
            object = new byte[n19];
            Arrays.fill((byte[])object, (byte)0);
            n2 = 0;
            while (n2 < n19) {
                int n20;
                int n21 = inputStream.read();
                int n22 = inputStream.read();
                if (n21 < 0 || n22 < 0) break;
                int n23 = n22 << 8 | n21;
                if ((n23 & 0x8000) != 0) {
                    n = inputStream.read();
                    if (n < 0) break;
                    for (n20 = -((int)n23); n2 < n19 && n20 > 0; --n20) {
                        object[n2++] = (byte)n;
                    }
                    continue;
                }
                while (n23 > 0 && n2 < n19 && (n20 = inputStream.read()) >= 0) {
                    object[n2++] = (byte)n20;
                    --n23;
                }
            }
            copyQMDisk = new CopyQMDisk(frame, n5, n4, n6, n7, file.getPath(), string, date, (byte[])object, n8, n9, byArray[116] & 0xFF, byArray[117] & 0xFF);
            long l = 0L;
            long l2 = 0L;
            for (n = 95; n >= 92; --n) {
                l = l << 8 | (long)(byArray[n] & 0xFF);
            }
            if (l != 0L) {
                l2 = CopyQMDisk.computeCRC((byte[])object, n2);
            }
            if (l != l2) {
                copyQMDisk.setWarningText("Die CopyQM-Datei scheint defekt zu sein (CRC-Fehler)!");
            }
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(inputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(inputStream);
        return copyQMDisk;
    }

    @Override
    public Date getDiskDate() {
        return this.diskDate;
    }

    @Override
    public String getFileFormatText() {
        return "CopyQM-Datei";
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    @Override
    public SectorData getSectorByIndex(int n, int n2, int n3) {
        int n4;
        n3 = this.sectorIndexToInterleave(n3);
        if (this.skew > 0 && (n4 = this.getSectorsPerCylinder()) > 0 && this.skew < n4) {
            if ((n3 += n4 - this.skew * (n % n4)) < 0) {
                if ((n3 += -n3 / n4 * n4) < 0) {
                    n3 += n4;
                }
            } else if (n3 >= n4) {
                n3 -= n3 / n4 * n4;
            }
        }
        return this.getSectorByIndexInternal(n, n2, n3);
    }

    @Override
    public SectorData getSectorByID(int n, int n2, int n3, int n4, int n5, int n6) {
        SectorData sectorData = this.getSectorByIndexInternal(n, n2, n5 - 1 - this.sectorOffset);
        if (sectorData != null && (sectorData.getCylinder() != n3 || sectorData.getHead() != n4 || sectorData.getSectorNum() != n5 || n6 >= 0 && sectorData.getSizeCode() != n6)) {
            sectorData = null;
        }
        return sectorData;
    }

    @Override
    public int getSectorOffset() {
        return this.sectorOffset;
    }

    @Override
    public void putSettingsTo(Properties properties, String string) {
        if (properties != null && this.fileName != null) {
            properties.setProperty(string + "file", this.fileName);
            properties.setProperty(string + "readonly", EmuUtil.VALUE_TRUE);
        }
    }

    private CopyQMDisk(Frame frame, int n, int n2, int n3, int n4, String string, String string2, Date date, byte[] byArray, int n5, int n6, int n7, int n8) {
        super(frame, n, n2, n3, n4, n7);
        this.fileName = string;
        this.remark = string2;
        this.diskDate = date;
        this.diskBytes = byArray;
        this.sectorSizeCode = n5;
        this.sectorOffset = n6;
        this.skew = n8;
    }

    private static long computeCRC(byte[] byArray, int n) {
        long l = 0L;
        if (byArray != null) {
            for (int i = 0; i < n; ++i) {
                int n2 = byArray[i] & 0x7F;
                l = crcTable[(int)((long)n2 ^ l) & 0x3F] ^ l >> 8;
            }
        }
        return l;
    }

    private SectorData getSectorByIndexInternal(int n, int n2, int n3) {
        SectorData sectorData = null;
        if (n >= 0 && n2 >= 0 && n3 >= 0) {
            int n4 = this.getSides();
            int n5 = this.getCylinders();
            int n6 = this.getSectorsPerCylinder();
            int n7 = this.getSectorSize();
            if (n2 < n4 && n < n5 && n3 < n6 && n7 > 0) {
                int n8 = n4 * n6 * n;
                if (n2 > 0) {
                    n8 += n6;
                }
                sectorData = new SectorData(n3, n, n2, n3 + 1 + this.sectorOffset, this.sectorSizeCode, this.diskBytes, (n8 += n3) * n7, n7);
            }
        }
        return sectorData;
    }

    private static void throwUnsupportedCopyQMFmt(String string) throws IOException {
        throw new IOException("Die Datei enth\u00e4lt ein nicht unterst\u00fctztes CopyQM-Format:\n" + string);
    }

    private static void throwNoCopyQMFile() throws IOException {
        throw new IOException("Datei ist keine CopyQM-Datei.");
    }
}

