/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyListener;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import jkcemu.Main;
import jkcemu.base.AbstractScreenDevice;
import jkcemu.base.AbstractScreenFrm;
import jkcemu.base.EmuUtil;
import jkcemu.base.ScreenFld;
import jkcemu.base.ScreenFrm;

public class SecondaryScreenFrm
extends AbstractScreenFrm {
    private static final String PROP_SCALE = "scale";
    private static Point oldLocation = null;
    private JMenuItem mnuClose;
    private ScreenFrm screenFrm;

    public SecondaryScreenFrm(ScreenFrm screenFrm, AbstractScreenDevice abstractScreenDevice) {
        this.screenFrm = screenFrm;
        this.copyEnabled = abstractScreenDevice.supportsCopyToClipboard();
        this.pasteEnabled = abstractScreenDevice.supportsPasteFromClipboard();
        this.setTitle(abstractScreenDevice.getTitle());
        Main.updIcon(this);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        JMenu jMenu2 = this.createScreenMenu(this.copyEnabled);
        if (jMenu2 != null) {
            jMenu.add(jMenu2);
            jMenu.addSeparator();
        }
        this.mnuClose = new JMenuItem("Schlie\u00dfen");
        this.mnuClose.addActionListener(this);
        jMenu.add(this.mnuClose);
        JMenu jMenu3 = this.createEditMenu(this.copyEnabled, this.pasteEnabled);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        if (jMenu3 != null) {
            jMenuBar.add(jMenu3);
        }
        jMenuBar.add(this.createScaleMenu());
        this.setJMenuBar(jMenuBar);
        this.setLayout(new BorderLayout());
        this.screenFld = new ScreenFld(this);
        this.screenFld.setFocusable(true);
        this.screenFld.setFocusTraversalKeysEnabled(false);
        this.screenFld.addMouseListener(this);
        this.add((Component)this.screenFld, "Center");
        this.setScreenDevice(abstractScreenDevice);
        this.setResizable(true);
        if (!this.applySettings(Main.getProperties(), true)) {
            if (oldLocation != null) {
                this.setLocation(oldLocation);
            } else {
                this.setLocationByPlatform(true);
            }
            this.pack();
        }
    }

    public boolean accepts(AbstractScreenDevice abstractScreenDevice) {
        boolean bl = false;
        if (abstractScreenDevice != null) {
            AbstractScreenDevice abstractScreenDevice2 = this.screenFld.getScreenDevice();
            if (abstractScreenDevice.getClass().equals(abstractScreenDevice2.getClass()) && abstractScreenDevice.getScreenHeight() == abstractScreenDevice2.getScreenHeight() && abstractScreenDevice.getScreenWidth() == abstractScreenDevice2.getScreenWidth()) {
                this.setScreenDevice(abstractScreenDevice);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean applySettings(Properties properties, boolean bl) {
        int n;
        boolean bl2 = super.applySettings(properties, bl);
        boolean bl3 = false;
        if (!this.isVisible()) {
            n = EmuUtil.getIntProperty(properties, this.getSettingsPrefix() + PROP_SCALE, 1);
            if (n < 1) {
                n = 1;
            }
            this.setScreenScale(n);
            this.screenFld.setScreenScale(n);
            bl3 = true;
        }
        if ((n = EmuUtil.getIntProperty(properties, "jkcemu.screen.margin", 20)) >= 0 && n != this.screenFld.getMargin()) {
            this.screenFld.setMargin(n);
            bl3 = true;
        }
        if (bl3) {
            this.pack();
        }
        return bl2;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null && object == this.mnuClose) {
            bl = true;
            this.doClose();
        }
        if (!bl) {
            bl = super.doAction(eventObject);
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        Point point = this.getLocation();
        boolean bl = super.doClose();
        if (bl) {
            AbstractScreenDevice abstractScreenDevice = this.screenFld.getScreenDevice();
            if (abstractScreenDevice instanceof KeyListener) {
                this.screenFld.removeKeyListener((KeyListener)((Object)abstractScreenDevice));
            }
            this.screenFrm.childFrameClosed(this);
            oldLocation = point;
        }
        return bl;
    }

    @Override
    protected AbstractScreenDevice getScreenDevice() {
        return this.screenFld.getScreenDevice();
    }

    @Override
    public void putSettingsTo(Properties properties) {
        if (properties != null) {
            super.putSettingsTo(properties);
            properties.setProperty(this.getSettingsPrefix() + PROP_SCALE, String.valueOf(this.screenFld.getScreenScale()));
        }
    }

    private void setScreenDevice(AbstractScreenDevice abstractScreenDevice) {
        AbstractScreenDevice abstractScreenDevice2 = this.screenFld.getScreenDevice();
        if (abstractScreenDevice2 != null && abstractScreenDevice2 instanceof KeyListener) {
            this.screenFld.removeKeyListener((KeyListener)((Object)abstractScreenDevice2));
        }
        this.screenFld.setScreenDevice(abstractScreenDevice);
        if (abstractScreenDevice instanceof KeyListener) {
            this.screenFld.addKeyListener((KeyListener)((Object)abstractScreenDevice));
        }
        abstractScreenDevice.setScreenFrm(this);
    }
}

