/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import jkcemu.Main;
import jkcemu.audio.AudioFrm;
import jkcemu.audio.AudioRecorderFrm;
import jkcemu.base.AboutDlg;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.AbstractScreenDevice;
import jkcemu.base.AbstractScreenFrm;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileSelectDlg;
import jkcemu.base.HelpFrm;
import jkcemu.base.KeyboardFrm;
import jkcemu.base.LoadDlg;
import jkcemu.base.MsgFrm;
import jkcemu.base.ProfileDlg;
import jkcemu.base.RAMFloppyFrm;
import jkcemu.base.SaveDlg;
import jkcemu.base.ScreenFld;
import jkcemu.base.SecondaryScreenFrm;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserCancelException;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.DiskImgCreateFrm;
import jkcemu.disk.DiskImgProcessDlg;
import jkcemu.disk.DiskImgViewFrm;
import jkcemu.disk.DiskUtil;
import jkcemu.disk.DriveSelectDlg;
import jkcemu.disk.FloppyDiskStationFrm;
import jkcemu.etc.ChessboardFrm;
import jkcemu.etc.Plotter;
import jkcemu.etc.PlotterFrm;
import jkcemu.etc.USBInterfaceFrm;
import jkcemu.filebrowser.FileBrowserFrm;
import jkcemu.filebrowser.FindFilesFrm;
import jkcemu.image.ImageCaptureFrm;
import jkcemu.image.ImageFrm;
import jkcemu.image.VideoCaptureFrm;
import jkcemu.joystick.JoystickFrm;
import jkcemu.print.PrintListFrm;
import jkcemu.text.TextEditFrm;
import jkcemu.text.TextUtil;
import jkcemu.tools.ReassFrm;
import jkcemu.tools.calculator.CalculatorFrm;
import jkcemu.tools.debugger.DebugFrm;
import jkcemu.tools.fileconverter.FileConvertFrm;
import jkcemu.tools.hexdiff.HexDiffFrm;
import jkcemu.tools.hexedit.HexEditFrm;
import jkcemu.tools.hexedit.MemEditFrm;
import z80emu.Z80Breakpoint;
import z80emu.Z80CPU;
import z80emu.Z80InterruptSource;
import z80emu.Z80Memory;
import z80emu.Z80StatusListener;

public class ScreenFrm
extends AbstractScreenFrm
implements DropTargetListener,
Z80StatusListener {
    public static final String PROP_CONFIRM_NMI = "confirm.nmi";
    public static final String PROP_CONFIRM_RESET = "confirm.reset";
    public static final String PROP_CONFIRM_QUIT = "confirm.quit";
    public static final String PROP_CONFIRM_POWER_ON = "confirm.power_on";
    public static final String PROP_SCREEN_REFRESH_MS = "screen.refresh.ms";
    public static final boolean DEFAULT_CONFIRM_NMI = true;
    public static final boolean DEFAULT_CONFIRM_RESET = false;
    public static final boolean DEFAULT_CONFIRM_POWER_ON = false;
    public static final boolean DEFAULT_CONFIRM_QUIT = false;
    private static final String HELP_PAGE_HOME = "/help/home.htm";
    private static final String HELP_PAGE_LICENSE = "/help/license.htm";
    private static final String TEXT_FULLSCREEN_ON = "Vollbildmodus einschalten";
    private static final String TEXT_FULLSCREEN_OFF = "Vollbildmodus ausschalten";
    private static final String TEXT_MAX_SPEED = "Maximale Geschwindigkeit";
    private static final String TEXT_STD_SPEED = "Standard-Geschwindigkeit";
    private static final String PROP_SCREEN_SCALE = "jkcemu.screen.scale";
    private static final String PROP_FULLSCREEN = "jkcemu.screen.fullscreen";
    private static final String ACTION_AUDIO = "audio";
    private static final String ACTION_AUDIORECORDER = "audiorecorder";
    private static final String ACTION_BASIC_OPEN = "basic.open";
    private static final String ACTION_BASIC_SAVE = "basic.save";
    private static final String ACTION_CALCULATOR = "calculator";
    private static final String ACTION_CHESSBOARD = "chessboard";
    private static final String ACTION_DEBUGGER = "debugger";
    private static final String ACTION_DISK_UNPACK = "disk.unpack";
    private static final String ACTION_DISKIMAGE_BUILD = "diskimage.build";
    private static final String ACTION_DISKIMAGE_CAPTURE = "diskimage.capture";
    private static final String ACTION_DISKIMAGE_UNPACK = "diskimage.unpack";
    private static final String ACTION_DISKIMAGE_WRITE = "diskimage.write";
    private static final String ACTION_DISKVIEWER = "diskviewer";
    private static final String ACTION_FILEBROWSER = "filebrowser";
    private static final String ACTION_FILECONVERTER = "fileconverter";
    private static final String ACTION_FILE_LOAD = "file.load";
    private static final String ACTION_FILE_SAVE = "file.save";
    private static final String ACTION_FIND_FILES = "find_files";
    private static final String ACTION_FLOPPYDISKS = "floppydisks";
    private static final String ACTION_FULLSCREEN = "fullscreen";
    private static final String ACTION_HELP_ABOUT = "help.about";
    private static final String ACTION_HELP_CONTENT = "help.content";
    private static final String ACTION_HELP_LICENSE = "help.license";
    private static final String ACTION_HELP_SYSTEM = "help.system";
    private static final String ACTION_HEXDIFF = "hexdiff";
    private static final String ACTION_HEXEDITOR = "hexeditor";
    private static final String ACTION_IMAGEVIEWER = "imageviewer";
    private static final String ACTION_JOYSTICK = "joystick";
    private static final String ACTION_KEYBOARD = "keyboard";
    private static final String ACTION_PLOTTER = "plotter";
    private static final String ACTION_PRINTER = "printer";
    private static final String ACTION_PROFILE = "profile";
    private static final String ACTION_QUIT = "file.quit";
    private static final String ACTION_MEMEDITOR = "memeditor";
    private static final String ACTION_NMI = "nmi";
    private static final String ACTION_PAUSE = "pause";
    private static final String ACTION_POWER_ON = "power_on";
    private static final String ACTION_RAMFLOPPIES = "ramfloppies";
    private static final String ACTION_REASSEMBLER = "reassembler";
    private static final String ACTION_RESET = "reset";
    private static final String ACTION_SECOND_SCREEN = "second_screen";
    private static final String ACTION_SETTINGS = "extra.settings";
    private static final String ACTION_SPEED = "speed";
    private static final String ACTION_TEXTEDITOR = "texteditor";
    private static final String ACTION_USB = "usb";
    private JMenuBar mnuBar;
    private JMenu mnuExtra;
    private JMenuItem mnuBasicOpen;
    private JMenuItem mnuBasicSave;
    private JMenuItem mnuAudio;
    private JMenuItem mnuChessboard;
    private JMenuItem mnuFloppyDisks;
    private JMenuItem mnuFullScreen;
    private JMenuItem mnuJoystick;
    private JMenuItem mnuKeyboard;
    private JMenuItem mnuPause;
    private JMenuItem mnuPlotter;
    private JMenuItem mnuPrintJobs;
    private JMenuItem mnuRAMFloppies;
    private JMenuItem mnuSecondScreen;
    private JMenuItem mnuSpeed;
    private JMenuItem mnuUSB;
    private JMenuItem mnuHelpSys;
    private JMenuItem mnuPopupAudio;
    private JMenuItem mnuPopupFloppyDisk;
    private JMenuItem mnuPopupUSB;
    private JMenuItem mnuPopupKeyboard;
    private JMenuItem mnuPopupJoystick;
    private JMenuItem mnuPopupSpeed;
    private JMenuItem mnuPopupPause;
    private JMenuItem mnuPopupFullScreen;
    private JToolBar toolBar;
    private JButton btnLoad;
    private JButton btnSave;
    private JButton btnAudio;
    private JButton btnChessboard;
    private JButton btnFloppyDisks;
    private JButton btnKeyboard;
    private JButton btnSettings;
    private JButton btnReset;
    private JLabel labelStatus;
    private Point windowLocation;
    private Dimension windowSize;
    private boolean fullScreenMode;
    private boolean fullScreenInfoDone;
    private boolean ignoreKeyChar;
    private volatile boolean chessboardDirty;
    private int screenScale;
    private Timer statusRefreshTimer;
    private NumberFormat speedFmt;
    private EmuThread emuThread;
    private KeyboardFrm keyboardFrm;
    private MsgFrm msgFrm;
    private DebugFrm primDebugFrm;
    private MemEditFrm primMemEditFrm;
    private ReassFrm primReassFrm;
    private DebugFrm secondDebugFrm;
    private MemEditFrm secondMemEditFrm;
    private ReassFrm secondReassFrm;
    private SecondaryScreenFrm secondScreenFrm;

    public ScreenFrm() {
        this.setTitle("JKCEMU");
        this.emuThread = null;
        this.keyboardFrm = null;
        this.msgFrm = null;
        this.primDebugFrm = null;
        this.primMemEditFrm = null;
        this.primReassFrm = null;
        this.secondDebugFrm = null;
        this.secondMemEditFrm = null;
        this.secondReassFrm = null;
        this.secondScreenFrm = null;
        this.windowLocation = null;
        this.windowSize = null;
        this.fullScreenMode = false;
        this.fullScreenInfoDone = false;
        this.ignoreKeyChar = false;
        this.chessboardDirty = false;
        this.screenScale = 1;
        this.speedFmt = NumberFormat.getNumberInstance();
        if (this.speedFmt instanceof DecimalFormat) {
            ((DecimalFormat)this.speedFmt).applyPattern("###,###,##0.0#");
        }
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        jMenu.add(this.createJMenuItem("Laden...", ACTION_FILE_LOAD, KeyStroke.getKeyStroke(76, 8)));
        jMenu.add(this.createJMenuItem("Speichern...", ACTION_FILE_SAVE, KeyStroke.getKeyStroke(83, 8)));
        jMenu.addSeparator();
        this.mnuBasicOpen = this.createJMenuItem("BASIC-Programm im Texteditor \u00f6ffnen...", ACTION_BASIC_OPEN, KeyStroke.getKeyStroke(84, 9));
        jMenu.add(this.mnuBasicOpen);
        this.mnuBasicSave = this.createJMenuItem("BASIC-Programm speichern...", ACTION_BASIC_SAVE, KeyStroke.getKeyStroke(83, 9));
        jMenu.add(this.mnuBasicSave);
        jMenu.addSeparator();
        this.mnuRAMFloppies = this.createJMenuItem("RAM-Floppies...", ACTION_RAMFLOPPIES);
        jMenu.add(this.mnuRAMFloppies);
        this.mnuFloppyDisks = this.createJMenuItem("Diskettenstation...", ACTION_FLOPPYDISKS);
        jMenu.add(this.mnuFloppyDisks);
        jMenu.addSeparator();
        JMenu jMenu2 = this.createScreenMenu(true);
        if (jMenu2 != null) {
            jMenu.add(jMenu2);
            jMenu.addSeparator();
        }
        jMenu.add(this.createJMenuItem("Texteditor/Programmierung...", ACTION_TEXTEDITOR, KeyStroke.getKeyStroke(84, 8)));
        jMenu.add(this.createJMenuItem("Datei-Browser...", ACTION_FILEBROWSER));
        jMenu.add(this.createJMenuItem("Dateien suchen...", ACTION_FIND_FILES, KeyStroke.getKeyStroke(70, 8)));
        jMenu.addSeparator();
        jMenu.add(this.createJMenuItem("Beenden", ACTION_QUIT));
        JMenu jMenu3 = this.createEditMenu(true, true);
        this.mnuExtra = new JMenu("Extra");
        this.mnuExtra.setMnemonic(69);
        this.mnuExtra.add(this.createScaleMenu());
        this.mnuExtra.addSeparator();
        this.mnuAudio = this.createJMenuItem("Audio/Kassette...", ACTION_AUDIO, KeyStroke.getKeyStroke(65, 8));
        this.mnuExtra.add(this.mnuAudio);
        this.mnuKeyboard = this.createJMenuItem("Tastatur...", ACTION_KEYBOARD, KeyStroke.getKeyStroke(75, 8));
        this.mnuExtra.add(this.mnuKeyboard);
        this.mnuJoystick = this.createJMenuItem("Joysticks...", ACTION_JOYSTICK, KeyStroke.getKeyStroke(74, 8));
        this.mnuExtra.add(this.mnuJoystick);
        this.mnuPrintJobs = this.createJMenuItem("Druckauftr\u00e4ge...", ACTION_PRINTER);
        this.mnuExtra.add(this.mnuPrintJobs);
        this.mnuPlotter = this.createJMenuItem("Plotter...", ACTION_PLOTTER);
        this.mnuExtra.add(this.mnuPlotter);
        this.mnuUSB = this.createJMenuItem("USB-Anschluss...", ACTION_USB, KeyStroke.getKeyStroke(85, 8));
        this.mnuExtra.add(this.mnuUSB);
        this.mnuChessboard = this.createJMenuItem("Schachbrett...", ACTION_CHESSBOARD);
        this.mnuExtra.add(this.mnuChessboard);
        this.mnuSecondScreen = this.createJMenuItem("Zweite Anzeigeeinheit...", ACTION_SECOND_SCREEN);
        this.mnuExtra.add(this.mnuSecondScreen);
        this.mnuExtra.addSeparator();
        this.mnuExtra.add(this.createJMenuItem("Bildschirmfoto...", "screenshot"));
        this.mnuExtra.add(this.createJMenuItem("Bildschirmvideo...", "screen.video"));
        JMenu jMenu4 = new JMenu("Werkzeuge");
        jMenu4.add(this.createJMenuItem("Debugger...", ACTION_DEBUGGER, KeyStroke.getKeyStroke(68, 9)));
        jMenu4.add(this.createJMenuItem("Reassembler...", ACTION_REASSEMBLER, KeyStroke.getKeyStroke(82, 9)));
        jMenu4.add(this.createJMenuItem("Speichereditor...", ACTION_MEMEDITOR, KeyStroke.getKeyStroke(77, 9)));
        jMenu4.add(this.createJMenuItem("Hex-Editor...", ACTION_HEXEDITOR, KeyStroke.getKeyStroke(72, 9)));
        jMenu4.add(this.createJMenuItem("Hex-Dateivergleicher...", ACTION_HEXDIFF));
        jMenu4.add(this.createJMenuItem("Dateikonverter...", ACTION_FILECONVERTER));
        jMenu4.add(this.createJMenuItem("Bildbetrachter/-bearbeitung...", ACTION_IMAGEVIEWER));
        jMenu4.add(this.createJMenuItem("Audiorecorder...", ACTION_AUDIORECORDER));
        jMenu4.add(this.createJMenuItem("Rechner...", ACTION_CALCULATOR));
        jMenu4.add(this.createJMenuItem("Diskettenabbilddatei-Inspektor...", ACTION_DISKVIEWER));
        jMenu4.addSeparator();
        jMenu4.add(this.createJMenuItem("CP/M-Diskettenabbilddatei manuell erstellen...", ACTION_DISKIMAGE_BUILD));
        jMenu4.add(this.createJMenuItem("CP/M-Diskettenabbilddatei entpacken...", ACTION_DISKIMAGE_UNPACK));
        jMenu4.add(this.createJMenuItem("CP/M-Diskette entpacken...", ACTION_DISK_UNPACK));
        jMenu4.addSeparator();
        jMenu4.add(this.createJMenuItem("Abbilddatei von Datentr\u00e4ger erstellen...", ACTION_DISKIMAGE_CAPTURE));
        jMenu4.add(this.createJMenuItem("Abbilddatei auf Datentr\u00e4ger schreiben...", ACTION_DISKIMAGE_WRITE));
        this.mnuExtra.add(jMenu4);
        this.mnuExtra.addSeparator();
        this.mnuExtra.add(this.createJMenuItem("Einstellungen...", ACTION_SETTINGS));
        this.mnuExtra.add(this.createJMenuItem("Profil anwenden...", ACTION_PROFILE));
        this.mnuExtra.addSeparator();
        this.mnuFullScreen = this.createJMenuItem(TEXT_FULLSCREEN_ON, ACTION_FULLSCREEN);
        this.mnuExtra.add(this.mnuFullScreen);
        this.mnuSpeed = this.createJMenuItem(TEXT_MAX_SPEED, ACTION_SPEED, KeyStroke.getKeyStroke(71, 8));
        this.mnuExtra.add(this.mnuSpeed);
        this.mnuPause = this.createJMenuItem("Pause", ACTION_PAUSE, KeyStroke.getKeyStroke(80, 8));
        this.mnuExtra.add(this.mnuPause);
        this.mnuExtra.add(this.createJMenuItem("NMI ausl\u00f6sen", ACTION_NMI, KeyStroke.getKeyStroke(78, 8)));
        this.mnuExtra.add(this.createJMenuItem("Zur\u00fccksetzen (RESET)", ACTION_RESET, KeyStroke.getKeyStroke(82, 8)));
        this.mnuExtra.add(this.createJMenuItem("Einschalten (Power On)", ACTION_POWER_ON, KeyStroke.getKeyStroke(73, 8)));
        JMenu jMenu5 = new JMenu("?");
        jMenu5.add(this.createJMenuItem("Hilfe...", ACTION_HELP_CONTENT));
        this.mnuHelpSys = this.createJMenuItem("Hilfe zum emulierten System...", ACTION_HELP_SYSTEM);
        this.mnuHelpSys.setEnabled(false);
        jMenu5.add(this.mnuHelpSys);
        jMenu5.addSeparator();
        jMenu5.add(this.createJMenuItem("\u00dcber JKCEMU...", ACTION_HELP_ABOUT));
        jMenu5.add(this.createJMenuItem("Lizenzbestimmungen...", ACTION_HELP_LICENSE));
        this.mnuBar = new JMenuBar();
        this.mnuBar.add(jMenu);
        this.mnuBar.add(jMenu3);
        this.mnuBar.add(this.mnuExtra);
        this.mnuBar.add(jMenu5);
        this.setJMenuBar(this.mnuBar);
        this.mnuPopup = new JPopupMenu();
        this.mnuPopupCopy = this.createJMenuItem("Kopieren", "edit.copy");
        this.mnuPopupCopy.setEnabled(false);
        this.mnuPopup.add(this.mnuPopupCopy);
        this.mnuPopupPaste = this.createJMenuItem("Einf\u00fcgen", "edit.paste");
        this.mnuPopupPaste.setEnabled(false);
        this.mnuPopup.add(this.mnuPopupPaste);
        this.mnuPopup.addSeparator();
        this.mnuPopup.add(this.createJMenuItem("Laden...", ACTION_FILE_LOAD));
        this.mnuPopup.add(this.createJMenuItem("Speichern...", ACTION_FILE_SAVE));
        this.mnuPopup.addSeparator();
        this.mnuPopupAudio = this.createJMenuItem("Audio/Kassette...", ACTION_AUDIO);
        this.mnuPopup.add(this.mnuPopupAudio);
        this.mnuPopupFloppyDisk = this.createJMenuItem("Diskettenstation...", ACTION_FLOPPYDISKS);
        this.mnuPopup.add(this.mnuPopupFloppyDisk);
        this.mnuPopupUSB = this.createJMenuItem("USB-Anschluss...", ACTION_USB);
        this.mnuPopup.add(this.mnuPopupUSB);
        this.mnuPopupKeyboard = this.createJMenuItem("Tastatur...", ACTION_KEYBOARD);
        this.mnuPopup.add(this.mnuPopupKeyboard);
        this.mnuPopupJoystick = this.createJMenuItem("Joysticks...", ACTION_JOYSTICK);
        this.mnuPopup.add(this.mnuPopupJoystick);
        this.mnuPopup.addSeparator();
        this.mnuPopup.add(this.createJMenuItem("Einstellungen...", ACTION_SETTINGS));
        this.mnuPopup.addSeparator();
        this.mnuPopupFullScreen = this.createJMenuItem(TEXT_FULLSCREEN_ON, ACTION_FULLSCREEN);
        this.mnuPopup.add(this.mnuPopupFullScreen);
        this.mnuPopupSpeed = this.createJMenuItem(TEXT_MAX_SPEED, ACTION_SPEED);
        this.mnuPopup.add(this.mnuPopupSpeed);
        this.mnuPopupPause = this.createJMenuItem("Pause", ACTION_PAUSE);
        this.mnuPopup.add(this.mnuPopupPause);
        this.mnuPopup.addSeparator();
        this.mnuPopup.add(this.createJMenuItem("Zur\u00fccksetzen (RESET)", ACTION_RESET));
        this.mnuPopup.add(this.createJMenuItem("Einschalten (Power On)", ACTION_POWER_ON));
        this.mnuPopup.addSeparator();
        this.mnuPopup.add(this.createJMenuItem("Beenden", ACTION_QUIT));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.add((Component)jPanel, gridBagConstraints);
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setBorderPainted(false);
        this.toolBar.setOrientation(0);
        this.toolBar.setRollover(true);
        jPanel.add(this.toolBar);
        this.btnLoad = this.createImageButton("/images/file/open.png", "Laden", ACTION_FILE_LOAD);
        this.btnSave = this.createImageButton("/images/file/save.png", "Speichern", ACTION_FILE_SAVE);
        this.btnCopy = this.createImageButton("/images/edit/copy.png", "Kopieren", "edit.copy");
        this.btnCopy.setEnabled(false);
        this.btnPaste = this.createImageButton("/images/edit/paste.png", "Einf\u00fcgen", "edit.paste");
        this.btnPaste.setEnabled(false);
        this.btnAudio = this.createImageButton("/images/audio/audio.png", "Audio", ACTION_AUDIO);
        this.btnChessboard = this.createImageButton("/images/chess/chessboard.png", "Schachbrett", ACTION_CHESSBOARD);
        this.btnFloppyDisks = this.createImageButton("/images/disk/floppydiskstation.png", "Diskettenstation", ACTION_FLOPPYDISKS);
        this.btnKeyboard = this.createImageButton("/images/keyboard/keyboard.png", "Tastatur", ACTION_KEYBOARD);
        this.btnSettings = this.createImageButton("/images/file/settings.png", "Einstellungen", ACTION_SETTINGS);
        this.btnReset = this.createImageButton("/images/file/reset.png", "Zur\u00fccksetzen (RESET)", ACTION_RESET);
        this.screenFld = new ScreenFld(this);
        this.screenFld.setFocusable(true);
        this.screenFld.setFocusTraversalKeysEnabled(false);
        this.screenFld.addKeyListener(this);
        this.screenFld.addMouseListener(this);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.screenFld, gridBagConstraints);
        this.labelStatus = new JLabel("Bereit");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelStatus, gridBagConstraints);
        new DropTarget(this.screenFld, this).setActive(true);
        this.updPasteBtns();
        this.updPauseBtn();
        this.statusRefreshTimer = new Timer(1000, this);
        this.statusRefreshTimer.start();
    }

    public void childFrameClosed(Frame frame) {
        if (frame != null) {
            if (frame == this.keyboardFrm) {
                this.keyboardFrm = null;
            } else if (frame == this.secondScreenFrm) {
                this.secondScreenFrm = null;
            }
        }
    }

    public void clearScreenSelection() {
        if (this.screenFld != null) {
            this.screenFld.clearSelection();
        }
    }

    public BufferedImage createSnapshot() {
        return this.screenFld.createBufferedImage();
    }

    public void fireAppendMsg(final String string) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenFrm.this.appendMsg(string);
            }
        });
    }

    public void fireOpenSecondScreen() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenFrm.this.doExtraSecondScreen(true);
            }
        });
    }

    public void fireReset(final EmuThread.ResetLevel resetLevel) {
        if (this.emuThread != null) {
            this.emuThread.informWillReset();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenFrm.this.execReset(resetLevel);
            }
        });
    }

    public void fireScreenSizeChanged() {
        this.windowSize = null;
        if (!this.fullScreenMode && this.getExtendedState() != 6) {
            final ScreenFrm screenFrm = this;
            final ScreenFld screenFld = this.screenFld;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    screenFld.updPreferredSize();
                    screenFrm.pack();
                }
            });
        }
    }

    public void fireShowStatusText(final String string) {
        if (string != null && !string.isEmpty()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenFrm.this.showStatusText(string);
                }
            });
        }
    }

    public void fireUpdScreenTextActionsEnabled() {
        final EmuSys emuSys = this.getEmuSys();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                if (emuSys != null) {
                    bl = emuSys.canExtractScreenText();
                }
                if (!bl) {
                    ScreenFrm.this.clearScreenSelection();
                }
                ScreenFrm.this.setScreenTextActionsEnabled(bl);
            }
        });
    }

    public EmuThread getEmuThread() {
        return this.emuThread;
    }

    public EmuSys getEmuSys() {
        return this.emuThread != null ? this.emuThread.getEmuSys() : null;
    }

    public boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    public DebugFrm openPrimaryDebugger() {
        if (this.primDebugFrm != null) {
            EmuUtil.showFrame(this.primDebugFrm);
        } else if (this.emuThread != null) {
            this.primDebugFrm = new DebugFrm(this.emuThread, this.emuThread.getZ80CPU(), this.emuThread);
            EmuUtil.showFrame(this.primDebugFrm);
        }
        return this.primDebugFrm;
    }

    public ReassFrm openPrimaryReassembler() {
        if (this.primReassFrm != null) {
            EmuUtil.showFrame(this.primReassFrm);
        } else if (this.emuThread != null) {
            this.primReassFrm = new ReassFrm(this.emuThread);
            EmuUtil.showFrame(this.primReassFrm);
        }
        return this.primReassFrm;
    }

    public DebugFrm openSecondDebugger() {
        EmuSys emuSys;
        DebugFrm debugFrm = null;
        if (this.emuThread != null && (emuSys = this.emuThread.getEmuSys()) != null) {
            Z80CPU z80CPU = emuSys.getSecondZ80CPU();
            Z80Memory z80Memory = emuSys.getSecondZ80Memory();
            if (z80CPU != null && z80Memory != null) {
                if (this.secondDebugFrm != null) {
                    EmuUtil.showFrame(this.secondDebugFrm);
                } else {
                    this.secondDebugFrm = new DebugFrm(this.emuThread, z80CPU, z80Memory);
                    String string = emuSys.getSecondSystemName();
                    if (string != null) {
                        this.secondDebugFrm.setTitle("JKCEMU Debugger: " + string);
                    } else {
                        this.secondDebugFrm.setTitle("JKCEMU Debugger: Sekund\u00e4rsystem");
                    }
                    EmuUtil.showFrame(this.secondDebugFrm);
                }
                debugFrm = this.secondDebugFrm;
            }
        }
        return debugFrm;
    }

    public ReassFrm openSecondReassembler() {
        ReassFrm reassFrm = null;
        EmuSys emuSys = this.getEmuSys();
        if (emuSys != null) {
            reassFrm = this.openSecondReassembler(emuSys.getSecondZ80Memory(), emuSys.getSecondSystemName());
        }
        return reassFrm;
    }

    public void openAudioInFile(File file, byte[] byArray, int n) {
        AudioFrm.open(this).openFile(file, byArray, n);
    }

    public void openAudioInFile(File file) {
        AudioFrm.open(this).openFile(file, null, 0);
    }

    public TextEditFrm openText(String string) {
        TextEditFrm textEditFrm = TextEditFrm.open(this.emuThread);
        if (textEditFrm != null) {
            textEditFrm.openText(string);
        }
        return textEditFrm;
    }

    public void setChessboardDirty(boolean bl) {
        this.chessboardDirty = bl;
    }

    public void setEmuThread(EmuThread emuThread) {
        Runnable runnable;
        if (this.emuThread != emuThread) {
            if (this.emuThread != null && (runnable = this.emuThread.getZ80CPU()) != null) {
                ((Z80CPU)runnable).removeStatusListener(this);
            }
            this.emuThread = emuThread;
            if (this.emuThread != null && (runnable = this.emuThread.getZ80CPU()) != null) {
                ((Z80CPU)runnable).addStatusListener(this);
            }
        }
        if ((runnable = this.getEmuSys()) != null) {
            this.copyEnabled = ((AbstractScreenDevice)((Object)runnable)).supportsCopyToClipboard();
            this.pasteEnabled = ((AbstractScreenDevice)((Object)runnable)).supportsPasteFromClipboard();
        } else {
            this.copyEnabled = false;
            this.pasteEnabled = false;
        }
        this.updActionBtns(this.getEmuSys());
    }

    public boolean setMaxSpeed(Component component, boolean bl) {
        Z80CPU z80CPU;
        boolean bl2 = false;
        if (this.emuThread != null && (z80CPU = this.emuThread.getZ80CPU()) != null) {
            if (bl && this.emuThread.isAudioLineOpen()) {
                BaseDlg.showInfoDlg(component, "Solange ein Audiokanal ge\u00f6ffnet ist,\nkann nicht auf maximale Geschwindigkeit geschaltet werden\nda der Audiokanal bremst.");
            } else {
                z80CPU.setBrakeEnabled(!bl);
                EmuSys emuSys = this.emuThread.getEmuSys();
                if (emuSys != null && (z80CPU = emuSys.getSecondZ80CPU()) != null) {
                    z80CPU.setBrakeEnabled(!bl);
                }
                if (bl) {
                    this.mnuSpeed.setText(TEXT_STD_SPEED);
                    this.mnuPopupSpeed.setText(TEXT_STD_SPEED);
                } else {
                    this.mnuSpeed.setText(TEXT_MAX_SPEED);
                    this.mnuPopupSpeed.setText(TEXT_MAX_SPEED);
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    public void showStatusText(String string) {
        this.statusRefreshTimer.stop();
        this.labelStatus.setText(string);
        this.statusRefreshTimer.setInitialDelay(5000);
        this.statusRefreshTimer.restart();
    }

    public void startEmulationThread() {
        if (this.emuThread != null) {
            this.emuThread.start();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        File file = EmuUtil.fileDrop(this, dropTargetDropEvent);
        if (file != null) {
            LoadDlg.loadFile(this, this, file, true, true, true);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void z80StatusChanged(Z80Breakpoint z80Breakpoint, Z80InterruptSource z80InterruptSource) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenFrm.this.updPauseBtn();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != null) {
            if (object == this.screenRefreshTimer) {
                if (this.chessboardDirty) {
                    ChessboardFrm.repaintChessboard();
                }
                if (this.screenDirty && this.screenFld != null) {
                    this.screenFld.repaint();
                }
            } else if (object == this.statusRefreshTimer) {
                this.refreshStatus();
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.emuThread != null && !keyEvent.isAltDown() && keyEvent.getKeyCode() != 121) {
            if (!(keyEvent.getKeyCode() != 77 || keyEvent.isAltDown() || keyEvent.isAltGraphDown() || !keyEvent.isControlDown() || keyEvent.isMetaDown() || keyEvent.isShiftDown())) {
                this.emuThread.keyTyped('\r');
                this.ignoreKeyChar = true;
                keyEvent.consume();
            } else if (this.emuThread.keyPressed(keyEvent)) {
                this.ignoreKeyChar = true;
                keyEvent.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.emuThread != null && !keyEvent.isAltDown()) {
            int n = keyEvent.getKeyCode();
            if (n != 121 && n != 17) {
                this.emuThread.keyReleased();
                keyEvent.consume();
            }
            this.ignoreKeyChar = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.emuThread != null && !keyEvent.isAltDown()) {
            if (this.ignoreKeyChar) {
                this.ignoreKeyChar = false;
            } else {
                this.emuThread.keyTyped(keyEvent.getKeyChar());
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            Main.setWindowActivated(1);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            Main.setWindowDeactivated(1);
            if (this.emuThread != null) {
                this.emuThread.keyReleased();
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            if (this.screenFld != null) {
                this.screenFld.requestFocus();
            }
            if (Main.isFirstExecution()) {
                SettingsFrm.open(this);
            }
        }
    }

    @Override
    public boolean applySettings(Properties properties, boolean bl) {
        Plotter plotter;
        int n;
        boolean bl2 = this.isVisible();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        Z80CPU z80CPU = null;
        Z80Memory z80Memory = null;
        int n2 = this.screenFld.getMargin();
        int n3 = this.screenFld.getScreenScale();
        AbstractScreenDevice abstractScreenDevice = this.screenFld.getScreenDevice();
        EmuSys emuSys = this.getEmuSys();
        if (emuSys != null) {
            this.setTitle("JKCEMU: " + emuSys.getTitle());
            this.mnuHelpSys.setEnabled(emuSys.getHelpPage() != null);
            bl4 = emuSys.supportsChessboard();
            bl5 = emuSys.getSupportedFloppyDiskDriveCount() > 0;
            bl6 = emuSys.supportsRAMFloppies();
            bl7 = emuSys.supportsUSB();
            z80CPU = emuSys.getSecondZ80CPU();
            z80Memory = emuSys.getSecondZ80Memory();
        }
        if (emuSys != null) {
            this.copyEnabled = emuSys.supportsCopyToClipboard();
            this.pasteEnabled = emuSys.supportsPasteFromClipboard();
            bl3 = emuSys.canExtractScreenText();
        } else {
            this.copyEnabled = false;
            this.pasteEnabled = false;
        }
        this.updActionBtns(emuSys);
        if (!this.copyEnabled) {
            this.mnuCopy.setEnabled(false);
            this.mnuPopupCopy.setEnabled(false);
        }
        this.updPasteBtns();
        if (this.screenRefreshTimer.isRunning()) {
            this.screenRefreshTimer.stop();
        }
        if (emuSys != null && !emuSys.isAutoScreenRefresh()) {
            this.screenRefreshMillis = EmuUtil.getIntProperty(properties, "jkcemu.screen.refresh.ms", ScreenFrm.getDefaultScreenRefreshMillis());
            if (this.screenRefreshMillis < 10) {
                this.screenRefreshMillis = ScreenFrm.getDefaultScreenRefreshMillis();
            }
            this.screenRefreshTimer.setDelay(this.screenRefreshMillis);
            this.screenRefreshTimer.start();
        }
        this.screenScale = n3;
        if (!bl2) {
            n = EmuUtil.getIntProperty(properties, PROP_SCREEN_SCALE, 1);
            this.screenScale = n >= 1 ? n : 1;
            this.setScreenScale(this.screenScale);
        }
        this.screenFld.setScreenDevice(emuSys);
        this.setScreenTextActionsEnabled(bl3);
        this.setScreenDirty(true);
        n = 0;
        boolean bl8 = false;
        int n4 = EmuUtil.getIntProperty(properties, "jkcemu.screen.margin", 20);
        if (n4 < 0) {
            n4 = 0;
        }
        this.screenFld.setMargin(n4);
        if (bl2 && emuSys != null && abstractScreenDevice != null && this.screenScale == n3 && emuSys.getScreenWidth() == abstractScreenDevice.getScreenWidth() && emuSys.getScreenHeight() == abstractScreenDevice.getScreenHeight() && n4 == n2) {
            bl8 = true;
        }
        if (!bl8) {
            n = super.applySettings(properties, bl) ? 1 : 0;
        }
        if (bl2) {
            if (this.fullScreenMode) {
                this.updFullScreenScale();
            }
        } else {
            this.setFullScreenMode(EmuUtil.getBooleanProperty(properties, PROP_FULLSCREEN, false));
        }
        if (!bl8 && !n) {
            if (this.fullScreenMode) {
                this.windowSize = null;
            } else {
                this.pack();
            }
            if (!bl2) {
                this.setScreenCentered();
            }
            n = 1;
        }
        if (!bl4) {
            ChessboardFrm.close();
        }
        if (!bl5) {
            FloppyDiskStationFrm.close();
        }
        if (this.keyboardFrm != null) {
            if (emuSys != null) {
                if (!this.keyboardFrm.accepts(emuSys)) {
                    this.keyboardFrm.doClose();
                }
            } else {
                this.keyboardFrm.doClose();
            }
        }
        if ((plotter = emuSys.getPlotter()) != null) {
            PlotterFrm.lazySetPlotter(plotter);
        } else {
            PlotterFrm.close();
        }
        if (this.secondDebugFrm != null && (z80CPU == null || z80Memory == null || this.secondDebugFrm.getZ80CPU() != z80CPU || this.secondDebugFrm.getZ80Memory() != z80Memory)) {
            this.secondDebugFrm.doClose();
            this.secondDebugFrm = null;
        }
        if (this.secondMemEditFrm != null && (z80Memory == null || this.secondMemEditFrm.getZ80Memory() != z80Memory)) {
            this.secondMemEditFrm.doClose();
            this.secondMemEditFrm = null;
        }
        if (this.secondReassFrm != null && (z80Memory == null || this.secondReassFrm.getZ80Memory() != z80Memory)) {
            this.secondReassFrm.doClose();
            this.secondReassFrm = null;
        }
        if (this.secondScreenFrm != null) {
            if (emuSys != null) {
                if (!this.secondScreenFrm.accepts(emuSys.getSecondScreenDevice())) {
                    this.secondScreenFrm.doClose();
                }
            } else {
                this.secondScreenFrm.doClose();
            }
        }
        if (!bl6) {
            RAMFloppyFrm.close();
        }
        if (!bl7) {
            USBInterfaceFrm.close();
        }
        return n != 0;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        String string;
        boolean bl = false;
        if (eventObject instanceof ActionEvent && (string = ((ActionEvent)eventObject).getActionCommand()) != null) {
            if (string.equals(ACTION_QUIT)) {
                bl = true;
                this.doClose();
            } else if (string.equals(ACTION_FILE_LOAD)) {
                bl = true;
                this.doFileLoad(true);
            } else if (string.equals(ACTION_FILE_SAVE)) {
                bl = true;
                this.doFileSave();
            } else if (string.equals(ACTION_RAMFLOPPIES)) {
                bl = true;
                this.doRAMFloppies();
            } else if (string.equals(ACTION_FLOPPYDISKS)) {
                bl = true;
                this.doFloppyDisk();
            } else if (string.equals(ACTION_BASIC_OPEN)) {
                bl = true;
                EmuSys emuSys = this.getEmuSys();
                if (emuSys != null) {
                    emuSys.openBasicProgram();
                }
            } else if (string.equals(ACTION_BASIC_SAVE)) {
                bl = true;
                EmuSys emuSys = this.getEmuSys();
                if (emuSys != null) {
                    emuSys.saveBasicProgram();
                }
            } else if (string.equals("screen.image.save")) {
                bl = true;
                this.doFileScreenImageSave();
            } else if (string.equals("screen.text.save")) {
                bl = true;
                this.doFileScreenTextSave();
            } else if (string.equals(ACTION_FIND_FILES)) {
                bl = true;
                FindFilesFrm.open(this);
            } else if (string.equals(ACTION_FILEBROWSER)) {
                bl = true;
                FileBrowserFrm.open(this);
            } else if (string.equals(ACTION_TEXTEDITOR)) {
                bl = true;
                TextEditFrm.open(this.emuThread);
            } else if (string.equals(ACTION_AUDIO)) {
                bl = true;
                AudioFrm.open(this);
            } else if (string.equals(ACTION_CHESSBOARD)) {
                bl = true;
                this.doExtraChessboard();
            } else if (string.equals(ACTION_JOYSTICK)) {
                bl = true;
                JoystickFrm.open(this.emuThread);
            } else if (string.equals(ACTION_KEYBOARD)) {
                bl = true;
                this.doExtraKeyboard();
            } else if (string.equals(ACTION_PLOTTER)) {
                bl = true;
                this.doExtraPlotter();
            } else if (string.equals(ACTION_PRINTER)) {
                bl = true;
                PrintListFrm.open(this);
            } else if (string.equals(ACTION_USB)) {
                bl = true;
                this.doExtraUSB();
            } else if (string.equals("screenshot")) {
                bl = true;
                ImageCaptureFrm.open(this);
            } else if (string.equals("screen.video")) {
                bl = true;
                VideoCaptureFrm.open(this);
            } else if (string.equals(ACTION_SECOND_SCREEN)) {
                bl = true;
                this.doExtraSecondScreen(false);
            } else if (string.equals(ACTION_IMAGEVIEWER)) {
                bl = true;
                ImageFrm.open();
            } else if (string.equals(ACTION_AUDIORECORDER)) {
                bl = true;
                AudioRecorderFrm.open();
            } else if (string.equals(ACTION_DEBUGGER)) {
                bl = true;
                this.doExtraDebugger();
            } else if (string.equals(ACTION_MEMEDITOR)) {
                bl = true;
                this.doExtraMemEditor();
            } else if (string.equals(ACTION_REASSEMBLER)) {
                bl = true;
                this.doExtraReassembler();
            } else if (string.equals(ACTION_CALCULATOR)) {
                bl = true;
                CalculatorFrm.open();
            } else if (string.equals(ACTION_HEXDIFF)) {
                bl = true;
                HexDiffFrm.open();
            } else if (string.equals(ACTION_HEXEDITOR)) {
                bl = true;
                HexEditFrm.open();
            } else if (string.equals(ACTION_FILECONVERTER)) {
                bl = true;
                FileConvertFrm.open();
            } else if (string.equals(ACTION_DISKIMAGE_BUILD)) {
                bl = true;
                DiskImgCreateFrm.open();
            } else if (string.equals(ACTION_DISKIMAGE_UNPACK)) {
                bl = true;
                this.doExtraDiskImgUnpack();
            } else if (string.equals(ACTION_DISK_UNPACK)) {
                bl = true;
                this.doExtraDiskUnpack();
            } else if (string.equals(ACTION_DISKIMAGE_CAPTURE)) {
                bl = true;
                DiskImgProcessDlg.createDiskImageFromDrive(this);
            } else if (string.equals(ACTION_DISKIMAGE_WRITE)) {
                bl = true;
                DiskImgProcessDlg.writeDiskImageToDrive(this);
            } else if (string.equals(ACTION_DISKVIEWER)) {
                bl = true;
                DiskImgViewFrm.open();
            } else if (string.equals(ACTION_SETTINGS)) {
                bl = true;
                SettingsFrm.open(this);
            } else if (string.equals(ACTION_PROFILE)) {
                bl = true;
                this.doExtraProfile();
            } else if (string.equals(ACTION_FULLSCREEN)) {
                bl = true;
                if (eventObject.getSource() == this.mnuPopupFullScreen) {
                    this.fullScreenInfoDone = true;
                }
                this.setFullScreenMode(!this.fullScreenMode);
            } else if (string.equals(ACTION_SPEED)) {
                bl = true;
                this.doExtraSpeed();
            } else if (string.equals(ACTION_PAUSE)) {
                bl = true;
                this.doExtraPause();
            } else if (string.equals(ACTION_NMI)) {
                bl = true;
                this.doExtraNMI();
            } else if (string.equals(ACTION_RESET)) {
                bl = true;
                this.doExtraReset();
            } else if (string.equals(ACTION_POWER_ON)) {
                bl = true;
                this.doExtraPowerOn();
            } else if (string.equals(ACTION_HELP_CONTENT)) {
                bl = true;
                HelpFrm.open(HELP_PAGE_HOME);
            } else if (string.equals(ACTION_HELP_SYSTEM)) {
                bl = true;
                this.doHelpSystem();
            } else if (string.equals(ACTION_HELP_ABOUT)) {
                bl = true;
                new AboutDlg((Window)this).setVisible(true);
            } else if (string.equals(ACTION_HELP_LICENSE)) {
                bl = true;
                HelpFrm.open(HELP_PAGE_LICENSE);
            }
        }
        if (!bl) {
            bl = super.doAction(eventObject);
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = true;
        if (Main.getBooleanProperty("jkcemu.confirm.quit", false) && !BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie den Emulator jetzt beenden?", "Best\u00e4tigung")) {
            bl = false;
        }
        if (bl) {
            bl = this.doQuit();
        }
        return bl;
    }

    @Override
    public boolean doQuit() {
        try {
            Frame[] frameArray = Frame.getFrames();
            if (frameArray != null) {
                for (Frame frame : frameArray) {
                    if (frame == this) continue;
                    if (frame instanceof BaseFrm) {
                        if (((BaseFrm)frame).doQuit()) continue;
                        return false;
                    }
                    frame.setVisible(false);
                    frame.dispose();
                }
            }
            if (this.emuThread != null) {
                this.emuThread.stopEmulator();
                Main.getThreadGroup().interrupt();
                try {
                    this.emuThread.join(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!super.doClose()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Main.exitSuccess();
        return true;
    }

    @Override
    protected void doScreenScale(int n) {
        this.screenScale = n;
        this.screenFld.setScreenScale(n);
        if (!this.fullScreenMode) {
            this.pack();
        }
    }

    @Override
    protected AbstractScreenDevice getScreenDevice() {
        return this.getEmuSys();
    }

    @Override
    public void putSettingsTo(Properties properties) {
        if (properties != null) {
            super.putSettingsTo(properties);
            if (this.fullScreenMode && this.windowLocation != null && this.windowSize != null) {
                String string = this.getSettingsPrefix();
                properties.setProperty(string + "window.x", String.valueOf(this.windowLocation.x));
                properties.setProperty(string + "window.y", String.valueOf(this.windowLocation.y));
                properties.setProperty(string + "window.width", String.valueOf(this.windowSize.width));
                properties.setProperty(string + "window.height", String.valueOf(this.windowSize.height));
            }
            properties.setProperty(PROP_FULLSCREEN, String.valueOf(this.fullScreenMode));
            properties.setProperty(PROP_SCREEN_SCALE, String.valueOf(this.screenScale));
        }
    }

    private void doFileLoad(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = true;
        File file = null;
        File file2 = EmuUtil.getDirectory(Main.getLastDirFile("software"));
        if (EmuUtil.isJKCEMUFileDialogSelected()) {
            FileSelectDlg fileSelectDlg = new FileSelectDlg(this, FileSelectDlg.Mode.LOAD, bl, true, "Datei in Arbeitsspeicher laden", file2, EmuUtil.getBinaryFileFilter(), EmuUtil.getAC1Basic6FileFilter(), EmuUtil.getBasicFileFilter(), EmuUtil.getKCSystemFileFilter(), EmuUtil.getKCBasicFileFilter(), EmuUtil.getTapeFileFilter(), EmuUtil.getHeadersaveFileFilter(), EmuUtil.getHexFileFilter());
            fileSelectDlg.setVisible(true);
            file = fileSelectDlg.getSelectedFile();
            bl3 = fileSelectDlg.isLoadWithOptionsSelected();
            bl2 = fileSelectDlg.isStartSelected();
        } else {
            file = EmuUtil.showFileOpenDlg(this, "Datei in Arbeitsspeicher laden", file2, EmuUtil.getBinaryFileFilter(), EmuUtil.getAC1Basic6FileFilter(), EmuUtil.getBasicFileFilter(), EmuUtil.getKCSystemFileFilter(), EmuUtil.getKCBasicFileFilter(), EmuUtil.getTapeFileFilter(), EmuUtil.getHeadersaveFileFilter(), EmuUtil.getHexFileFilter());
        }
        if (file != null) {
            LoadDlg.loadFile(this, this, file, bl3, bl, bl2);
        }
    }

    private void doFileSave() {
        new SaveDlg(this, -1, -1, "Programm/Adressbereich speichern", SaveDlg.BasicType.NO_BASIC, null).setVisible(true);
    }

    private void doFileScreenImageSave() {
        if (this.doScreenImageSave()) {
            this.showStatusText("Bilddatei gespeichert");
        }
    }

    private void doFileScreenTextSave() {
        if (this.doScreenTextSave()) {
            this.showStatusText("Textdatei gespeichert");
        }
    }

    private void doFloppyDisk() {
        EmuSys emuSys = this.getEmuSys();
        if (emuSys != null) {
            int n = emuSys.getSupportedFloppyDiskDriveCount();
            if (n > 0) {
                FloppyDiskStationFrm floppyDiskStationFrm = FloppyDiskStationFrm.getSharedInstance(this);
                floppyDiskStationFrm.setDriveCount(n);
                EmuUtil.showFrame(floppyDiskStationFrm);
            } else {
                BaseDlg.showInfoDlg(this, "Das gerade emulierte System unterst\u00fctzt keine Floppy Disks.");
            }
        }
    }

    private void doRAMFloppies() {
        EmuSys emuSys = this.getEmuSys();
        if (emuSys != null && (emuSys.supportsRAMFloppy1() || emuSys.supportsRAMFloppy2())) {
            RAMFloppyFrm.open(this.emuThread);
        }
    }

    private void doExtraChessboard() {
        EmuSys emuSys = this.getEmuSys();
        if (emuSys != null) {
            if (emuSys.supportsChessboard()) {
                ChessboardFrm.open(this.emuThread);
            } else {
                BaseDlg.showInfoDlg(this, "Das Schachbrett kann nur angezeigt werden,\nwenn ein Schachcomputer oder Lerncomputer\nmit integriertem Schachprogramm emuliert wird.\nDas trifft jedoch f\u00fcr das gerade emulierte System nicht zu.");
            }
        }
    }

    private void doExtraKeyboard() {
        if (this.keyboardFrm != null) {
            EmuUtil.showFrame(this.keyboardFrm);
        } else {
            EmuSys emuSys = this.getEmuSys();
            if (emuSys != null) {
                try {
                    if (emuSys.supportsKeyboardFld()) {
                        try {
                            AbstractKeyboardFld abstractKeyboardFld = emuSys.createKeyboardFld();
                            if (abstractKeyboardFld != null) {
                                this.keyboardFrm = new KeyboardFrm(this, emuSys, abstractKeyboardFld);
                            }
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                    }
                    if (this.keyboardFrm != null) {
                        EmuUtil.showFrame(this.keyboardFrm);
                    } else {
                        BaseDlg.showErrorDlg((Component)this, "F\u00fcr das emulierte System steht keine Tastaturansicht zur Verf\u00fcgung.");
                    }
                }
                catch (UserCancelException userCancelException) {
                    // empty catch block
                }
            }
        }
    }

    private void doExtraPlotter() {
        EmuSys emuSys = this.getEmuSys();
        if (emuSys != null) {
            Plotter plotter = emuSys.getPlotter();
            if (plotter != null) {
                PlotterFrm.open(plotter);
            } else {
                BaseDlg.showInfoDlg(this, "Das Plotter-Fenster kann nur angezeigt werden,\nwenn auch ein Plotter emuliert wird.\nDas ist aber bei der gerade eingestellten Konfiguration nicht der Fall.");
            }
        }
    }

    private void doExtraDebugger() {
        if (this.emuThread != null) {
            int n = 0;
            Z80CPU z80CPU = null;
            Z80Memory z80Memory = null;
            String string = null;
            EmuSys emuSys = this.emuThread.getEmuSys();
            if (emuSys != null) {
                z80CPU = emuSys.getSecondZ80CPU();
                z80Memory = emuSys.getSecondZ80Memory();
                string = emuSys.getSecondSystemName();
            }
            if (z80CPU != null && z80Memory != null) {
                n = this.askAccessToSysNum(string);
            }
            if (n == 0) {
                this.openPrimaryDebugger();
            } else if (n == 1) {
                this.openSecondDebugger();
            }
        }
    }

    private void doExtraDiskImgUnpack() {
        File file = EmuUtil.showFileOpenDlg(this, "CP/M-Diskettenabbilddatei entpacken", Main.getLastDirFile("disk"), EmuUtil.getPlainDiskFileFilter(), EmuUtil.getAnaDiskFileFilter(), EmuUtil.getCopyQMFileFilter(), EmuUtil.getDskFileFilter(), EmuUtil.getImageDiskFileFilter(), EmuUtil.getTeleDiskFileFilter());
        if (file != null) {
            try {
                boolean bl = false;
                String string = file.getName();
                if (string != null) {
                    if (TextUtil.endsWith(string = string.toLowerCase(), DiskUtil.plainDiskFileExt) || TextUtil.endsWith(string, DiskUtil.gzPlainDiskFileExt)) {
                        DiskUtil.unpackPlainDiskFile(this, file);
                        bl = true;
                    } else {
                        AbstractFloppyDisk abstractFloppyDisk = DiskUtil.readNonPlainDiskFile(this, file, true);
                        if (abstractFloppyDisk != null) {
                            if (DiskUtil.checkAndConfirmWarning(this, abstractFloppyDisk)) {
                                DiskUtil.unpackDisk(this, file, abstractFloppyDisk, true);
                            }
                            bl = true;
                        }
                    }
                }
                if (!bl && JOptionPane.showConfirmDialog(this, "Aus der Dateiendung l\u00e4sst sich der Typ\nder Abbilddatei nicht ermitteln.\nDie Datei wird deshalb als einfach Abbilddatei ge\u00f6ffnet.", "Dateityp", 2, 2) == 0) {
                    DiskUtil.unpackPlainDiskFile(this, file);
                }
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this, iOException);
            }
        }
    }

    private void doExtraDiskUnpack() {
        String string = DriveSelectDlg.selectDriveFileName(this);
        if (string != null) {
            try {
                DiskUtil.unpackPlainDisk(this, string);
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this, iOException);
            }
        }
    }

    private void doExtraMemEditor() {
        if (this.emuThread != null) {
            int n = 0;
            Z80Memory z80Memory = null;
            String string = null;
            EmuSys emuSys = this.emuThread.getEmuSys();
            if (emuSys != null) {
                z80Memory = emuSys.getSecondZ80Memory();
                string = emuSys.getSecondSystemName();
            }
            if (z80Memory != null) {
                n = this.askAccessToSysNum(string);
            }
            if (n == 0) {
                if (this.primMemEditFrm != null) {
                    EmuUtil.showFrame(this.primMemEditFrm);
                } else {
                    this.primMemEditFrm = new MemEditFrm(this.emuThread);
                    EmuUtil.showFrame(this.primMemEditFrm);
                }
            } else if (n == 1) {
                if (this.secondMemEditFrm != null) {
                    EmuUtil.showFrame(this.secondMemEditFrm);
                } else {
                    this.secondMemEditFrm = new MemEditFrm(z80Memory);
                    if (string != null) {
                        this.secondMemEditFrm.setTitle("JKCEMU Speichereditor: " + string);
                    } else {
                        this.secondMemEditFrm.setTitle("JKCEMU Speichereditor: Sekund\u00e4rsystem");
                    }
                    EmuUtil.showFrame(this.secondMemEditFrm);
                }
            }
        }
    }

    private void doExtraReassembler() {
        if (this.emuThread != null) {
            int n = 0;
            Z80Memory z80Memory = null;
            String string = null;
            EmuSys emuSys = this.emuThread.getEmuSys();
            if (emuSys != null) {
                z80Memory = emuSys.getSecondZ80Memory();
                string = emuSys.getSecondSystemName();
            }
            if (z80Memory != null) {
                n = this.askAccessToSysNum(string);
            }
            if (n == 0) {
                this.openPrimaryReassembler();
            } else if (n == 1) {
                this.openSecondReassembler();
            }
        }
    }

    private void doExtraSecondScreen(boolean bl) {
        if (this.secondScreenFrm != null) {
            EmuUtil.showFrame(this.secondScreenFrm);
        } else {
            AbstractScreenDevice abstractScreenDevice;
            EmuSys emuSys = this.getEmuSys();
            if (emuSys != null && (abstractScreenDevice = emuSys.getSecondScreenDevice()) != null) {
                this.secondScreenFrm = new SecondaryScreenFrm(this, abstractScreenDevice);
                if (bl) {
                    this.secondScreenFrm.setCloseMsg(String.format("Sie k\u00f6nnen das Fenster \u00fcber den Men\u00fcpunkt\n'%s' \u2192 '%s'\nim Hauptfenster wieder \u00f6ffnen.", this.mnuExtra.getText(), this.mnuSecondScreen.getText()));
                }
                EmuUtil.showFrame(this.secondScreenFrm);
            }
        }
    }

    private void doExtraProfile() {
        Properties properties;
        ProfileDlg profileDlg = new ProfileDlg(this, "Profil anwenden", "Anwenden", Main.getProfileFile(), false);
        profileDlg.setVisible(true);
        File file = profileDlg.getSelectedProfile();
        if (file != null && (properties = Main.loadProperties(file)) != null) {
            this.emuThread.applySettings(properties);
            Main.applyProfileToFrames(file, properties, true, null);
            FloppyDiskStationFrm.getSharedInstance(this).openDisks(properties);
            this.fireReset(EmuThread.ResetLevel.COLD_RESET);
        }
    }

    private void doExtraSpeed() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        if (z80CPU != null) {
            this.setMaxSpeed(this, z80CPU.isBrakeEnabled());
        }
    }

    private void doExtraPause() {
        EmuSys emuSys;
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        if (z80CPU != null && z80CPU.isActive()) {
            z80CPU.firePause(!z80CPU.isPause());
        }
        if ((emuSys = this.emuThread.getEmuSys()) != null && (z80CPU = emuSys.getSecondZ80CPU()) != null && z80CPU.isActive()) {
            z80CPU.firePause(!z80CPU.isPause());
        }
    }

    private void doExtraNMI() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        if (z80CPU != null) {
            if (Main.getBooleanProperty("jkcemu.confirm.nmi", true)) {
                if (BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie einen nicht maskierbaren\nInterrupt (NMI) ausl\u00f6sen?\n\nAchtung! Wenn auf Adresse 0066h keine\nInterrupt-Routine installiert ist,\nkann das Ausl\u00f6sen eines NMI zum Absturz\ndes im Emulator laufenden Programms\nund damit zu Datenverlust f\u00fchren.", "Best\u00e4tigung")) {
                    z80CPU.fireNMI();
                }
            } else {
                z80CPU.fireNMI();
            }
        }
    }

    private void doExtraReset() {
        if (Main.getBooleanProperty("jkcemu.confirm.reset", false)) {
            if (BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie den Emulator neu starten?", "Best\u00e4tigung")) {
                this.fireReset(EmuThread.ResetLevel.WARM_RESET);
            }
        } else {
            this.fireReset(EmuThread.ResetLevel.WARM_RESET);
        }
    }

    private void doExtraPowerOn() {
        if (Main.getBooleanProperty("jkcemu.confirm.power_on", false)) {
            if (BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie das Aus- und wieder Einschalten emulieren?\nDabei gehen alle im Arbeitsspeicher befindlichen\nProgramme und Daten verloren.", "Best\u00e4tigung")) {
                this.fireReset(EmuThread.ResetLevel.POWER_ON);
            }
        } else {
            this.fireReset(EmuThread.ResetLevel.POWER_ON);
        }
    }

    private void doExtraUSB() {
        EmuSys emuSys = this.getEmuSys();
        if (emuSys != null) {
            if (emuSys.supportsUSB()) {
                USBInterfaceFrm.open(this);
            } else {
                BaseDlg.showInfoDlg(this, "Das Fenster f\u00fcr den USB-Anschluss kann nur angezeigt werden,\nwenn auch ein USB-Anschluss emuliert wird.\nDas ist aber bei der gerade eingestellten Konfiguration nicht der Fall.");
            }
        }
    }

    private void doHelpSystem() {
        String string;
        EmuSys emuSys = this.getEmuSys();
        if (emuSys != null && (string = emuSys.getHelpPage()) != null) {
            HelpFrm.open(string);
        }
    }

    private void appendMsg(String string) {
        if (this.msgFrm == null) {
            this.msgFrm = new MsgFrm((Window)this);
        }
        EmuUtil.showFrame(this.msgFrm);
        this.msgFrm.appendMsg(string);
    }

    private int askAccessToSysNum(String string) {
        int n = -1;
        Object[] objectArray = new String[]{"Grundger\u00e4t", string != null ? string : "Zweitsystem", "Abbrechen"};
        JOptionPane jOptionPane = new JOptionPane("Auf welches Prozessorsystem m\u00f6chten Sie zugreifen?", 3);
        jOptionPane.setOptions(objectArray);
        jOptionPane.setValue(objectArray[0]);
        jOptionPane.setWantsInput(false);
        jOptionPane.createDialog(this, "Auswahl Prozessorsystem").setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null) {
            if (object.equals(objectArray[0])) {
                n = 0;
            }
            if (object.equals(objectArray[1])) {
                n = 1;
            }
        }
        return n;
    }

    private JButton createImageButton(String string, String string2, String string3) {
        Image image;
        URL uRL;
        Component component = null;
        Toolkit toolkit = this.getToolkit();
        if (toolkit != null && (uRL = this.getClass().getResource(string)) != null && (image = toolkit.createImage(uRL)) != null) {
            component = new JButton(new ImageIcon(image));
            ((JComponent)component).setToolTipText(string2);
            Main.putImage(string, image);
        }
        if (component == null) {
            component = new JButton(string2);
        }
        component.setFocusable(false);
        if (string3 != null) {
            ((AbstractButton)component).setActionCommand(string3);
        }
        ((AbstractButton)component).addActionListener(this);
        return component;
    }

    private String createMHzText(Z80CPU z80CPU) {
        double d;
        String string = null;
        if (z80CPU != null && (d = z80CPU.getCurrentSpeedKHz() / 1000.0) > 0.09) {
            string = this.speedFmt.format(d);
        }
        return string;
    }

    private void execReset(EmuThread.ResetLevel resetLevel) {
        this.emuThread.fireReset(resetLevel);
        this.screenRefreshTimer.restart();
        this.statusRefreshTimer.restart();
    }

    private ReassFrm openSecondReassembler(Z80Memory z80Memory, String string) {
        ReassFrm reassFrm = null;
        if (z80Memory != null && string != null) {
            if (this.secondReassFrm != null) {
                EmuUtil.showFrame(this.secondReassFrm);
            } else {
                this.secondReassFrm = new ReassFrm(z80Memory);
                if (string != null) {
                    this.secondReassFrm.setTitle("JKCEMU Reassembler: " + string);
                } else {
                    this.secondReassFrm.setTitle("JKCEMU Reassembler: Sekund\u00e4rsystem");
                }
                EmuUtil.showFrame(this.secondReassFrm);
            }
            reassFrm = this.secondReassFrm;
        }
        return reassFrm;
    }

    private void refreshStatus() {
        Z80CPU z80CPU;
        String string = "Bereit";
        if (this.emuThread != null && (z80CPU = this.emuThread.getZ80CPU()) != null && z80CPU.isActive()) {
            if (z80CPU.isPause()) {
                string = z80CPU.isDebugEnabled() ? "Debug-Haltepunkt erreicht" : "Pause";
                EmuSys emuSys = this.getEmuSys();
                if (emuSys != null) {
                    emuSys.updDebugScreen();
                }
                this.screenDirty = true;
                this.screenFld.repaint();
            } else {
                String string2 = this.createMHzText(z80CPU);
                if (string2 != null) {
                    string = String.format("Emulierte Taktfrequenz: %s MHz", string2);
                    EmuSys emuSys = this.emuThread.getEmuSys();
                    if (emuSys != null) {
                        String string3 = emuSys.getSecondSystemName();
                        Z80CPU z80CPU2 = emuSys.getSecondZ80CPU();
                        if (string3 != null && z80CPU2 != null && emuSys.isSecondSystemRunning() && !z80CPU2.isPause() && (string2 = this.createMHzText(z80CPU2)) != null) {
                            string = String.format("%s, %s: %s MHz", string, string3, string2);
                        }
                    }
                }
            }
        }
        this.labelStatus.setText(string);
    }

    private void setFullScreenMode(boolean bl) {
        if (bl != this.fullScreenMode) {
            this.clearScreenSelection();
            this.setVisible(false);
            this.dispose();
            this.fullScreenMode = bl;
            if (this.fullScreenMode) {
                this.windowLocation = this.getLocation();
                this.windowSize = this.getSize();
                this.mnuBar.setVisible(false);
                this.toolBar.setVisible(false);
                this.labelStatus.setVisible(false);
                if (!this.updFullScreenScale()) {
                    this.setExtendedState(6);
                }
                try {
                    this.setUndecorated(true);
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
                this.mnuFullScreen.setText(TEXT_FULLSCREEN_OFF);
                this.mnuPopupFullScreen.setText(TEXT_FULLSCREEN_OFF);
                if (!this.fullScreenInfoDone) {
                    this.fullScreenInfoDone = true;
                    final ScreenFrm screenFrm = this;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BaseDlg.showInfoDlg(screenFrm, "Den Vollbildmodus k\u00f6nnen Sie im Kontextmen\u00fc wieder ausschalten.");
                        }
                    });
                }
                this.screenFld.requestFocus();
            } else {
                this.mnuBar.setVisible(true);
                this.toolBar.setVisible(true);
                this.labelStatus.setVisible(true);
                this.setScreenScale(this.screenScale);
                try {
                    this.setUndecorated(false);
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
                this.setExtendedState(0);
                if (this.windowLocation != null) {
                    this.setLocation(this.windowLocation);
                }
                if (this.windowSize != null) {
                    this.setSize(this.windowSize);
                } else {
                    this.screenFld.updPreferredSize();
                    this.pack();
                }
                this.mnuFullScreen.setText(TEXT_FULLSCREEN_ON);
                this.mnuPopupFullScreen.setText(TEXT_FULLSCREEN_ON);
            }
            this.setVisible(true);
        }
    }

    private void setScreenTextActionsEnabled(boolean bl) {
        this.mnuScreenTextShow.setEnabled(bl);
        this.mnuScreenTextCopy.setEnabled(bl);
        this.mnuScreenTextSave.setEnabled(bl);
    }

    private void updActionBtns(EmuSys emuSys) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        if (emuSys != null) {
            bl = emuSys.supportsOpenBasic();
            bl2 = emuSys.supportsSaveBasic();
            bl3 = emuSys.supportsAudio();
            bl4 = emuSys.supportsChessboard();
            bl5 = emuSys.getSupportedFloppyDiskDriveCount() > 0;
            bl6 = emuSys.getSupportedJoystickCount() > 0;
            bl7 = emuSys.supportsKeyboardFld();
            bl8 = emuSys.getPlotter() != null;
            bl9 = emuSys.supportsPrinter();
            bl12 = emuSys.supportsUSB();
            bl11 = emuSys.getSecondScreenDevice() != null;
            bl10 = emuSys.supportsRAMFloppies();
        }
        this.mnuBasicOpen.setEnabled(bl);
        this.mnuBasicSave.setEnabled(bl2);
        this.mnuFloppyDisks.setEnabled(bl5);
        this.mnuPopupFloppyDisk.setEnabled(bl5);
        this.mnuAudio.setEnabled(bl3);
        this.mnuPopupAudio.setEnabled(bl3);
        this.mnuChessboard.setEnabled(bl4);
        this.mnuJoystick.setEnabled(bl6);
        this.mnuPopupJoystick.setEnabled(bl6);
        this.mnuKeyboard.setEnabled(bl7);
        this.mnuPopupKeyboard.setEnabled(bl7);
        this.mnuPlotter.setEnabled(bl8);
        this.mnuPrintJobs.setEnabled(bl9);
        this.mnuSecondScreen.setEnabled(bl11);
        this.mnuRAMFloppies.setEnabled(bl10);
        this.mnuUSB.setEnabled(bl12);
        this.mnuPopupUSB.setEnabled(bl12);
        this.toolBar.removeAll();
        this.toolBar.add(this.btnLoad);
        this.toolBar.add(this.btnSave);
        if (this.copyEnabled || this.pasteEnabled) {
            this.toolBar.addSeparator();
            if (this.copyEnabled) {
                this.toolBar.add(this.btnCopy);
            }
            if (this.pasteEnabled) {
                this.toolBar.add(this.btnPaste);
            }
        }
        this.toolBar.addSeparator();
        if (bl4) {
            this.toolBar.add(this.btnChessboard);
        }
        if (bl5) {
            this.toolBar.add(this.btnFloppyDisks);
        }
        if (bl7) {
            this.toolBar.add(this.btnKeyboard);
        }
        if (bl3) {
            this.toolBar.add(this.btnAudio);
        }
        this.toolBar.add(this.btnSettings);
        this.toolBar.addSeparator();
        this.toolBar.add(this.btnReset);
        SwingUtilities.updateComponentTreeUI(this.toolBar);
    }

    private boolean updFullScreenScale() {
        DisplayMode displayMode;
        GraphicsDevice graphicsDevice;
        boolean bl = false;
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null && (graphicsDevice = graphicsConfiguration.getDevice()) != null && (displayMode = graphicsDevice.getDisplayMode()) != null) {
            int n = displayMode.getWidth();
            int n2 = displayMode.getHeight();
            if (n > 0 && n2 > 0) {
                this.setBounds(0, 0, n, n2);
                EmuSys emuSys = this.getEmuSys();
                if (emuSys != null) {
                    int n3 = emuSys.getScreenWidth();
                    int n4 = emuSys.getScreenHeight();
                    if (n3 > 0 && n4 > 0) {
                        int n5 = Math.min((n - 50) / n3, (n2 - 50) / n4);
                        this.screenFld.setScreenScale(n5 > 1 ? n5 : 1);
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    private void updPauseBtn() {
        Z80CPU z80CPU;
        String string = "Pause";
        if (this.emuThread != null && (z80CPU = this.emuThread.getZ80CPU()) != null) {
            if (z80CPU.isActive()) {
                if (z80CPU.isPause()) {
                    string = "Fortsetzen";
                }
                this.mnuPause.setEnabled(true);
                this.mnuPopupPause.setEnabled(true);
            } else {
                this.mnuPause.setEnabled(false);
                this.mnuPopupPause.setEnabled(false);
            }
        }
        this.mnuPause.setText(string);
        this.mnuPopupPause.setText(string);
    }
}

